<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:hl7="urn:hl7-org:v3"
                xmlns:cda="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:sdtc="urn:hl7-org:sdtc"
                xmlns:pharm="urn:ihe:pharm:medication"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
   <xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


   <!--PROLOG-->
   <xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
               method="xml"
               omit-xml-declaration="no"
               standalone="yes"
               indent="yes"/>

   <!--XSD TYPES FOR XSLT2-->


   <!--KEYS AND FUNCTIONS-->


   <!--DEFAULT RULES-->


   <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
   <!--This mode can be used to generate prefixed XPath for humans-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
   <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
   <xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
   <xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters-->
   <xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
   <xsl:template match="/">
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                              title="Schematron file for transaction Create LSPP (2.16.840.1.113883.3.1937.777.63.4.36 2025-05-22T00:00:00)"
                              schemaVersion="">
         <xsl:comment>
            <xsl:value-of select="$archiveDirParameter"/>   
		 <xsl:value-of select="$archiveNameParameter"/>  
		 <xsl:value-of select="$fileNameParameter"/>  
		 <xsl:value-of select="$fileDirParameter"/>
         </xsl:comment>
         <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:v3" prefix="hl7"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:v3" prefix="cda"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:sdtc" prefix="sdtc"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:ihe:pharm:medication" prefix="pharm"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/XML/1998/namespace" prefix="xml"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M9"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="name">lettera_di_invito_per_screening_o_ad_altri_percorsi_di_prevenzione</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M10"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820</xsl:attribute>
            <xsl:attribute name="name">Lettera di invito per screening o ad altri percorsi di prevenzione</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M11"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820-closed</xsl:attribute>
            <xsl:attribute name="name">Lettera di invito per screening o ad altri percorsi di prevenzione</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M12"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500</xsl:attribute>
            <xsl:attribute name="name">Riferimento a invito precedente</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M18"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123</xsl:attribute>
            <xsl:attribute name="name">Section per lettera di invito screening</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M19"/>
      </svrl:schematron-output>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Schematron file for transaction Create LSPP (2.16.840.1.113883.3.1937.777.63.4.36 2025-05-22T00:00:00)</svrl:text>
   <xsl:param name="scenariolabel" select="'2.16.840.1.113883.3.1937.777.63.4.36'"/>

   <!--PATTERN -->
   <xsl:template match="text()" priority="-1" mode="M9"/>
   <xsl:template match="@*|node()" priority="-2" mode="M9">
      <xsl:apply-templates select="*" mode="M9"/>
   </xsl:template>

   <!--PATTERN lettera_di_invito_per_screening_o_ad_altri_percorsi_di_prevenzione-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">lettera_di_invito_per_screening_o_ad_altri_percorsi_di_prevenzione</svrl:text>

	  <!--RULE -->
   <xsl:template match="/" priority="1000" mode="M10">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M10"/>
   <xsl:template match="@*|node()" priority="-2" mode="M10">
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820Lettera di invito per screening o ad altri percorsi di prevenzione-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Lettera di invito per screening o ad altri percorsi di prevenzione</svrl:text>

	  <!--RULE d45e20-false-d228e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]"
                 priority="1066"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('DOCCLIN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:realmCode) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:realmCode) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:realmCode is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '108276-7 ' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '108276-7 ' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:code[(@code = '108276-7 ' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '108276-7 ' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '108276-7 ' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:code[(@code = '108276-7 ' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:title) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:title appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:effectiveTime is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:languageCode) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:languageCode is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:languageCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:languageCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:setId) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:setId appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:versionNumber) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:versionNumber appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:recordTarget[hl7:patientRole] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:recordTarget[hl7:patientRole] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:author[hl7:assignedAuthor] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:custodian[hl7:assignedCustodian] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &gt;= 2"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &gt;= 2">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] is required [min 2x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &lt;= 2"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &lt;= 2">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] appears too often [max 2x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:structuredBody]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[hl7:structuredBody]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:component[hl7:structuredBody] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:structuredBody]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[hl7:structuredBody]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:component[hl7:structuredBody] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e23-false-d546e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:realmCode"
                 priority="1065"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e43-false-d560e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']"
                 priority="1064"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.1.3')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.1.3')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('POCD_MT000040UV02')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@extension) = ('POCD_MT000040UV02')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e57-false-d579e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']"
                 priority="1063"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.14.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.2.9.10.1.14.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.14.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('1.0')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@extension) = ('1.0')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for extension SHALL be '1.0'. Found: "<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e83-false-d600e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:id"
                 priority="1062"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e119-false-d622e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:code[(@code = '108276-7 ' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1061"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('108276-7')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('108276-7')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for code SHALL be '108276-7'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Lettera di invito allo screening') or not(@displayName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@displayName) = ('Lettera di invito allo screening') or not(@displayName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for displayName SHALL be 'Lettera di invito allo screening'. Found: "<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e133-false-d654e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:code[(@code = '108276-7 ' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation"
                 priority="1060"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystemName">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): attribute @codeSystemName SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e170-false-d699e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]"
                 priority="1059"
                 mode="M11">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (@code='N' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Normal' and @codeSystemName='HL7 Confidentiality') or (@code='V' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Very Restricted' and @codeSystemName='HL7 Confidentiality') or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@nullFlavor or (@code='N' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Normal' and @codeSystemName='HL7 Confidentiality') or (@code='V' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Very Restricted' and @codeSystemName='HL7 Confidentiality') or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The element value SHALL be one of 'code 'N' codeSystem '2.16.840.1.113883.5.25' displayName='Normal' codeSystemName='HL7 Confidentiality' or code 'V' codeSystem '2.16.840.1.113883.5.25' displayName='Very Restricted' codeSystemName='HL7 Confidentiality' or 2.16.840.1.113883.1.11.16926 x_BasicConfidentialityKind (DYNAMIC)'.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e199-false-d734e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:setId"
                 priority="1058"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d757e17-false-d785e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]"
                 priority="1057"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('RCT') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('RCT') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): The value for typeCode SHALL be 'RCT'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[hl7:patient]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patientRole[hl7:patient]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:patientRole[hl7:patient] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[hl7:patient]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patientRole[hl7:patient]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:patientRole[hl7:patient] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d757e32-false-d851e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]"
                 priority="1056"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PAT') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PAT') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): The value for classCode SHALL be 'PAT'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:addr is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:providerOrganization) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:providerOrganization) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:providerOrganization appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d757e39-false-d917e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id"
                 priority="1055"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr"
                 priority="1054"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d757e224-false-d1089e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom"
                 priority="1052"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d757e258-false-d1126e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
                 priority="1051"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PSN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthTime) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:birthTime is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:birthTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthplace[hl7:place]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthplace[hl7:place]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:birthplace[hl7:place] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthplace[hl7:place]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthplace[hl7:place]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:birthplace[hl7:place] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d757e266-false-d1185e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name"
                 priority="1050"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d757e290-false-d1228e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
                 priority="1049"
                 mode="M11">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d757e340-false-d1261e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime"
                 priority="1048"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d757e351-false-d1282e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]"
                 priority="1047"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('BIRTHPL') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('BIRTHPL') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): The value for classCode SHALL be 'BIRTHPL'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:place) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:place is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:place) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:place appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d757e384-false-d1318e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place"
                 priority="1046"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PLC') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PLC') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): The value for classCode SHALL be 'PLC'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr[hl7:country]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:addr[hl7:country]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:addr[hl7:country] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr[hl7:country]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:addr[hl7:country]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): element hl7:addr[hl7:country] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]"
                 priority="1045"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization"
                 priority="1044"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.671-2025-05-29T142336.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Screening): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.671-2025-05-29T142336.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Screening): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.671-2025-05-29T142336.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Screening): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): Attribute @classCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization/hl7:id"
                 priority="1042"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.671-2025-05-29T142336.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Screening): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.671-2025-05-29T142336.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Screening): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.671-2025-05-29T142336.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Screening): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.671-2025-05-29T142336.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Screening): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.671-2025-05-29T142336.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Screening): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1486e73-false-d1580e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]"
                 priority="1041"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('AUT') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): element hl7:time is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedAuthor) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): element hl7:assignedAuthor is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedAuthor) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): element hl7:assignedAuthor appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1486e82-false-d1664e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1040"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): element hl7:assignedPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1486e98-false-d1716e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1039"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1038"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.618-2025-05-22T101236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA personScreening): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.618-2025-05-22T101236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA personScreening): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PSN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name"
                 priority="1036"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.619-2025-05-22T101836.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameScreening): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.619-2025-05-22T101836.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameScreening): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.619-2025-05-22T101836.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameScreening): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.619-2025-05-22T101836.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameScreening): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1035"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.617-2025-05-22T093749.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationScreening): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.617-2025-05-22T093749.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationScreening): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.617-2025-05-22T093749.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationScreening): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1034"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.617-2025-05-22T093749.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationScreening): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.617-2025-05-22T093749.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationScreening): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.617-2025-05-22T093749.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationScreening): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.617-2025-05-22T093749.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationScreening): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.617-2025-05-22T093749.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationScreening): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1033"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.617-2025-05-22T093749.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationScreening): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.617-2025-05-22T093749.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationScreening): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1032"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.617-2025-05-22T093749.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationScreening): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.617-2025-05-22T093749.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationScreening): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1867e118-false-d2139e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]"
                 priority="1030"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('CST') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('CST') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.624-2025-05-22T133720.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianScreening): The value for typeCode SHALL be 'CST'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.624-2025-05-22T133720.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianScreening): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.624-2025-05-22T133720.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianScreening): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]"
                 priority="1029"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedCustodianOrganization) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.895-2025-12-18T112920.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA assignedCustodian v1.0): element hl7:representedCustodianOrganization is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedCustodianOrganization) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.895-2025-12-18T112920.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA assignedCustodian v1.0): element hl7:representedCustodianOrganization appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.624-2025-05-22T133720.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianScreening): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization"
                 priority="1027"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): element hl7:addr appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id"
                 priority="1026"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom"
                 priority="1025"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr"
                 priority="1024"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2198e142-false-d2544e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
                 priority="1022"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('LA') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('LA') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.606-2025-05-20T114130.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorScreening): The value for typeCode SHALL be 'LA'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.606-2025-05-20T114130.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorScreening): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.606-2025-05-20T114130.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorScreening): element hl7:time is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.606-2025-05-20T114130.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorScreening): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.606-2025-05-20T114130.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorScreening): element hl7:signatureCode[@code = 'S'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.606-2025-05-20T114130.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorScreening): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.606-2025-05-20T114130.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorScreening): element hl7:assignedEntity is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.606-2025-05-20T114130.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorScreening): element hl7:assignedEntity appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2198e156-false-d2605e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
                 priority="1021"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('S')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string(@code) = ('S')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.606-2025-05-20T114130.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorScreening): The value for code SHALL be 'S'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity"
                 priority="1020"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.621-2025-05-22T105111.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityScreening): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.621-2025-05-22T105111.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityScreening): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.621-2025-05-22T105111.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityScreening): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.621-2025-05-22T105111.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityScreening): element hl7:assignedPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id"
                 priority="1019"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.621-2025-05-22T105111.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityScreening): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.621-2025-05-22T105111.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityScreening): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.621-2025-05-22T105111.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityScreening): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.621-2025-05-22T105111.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityScreening): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.621-2025-05-22T105111.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityScreening): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1018"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.618-2025-05-22T101236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA personScreening): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.618-2025-05-22T101236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA personScreening): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1017"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.619-2025-05-22T101836.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameScreening): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.619-2025-05-22T101836.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameScreening): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.619-2025-05-22T101836.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameScreening): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.619-2025-05-22T101836.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameScreening): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2632e86-false-d2816e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:participant[@typeCode = 'VRF'][hl7:associatedEntity[@classCode = 'PROV']]"
                 priority="1016"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('VRF')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('VRF')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): The value for typeCode SHALL be 'VRF'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity[@classCode = 'PROV']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:associatedEntity[@classCode = 'PROV']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): element hl7:associatedEntity[@classCode = 'PROV'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity[@classCode = 'PROV']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:associatedEntity[@classCode = 'PROV']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): element hl7:associatedEntity[@classCode = 'PROV'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2632e124-false-d2870e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:participant[@typeCode = 'VRF'][hl7:associatedEntity[@classCode = 'PROV']]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
                 priority="1015"
                 mode="M11">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2632e174-false-d2910e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:participant[@typeCode = 'VRF'][hl7:associatedEntity[@classCode = 'PROV']]/hl7:associatedEntity[@classCode = 'PROV']"
                 priority="1014"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PROV')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PROV')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): The value for classCode SHALL be 'PROV'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.19313' RoleClassAssociative (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:associatedPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): element hl7:associatedPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2632e185-false-d2952e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:participant[@typeCode = 'VRF'][hl7:associatedEntity[@classCode = 'PROV']]/hl7:associatedEntity[@classCode = 'PROV']/hl7:id"
                 priority="1013"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:participant[@typeCode = 'VRF'][hl7:associatedEntity[@classCode = 'PROV']]/hl7:associatedEntity[@classCode = 'PROV']/hl7:associatedPerson"
                 priority="1012"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.618-2025-05-22T101236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA personScreening): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.618-2025-05-22T101236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA personScreening): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:participant[@typeCode = 'VRF'][hl7:associatedEntity[@classCode = 'PROV']]/hl7:associatedEntity[@classCode = 'PROV']/hl7:associatedPerson/hl7:name"
                 priority="1011"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.619-2025-05-22T101836.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameScreening): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.619-2025-05-22T101836.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameScreening): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.619-2025-05-22T101836.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameScreening): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.619-2025-05-22T101836.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameScreening): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2985e49-false-d3082e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]"
                 priority="1010"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('DOC') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('DOC') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): The value for typeCode SHALL be 'DOC'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): element hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): element hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2985e72-false-d3108e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
                 priority="1009"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ACT') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ACT') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): The value for classCode SHALL be 'ACT'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2985e80-false-d3138e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
                 priority="1008"
                 mode="M11">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.62 Campagna di screening (DYNAMIC)'.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d3144e43-false-d3174e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
                 priority="1007"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@typeCode"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@typeCode">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): attribute @typeCode SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:parentDocument) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:parentDocument) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): element hl7:parentDocument is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:parentDocument) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:parentDocument) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): element hl7:parentDocument appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d3144e87-false-d3205e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
                 priority="1006"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('DOCCLIN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): element hl7:text appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:setId) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): element hl7:setId appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:versionNumber) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): element hl7:versionNumber appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d3144e90-false-d3251e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
                 priority="1005"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d3144e99-false-d3269e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
                 priority="1004"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e238-false-d3344e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]"
                 priority="1003"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('COMP') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextConductionInd"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:structuredBody[hl7:component]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:structuredBody[hl7:component]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:structuredBody[hl7:component] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:structuredBody[hl7:component]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:structuredBody[hl7:component]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:structuredBody[hl7:component] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e241-false-d3422e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]"
                 priority="1002"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCBODY') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('DOCBODY') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for classCode SHALL be 'DOCBODY'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]"
                 priority="1001"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('COMP') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextConductionInd"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]"
                 priority="1000"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('COMP') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextConductionInd"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M11"/>
   <xsl:template match="@*|node()" priority="-2" mode="M11">
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820-closedLettera di invito per screening o ad altri percorsi di prevenzione-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Lettera di invito per screening o ad altri percorsi di prevenzione</svrl:text>

	  <!--RULE d45e20-true-d4017e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/*[not(@xsi:nil = 'true')][not(self::hl7:realmCode | self::hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] | self::hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0'] | self::hl7:id | self::hl7:code[(@code = '108276-7 ' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:effectiveTime | self::hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] | self::hl7:languageCode | self::hl7:setId | self::hl7:versionNumber | self::hl7:recordTarget[hl7:patientRole] | self::hl7:author[hl7:assignedAuthor] | self::hl7:custodian[hl7:assignedCustodian] | self::hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] | self::hl7:participant[@typeCode = 'VRF'][hl7:associatedEntity[@classCode = 'PROV']] | self::hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] | self::hl7:relatedDocument[@typeCode][hl7:parentDocument] | self::hl7:component[hl7:structuredBody])]"
                 priority="1054"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d45e20-true-d4017e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:realmCode | hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] | hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0'] | hl7:id | hl7:code[(@code = '108276-7 ' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:effectiveTime | hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] | hl7:languageCode | hl7:setId | hl7:versionNumber | hl7:recordTarget[hl7:patientRole] | hl7:author[hl7:assignedAuthor] | hl7:custodian[hl7:assignedCustodian] | hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] | hl7:participant[@typeCode = 'VRF'][hl7:associatedEntity[@classCode = 'PROV']] | hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] | hl7:relatedDocument[@typeCode][hl7:parentDocument] | hl7:component[hl7:structuredBody] (rule-reference: d45e20-true-d4017e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d45e119-true-d4054e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:code[(@code = '108276-7 ' and @codeSystem = '2.16.840.1.113883.6.1')]/*[not(@xsi:nil = 'true')][not(self::hl7:translation)]"
                 priority="1053"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d45e119-true-d4054e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:translation (rule-reference: d45e119-true-d4054e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4099e13-true-d4174e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/*[not(@xsi:nil = 'true')][not(self::hl7:patientRole[hl7:patient])]"
                 priority="1052"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening)/d4099e13-true-d4174e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:patientRole[hl7:patient] (rule-reference: d4099e13-true-d4174e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4099e28-true-d4277e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:addr | self::hl7:telecom | self::hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] | self::hl7:providerOrganization)]"
                 priority="1051"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening)/d4099e28-true-d4277e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:addr | hl7:telecom | hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] | hl7:providerOrganization (rule-reference: d4099e28-true-d4277e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4099e155-true-d4329e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
                 priority="1050"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening)/d4099e155-true-d4329e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d4099e155-true-d4329e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4099e254-true-d4431e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/*[not(@xsi:nil = 'true')][not(self::hl7:name | self::hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] | self::hl7:birthTime | self::hl7:birthplace[hl7:place])]"
                 priority="1049"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening)/d4099e254-true-d4431e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name | hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] | hl7:birthTime | hl7:birthplace[hl7:place] (rule-reference: d4099e254-true-d4431e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4099e262-true-d4450e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family)]"
                 priority="1048"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening)/d4099e262-true-d4450e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family (rule-reference: d4099e262-true-d4450e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4099e347-true-d4511e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/*[not(@xsi:nil = 'true')][not(self::hl7:place)]"
                 priority="1047"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening)/d4099e347-true-d4511e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:place (rule-reference: d4099e347-true-d4511e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4099e380-true-d4554e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/*[not(@xsi:nil = 'true')][not(self::hl7:name | self::hl7:addr[hl7:country])]"
                 priority="1046"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening)/d4099e380-true-d4554e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name | hl7:addr[hl7:country] (rule-reference: d4099e380-true-d4554e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4099e384-true-d4601e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:censusTract | self::hl7:postalCode)]"
                 priority="1045"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening)/d4099e384-true-d4601e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:censusTract | hl7:postalCode (rule-reference: d4099e384-true-d4601e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4099e385-true-d4653e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name)]"
                 priority="1044"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.604-2025-05-20T110853.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetScreening)/d4099e385-true-d4653e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name (rule-reference: d4099e385-true-d4653e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4667e12-true-d4750e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
                 priority="1043"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening)/d4667e12-true-d4750e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d4667e12-true-d4750e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4667e21-true-d4845e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson | self::hl7:representedOrganization[@classCode = 'ORG'])]"
                 priority="1042"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening)/d4667e21-true-d4845e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson | hl7:representedOrganization[@classCode = 'ORG'] (rule-reference: d4667e21-true-d4845e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4667e51-true-d4879e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
                 priority="1041"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening)/d4667e51-true-d4879e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d4667e51-true-d4879e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4855e16-true-d4901e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family)]"
                 priority="1040"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening)/d4855e16-true-d4901e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family (rule-reference: d4855e16-true-d4901e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4667e67-true-d4970e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr)]"
                 priority="1039"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening)/d4667e67-true-d4970e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr (rule-reference: d4667e67-true-d4970e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4916e54-true-d5032e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
                 priority="1038"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.605-2025-05-20T112626.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorScreening)/d4916e54-true-d5032e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d4916e54-true-d5032e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5071e12-true-d5137e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/*[not(@xsi:nil = 'true')][not(self::hl7:assignedCustodian[hl7:representedCustodianOrganization])]"
                 priority="1037"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.624-2025-05-22T133720.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianScreening)/d5071e12-true-d5137e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:assignedCustodian[hl7:representedCustodianOrganization] (rule-reference: d5071e12-true-d5137e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5071e19-true-d5199e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/*[not(@xsi:nil = 'true')][not(self::hl7:representedCustodianOrganization)]"
                 priority="1036"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.624-2025-05-22T133720.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianScreening)/d5071e19-true-d5199e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:representedCustodianOrganization (rule-reference: d5071e19-true-d5199e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5142e2-true-d5258e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr)]"
                 priority="1035"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.624-2025-05-22T133720.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianScreening)/d5142e2-true-d5258e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr (rule-reference: d5142e2-true-d5258e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5204e46-true-d5320e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
                 priority="1034"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.624-2025-05-22T133720.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianScreening)/d5204e46-true-d5320e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d5204e46-true-d5320e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5359e12-true-d5417e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:signatureCode[@code = 'S'] | self::hl7:assignedEntity)]"
                 priority="1033"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.606-2025-05-20T114130.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorScreening)/d5359e12-true-d5417e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:signatureCode[@code = 'S'] | hl7:assignedEntity (rule-reference: d5359e12-true-d5417e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5359e33-true-d5471e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
                 priority="1032"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.606-2025-05-20T114130.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorScreening)/d5359e33-true-d5471e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d5359e33-true-d5471e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5433e34-true-d5505e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
                 priority="1031"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.606-2025-05-20T114130.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorScreening)/d5433e34-true-d5505e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d5433e34-true-d5505e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5481e6-true-d5527e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family)]"
                 priority="1030"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.606-2025-05-20T114130.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorScreening)/d5481e6-true-d5527e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family (rule-reference: d5481e6-true-d5527e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5541e12-true-d5580e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:participant[@typeCode = 'VRF'][hl7:associatedEntity[@classCode = 'PROV']]/*[not(@xsi:nil = 'true')][not(self::hl7:functionCode | self::hl7:associatedEntity[@classCode = 'PROV'])]"
                 priority="1029"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening)/d5541e12-true-d5580e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:functionCode | hl7:associatedEntity[@classCode = 'PROV'] (rule-reference: d5541e12-true-d5580e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5541e100-true-d5628e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:participant[@typeCode = 'VRF'][hl7:associatedEntity[@classCode = 'PROV']]/hl7:associatedEntity[@classCode = 'PROV']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:associatedPerson)]"
                 priority="1028"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening)/d5541e100-true-d5628e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:associatedPerson (rule-reference: d5541e100-true-d5628e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5541e115-true-d5662e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:participant[@typeCode = 'VRF'][hl7:associatedEntity[@classCode = 'PROV']]/hl7:associatedEntity[@classCode = 'PROV']/hl7:associatedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
                 priority="1027"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening)/d5541e115-true-d5662e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d5541e115-true-d5662e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5638e6-true-d5684e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:participant[@typeCode = 'VRF'][hl7:associatedEntity[@classCode = 'PROV']]/hl7:associatedEntity[@classCode = 'PROV']/hl7:associatedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family)]"
                 priority="1026"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.607-2025-05-20T115753.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participantScreening)/d5638e6-true-d5684e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family (rule-reference: d5638e6-true-d5684e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5698e13-true-d5719e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/*[not(@xsi:nil = 'true')][not(self::hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]])]"
                 priority="1025"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening)/d5698e13-true-d5719e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] (rule-reference: d5698e13-true-d5719e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5698e36-true-d5742e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/*[not(@xsi:nil = 'true')][not(self::hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)])]"
                 priority="1024"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.940-2026-02-26T144033.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfScreening)/d5698e36-true-d5742e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.62-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] (rule-reference: d5698e36-true-d5742e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5754e13-true-d5766e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/*[not(@xsi:nil = 'true')][not(self::hl7:parentDocument)]"
                 priority="1023"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening)/d5754e13-true-d5766e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:parentDocument (rule-reference: d5754e13-true-d5766e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5754e57-true-d5800e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:text | self::hl7:setId | self::hl7:versionNumber)]"
                 priority="1022"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.712-2025-06-18T082612.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocumentScreening)/d5754e57-true-d5800e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:text | hl7:setId | hl7:versionNumber (rule-reference: d5754e57-true-d5800e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d45e238-true-d5920e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/*[not(@xsi:nil = 'true')][not(self::hl7:structuredBody[hl7:component])]"
                 priority="1021"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d45e238-true-d5920e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:structuredBody[hl7:component] (rule-reference: d45e238-true-d5920e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d45e241-true-d6024e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/*[not(@xsi:nil = 'true')][not(self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]])]"
                 priority="1020"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d45e241-true-d6024e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]] (rule-reference: d45e241-true-d6024e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d45e244-true-d6098e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']])]"
                 priority="1019"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d45e244-true-d6098e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']] (rule-reference: d45e244-true-d6098e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6029e3-true-d6203e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941'] | self::hl7:id | self::hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:entry[hl7:encounter[@moodCode = 'APT']] | self::hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]])]"
                 priority="1018"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6029e3-true-d6203e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941'] | hl7:id | hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:entry[hl7:encounter[@moodCode = 'APT']] | hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]] (rule-reference: d6029e3-true-d6203e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6029e41-true-d6274e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/*[not(@xsi:nil = 'true')][not(self::hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime])]"
                 priority="1017"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6029e41-true-d6274e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime] (rule-reference: d6029e41-true-d6274e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6235e7-true-d6327e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/*[not(@xsi:nil = 'true')][not(self::hl7:effectiveTime | self::hl7:participant | self::hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]])]"
                 priority="1016"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6235e7-true-d6327e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:effectiveTime | hl7:participant | hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]] (rule-reference: d6235e7-true-d6327e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6235e30-true-d6373e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/*[not(@xsi:nil = 'true')][not(self::hl7:participantRole)]"
                 priority="1015"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6235e30-true-d6373e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:participantRole (rule-reference: d6235e30-true-d6373e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6235e37-true-d6429e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/*[not(@xsi:nil = 'true')][not(self::hl7:playingEntity[hl7:name] | self::hl7:addr | self::hl7:telecom | self::hl7:id)]"
                 priority="1014"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6235e37-true-d6429e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:playingEntity[hl7:name] | hl7:addr | hl7:telecom | hl7:id (rule-reference: d6235e37-true-d6429e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6235e39-true-d6443e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:playingEntity[hl7:name]/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
                 priority="1013"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6235e39-true-d6443e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d6235e39-true-d6443e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6235e41-true-d6495e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
                 priority="1012"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6235e41-true-d6495e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d6235e41-true-d6495e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6235e71-true-d6557e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]/*[not(@xsi:nil = 'true')][not(self::hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]])]"
                 priority="1011"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6235e71-true-d6557e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]] (rule-reference: d6235e71-true-d6557e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6235e78-true-d6579e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]/*[not(@xsi:nil = 'true')][not(self::hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')] | self::hl7:text)]"
                 priority="1010"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6235e78-true-d6579e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')] | hl7:text (rule-reference: d6235e78-true-d6579e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6029e48-true-d6619e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/*[not(@xsi:nil = 'true')][not(self::hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']])]"
                 priority="1009"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6029e48-true-d6619e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']] (rule-reference: d6029e48-true-d6619e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6595e20-true-d6664e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614'] | self::hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] | self::hl7:text | self::hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]])]"
                 priority="1008"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6595e20-true-d6664e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614'] | hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] | hl7:text | hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]] (rule-reference: d6595e20-true-d6664e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6595e58-true-d6701e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]/*[not(@xsi:nil = 'true')][not(self::hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']])]"
                 priority="1007"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6595e58-true-d6701e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']] (rule-reference: d6595e58-true-d6701e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6686e5-true-d6723e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623'] | self::hl7:code)]"
                 priority="1006"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6686e5-true-d6723e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623'] | hl7:code (rule-reference: d6686e5-true-d6723e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d45e247-true-d6763e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']])]"
                 priority="1005"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d45e247-true-d6763e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']] (rule-reference: d45e247-true-d6763e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6739e3-true-d6818e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676'] | self::hl7:id | self::hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]])]"
                 priority="1004"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6739e3-true-d6818e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676'] | hl7:id | hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]] (rule-reference: d6739e3-true-d6818e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6739e21-true-d6865e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]/*[not(@xsi:nil = 'true')][not(self::hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']])]"
                 priority="1003"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6739e21-true-d6865e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']] (rule-reference: d6739e21-true-d6865e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6850e20-true-d6894e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677'] | self::hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:reference[@typeCode = 'REFR'][hl7:externalDocument])]"
                 priority="1002"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6850e20-true-d6894e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677'] | hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:reference[@typeCode = 'REFR'][hl7:externalDocument] (rule-reference: d6850e20-true-d6894e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6850e30-true-d6920e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/*[not(@xsi:nil = 'true')][not(self::hl7:externalDocument[not(@nullFlavor)][hl7:id])]"
                 priority="1001"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6850e30-true-d6920e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:externalDocument[not(@nullFlavor)][hl7:id] (rule-reference: d6850e30-true-d6920e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6850e32-true-d6939e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.14.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[not(@nullFlavor)][hl7:id]/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code)]"
                 priority="1000"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.2.9.10.1.14.1-2026-02-26T145820.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per screening o ad altri percorsi di prevenzione)/d6850e32-true-d6939e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code (rule-reference: d6850e32-true-d6939e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M12"/>
   <xsl:template match="@*|node()" priority="-2" mode="M12">
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500Riferimento a invito precedente-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Riferimento a invito precedente</svrl:text>

	  <!--RULE d45e1349-false-d6969e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]"
                 priority="1012"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>

	  <!--RULE d45e1363-false-d6992e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]"
                 priority="1011"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCSECT') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('DOCSECT') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): The value for classCode SHALL be 'DOCSECT'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): element hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): element hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:title) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): element hl7:title appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): element hl7:text appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): element hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): element hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>

	  <!--RULE d45e1366-false-d7057e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']"
                 priority="1010"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.676')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.676')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.676'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>

	  <!--RULE d45e1369-false-d7077e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1009"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('55107-7')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('55107-7')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): The value for code SHALL be '55107-7'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('External documents') or not(@displayName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@displayName) = ('External documents') or not(@displayName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): The value for displayName SHALL be 'External documents'. Found: "<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]"
                 priority="1008"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19446-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19446-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19446' x_ActRelationshipEntry (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.676-2025-06-04T083500.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento a invito precedente): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextConductionInd"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]"
                 priority="1006"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ACT')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ACT')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): The value for classCode SHALL be 'ACT'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): element hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): element hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): element hl7:reference[@typeCode = 'REFR'][hl7:externalDocument] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): element hl7:reference[@typeCode = 'REFR'][hl7:externalDocument] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']"
                 priority="1005"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.677')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.677')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.677'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]/hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1004"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('55107-7')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('55107-7')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): The value for code SHALL be '55107-7'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('External documents') or not(@displayName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@displayName) = ('External documents') or not(@displayName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): The value for displayName SHALL be 'External documents'. Found: "<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]"
                 priority="1003"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('REFR')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('REFR')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): The value for typeCode SHALL be 'REFR'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:externalDocument[not(@nullFlavor)][hl7:id]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:externalDocument[not(@nullFlavor)][hl7:id]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): element hl7:externalDocument[not(@nullFlavor)][hl7:id] is mandatory [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:externalDocument[not(@nullFlavor)][hl7:id]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:externalDocument[not(@nullFlavor)][hl7:id]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): element hl7:externalDocument[not(@nullFlavor)][hl7:id] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[not(@nullFlavor)][hl7:id]"
                 priority="1002"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('DOCCLIN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[not(@nullFlavor)][hl7:id]/hl7:id"
                 priority="1001"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.676']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.677']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[not(@nullFlavor)][hl7:id]/hl7:code"
                 priority="1000"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.677-2025-06-04T083909.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(screening)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M18"/>
   <xsl:template match="@*|node()" priority="-2" mode="M18">
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123Section per lettera di invito screening-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Section per lettera di invito screening</svrl:text>

	  <!--RULE d45e1953-false-d7374e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]"
                 priority="1026"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE d45e1967-false-d7427e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]"
                 priority="1025"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCSECT') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('DOCSECT') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): The value for classCode SHALL be 'DOCSECT'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): element hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): element hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:title) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): element hl7:title appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): element hl7:text is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): element hl7:text appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:encounter[@moodCode = 'APT']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entry[hl7:encounter[@moodCode = 'APT']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): element hl7:entry[hl7:encounter[@moodCode = 'APT']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): element hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): element hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE d45e1970-false-d7515e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']"
                 priority="1024"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.941')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.941')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.941'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE d45e1973-false-d7535e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1023"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('112071-6')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('112071-6')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): The value for code SHALL be '112071-6'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Screening invitation letter [Text] Narrative Preventive medicine') or not(@displayName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@displayName) = ('Screening invitation letter [Text] Narrative Preventive medicine') or not(@displayName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): The value for displayName SHALL be 'Screening invitation letter [Text] Narrative Preventive medicine'. Found: "<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]"
                 priority="1022"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): Attribute @typeCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]"
                 priority="1020"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('APT')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('APT')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): The value for moodCode SHALL be 'APT'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:effectiveTime is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:participant) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:participant) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:participant appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant"
                 priority="1019"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode ) = ('LOC') or not(@typeCode )"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode ) = ('LOC') or not(@typeCode )">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): The value for typeCode  SHALL be 'LOC'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode "/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:participantRole) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:participantRole) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:participantRole appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole"
                 priority="1018"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('SDLOC') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('SDLOC') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): The value for classCode SHALL be 'SDLOC'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:playingEntity[hl7:name]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:playingEntity[hl7:name]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:playingEntity[hl7:name] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:addr appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:playingEntity[hl7:name]"
                 priority="1017"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr"
                 priority="1016"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:telecom"
                 priority="1014"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:id"
                 priority="1013"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): Attribute @root SHALL be of data type 'oid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@ assignedAuthorityName) or string-length(@ assignedAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@ assignedAuthorityName) or string-length(@ assignedAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): Attribute @ assignedAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@ assignedAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]"
                 priority="1012"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@ typeCode) = ('COMP') or not(@ typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@ typeCode) = ('COMP') or not(@ typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): The value for  typeCode SHALL be 'COMP'. Found: "<xsl:text/>
                  <xsl:value-of select="@ typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]"
                 priority="1011"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('OBS') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('OBS') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): The value for classCode SHALL be 'OBS'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): element hl7:text appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]"
                 priority="1010"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('ASSERTION')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('ASSERTION')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): The value for code SHALL be 'ASSERTION'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.4')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.5.4')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): The value for codeSystem SHALL be '2.16.840.1.113883.5.4'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_Screening_Appuntamento): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]"
                 priority="1009"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19446-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19446-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19446' x_ActRelationshipEntry (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.941-2026-02-26T145123.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per lettera di invito screening): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextConductionInd"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]"
                 priority="1007"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ACT')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ACT')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): The value for classCode SHALL be 'ACT'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): element hl7:text is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): element hl7:text appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): element hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): element hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']"
                 priority="1006"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.614')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.614')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.614'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1']"
                 priority="1005"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.61-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.61-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.61' Livello screening (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]"
                 priority="1004"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): element hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): element hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('COMP')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ActLivelloScreening): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]"
                 priority="1002"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PROC') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PROC') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): The value for classCode SHALL be 'PROC'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): element hl7:code is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']"
                 priority="1001"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.623')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.623')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.623'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.941']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]/hl7:code"
                 priority="1000"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20260227T144652/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(PrestazioneScreening): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M19"/>
   <xsl:template match="@*|node()" priority="-2" mode="M19">
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>
</xsl:stylesheet>
