<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Name: Erogazione Farmaceutica non a carico SSN
Description: 
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616">
   <title>Erogazione Farmaceutica non a carico SSN</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]"
         id="d45e7-false-d430e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:realmCode) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:realmCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:id) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:id) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:title) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:effectiveTime[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:languageCode) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:languageCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:languageCode) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:languageCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:setId) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:versionNumber) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:versionNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:author[hl7:assignedAuthor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:dataEnterer[hl7:assignedEntity]) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:dataEnterer[hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:custodian[hl7:assignedCustodian] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">(Erogazione Farmaceutica non a carico SSN): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:component[not(@nullFlavor)][hl7:structuredBody]) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:component[not(@nullFlavor)][hl7:structuredBody] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:component[not(@nullFlavor)][hl7:structuredBody]) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:component[not(@nullFlavor)][hl7:structuredBody] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:realmCode
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:realmCode"
         id="d45e8-false-d1005e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="@code">(Erogazione Farmaceutica non a carico SSN): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Erogazione Farmaceutica non a carico SSN): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']"
         id="d45e19-false-d1021e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@root) = ('2.16.840.1.113883.1.3')">(Erogazione Farmaceutica non a carico SSN): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@extension) = ('POCD_MT000040UV02')">(Erogazione Farmaceutica non a carico SSN): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Erogazione Farmaceutica non a carico SSN): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']"
         id="d45e40-false-d1040e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.13.2.1')">(Erogazione Farmaceutica non a carico SSN): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.13.2.1'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@extension) = ('1.0')">(Erogazione Farmaceutica non a carico SSN): The value for extension SHALL be '1.0'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Erogazione Farmaceutica non a carico SSN): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:id
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:id"
         id="d45e50-false-d1058e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="@root">(Erogazione Farmaceutica non a carico SSN): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Erogazione Farmaceutica non a carico SSN): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="@extension">(Erogazione Farmaceutica non a carico SSN): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Erogazione Farmaceutica non a carico SSN): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Erogazione Farmaceutica non a carico SSN): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d45e59-false-d1080e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@code) = ('60593-1')">(Erogazione Farmaceutica non a carico SSN): The value for code SHALL be '60593-1'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Erogazione Farmaceutica non a carico SSN): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Erogazione Farmaceutica non a carico SSN): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Erogazione Farmaceutica non a carico SSN): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Erogazione Farmaceutica non a carico SSN): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation"
         id="d45e72-false-d1108e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="@code">(Erogazione Farmaceutica non a carico SSN): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Erogazione Farmaceutica non a carico SSN): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="@codeSystem">(Erogazione Farmaceutica non a carico SSN): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Erogazione Farmaceutica non a carico SSN): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Erogazione Farmaceutica non a carico SSN): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Erogazione Farmaceutica non a carico SSN): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:title
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:effectiveTime[not(@nullFlavor)]
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:effectiveTime[not(@nullFlavor)]"
         id="d45e86-false-d1140e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="@value">(Erogazione Farmaceutica non a carico SSN): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Erogazione Farmaceutica non a carico SSN): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']"
         id="d45e95-false-d1154e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="@nullFlavor or (@code='N') or (@code='V')">(Erogazione Farmaceutica non a carico SSN): The element value SHALL be one of 'code 'N' or code 'V''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="@code">(Erogazione Farmaceutica non a carico SSN): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Erogazione Farmaceutica non a carico SSN): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.25')">(Erogazione Farmaceutica non a carico SSN): The value for codeSystem SHALL be '2.16.840.1.113883.5.25'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName)">(Erogazione Farmaceutica non a carico SSN): The value for codeSystemName SHALL be 'HL7 Confidentiality'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Erogazione Farmaceutica non a carico SSN): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Erogazione Farmaceutica non a carico SSN): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:languageCode
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:languageCode"
         id="d45e121-false-d1187e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="@code">(Erogazione Farmaceutica non a carico SSN): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Erogazione Farmaceutica non a carico SSN): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:setId
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:setId"
         id="d45e134-false-d1200e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="@root">(Erogazione Farmaceutica non a carico SSN): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Erogazione Farmaceutica non a carico SSN): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="@extension">(Erogazione Farmaceutica non a carico SSN): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Erogazione Farmaceutica non a carico SSN): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Erogazione Farmaceutica non a carico SSN): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:versionNumber
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:versionNumber"
         id="d45e150-false-d1221e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="@value">(Erogazione Farmaceutica non a carico SSN): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')">(Erogazione Farmaceutica non a carico SSN): Attribute @value is not a valid int number <value-of select="@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]"
         id="d1228e21-false-d1315e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="string(@typeCode) = ('RCT') or not(@typeCode)">(CDA recordTarget (Erog non a carico SSN)): The value for typeCode SHALL be 'RCT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA recordTarget (Erog non a carico SSN)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:patientRole[@classCode = 'PAT'][hl7:patient]) &gt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:patientRole[@classCode = 'PAT'][hl7:patient] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:patientRole[@classCode = 'PAT'][hl7:patient]) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:patientRole[@classCode = 'PAT'][hl7:patient] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]"
         id="d1228e27-false-d1499e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="string(@classCode) = ('PAT')">(CDA recordTarget (Erog non a carico SSN)): The value for classCode SHALL be 'PAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:id) &gt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:providerOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:id
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:id"
         id="d1228e29-false-d1623e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@root">(CDA recordTarget (Erog non a carico SSN)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTarget (Erog non a carico SSN)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@extension">(CDA recordTarget (Erog non a carico SSN)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTarget (Erog non a carico SSN)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA recordTarget (Erog non a carico SSN)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:addr
Item: (CDA recordTarget (Erog non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:addr">
      <extends rule="d1677e0-false-d1683e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@use">(CDA recordTarget (Erog non a carico SSN)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget (Erog non a carico SSN)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d1677e0-false-d1683e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:telecom
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:telecom"
         id="d1228e122-false-d1795e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@use">(CDA recordTarget (Erog non a carico SSN)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget (Erog non a carico SSN)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@value">(CDA recordTarget (Erog non a carico SSN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@value) or string-length(@value)&gt;0">(CDA recordTarget (Erog non a carico SSN)): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
         id="d1228e146-false-d1867e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTarget (Erog non a carico SSN)): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTarget (Erog non a carico SSN)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:birthTime) &gt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:birthTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:birthTime) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:birthTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name"
         id="d1228e158-false-d1959e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:family) &gt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:family) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:given) &gt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:given) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:given appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:family
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:given
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d1228e186-false-d2002e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA recordTarget (Erog non a carico SSN)): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@code">(CDA recordTarget (Erog non a carico SSN)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA recordTarget (Erog non a carico SSN)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.1')">(CDA recordTarget (Erog non a carico SSN)): The value for codeSystem SHALL be '2.16.840.1.113883.5.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="string(@codeSystemName) = ('HL7 AdministrativeGender') or not(@codeSystemName)">(CDA recordTarget (Erog non a carico SSN)): The value for codeSystemName SHALL be 'HL7 AdministrativeGender'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA recordTarget (Erog non a carico SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA recordTarget (Erog non a carico SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime"
         id="d1228e214-false-d2037e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@value">(CDA recordTarget (Erog non a carico SSN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDA recordTarget (Erog non a carico SSN)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian"
         id="d1228e233-false-d2091e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="string(@classCode) = ('GUARD') or not(@classCode)">(CDA recordTarget (Erog non a carico SSN)): The value for classCode SHALL be 'GUARD'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:code) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:guardianPerson) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:guardianPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:guardianOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id"
         id="d1228e243-false-d2174e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@root">(CDA recordTarget (Erog non a carico SSN)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTarget (Erog non a carico SSN)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@extension">(CDA recordTarget (Erog non a carico SSN)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTarget (Erog non a carico SSN)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA recordTarget (Erog non a carico SSN)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code"
         id="d1228e255-false-d2195e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@code">(CDA recordTarget (Erog non a carico SSN)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA recordTarget (Erog non a carico SSN)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@codeSystem">(CDA recordTarget (Erog non a carico SSN)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(CDA recordTarget (Erog non a carico SSN)): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA recordTarget (Erog non a carico SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA recordTarget (Erog non a carico SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr
Item: (CDA recordTarget (Erog non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr">
      <extends rule="d2252e0-false-d2258e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@use">(CDA recordTarget (Erog non a carico SSN)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget (Erog non a carico SSN)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d2252e0-false-d2258e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:telecom
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:telecom"
         id="d1228e285-false-d2370e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@use">(CDA recordTarget (Erog non a carico SSN)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget (Erog non a carico SSN)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="@value">(CDA recordTarget (Erog non a carico SSN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@value) or string-length(@value)&gt;0">(CDA recordTarget (Erog non a carico SSN)): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson
Item: (CDA recordTarget (Erog non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTarget (Erog non a carico SSN)): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA recordTarget (Erog non a carico SSN)): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.61
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson
Item: (CDA person (Pr))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.61
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name
Item: (CDA person (Pr))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d2648e0-false-d2654e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d2648e0-false-d2654e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d2812e0-false-d2848e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d2812e0-false-d2848e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d3018e0-false-d3022e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d3018e0-false-d3022e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d3188e0-false-d3194e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d3188e0-false-d3194e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3352e0-false-d3388e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d3352e0-false-d3388e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]"
         id="d1228e327-false-d3564e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="string(@classCode) = ('BIRTHPL')">(CDA recordTarget (Erog non a carico SSN)): The value for classCode SHALL be 'BIRTHPL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:place) &gt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:place is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:place) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:place appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]/hl7:place
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]/hl7:place"
         id="d1228e344-false-d3584e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA recordTarget (Erog non a carico SSN)): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTarget (Erog non a carico SSN)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:addr) &gt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:addr is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:addr) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:addr appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]/hl7:place/hl7:addr
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]/hl7:place/hl7:addr"
         id="d1228e372-false-d3608e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:country) &gt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:country) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:state) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:county) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:city) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:censusTract appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.820-2025-10-14T163315.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA recordTarget (Erog non a carico SSN)): element hl7:postalCode appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]/hl7:place/hl7:addr/hl7:country
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]/hl7:place/hl7:addr/hl7:state
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]/hl7:place/hl7:addr/hl7:county
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]/hl7:place/hl7:addr/hl7:city
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]/hl7:place/hl7:addr/hl7:censusTract
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]/hl7:place/hl7:addr/hl7:postalCode
Item: (CDA recordTarget (Erog non a carico SSN))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.820
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA recordTarget (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3909e0-false-d3915e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d3909e0-false-d3915e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4073e0-false-d4109e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d4073e0-false-d4109e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d4279e0-false-d4283e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d4279e0-false-d4283e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d4449e0-false-d4455e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d4449e0-false-d4455e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4613e0-false-d4649e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d4613e0-false-d4649e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.821
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]
Item: (CDA author (Erog non a carico SNN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]"
         id="d3735e427-false-d4874e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA author (Erog non a carico SNN)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA author (Erog non a carico SNN)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="count(hl7:time) &gt;= 1">(CDA author (Erog non a carico SNN)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="count(hl7:time) &lt;= 1">(CDA author (Erog non a carico SNN)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="count(hl7:assignedAuthor[hl7:assignedPerson]) &gt;= 1">(CDA author (Erog non a carico SNN)): element hl7:assignedAuthor[hl7:assignedPerson] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="count(hl7:assignedAuthor[hl7:assignedPerson]) &lt;= 1">(CDA author (Erog non a carico SNN)): element hl7:assignedAuthor[hl7:assignedPerson] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.821
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA author (Erog non a carico SNN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:time"
         id="d3735e435-false-d4954e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="@value">(CDA author (Erog non a carico SNN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDA author (Erog non a carico SNN)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.821
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]
Item: (CDA author (Erog non a carico SNN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]"
         id="d3735e453-false-d5015e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="count(hl7:id) &gt;= 1">(CDA author (Erog non a carico SNN)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="count(hl7:code) &lt;= 1">(CDA author (Erog non a carico SNN)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="count(hl7:assignedPerson) &gt;= 1">(CDA author (Erog non a carico SNN)): element hl7:assignedPerson is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA author (Erog non a carico SNN)): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA author (Erog non a carico SNN)): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.821
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:id
Item: (CDA author (Erog non a carico SNN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:id"
         id="d3735e457-false-d5105e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="@root">(CDA author (Erog non a carico SNN)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA author (Erog non a carico SNN)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="@extension">(CDA author (Erog non a carico SNN)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA author (Erog non a carico SNN)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA author (Erog non a carico SNN)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.821
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:code
Item: (CDA author (Erog non a carico SNN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:code"
         id="d3735e493-false-d5126e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="@code">(CDA author (Erog non a carico SNN)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author (Erog non a carico SNN)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.12' RoleCodeIT (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="@codeSystem">(CDA author (Erog non a carico SNN)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA author (Erog non a carico SNN)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA author (Erog non a carico SNN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA author (Erog non a carico SNN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.821
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr
Item: (CDA author (Erog non a carico SNN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr">
      <extends rule="d5193e0-false-d5199e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="@use">(CDA author (Erog non a carico SNN)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author (Erog non a carico SNN)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d5193e0-false-d5199e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.821
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:telecom
Item: (CDA author (Erog non a carico SNN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:telecom"
         id="d3735e519-false-d5311e0">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author (Erog non a carico SNN)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="@value">(CDA author (Erog non a carico SNN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.821-2025-10-14T163506.html"
              test="not(@value) or string-length(@value)&gt;0">(CDA author (Erog non a carico SNN)): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.821
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson
Item: (CDA author (Erog non a carico SNN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.821
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA author (Erog non a carico SNN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.828
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization (non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="string(@classCode) = ('ORG')">(CDA Organization (non a carico SSN)): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization (non a carico SSN)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization (non a carico SSN)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization (non a carico SSN)): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization (non a carico SSN)): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.828
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization (non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="@root">(CDA Organization (non a carico SSN)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization (non a carico SSN)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="@extension">(CDA Organization (non a carico SSN)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization (non a carico SSN)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization (non a carico SSN)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.828
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization (non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.828
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization (non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="@use">(CDA Organization (non a carico SSN)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization (non a carico SSN)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.828
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization (non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d5684e0-false-d5690e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="@use">(CDA Organization (non a carico SSN)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization (non a carico SSN)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d5684e0-false-d5690e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.828
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization (non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d5848e0-false-d5884e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization (non a carico SSN)): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.828-2025-10-14T170148.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization (non a carico SSN)): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.827
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf (non a carico SSN))
-->
   <rule fpi="RULC-1" id="d5848e0-false-d5884e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf (non a carico SSN)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf (non a carico SSN)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf (non a carico SSN)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf (non a carico SSN)): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.827
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf (non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="@root">(CDA organizationPartOf (non a carico SSN)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf (non a carico SSN)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="@extension">(CDA organizationPartOf (non a carico SSN)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf (non a carico SSN)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf (non a carico SSN)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.827
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf (non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="@code">(CDA organizationPartOf (non a carico SSN)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf (non a carico SSN)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="@codeSystem">(CDA organizationPartOf (non a carico SSN)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf (non a carico SSN)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf (non a carico SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf (non a carico SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf (non a carico SSN)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.827
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf (non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.827
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf (non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.827
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf (non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d6054e0-false-d6058e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.827-2025-10-14T165536.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf (non a carico SSN)): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d6054e0-false-d6058e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d6224e0-false-d6230e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d6224e0-false-d6230e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d6388e0-false-d6424e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d6388e0-false-d6424e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d6594e0-false-d6598e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d6594e0-false-d6598e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d6764e0-false-d6770e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d6764e0-false-d6770e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d6928e0-false-d6964e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d6928e0-false-d6964e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.822
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]
Item: (CDA dataEnterer (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]"
         id="d5510e583-false-d7190e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.822-2025-10-14T163638.html"
              test="string(@typeCode) = ('ENT') or not(@typeCode)">(CDA dataEnterer (Erog non a carico SSN)): The value for typeCode SHALL be 'ENT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.822-2025-10-14T163638.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA dataEnterer (Erog non a carico SSN)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.822-2025-10-14T163638.html"
              test="count(hl7:time) &lt;= 1">(CDA dataEnterer (Erog non a carico SSN)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.822-2025-10-14T163638.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA dataEnterer (Erog non a carico SSN)): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.822-2025-10-14T163638.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA dataEnterer (Erog non a carico SSN)): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.822
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:time
Item: (CDA dataEnterer (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:time"
         id="d5510e594-false-d7269e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.822-2025-10-14T163638.html"
              test="@value">(CDA dataEnterer (Erog non a carico SSN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.822-2025-10-14T163638.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDA dataEnterer (Erog non a carico SSN)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.822
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA dataEnterer (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity v1.0): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@root">(CDA AssignedEntity v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@extension">(CDA AssignedEntity v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@code">(CDA AssignedEntity v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@codeSystem">(CDA AssignedEntity v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d7571e0-false-d7577e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@use">(CDA AssignedEntity v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d7571e0-false-d7577e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@use">(CDA AssignedEntity v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d8060e0-false-d8066e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d8060e0-false-d8066e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d8224e0-false-d8260e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d8224e0-false-d8260e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d8430e0-false-d8434e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d8430e0-false-d8434e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d8600e0-false-d8606e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d8600e0-false-d8606e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d8764e0-false-d8800e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d8764e0-false-d8800e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.823
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]
Item: (CDA custodian (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]"
         id="d7336e564-false-d8986e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="string(@typeCode) = ('CST') or not(@typeCode)">(CDA custodian (Erog non a carico SSN)): The value for typeCode SHALL be 'CST'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1">(CDA custodian (Erog non a carico SSN)): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1">(CDA custodian (Erog non a carico SSN)): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.823
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA custodian (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]"
         id="d7336e612-false-d9024e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA custodian (Erog non a carico SSN)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="count(hl7:representedCustodianOrganization) &gt;= 1">(CDA custodian (Erog non a carico SSN)): element hl7:representedCustodianOrganization is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="count(hl7:representedCustodianOrganization) &lt;= 1">(CDA custodian (Erog non a carico SSN)): element hl7:representedCustodianOrganization appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.823
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (CDA custodian (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization"
         id="d7336e617-false-d9062e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA custodian (Erog non a carico SSN)): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA custodian (Erog non a carico SSN)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="count(hl7:id) &gt;= 1">(CDA custodian (Erog non a carico SSN)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="count(hl7:name) &lt;= 1">(CDA custodian (Erog non a carico SSN)): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="count(hl7:addr) &lt;= 1">(CDA custodian (Erog non a carico SSN)): element hl7:addr appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.823
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id
Item: (CDA custodian (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id"
         id="d7336e620-false-d9109e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="@root">(CDA custodian (Erog non a carico SSN)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA custodian (Erog non a carico SSN)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="@extension">(CDA custodian (Erog non a carico SSN)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA custodian (Erog non a carico SSN)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA custodian (Erog non a carico SSN)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.823
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:name
Item: (CDA custodian (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.823
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom
Item: (CDA custodian (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom"
         id="d7336e644-false-d9138e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="@use">(CDA custodian (Erog non a carico SSN)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA custodian (Erog non a carico SSN)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="@value">(CDA custodian (Erog non a carico SSN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="not(@value) or string-length(@value)&gt;0">(CDA custodian (Erog non a carico SSN)): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.823
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (CDA custodian (Erog non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr">
      <extends rule="d9199e0-false-d9205e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="@use">(CDA custodian (Erog non a carico SSN)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.823-2025-10-14T163806.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA custodian (Erog non a carico SSN)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d9199e0-false-d9205e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.900
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]
Item: (CDA legalAuthenticator (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
         id="d9180e71-false-d9368e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.900-2026-01-13T104904.html"
              test="string(@typeCode) = ('LA') or not(@typeCode)">(CDA legalAuthenticator (Erog non a carico SSN)): The value for typeCode SHALL be 'LA'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.900-2026-01-13T104904.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA legalAuthenticator (Erog non a carico SSN)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.900-2026-01-13T104904.html"
              test="count(hl7:time) &gt;= 1">(CDA legalAuthenticator (Erog non a carico SSN)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.900-2026-01-13T104904.html"
              test="count(hl7:time) &lt;= 1">(CDA legalAuthenticator (Erog non a carico SSN)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.900-2026-01-13T104904.html"
              test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">(CDA legalAuthenticator (Erog non a carico SSN)): element hl7:signatureCode[@code = 'S'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.900-2026-01-13T104904.html"
              test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">(CDA legalAuthenticator (Erog non a carico SSN)): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.900-2026-01-13T104904.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA legalAuthenticator (Erog non a carico SSN)): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.900-2026-01-13T104904.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA legalAuthenticator (Erog non a carico SSN)): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.900
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time
Item: (CDA legalAuthenticator (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time"
         id="d9180e79-false-d9458e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.900-2026-01-13T104904.html"
              test="@value">(CDA legalAuthenticator (Erog non a carico SSN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.900-2026-01-13T104904.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDA legalAuthenticator (Erog non a carico SSN)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.900
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']
Item: (CDA legalAuthenticator (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
         id="d9180e90-false-d9472e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.900-2026-01-13T104904.html"
              test="string(@code) = ('S')">(CDA legalAuthenticator (Erog non a carico SSN)): The value for code SHALL be 'S'. Found: "<value-of select="@code"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.900
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA legalAuthenticator (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity v1.0): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@root">(CDA AssignedEntity v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@extension">(CDA AssignedEntity v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@code">(CDA AssignedEntity v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@codeSystem">(CDA AssignedEntity v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr">
      <extends rule="d9772e0-false-d9778e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@use">(CDA AssignedEntity v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d9772e0-false-d9778e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@use">(CDA AssignedEntity v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d10261e0-false-d10267e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d10261e0-false-d10267e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d10425e0-false-d10461e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d10425e0-false-d10461e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d10631e0-false-d10635e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d10631e0-false-d10635e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d10801e0-false-d10807e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d10801e0-false-d10807e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d10965e0-false-d11001e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d10965e0-false-d11001e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.825
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]
Item: (CDA authenticator (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]"
         id="d9537e564-false-d11228e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.825-2025-10-14T163949.html"
              test="string(@typeCode) = ('AUTHEN') or not(@typeCode)">(CDA authenticator (Erog non a carico SSN)): The value for typeCode SHALL be 'AUTHEN'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.825-2025-10-14T163949.html"
              test="count(hl7:time) &gt;= 1">(CDA authenticator (Erog non a carico SSN)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.825-2025-10-14T163949.html"
              test="count(hl7:time) &lt;= 1">(CDA authenticator (Erog non a carico SSN)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.825-2025-10-14T163949.html"
              test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">(CDA authenticator (Erog non a carico SSN)): element hl7:signatureCode[@code = 'S'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.825-2025-10-14T163949.html"
              test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">(CDA authenticator (Erog non a carico SSN)): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.825-2025-10-14T163949.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA authenticator (Erog non a carico SSN)): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.825-2025-10-14T163949.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA authenticator (Erog non a carico SSN)): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.825
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:time
Item: (CDA authenticator (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:time"
         id="d9537e581-false-d11314e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.825-2025-10-14T163949.html"
              test="@value">(CDA authenticator (Erog non a carico SSN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.825-2025-10-14T163949.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDA authenticator (Erog non a carico SSN)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.825
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']
Item: (CDA authenticator (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
         id="d9537e590-false-d11328e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.825-2025-10-14T163949.html"
              test="string(@code) = ('S')">(CDA authenticator (Erog non a carico SSN)): The value for code SHALL be 'S'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.825-2025-10-14T163949.html"
              test="not(@code) or string-length(@code)&gt;0">(CDA authenticator (Erog non a carico SSN)): Attribute @code SHALL be of data type 'st'  - '<value-of select="@code"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.825
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA authenticator (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.831
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA AssignedEntity(Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity(Erog non SSN)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity(Erog non SSN)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity(Erog non SSN)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity(Erog non SSN)): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity(Erog non SSN)): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity(Erog non SSN)): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.831
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity(Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="@root">(CDA AssignedEntity(Erog non SSN)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity(Erog non SSN)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="@extension">(CDA AssignedEntity(Erog non SSN)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity(Erog non SSN)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity(Erog non SSN)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.831
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity(Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="@code">(CDA AssignedEntity(Erog non SSN)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity(Erog non SSN)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="@codeSystem">(CDA AssignedEntity(Erog non SSN)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity(Erog non SSN)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity(Erog non SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity(Erog non SSN)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity(Erog non SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.831
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity(Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr">
      <extends rule="d11629e0-false-d11635e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="@use">(CDA AssignedEntity(Erog non SSN)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity(Erog non SSN)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d11629e0-false-d11635e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.831
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity(Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="@use">(CDA AssignedEntity(Erog non SSN)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity(Erog non SSN)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="@value">(CDA AssignedEntity(Erog non SSN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.831-2025-10-20T122415.html"
              test="not(@value) or string-length(@value)&gt;0">(CDA AssignedEntity(Erog non SSN)): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.831
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity(Erog non SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.831
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity(Erog non SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d12123e0-false-d12129e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d12123e0-false-d12129e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d12287e0-false-d12323e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d12287e0-false-d12323e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d12493e0-false-d12497e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d12493e0-false-d12497e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d12663e0-false-d12669e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d12663e0-false-d12669e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d12827e0-false-d12863e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d12827e0-false-d12863e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.826
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]
Item: (CDA participant (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]"
         id="d11396e568-false-d13088e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="@typeCode">(CDA participant (Erog non a carico SSN)): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(CDA participant (Erog non a carico SSN)): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA participant (Erog non a carico SSN)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA participant (Erog non a carico SSN)): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="count(hl7:time) &lt;= 1">(CDA participant (Erog non a carico SSN)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="count(hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]) &gt;= 1">(CDA participant (Erog non a carico SSN)): element hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="count(hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]) &lt;= 1">(CDA participant (Erog non a carico SSN)): element hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.826
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA participant (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d11396e574-false-d13179e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA participant (Erog non a carico SSN)): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="@code">(CDA participant (Erog non a carico SSN)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA participant (Erog non a carico SSN)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="@codeSystem">(CDA participant (Erog non a carico SSN)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(CDA participant (Erog non a carico SSN)): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA participant (Erog non a carico SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA participant (Erog non a carico SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.826
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:time
Item: (CDA participant (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:time"
         id="d11396e585-false-d13212e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="@value">(CDA participant (Erog non a carico SSN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDA participant (Erog non a carico SSN)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.826
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]
Item: (CDA participant (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]"
         id="d11396e587-false-d13273e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="@classCode">(CDA participant (Erog non a carico SSN)): attribute @classCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant (Erog non a carico SSN)): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.19313' RoleClassAssociative (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="count(hl7:id) &gt;= 1">(CDA participant (Erog non a carico SSN)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="count(hl7:code) &lt;= 1">(CDA participant (Erog non a carico SSN)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="count(hl7:associatedPerson) &lt;= 1">(CDA participant (Erog non a carico SSN)): element hl7:associatedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="count(hl7:scopingOrganization[@classCode = 'ORG']) &lt;= 1">(CDA participant (Erog non a carico SSN)): element hl7:scopingOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.826
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:id
Item: (CDA participant (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:id"
         id="d11396e590-false-d13376e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="@root">(CDA participant (Erog non a carico SSN)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$')">(CDA participant (Erog non a carico SSN)): Attribute @root SHALL be of data type 'oid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="@extension">(CDA participant (Erog non a carico SSN)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA participant (Erog non a carico SSN)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="count(hl7:assigningAuthorityName) &lt;= 1">(CDA participant (Erog non a carico SSN)): element hl7:assigningAuthorityName appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.826
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:id/hl7:assigningAuthorityName
Item: (CDA participant (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.826
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:code
Item: (CDA participant (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:code"
         id="d11396e594-false-d13408e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="@code">(CDA participant (Erog non a carico SSN)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA participant (Erog non a carico SSN)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="@codeSystem">(CDA participant (Erog non a carico SSN)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(CDA participant (Erog non a carico SSN)): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA participant (Erog non a carico SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA participant (Erog non a carico SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.826
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:addr
Item: (CDA participant (Erog non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:addr">
      <extends rule="d13455e0-false-d13461e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="@use">(CDA participant (Erog non a carico SSN)): attribute @use SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(CDA participant (Erog non a carico SSN)): Attribute @use SHALL be of data type 'cs'  - '<value-of select="@use"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d13455e0-false-d13461e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.826
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:telecom
Item: (CDA participant (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:telecom"
         id="d11396e601-false-d13573e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="@use">(CDA participant (Erog non a carico SSN)): attribute @use SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(CDA participant (Erog non a carico SSN)): Attribute @use SHALL be of data type 'cs'  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="@value ">(CDA participant (Erog non a carico SSN)): attribute @value  SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="not(@value ) or string-length(@value )&gt;0">(CDA participant (Erog non a carico SSN)): Attribute @value  SHALL be of data type 'st'  - '<value-of select="@value "/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.826
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:associatedPerson
Item: (CDA participant (Erog non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:associatedPerson">
      <extends rule="d13616e0-false-d13628e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA participant (Erog non a carico SSN)): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.826-2025-10-14T164147.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA participant (Erog non a carico SSN)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:associatedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1" id="d13616e0-false-d13628e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:associatedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:associatedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:associatedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:associatedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:associatedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:associatedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:associatedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.826
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']
Item: (CDA participant (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d13946e0-false-d13952e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d13946e0-false-d13952e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d14110e0-false-d14146e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d14110e0-false-d14146e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d14316e0-false-d14320e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d14316e0-false-d14320e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d14486e0-false-d14492e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d14486e0-false-d14492e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d14650e0-false-d14686e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d14650e0-false-d14686e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:id]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.819
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:inFulfillmentOf[hl7:order]
Item: (CDA inFulfillmentOf(Erog non SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:inFulfillmentOf[hl7:order]"
         id="d13772e396-false-d14863e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="string(@typeCode) = ('FLFS') or not(@typeCode)">(CDA inFulfillmentOf(Erog non SSN)): The value for typeCode SHALL be 'FLFS'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="count(hl7:order) &gt;= 1">(CDA inFulfillmentOf(Erog non SSN)): element hl7:order is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="count(hl7:order) &lt;= 1">(CDA inFulfillmentOf(Erog non SSN)): element hl7:order appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.819
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:inFulfillmentOf[hl7:order]/hl7:order
Item: (CDA inFulfillmentOf(Erog non SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:inFulfillmentOf[hl7:order]/hl7:order"
         id="d13772e401-false-d14883e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="string(@classCode) = ('ACT') or not(@classCode)">(CDA inFulfillmentOf(Erog non SSN)): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="string(@moodCode) = ('RQO') or not(@moodCode)">(CDA inFulfillmentOf(Erog non SSN)): The value for moodCode SHALL be 'RQO'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="count(hl7:id) &gt;= 1">(CDA inFulfillmentOf(Erog non SSN)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="count(hl7:id) &lt;= 1">(CDA inFulfillmentOf(Erog non SSN)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="count(hl7:code) &lt;= 1">(CDA inFulfillmentOf(Erog non SSN)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="count(hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA inFulfillmentOf(Erog non SSN)): element hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.819
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:id
Item: (CDA inFulfillmentOf(Erog non SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:id"
         id="d13772e410-false-d14922e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="@root">(CDA inFulfillmentOf(Erog non SSN)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA inFulfillmentOf(Erog non SSN)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="@extension">(CDA inFulfillmentOf(Erog non SSN)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA inFulfillmentOf(Erog non SSN)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA inFulfillmentOf(Erog non SSN)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.819
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:code
Item: (CDA inFulfillmentOf(Erog non SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:code"
         id="d13772e423-false-d14943e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="@code">(CDA inFulfillmentOf(Erog non SSN)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA inFulfillmentOf(Erog non SSN)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="@codeSystem">(CDA inFulfillmentOf(Erog non SSN)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(CDA inFulfillmentOf(Erog non SSN)): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA inFulfillmentOf(Erog non SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA inFulfillmentOf(Erog non SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.819
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA inFulfillmentOf(Erog non SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d13772e428-false-d14970e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA inFulfillmentOf(Erog non SSN)): The element value SHALL be one of '2.16.840.1.113883.1.11.16866 ActPriority (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="@code">(CDA inFulfillmentOf(Erog non SSN)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA inFulfillmentOf(Erog non SSN)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="@codeSystem">(CDA inFulfillmentOf(Erog non SSN)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA inFulfillmentOf(Erog non SSN)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA inFulfillmentOf(Erog non SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.819-2025-10-14T163006.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA inFulfillmentOf(Erog non SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.901
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]
Item: (CDA relatedDocument (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
         id="d14976e40-false-d15004e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="@typeCode">(CDA relatedDocument (Erog non a carico SSN)): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA relatedDocument (Erog non a carico SSN)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="count(hl7:parentDocument) &gt;= 1">(CDA relatedDocument (Erog non a carico SSN)): element hl7:parentDocument is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="count(hl7:parentDocument) &lt;= 1">(CDA relatedDocument (Erog non a carico SSN)): element hl7:parentDocument appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.901
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument
Item: (CDA relatedDocument (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
         id="d14976e93-false-d15035e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(CDA relatedDocument (Erog non a carico SSN)): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA relatedDocument (Erog non a carico SSN)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="count(hl7:id) &gt;= 1">(CDA relatedDocument (Erog non a carico SSN)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="count(hl7:code) &lt;= 1">(CDA relatedDocument (Erog non a carico SSN)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="count(hl7:text) &lt;= 1">(CDA relatedDocument (Erog non a carico SSN)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="count(hl7:setId) &lt;= 1">(CDA relatedDocument (Erog non a carico SSN)): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="count(hl7:versionNumber) &lt;= 1">(CDA relatedDocument (Erog non a carico SSN)): element hl7:versionNumber appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.901
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id
Item: (CDA relatedDocument (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
         id="d14976e120-false-d15081e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="@root">(CDA relatedDocument (Erog non a carico SSN)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocument (Erog non a carico SSN)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="@extension">(CDA relatedDocument (Erog non a carico SSN)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA relatedDocument (Erog non a carico SSN)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA relatedDocument (Erog non a carico SSN)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.901
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code
Item: (CDA relatedDocument (Erog non a carico SSN))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
         id="d14976e132-false-d15102e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="@code">(CDA relatedDocument (Erog non a carico SSN)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA relatedDocument (Erog non a carico SSN)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="@codeSystem">(CDA relatedDocument (Erog non a carico SSN)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(CDA relatedDocument (Erog non a carico SSN)): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA relatedDocument (Erog non a carico SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.901-2026-01-13T110005.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA relatedDocument (Erog non a carico SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.901
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:text
Item: (CDA relatedDocument (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.901
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:setId
Item: (CDA relatedDocument (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.901
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:versionNumber
Item: (CDA relatedDocument (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]"
         id="d45e178-false-d15177e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:structuredBody[not(@nullFlavor)][hl7:component]) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:structuredBody[not(@nullFlavor)][hl7:component] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:structuredBody[not(@nullFlavor)][hl7:component]) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:structuredBody[not(@nullFlavor)][hl7:component] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]
Item: (Erogazione Farmaceutica non a carico SSN)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]"
         id="d45e179-false-d15247e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@classCode) = ('DOCBODY') or not(@classCode)">(Erogazione Farmaceutica non a carico SSN): The value for classCode SHALL be 'DOCBODY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Erogazione Farmaceutica non a carico SSN): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]) &gt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]]) &lt;= 1">(Erogazione Farmaceutica non a carico SSN): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]
Item: (Erogazione Farmaceutica non a carico SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]">
      <extends rule="d15342e0-false-d15346e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Erogazione Farmaceutica non a carico SSN): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.809
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]
Item: (Section_Erogazione Farmaceutica non SSN)
-->
   <rule fpi="RULC-1" id="d15342e0-false-d15346e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]) &gt;= 1">(Section_Erogazione Farmaceutica non SSN): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]) &lt;= 1">(Section_Erogazione Farmaceutica non SSN): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.809
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]
Item: (Section_Erogazione Farmaceutica non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Section_Erogazione Farmaceutica non SSN): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Section_Erogazione Farmaceutica non SSN): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']) &gt;= 1">(Section_Erogazione Farmaceutica non SSN): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']) &lt;= 1">(Section_Erogazione Farmaceutica non SSN): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="count(hl7:code[(@code = '60590-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Section_Erogazione Farmaceutica non SSN): element hl7:code[(@code = '60590-7' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="count(hl7:code[(@code = '60590-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Section_Erogazione Farmaceutica non SSN): element hl7:code[(@code = '60590-7' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="count(hl7:title) &lt;= 1">(Section_Erogazione Farmaceutica non SSN): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="count(hl7:text) &gt;= 1">(Section_Erogazione Farmaceutica non SSN): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="count(hl7:text) &lt;= 1">(Section_Erogazione Farmaceutica non SSN): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="count(hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]) &gt;= 1">(Section_Erogazione Farmaceutica non SSN): element hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]] is required [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.809
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']
Item: (Section_Erogazione Farmaceutica non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.809')">(Section_Erogazione Farmaceutica non SSN): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.809'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.809
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:id
Item: (Section_Erogazione Farmaceutica non SSN)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.809
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:code[(@code = '60590-7' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Section_Erogazione Farmaceutica non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:code[(@code = '60590-7' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="string(@code) = ('60590-7')">(Section_Erogazione Farmaceutica non SSN): The value for code SHALL be '60590-7'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Section_Erogazione Farmaceutica non SSN): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Section_Erogazione Farmaceutica non SSN): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Section_Erogazione Farmaceutica non SSN): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Section_Erogazione Farmaceutica non SSN): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.809
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:title
Item: (Section_Erogazione Farmaceutica non SSN)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.809
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:text
Item: (Section_Erogazione Farmaceutica non SSN)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.809
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]
Item: (Section_Erogazione Farmaceutica non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]">
      <extends rule="d15583e0-false-d15587e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Section_Erogazione Farmaceutica non SSN): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.809-2025-10-07T121712.html"
              test="not(@contextConductionInd) or string(@contextConductionInd)=('true','false')">(Section_Erogazione Farmaceutica non SSN): Attribute @contextConductionInd SHALL be of data type 'bl'  - '<value-of select="@contextConductionInd"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1" id="d15583e0-false-d15587e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]) &gt;= 1">(Supply_ErogazioneF non SSN): element hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="string(@classCode) = ('SPLY') or not(@classCode)">(Supply_ErogazioneF non SSN): The value for classCode SHALL be 'SPLY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="string(@moodCode) = ('EVN')">(Supply_ErogazioneF non SSN): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']) &gt;= 1">(Supply_ErogazioneF non SSN): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:id) &gt;= 1">(Supply_ErogazioneF non SSN): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:id) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Supply_ErogazioneF non SSN): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:quantity) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:quantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:product[hl7:manufacturedProduct]) &gt;= 1">(Supply_ErogazioneF non SSN): element hl7:product[hl7:manufacturedProduct] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:product[hl7:manufacturedProduct]) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:product[hl7:manufacturedProduct] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]) &gt;= 1">(Supply_ErogazioneF non SSN): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]) &gt;= 1">(Supply_ErogazioneF non SSN): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]]) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.810')">(Supply_ErogazioneF non SSN): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.810'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:id
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="@root">(Supply_ErogazioneF non SSN): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Supply_ErogazioneF non SSN): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="@extension">(Supply_ErogazioneF non SSN): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Supply_ErogazioneF non SSN): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Supply_ErogazioneF non SSN): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:effectiveTime
Item: (Supply_ErogazioneF non SSN)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:quantity
Item: (Supply_ErogazioneF non SSN)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:product[hl7:manufacturedProduct]
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:product[hl7:manufacturedProduct]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]]) &gt;= 1">(Supply_ErogazioneF non SSN): element hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]]) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:product[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]]
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:product[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:id) &gt;= 1">(Supply_ErogazioneF non SSN): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:id) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]) &gt;= 1">(Supply_ErogazioneF non SSN): element hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:product[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]]/hl7:id
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:product[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]]/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="@root">(Supply_ErogazioneF non SSN): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Supply_ErogazioneF non SSN): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="@extension">(Supply_ErogazioneF non SSN): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Supply_ErogazioneF non SSN): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Supply_ErogazioneF non SSN): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:product[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]]/hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:product[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]]/hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']) &gt;= 1">(Supply_ErogazioneF non SSN): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="count(hl7:name) &lt;= 1">(Supply_ErogazioneF non SSN): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:product[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]]/hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:product[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]]/hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="@code">(Supply_ErogazioneF non SSN): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Supply_ErogazioneF non SSN): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.1.5')">(Supply_ErogazioneF non SSN): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.6.1.5'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Supply_ErogazioneF non SSN): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Supply_ErogazioneF non SSN): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:product[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]]/hl7:manufacturedLabeledDrug[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.5']]/hl7:name
Item: (Supply_ErogazioneF non SSN)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]">
      <extends rule="d15945e0-false-d15949e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="string(@typeCode) = ('COMP')">(Supply_ErogazioneF non SSN): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.829
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]
Item: (Observation_Prezzo(Erog non SSN))
-->
   <rule fpi="RULC-1" id="d15945e0-false-d15949e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]) &gt;= 1">(Observation_Prezzo(Erog non SSN)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]) &lt;= 1">(Observation_Prezzo(Erog non SSN)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.829
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]
Item: (Observation_Prezzo(Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Observation_Prezzo(Erog non SSN)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Observation_Prezzo(Erog non SSN)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']) &gt;= 1">(Observation_Prezzo(Erog non SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']) &lt;= 1">(Observation_Prezzo(Erog non SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="count(hl7:code[(@code = '92033-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Observation_Prezzo(Erog non SSN)): element hl7:code[(@code = '92033-0' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="count(hl7:code[(@code = '92033-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Observation_Prezzo(Erog non SSN)): element hl7:code[(@code = '92033-0' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="count(hl7:text) &lt;= 1">(Observation_Prezzo(Erog non SSN)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="count(hl7:value) &lt;= 1">(Observation_Prezzo(Erog non SSN)): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.829
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']
Item: (Observation_Prezzo(Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.829')">(Observation_Prezzo(Erog non SSN)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.829'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.829
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]/hl7:code[(@code = '92033-0' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Observation_Prezzo(Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]/hl7:code[(@code = '92033-0' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="string(@code) = ('92033-0')">(Observation_Prezzo(Erog non SSN)): The value for code SHALL be '92033-0'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Observation_Prezzo(Erog non SSN)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Observation_Prezzo(Erog non SSN)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Observation_Prezzo(Erog non SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="string(@displayName) = ('Purchase cost [#] Supply') or not(@displayName)">(Observation_Prezzo(Erog non SSN)): The value for displayName SHALL be 'Purchase cost [#] Supply'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Observation_Prezzo(Erog non SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.829
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]/hl7:text
Item: (Observation_Prezzo(Erog non SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.829
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]/hl7:value
Item: (Observation_Prezzo(Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.829']]/hl7:value">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="@value">(Observation_Prezzo(Erog non SSN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.829-2025-10-20T114030.html"
              test="@currency">(Observation_Prezzo(Erog non SSN)): attribute @currency SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]">
      <extends rule="d16090e0-false-d16094e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="string(@typeCode) = ('COMP')">(Supply_ErogazioneF non SSN): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.830
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]
Item: (Observation_AltriCosti(Erog non SSN))
-->
   <rule fpi="RULC-1" id="d16090e0-false-d16094e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]) &gt;= 1">(Observation_AltriCosti(Erog non SSN)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]) &lt;= 1">(Observation_AltriCosti(Erog non SSN)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.830
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]
Item: (Observation_AltriCosti(Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Observation_AltriCosti(Erog non SSN)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Observation_AltriCosti(Erog non SSN)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']) &gt;= 1">(Observation_AltriCosti(Erog non SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']) &lt;= 1">(Observation_AltriCosti(Erog non SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="count(hl7:code[(@code = ' surcharge' and @codeSystem = '2.16.840.1.113883.4.642.3.3093')]) &gt;= 1">(Observation_AltriCosti(Erog non SSN)): element hl7:code[(@code = ' surcharge' and @codeSystem = '2.16.840.1.113883.4.642.3.3093')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="count(hl7:code[(@code = ' surcharge' and @codeSystem = '2.16.840.1.113883.4.642.3.3093')]) &lt;= 1">(Observation_AltriCosti(Erog non SSN)): element hl7:code[(@code = ' surcharge' and @codeSystem = '2.16.840.1.113883.4.642.3.3093')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="count(hl7:text) &lt;= 1">(Observation_AltriCosti(Erog non SSN)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="count(hl7:value) &lt;= 1">(Observation_AltriCosti(Erog non SSN)): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.830
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']
Item: (Observation_AltriCosti(Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.830')">(Observation_AltriCosti(Erog non SSN)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.830'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.830
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]/hl7:code[(@code = ' surcharge' and @codeSystem = '2.16.840.1.113883.4.642.3.3093')]
Item: (Observation_AltriCosti(Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]/hl7:code[(@code = ' surcharge' and @codeSystem = '2.16.840.1.113883.4.642.3.3093')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="string(@code) = ('surcharge')">(Observation_AltriCosti(Erog non SSN)): The value for code SHALL be 'surcharge'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.4.642.3.3093')">(Observation_AltriCosti(Erog non SSN)): The value for codeSystem SHALL be '2.16.840.1.113883.4.642.3.3093'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="string(@codeSystemName) = ('PriceComponentType') or not(@codeSystemName)">(Observation_AltriCosti(Erog non SSN)): The value for codeSystemName SHALL be 'PriceComponentType'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Observation_AltriCosti(Erog non SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="string(@displayName) = ('surcharge') or not(@displayName)">(Observation_AltriCosti(Erog non SSN)): The value for displayName SHALL be 'surcharge'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Observation_AltriCosti(Erog non SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.830
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]/hl7:text
Item: (Observation_AltriCosti(Erog non SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.830
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]/hl7:value
Item: (Observation_AltriCosti(Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.830']]/hl7:value">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="@value">(Observation_AltriCosti(Erog non SSN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.830-2025-10-20T114152.html"
              test="@currency">(Observation_AltriCosti(Erog non SSN)): attribute @currency SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]">
      <extends rule="d16242e0-false-d16246e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="string(@typeCode) = ('COMP')">(Supply_ErogazioneF non SSN): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.903
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]
Item: (Act_VariazioneFarmaco (ErF non SSN))
-->
   <rule fpi="RULC-1" id="d16242e0-false-d16246e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]) &gt;= 1">(Act_VariazioneFarmaco (ErF non SSN)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]) &lt;= 1">(Act_VariazioneFarmaco (ErF non SSN)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.903
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]
Item: (Act_VariazioneFarmaco (ErF non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="string(@classCode) = ('ACT')">(Act_VariazioneFarmaco (ErF non SSN)): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="string(@moodCode) = ('EVN')">(Act_VariazioneFarmaco (ErF non SSN)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']) &gt;= 1">(Act_VariazioneFarmaco (ErF non SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']) &lt;= 1">(Act_VariazioneFarmaco (ErF non SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.16-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(Act_VariazioneFarmaco (ErF non SSN)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.16-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.16-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Act_VariazioneFarmaco (ErF non SSN)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.16-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &gt;= 1">(Act_VariazioneFarmaco (ErF non SSN)): element hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &lt;= 1">(Act_VariazioneFarmaco (ErF non SSN)): element hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.903
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']
Item: (Act_VariazioneFarmaco (ErF non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.811')">(Act_VariazioneFarmaco (ErF non SSN)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.811'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.903
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.16-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Act_VariazioneFarmaco (ErF non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.16-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.16-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Act_VariazioneFarmaco (ErF non SSN)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.16 FlagErogazione (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="@code">(Act_VariazioneFarmaco (ErF non SSN)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Act_VariazioneFarmaco (ErF non SSN)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="@codeSystem">(Act_VariazioneFarmaco (ErF non SSN)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Act_VariazioneFarmaco (ErF non SSN)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Act_VariazioneFarmaco (ErF non SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Act_VariazioneFarmaco (ErF non SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.903
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]
Item: (Act_VariazioneFarmaco (ErF non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]">
      <extends rule="d16396e0-false-d16400e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.903-2026-01-13T173457.html"
              test="string(@typeCode) = ('RSON')">(Act_VariazioneFarmaco (ErF non SSN)): The value for typeCode SHALL be 'RSON'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.904
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]
Item: (Observation_MotivazioneSostuibilità (ErF non SSN))
-->
   <rule fpi="RULC-1" id="d16396e0-false-d16400e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="count(hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(Observation_MotivazioneSostuibilità (ErF non SSN)): element hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="count(hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(Observation_MotivazioneSostuibilità (ErF non SSN)): element hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.904
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (Observation_MotivazioneSostuibilità (ErF non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Observation_MotivazioneSostuibilità (ErF non SSN)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="string(@moodCode) = ('EVN')">(Observation_MotivazioneSostuibilità (ErF non SSN)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="count(hl7:templateId[not(@nullFlavor)]) &gt;= 1">(Observation_MotivazioneSostuibilità (ErF non SSN)): element hl7:templateId[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="count(hl7:templateId[not(@nullFlavor)]) &lt;= 1">(Observation_MotivazioneSostuibilità (ErF non SSN)): element hl7:templateId[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(Observation_MotivazioneSostuibilità (ErF non SSN)): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Observation_MotivazioneSostuibilità (ErF non SSN)): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="count(hl7:value) &lt;= 1">(Observation_MotivazioneSostuibilità (ErF non SSN)): element hl7:value appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="count(hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]) &lt;= 1">(Observation_MotivazioneSostuibilità (ErF non SSN)): element hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.904
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:templateId[not(@nullFlavor)]
Item: (Observation_MotivazioneSostuibilità (ErF non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:templateId[not(@nullFlavor)]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.812') or not(@root)">(Observation_MotivazioneSostuibilità (ErF non SSN)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.812'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.904
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Observation_MotivazioneSostuibilità (ErF non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Observation_MotivazioneSostuibilità (ErF non SSN)): The element value SHALL be one of '2.16.840.1.113883.2.9.6.1.53 Motivazione Sostituzione (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="@code">(Observation_MotivazioneSostuibilità (ErF non SSN)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Observation_MotivazioneSostuibilità (ErF non SSN)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.1.53')">(Observation_MotivazioneSostuibilità (ErF non SSN)): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.6.1.53'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Observation_MotivazioneSostuibilità (ErF non SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Observation_MotivazioneSostuibilità (ErF non SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.904
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:value
Item: (Observation_MotivazioneSostuibilità (ErF non SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.904
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]
Item: (Observation_MotivazioneSostuibilità (ErF non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]">
      <extends rule="d16545e0-false-d16549e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.904-2026-01-13T173616.html"
              test="string(@typeCode) = ('COMP')">(Observation_MotivazioneSostuibilità (ErF non SSN)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.905
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]
Item: (FarmacoSostituito(erog non SSN))
-->
   <rule fpi="RULC-1" id="d16545e0-false-d16549e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="count(hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable]) &gt;= 1">(FarmacoSostituito(erog non SSN)): element hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="count(hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable]) &lt;= 1">(FarmacoSostituito(erog non SSN)): element hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.905
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]/hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable]
Item: (FarmacoSostituito(erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]/hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="string(@classCode) = ('SBADM') or not(@classCode)">(FarmacoSostituito(erog non SSN)): The value for classCode SHALL be 'SBADM'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="string(@moodCode) = ('RQO')">(FarmacoSostituito(erog non SSN)): The value for moodCode SHALL be 'RQO'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="count(hl7:consumable[not(@nullFlavor)][hl7:manufacturedProduct[@classCode = 'MANU']]) &gt;= 1">(FarmacoSostituito(erog non SSN)): element hl7:consumable[not(@nullFlavor)][hl7:manufacturedProduct[@classCode = 'MANU']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="count(hl7:consumable[not(@nullFlavor)][hl7:manufacturedProduct[@classCode = 'MANU']]) &lt;= 1">(FarmacoSostituito(erog non SSN)): element hl7:consumable[not(@nullFlavor)][hl7:manufacturedProduct[@classCode = 'MANU']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.905
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]/hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable]/hl7:consumable[not(@nullFlavor)][hl7:manufacturedProduct[@classCode = 'MANU']]
Item: (FarmacoSostituito(erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]/hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable]/hl7:consumable[not(@nullFlavor)][hl7:manufacturedProduct[@classCode = 'MANU']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="string(@typeCode) = ('CSM') or not(@typeCode)">(FarmacoSostituito(erog non SSN)): The value for typeCode SHALL be 'CSM'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="count(hl7:manufacturedProduct[@classCode = 'MANU'][hl7:manufacturedLabeledDrug]) &gt;= 1">(FarmacoSostituito(erog non SSN)): element hl7:manufacturedProduct[@classCode = 'MANU'][hl7:manufacturedLabeledDrug] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="count(hl7:manufacturedProduct[@classCode = 'MANU'][hl7:manufacturedLabeledDrug]) &lt;= 1">(FarmacoSostituito(erog non SSN)): element hl7:manufacturedProduct[@classCode = 'MANU'][hl7:manufacturedLabeledDrug] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.905
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]/hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable]/hl7:consumable[not(@nullFlavor)][hl7:manufacturedProduct[@classCode = 'MANU']]/hl7:manufacturedProduct[@classCode = 'MANU'][hl7:manufacturedLabeledDrug]
Item: (FarmacoSostituito(erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]/hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable]/hl7:consumable[not(@nullFlavor)][hl7:manufacturedProduct[@classCode = 'MANU']]/hl7:manufacturedProduct[@classCode = 'MANU'][hl7:manufacturedLabeledDrug]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="string(@classCode) = ('MANU')">(FarmacoSostituito(erog non SSN)): The value for classCode SHALL be 'MANU'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="count(hl7:manufacturedLabeledDrug) &gt;= 1">(FarmacoSostituito(erog non SSN)): element hl7:manufacturedLabeledDrug is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="count(hl7:manufacturedLabeledDrug) &lt;= 1">(FarmacoSostituito(erog non SSN)): element hl7:manufacturedLabeledDrug appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.905
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]/hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable]/hl7:consumable[not(@nullFlavor)][hl7:manufacturedProduct[@classCode = 'MANU']]/hl7:manufacturedProduct[@classCode = 'MANU'][hl7:manufacturedLabeledDrug]/hl7:manufacturedLabeledDrug
Item: (FarmacoSostituito(erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]/hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable]/hl7:consumable[not(@nullFlavor)][hl7:manufacturedProduct[@classCode = 'MANU']]/hl7:manufacturedProduct[@classCode = 'MANU'][hl7:manufacturedLabeledDrug]/hl7:manufacturedLabeledDrug">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="count(hl7:code) &gt;= 1">(FarmacoSostituito(erog non SSN)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="count(hl7:code) &lt;= 1">(FarmacoSostituito(erog non SSN)): element hl7:code appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.905
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]/hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable]/hl7:consumable[not(@nullFlavor)][hl7:manufacturedProduct[@classCode = 'MANU']]/hl7:manufacturedProduct[@classCode = 'MANU'][hl7:manufacturedLabeledDrug]/hl7:manufacturedLabeledDrug/hl7:code
Item: (FarmacoSostituito(erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.811']]/hl7:entryRelationship[hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:observation[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.53' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.53-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:substanceAdministration[@moodCode = 'RQO']]/hl7:substanceAdministration[@moodCode = 'RQO'][hl7:consumable]/hl7:consumable[not(@nullFlavor)][hl7:manufacturedProduct[@classCode = 'MANU']]/hl7:manufacturedProduct[@classCode = 'MANU'][hl7:manufacturedLabeledDrug]/hl7:manufacturedLabeledDrug/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="@code">(FarmacoSostituito(erog non SSN)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(FarmacoSostituito(erog non SSN)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="@codeSystem">(FarmacoSostituito(erog non SSN)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(FarmacoSostituito(erog non SSN)): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(FarmacoSostituito(erog non SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.905-2026-01-13T173714.html"
              test="not(@ displayName) or string-length(@ displayName)&gt;0">(FarmacoSostituito(erog non SSN)): Attribute @ displayName SHALL be of data type 'st'  - '<value-of select="@ displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]]
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]]">
      <extends rule="d16683e0-false-d16687e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="string(@typeCode) = ('COMP')">(Supply_ErogazioneF non SSN): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.813
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]]
Item: (Obs_RegimeErogazione (ErF non SSN))
-->
   <rule fpi="RULC-1" id="d16683e0-false-d16687e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.813-2025-10-07T123339.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]) &gt;= 1">(Obs_RegimeErogazione (ErF non SSN)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.813-2025-10-07T123339.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]) &lt;= 1">(Obs_RegimeErogazione (ErF non SSN)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.813
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]
Item: (Obs_RegimeErogazione (ErF non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.813-2025-10-07T123339.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Obs_RegimeErogazione (ErF non SSN)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.813-2025-10-07T123339.html"
              test="string(@moodCode) = ('EVN')">(Obs_RegimeErogazione (ErF non SSN)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.813-2025-10-07T123339.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']) &gt;= 1">(Obs_RegimeErogazione (ErF non SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.813-2025-10-07T123339.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']) &lt;= 1">(Obs_RegimeErogazione (ErF non SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.813-2025-10-07T123339.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.25-2023-05-09T095713.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(Obs_RegimeErogazione (ErF non SSN)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.25-2023-05-09T095713.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.813-2025-10-07T123339.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.25-2023-05-09T095713.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Obs_RegimeErogazione (ErF non SSN)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.25-2023-05-09T095713.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.813
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']
Item: (Obs_RegimeErogazione (ErF non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.813-2025-10-07T123339.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.813')">(Obs_RegimeErogazione (ErF non SSN)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.813'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.813
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.25-2023-05-09T095713.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Obs_RegimeErogazione (ErF non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.813']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.25-2023-05-09T095713.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.813-2025-10-07T123339.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.25-2023-05-09T095713.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Obs_RegimeErogazione (ErF non SSN)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.25 Regime Erogazione (2023-05-09T09:57:13)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.902
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]
Item: (Supply_ErogazioneF non SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]">
      <extends rule="d16785e0-false-d16789e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.902-2026-01-13T173333.html"
              test="string(@typeCode) = ('SUBJ')">(Supply_ErogazioneF non SSN): The value for typeCode SHALL be 'SUBJ'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.818
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]
Item: (Act_MessaggioRegionale (Erog non SSN))
-->
   <rule fpi="RULC-1" id="d16785e0-false-d16789e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]) &gt;= 1">(Act_MessaggioRegionale (Erog non SSN)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]) &lt;= 1">(Act_MessaggioRegionale (Erog non SSN)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.818
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]
Item: (Act_MessaggioRegionale (Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="string(@classCode) = ('ACT')">(Act_MessaggioRegionale (Erog non SSN)): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="string(@moodCode) = ('ENV')">(Act_MessaggioRegionale (Erog non SSN)): The value for moodCode SHALL be 'ENV'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']) &gt;= 1">(Act_MessaggioRegionale (Erog non SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']) &lt;= 1">(Act_MessaggioRegionale (Erog non SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="count(hl7:code[(@code = ' 48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Act_MessaggioRegionale (Erog non SSN)): element hl7:code[(@code = ' 48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="count(hl7:code[(@code = ' 48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Act_MessaggioRegionale (Erog non SSN)): element hl7:code[(@code = ' 48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="count(hl7:text) &lt;= 1">(Act_MessaggioRegionale (Erog non SSN)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.818
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']
Item: (Act_MessaggioRegionale (Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.818')">(Act_MessaggioRegionale (Erog non SSN)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.818'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.818
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]/hl7:code[(@code = ' 48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Act_MessaggioRegionale (Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]/hl7:code[(@code = ' 48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="string(@code) = ('48767-8')">(Act_MessaggioRegionale (Erog non SSN)): The value for code SHALL be '48767-8'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Act_MessaggioRegionale (Erog non SSN)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Act_MessaggioRegionale (Erog non SSN)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Act_MessaggioRegionale (Erog non SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Act_MessaggioRegionale (Erog non SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.818
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]/hl7:text
Item: (Act_MessaggioRegionale (Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]/hl7:text">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="count(hl7:reference) &gt;= 1">(Act_MessaggioRegionale (Erog non SSN)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="count(hl7:reference) &lt;= 1">(Act_MessaggioRegionale (Erog non SSN)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.818
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]/hl7:text/hl7:reference
Item: (Act_MessaggioRegionale (Erog non SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.809']]/hl7:entry[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.810']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.818']]/hl7:text/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="@value">(Act_MessaggioRegionale (Erog non SSN)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.818-2025-10-14T161320.html"
              test="not(@value) or string-length(@value)&gt;0">(Act_MessaggioRegionale (Erog non SSN)): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]]
Item: (Erogazione Farmaceutica non a carico SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]]">
      <extends rule="d16929e0-false-d16933e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Erogazione Farmaceutica non a carico SSN): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.816
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]]
Item: (Messaggio Regionale (Erog non a carico SSN))
-->
   <rule fpi="RULC-1" id="d16929e0-false-d16933e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]) &gt;= 1">(Messaggio Regionale (Erog non a carico SSN)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]) &lt;= 1">(Messaggio Regionale (Erog non a carico SSN)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.816
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]
Item: (Messaggio Regionale (Erog non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']) &gt;= 1">(Messaggio Regionale (Erog non a carico SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']) &lt;= 1">(Messaggio Regionale (Erog non a carico SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="count(hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Messaggio Regionale (Erog non a carico SSN)): element hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="count(hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Messaggio Regionale (Erog non a carico SSN)): element hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="count(hl7:title) &lt;= 1">(Messaggio Regionale (Erog non a carico SSN)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="count(hl7:text) &gt;= 1">(Messaggio Regionale (Erog non a carico SSN)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="count(hl7:text) &lt;= 1">(Messaggio Regionale (Erog non a carico SSN)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.816
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']
Item: (Messaggio Regionale (Erog non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.816')">(Messaggio Regionale (Erog non a carico SSN)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.816'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.816
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]/hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Messaggio Regionale (Erog non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]/hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="string(@code) = ('51851-4')">(Messaggio Regionale (Erog non a carico SSN)): The value for code SHALL be '51851-4'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Messaggio Regionale (Erog non a carico SSN)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="string(@codeSystemName) = ('LOINC')">(Messaggio Regionale (Erog non a carico SSN)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Messaggio Regionale (Erog non a carico SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.816-2025-10-14T102656.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Messaggio Regionale (Erog non a carico SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.816
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]/hl7:title
Item: (Messaggio Regionale (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.816
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.816']]/hl7:text
Item: (Messaggio Regionale (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.13.2.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]]
Item: (Erogazione Farmaceutica non a carico SSN)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]]">
      <extends rule="d17059e0-false-d17063e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.2.9.10.1.13.2.1-2025-10-07T120616.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Erogazione Farmaceutica non a carico SSN): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.815
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]]
Item: (Annotazioni (Erog non a carico SSN))
-->
   <rule fpi="RULC-1" id="d17059e0-false-d17063e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]) &gt;= 1">(Annotazioni (Erog non a carico SSN)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]) &lt;= 1">(Annotazioni (Erog non a carico SSN)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.815
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]
Item: (Annotazioni (Erog non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']) &gt;= 1">(Annotazioni (Erog non a carico SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']) &lt;= 1">(Annotazioni (Erog non a carico SSN)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Annotazioni (Erog non a carico SSN)): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Annotazioni (Erog non a carico SSN)): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="count(hl7:title) &lt;= 1">(Annotazioni (Erog non a carico SSN)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="count(hl7:text) &gt;= 1">(Annotazioni (Erog non a carico SSN)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="count(hl7:text) &lt;= 1">(Annotazioni (Erog non a carico SSN)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.815
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']
Item: (Annotazioni (Erog non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.815')">(Annotazioni (Erog non a carico SSN)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.815'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.815
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Annotazioni (Erog non a carico SSN))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="string(@code) = ('48767-8')">(Annotazioni (Erog non a carico SSN)): The value for code SHALL be '48767-8'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Annotazioni (Erog non a carico SSN)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Annotazioni (Erog non a carico SSN)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Annotazioni (Erog non a carico SSN)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T144654/tmp-2.16.840.1.113883.3.1937.777.63.10.815-2025-10-14T100536.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Annotazioni (Erog non a carico SSN)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.815
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]/hl7:title
Item: (Annotazioni (Erog non a carico SSN))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.815
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.2.1'][@extension = '1.0']]/hl7:component[not(@nullFlavor)][hl7:structuredBody]/hl7:structuredBody[not(@nullFlavor)][hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.815']]/hl7:text
Item: (Annotazioni (Erog non a carico SSN))
--></pattern>
