<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.15.1
Name: Lettera di invito per Vaccinazione
Description: 
                   Lettera di invito per vaccinazioni   
            
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926">
   <title>Lettera di invito per Vaccinazione</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]
Item: (Lettera di invito per Vaccinazione)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]"
         id="d45e15-false-d216e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(Lettera di invito per Vaccinazione): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Lettera di invito per Vaccinazione): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:realmCode) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:realmCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:id) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:id) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:title) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:languageCode) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:languageCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:languageCode) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:languageCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:setId) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:versionNumber) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:versionNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:recordTarget[hl7:patientRole] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:recordTarget[hl7:patientRole] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:author[hl7:assignedAuthor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:custodian[hl7:assignedCustodian] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">(Lettera di invito per Vaccinazione): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:component[hl7:structuredBody]) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:component[hl7:structuredBody] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:component[hl7:structuredBody]) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:component[hl7:structuredBody] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:realmCode
Item: (Lettera di invito per Vaccinazione)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:realmCode"
         id="d45e18-false-d513e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="@code">(Lettera di invito per Vaccinazione): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Lettera di invito per Vaccinazione): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']
Item: (Lettera di invito per Vaccinazione)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']"
         id="d45e38-false-d529e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@root) = ('2.16.840.1.113883.1.3')">(Lettera di invito per Vaccinazione): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@extension) = ('POCD_MT000040UV02')">(Lettera di invito per Vaccinazione): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Lettera di invito per Vaccinazione): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']
Item: (Lettera di invito per Vaccinazione)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']"
         id="d45e52-false-d548e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.15.1')">(Lettera di invito per Vaccinazione): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.15.1'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@extension) = ('1.0')">(Lettera di invito per Vaccinazione): The value for extension SHALL be '1.0'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Lettera di invito per Vaccinazione): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Lettera di invito per Vaccinazione): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:id
Item: (Lettera di invito per Vaccinazione)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:id"
         id="d45e75-false-d569e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="@root">(Lettera di invito per Vaccinazione): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Lettera di invito per Vaccinazione): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="@extension">(Lettera di invito per Vaccinazione): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Lettera di invito per Vaccinazione): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Lettera di invito per Vaccinazione): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Lettera di invito per Vaccinazione)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d45e99-false-d591e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@code) = ('111490-9')">(Lettera di invito per Vaccinazione): The value for code SHALL be '111490-9'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Lettera di invito per Vaccinazione): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Lettera di invito per Vaccinazione): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Lettera di invito per Vaccinazione): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@displayName) = ('Immunization invitation letter') or not(@displayName)">(Lettera di invito per Vaccinazione): The value for displayName SHALL be 'Immunization invitation letter'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Lettera di invito per Vaccinazione): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation
Item: (Lettera di invito per Vaccinazione)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation"
         id="d45e109-false-d622e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="@code">(Lettera di invito per Vaccinazione): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Lettera di invito per Vaccinazione): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="@codeSystem">(Lettera di invito per Vaccinazione): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Lettera di invito per Vaccinazione): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Lettera di invito per Vaccinazione): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Lettera di invito per Vaccinazione): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:title
Item: (Lettera di invito per Vaccinazione)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:effectiveTime
Item: (Lettera di invito per Vaccinazione)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]
Item: (Lettera di invito per Vaccinazione)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]"
         id="d45e143-false-d665e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="@nullFlavor or (@code='N' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Normal' and @codeSystemName='HL7 Confidentiality') or (@code='V' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Very Restricted' and @codeSystemName='HL7 Confidentiality') or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Lettera di invito per Vaccinazione): The element value SHALL be one of 'code 'N' codeSystem '2.16.840.1.113883.5.25' displayName='Normal' codeSystemName='HL7 Confidentiality' or code 'V' codeSystem '2.16.840.1.113883.5.25' displayName='Very Restricted' codeSystemName='HL7 Confidentiality' or 2.16.840.1.113883.1.11.16926 x_BasicConfidentialityKind (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:languageCode
Item: (Lettera di invito per Vaccinazione)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:setId
Item: (Lettera di invito per Vaccinazione)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:setId"
         id="d45e167-false-d700e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="@root">(Lettera di invito per Vaccinazione): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Lettera di invito per Vaccinazione): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="@extension">(Lettera di invito per Vaccinazione): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Lettera di invito per Vaccinazione): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Lettera di invito per Vaccinazione): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:versionNumber
Item: (Lettera di invito per Vaccinazione)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]
Item: (CDA recordTargetLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]"
         id="d723e18-false-d751e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="string(@typeCode) = ('RCT') or not(@typeCode)">(CDA recordTargetLett_Vacc): The value for typeCode SHALL be 'RCT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA recordTargetLett_Vacc): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:patientRole[hl7:patient]) &gt;= 1">(CDA recordTargetLett_Vacc): element hl7:patientRole[hl7:patient] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:patientRole[hl7:patient]) &lt;= 1">(CDA recordTargetLett_Vacc): element hl7:patientRole[hl7:patient] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]
Item: (CDA recordTargetLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]"
         id="d723e33-false-d817e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="string(@classCode) = ('PAT') or not(@classCode)">(CDA recordTargetLett_Vacc): The value for classCode SHALL be 'PAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:id) &gt;= 1">(CDA recordTargetLett_Vacc): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:addr) &gt;= 1">(CDA recordTargetLett_Vacc): element hl7:addr is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(CDA recordTargetLett_Vacc): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(CDA recordTargetLett_Vacc): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:providerOrganization) &lt;= 1">(CDA recordTargetLett_Vacc): element hl7:providerOrganization appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id
Item: (CDA recordTargetLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id"
         id="d723e40-false-d883e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="@root">(CDA recordTargetLett_Vacc): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTargetLett_Vacc): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="@extension">(CDA recordTargetLett_Vacc): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTargetLett_Vacc): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA recordTargetLett_Vacc): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA recordTargetLett_Vacc)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr">
      <extends rule="d937e0-false-d943e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="@use">(CDA recordTargetLett_Vacc): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTargetLett_Vacc): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d937e0-false-d943e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom
Item: (CDA recordTargetLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom"
         id="d723e172-false-d1055e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="@use">(CDA recordTargetLett_Vacc): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTargetLett_Vacc): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="@value">(CDA recordTargetLett_Vacc): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (CDA recordTargetLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
         id="d723e201-false-d1092e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTargetLett_Vacc): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTargetLett_Vacc): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:name) &gt;= 1">(CDA recordTargetLett_Vacc): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTargetLett_Vacc): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(CDA recordTargetLett_Vacc): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA recordTargetLett_Vacc): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:birthTime) &gt;= 1">(CDA recordTargetLett_Vacc): element hl7:birthTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:birthTime) &lt;= 1">(CDA recordTargetLett_Vacc): element hl7:birthTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:birthplace[hl7:place]) &gt;= 1">(CDA recordTargetLett_Vacc): element hl7:birthplace[hl7:place] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:birthplace[hl7:place]) &lt;= 1">(CDA recordTargetLett_Vacc): element hl7:birthplace[hl7:place] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name
Item: (CDA recordTargetLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name"
         id="d723e209-false-d1151e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:given) &gt;= 1">(CDA recordTargetLett_Vacc): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:given) &lt;= 1">(CDA recordTargetLett_Vacc): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:family) &gt;= 1">(CDA recordTargetLett_Vacc): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:family) &lt;= 1">(CDA recordTargetLett_Vacc): element hl7:family appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:given
Item: (CDA recordTargetLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:family
Item: (CDA recordTargetLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA recordTargetLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d723e233-false-d1194e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA recordTargetLett_Vacc): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="@code">(CDA recordTargetLett_Vacc): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="@codeSystem">(CDA recordTargetLett_Vacc): attribute @codeSystem SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime
Item: (CDA recordTargetLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime"
         id="d723e284-false-d1218e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="@value">(CDA recordTargetLett_Vacc): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDA recordTargetLett_Vacc): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]
Item: (CDA recordTargetLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]"
         id="d723e295-false-d1239e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="string(@classCode) = ('BIRTHPL') or not(@classCode)">(CDA recordTargetLett_Vacc): The value for classCode SHALL be 'BIRTHPL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:place) &gt;= 1">(CDA recordTargetLett_Vacc): element hl7:place is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:place) &lt;= 1">(CDA recordTargetLett_Vacc): element hl7:place appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place
Item: (CDA recordTargetLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place"
         id="d723e328-false-d1275e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA recordTargetLett_Vacc): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTargetLett_Vacc): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTargetLett_Vacc): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:addr[hl7:country]) &gt;= 1">(CDA recordTargetLett_Vacc): element hl7:addr[hl7:country] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="count(hl7:addr[hl7:country]) &lt;= 1">(CDA recordTargetLett_Vacc): element hl7:addr[hl7:country] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name
Item: (CDA recordTargetLett_Vacc)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]
Item: (CDA recordTargetLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.883
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]
Item: (CDA AddressBirthPlace (lettere di invito))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html"
              test="count(hl7:country) &gt;= 1">(CDA AddressBirthPlace (lettere di invito)): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html"
              test="count(hl7:country) &lt;= 1">(CDA AddressBirthPlace (lettere di invito)): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html"
              test="count(hl7:state) &lt;= 1">(CDA AddressBirthPlace (lettere di invito)): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html"
              test="count(hl7:county) &lt;= 1">(CDA AddressBirthPlace (lettere di invito)): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html"
              test="count(hl7:city) &lt;= 1">(CDA AddressBirthPlace (lettere di invito)): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA AddressBirthPlace (lettere di invito)): element hl7:censusTract appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA AddressBirthPlace (lettere di invito)): element hl7:postalCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.883
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:country
Item: (CDA AddressBirthPlace (lettere di invito))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.883
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:state
Item: (CDA AddressBirthPlace (lettere di invito))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.883
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:county
Item: (CDA AddressBirthPlace (lettere di invito))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.883
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:city
Item: (CDA AddressBirthPlace (lettere di invito))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.883
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:censusTract
Item: (CDA AddressBirthPlace (lettere di invito))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.883
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:postalCode
Item: (CDA AddressBirthPlace (lettere di invito))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.626
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization
Item: (CDA recordTargetLett_Vacc)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization">
      <extends rule="d1453e0-false-d1459e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(CDA recordTargetLett_Vacc): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA recordTargetLett_Vacc): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.670
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization
Item: (CDA Organization_Lett_Vacc)
-->
   <rule fpi="RULC-1" id="d1453e0-false-d1459e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization_Lett_Vacc): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization_Lett_Vacc): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization_Lett_Vacc): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.670
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization/hl7:id
Item: (CDA Organization_Lett_Vacc)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html"
              test="@root">(CDA Organization_Lett_Vacc): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization_Lett_Vacc): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html"
              test="@extension">(CDA Organization_Lett_Vacc): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization_Lett_Vacc): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization_Lett_Vacc): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.670
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization/hl7:name
Item: (CDA Organization_Lett_Vacc)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.631
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]
Item: (CDA authorLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]"
         id="d1443e74-false-d1536e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA authorLett_Vacc): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA authorLett_Vacc): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="count(hl7:time) &gt;= 1">(CDA authorLett_Vacc): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="count(hl7:time) &lt;= 1">(CDA authorLett_Vacc): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA authorLett_Vacc): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA authorLett_Vacc): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.631
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA authorLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.631
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA authorLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
         id="d1443e83-false-d1618e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA authorLett_Vacc): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="count(hl7:id) &gt;= 1">(CDA authorLett_Vacc): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA authorLett_Vacc): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA authorLett_Vacc): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.631
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA authorLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
         id="d1443e99-false-d1669e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="@root">(CDA authorLett_Vacc): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA authorLett_Vacc): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="@extension">(CDA authorLett_Vacc): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA authorLett_Vacc): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA authorLett_Vacc): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.631
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA authorLett_Vacc)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <extends rule="d1713e0-false-d1723e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA authorLett_Vacc): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA authorLett_Vacc): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.636
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA personLett_Vacc)
-->
   <rule fpi="RULC-1" id="d1713e0-false-d1723e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.636-2025-05-27T105600.html"
              test="count(hl7:name) &gt;= 1">(CDA personLett_Vacc): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.636-2025-05-27T105600.html"
              test="count(hl7:name) &lt;= 1">(CDA personLett_Vacc): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.636
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA personLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.637
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA nameLett_Vacc)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html"
              test="count(hl7:given) &gt;= 1">(CDA nameLett_Vacc): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html"
              test="count(hl7:given) &lt;= 1">(CDA nameLett_Vacc): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html"
              test="count(hl7:family) &gt;= 1">(CDA nameLett_Vacc): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html"
              test="count(hl7:family) &lt;= 1">(CDA nameLett_Vacc): element hl7:family appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.637
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA nameLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.637
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA nameLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.631
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA authorLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.647
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA OrganizationLett_Vacc)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html"
              test="string(@classCode) = ('ORG')">(CDA OrganizationLett_Vacc): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA OrganizationLett_Vacc): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html"
              test="count(hl7:name) &lt;= 1">(CDA OrganizationLett_Vacc): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.647
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA OrganizationLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.647
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA OrganizationLett_Vacc)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html"
              test="@use">(CDA OrganizationLett_Vacc): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA OrganizationLett_Vacc): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.647
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA OrganizationLett_Vacc)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d1919e0-false-d1925e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html"
              test="@use">(CDA OrganizationLett_Vacc): attribute @use SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html"
              test="not(@use) or string-length(@use) &gt; 0">(CDA OrganizationLett_Vacc): Attribute @use SHALL be of data type 'set_cs'  - '<value-of select="@use"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d1919e0-false-d1925e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.665
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]
Item: (CDA custodianLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]"
         id="d1819e99-false-d2056e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.665-2025-05-28T112505.html"
              test="string(@typeCode) = ('CST') or not(@typeCode)">(CDA custodianLett_Vacc): The value for typeCode SHALL be 'CST'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.665-2025-05-28T112505.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1">(CDA custodianLett_Vacc): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.665-2025-05-28T112505.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1">(CDA custodianLett_Vacc): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.665
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA custodianLett_Vacc)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]">
      <extends rule="d2122e0-false-d2126e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.665-2025-05-28T112505.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA custodianLett_Vacc): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.895
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA assignedCustodian v1.0)
-->
   <rule fpi="RULC-1" id="d2122e0-false-d2126e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.895-2025-12-18T112920.html"
              test="count(hl7:representedCustodianOrganization) &gt;= 1">(CDA assignedCustodian v1.0): element hl7:representedCustodianOrganization is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.895-2025-12-18T112920.html"
              test="count(hl7:representedCustodianOrganization) &lt;= 1">(CDA assignedCustodian v1.0): element hl7:representedCustodianOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.895
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (CDA assignedCustodian v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.896
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (custodianOrganization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(custodianOrganization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(custodianOrganization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="count(hl7:id) &gt;= 1">(custodianOrganization v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="count(hl7:name) &gt;= 1">(custodianOrganization v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="count(hl7:name) &lt;= 1">(custodianOrganization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="count(hl7:addr) &lt;= 1">(custodianOrganization v1.0): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.896
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id
Item: (custodianOrganization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="@root">(custodianOrganization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(custodianOrganization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="@extension">(custodianOrganization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="not(@extension) or string-length(@extension)&gt;0">(custodianOrganization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(custodianOrganization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.896
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:name
Item: (custodianOrganization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.896
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom
Item: (custodianOrganization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="@use">(custodianOrganization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.896
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (custodianOrganization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr">
      <extends rule="d2330e0-false-d2336e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="@use">(custodianOrganization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d2330e0-false-d2336e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.632
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]
Item: (CDA legalAuthenticatorLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
         id="d2115e143-false-d2461e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html"
              test="string(@typeCode) = ('LA') or not(@typeCode)">(CDA legalAuthenticatorLett_Vacc): The value for typeCode SHALL be 'LA'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA legalAuthenticatorLett_Vacc): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html"
              test="count(hl7:time) &gt;= 1">(CDA legalAuthenticatorLett_Vacc): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html"
              test="count(hl7:time) &lt;= 1">(CDA legalAuthenticatorLett_Vacc): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html"
              test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">(CDA legalAuthenticatorLett_Vacc): element hl7:signatureCode[@code = 'S'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html"
              test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">(CDA legalAuthenticatorLett_Vacc): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA legalAuthenticatorLett_Vacc): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA legalAuthenticatorLett_Vacc): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.632
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time
Item: (CDA legalAuthenticatorLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.632
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']
Item: (CDA legalAuthenticatorLett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
         id="d2115e157-false-d2522e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html"
              test="string(@code) = ('S')">(CDA legalAuthenticatorLett_Vacc): The value for code SHALL be 'S'. Found: "<value-of select="@code"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.632
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA legalAuthenticatorLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.635
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA AssignedEntityLett_Vacc)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntityLett_Vacc): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntityLett_Vacc): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html"
              test="count(hl7:id) &lt;= 1">(CDA AssignedEntityLett_Vacc): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntityLett_Vacc): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.635
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntityLett_Vacc)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html"
              test="@root">(CDA AssignedEntityLett_Vacc): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntityLett_Vacc): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html"
              test="@extension">(CDA AssignedEntityLett_Vacc): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntityLett_Vacc): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntityLett_Vacc): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.635
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntityLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.636
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA personLett_Vacc)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.636-2025-05-27T105600.html"
              test="count(hl7:name) &gt;= 1">(CDA personLett_Vacc): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.636-2025-05-27T105600.html"
              test="count(hl7:name) &lt;= 1">(CDA personLett_Vacc): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.636
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA personLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.637
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA nameLett_Vacc)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html"
              test="count(hl7:given) &gt;= 1">(CDA nameLett_Vacc): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html"
              test="count(hl7:given) &lt;= 1">(CDA nameLett_Vacc): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html"
              test="count(hl7:family) &gt;= 1">(CDA nameLett_Vacc): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html"
              test="count(hl7:family) &lt;= 1">(CDA nameLett_Vacc): element hl7:family appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.637
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA nameLett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.637
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA nameLett_Vacc)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.706
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]
Item: (CDA documentationOfLet_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]"
         id="d2549e87-false-d2727e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html"
              test="string(@typeCode) = ('DOC') or not(@typeCode)">(CDA documentationOfLet_Vacc): The value for typeCode SHALL be 'DOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html"
              test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]) &gt;= 1">(CDA documentationOfLet_Vacc): element hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html"
              test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]) &lt;= 1">(CDA documentationOfLet_Vacc): element hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.706
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]
Item: (CDA documentationOfLet_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]"
         id="d2549e104-false-d2749e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html"
              test="string(@classCode) = ('ACT') or not(@classCode)">(CDA documentationOfLet_Vacc): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA documentationOfLet_Vacc): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &gt;= 1">(CDA documentationOfLet_Vacc): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &lt;= 1">(CDA documentationOfLet_Vacc): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.706
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1']
Item: (CDA documentationOfLet_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1']"
         id="d2549e112-false-d2775e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html"
              test="@code">(CDA documentationOfLet_Vacc): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA documentationOfLet_Vacc): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(CDA documentationOfLet_Vacc): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(CDA documentationOfLet_Vacc): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA documentationOfLet_Vacc): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA documentationOfLet_Vacc): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.708
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]
Item: (CDA relatedDocument Lett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
         id="d2795e38-false-d2802e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="@typeCode">(CDA relatedDocument Lett_Vacc): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA relatedDocument Lett_Vacc): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="count(hl7:parentDocument) &gt;= 1">(CDA relatedDocument Lett_Vacc): element hl7:parentDocument is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="count(hl7:parentDocument) &lt;= 1">(CDA relatedDocument Lett_Vacc): element hl7:parentDocument appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.708
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument
Item: (CDA relatedDocument Lett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
         id="d2795e77-false-d2833e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(CDA relatedDocument Lett_Vacc): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA relatedDocument Lett_Vacc): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="count(hl7:id) &gt;= 1">(CDA relatedDocument Lett_Vacc): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="count(hl7:code) &lt;= 1">(CDA relatedDocument Lett_Vacc): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="count(hl7:text) &lt;= 1">(CDA relatedDocument Lett_Vacc): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="count(hl7:setId) &lt;= 1">(CDA relatedDocument Lett_Vacc): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="count(hl7:versionNumber) &lt;= 1">(CDA relatedDocument Lett_Vacc): element hl7:versionNumber appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.708
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id
Item: (CDA relatedDocument Lett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
         id="d2795e80-false-d2879e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="@root">(CDA relatedDocument Lett_Vacc): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocument Lett_Vacc): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="@extension">(CDA relatedDocument Lett_Vacc): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA relatedDocument Lett_Vacc): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.708
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code
Item: (CDA relatedDocument Lett_Vacc)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
         id="d2795e89-false-d2897e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="@code">(CDA relatedDocument Lett_Vacc): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA relatedDocument Lett_Vacc): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="@codeSystem">(CDA relatedDocument Lett_Vacc): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocument Lett_Vacc): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA relatedDocument Lett_Vacc): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA relatedDocument Lett_Vacc): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.708
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:text
Item: (CDA relatedDocument Lett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.708
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:setId
Item: (CDA relatedDocument Lett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.708
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:versionNumber
Item: (CDA relatedDocument Lett_Vacc)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]
Item: (Lettera di invito per Vaccinazione)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]"
         id="d45e200-false-d2972e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Lettera di invito per Vaccinazione): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Lettera di invito per Vaccinazione): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:structuredBody[hl7:component]) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:structuredBody[hl7:component] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:structuredBody[hl7:component]) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:structuredBody[hl7:component] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]
Item: (Lettera di invito per Vaccinazione)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]"
         id="d45e203-false-d3050e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@classCode) = ('DOCBODY') or not(@classCode)">(Lettera di invito per Vaccinazione): The value for classCode SHALL be 'DOCBODY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Lettera di invito per Vaccinazione): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]) &gt;= 1">(Lettera di invito per Vaccinazione): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]) &lt;= 1">(Lettera di invito per Vaccinazione): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]
Item: (Lettera di invito per Vaccinazione)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Lettera di invito per Vaccinazione): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Lettera di invito per Vaccinazione): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.15.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]
Item: (Lettera di invito per Vaccinazione)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Lettera di invito per Vaccinazione): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T105820/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Lettera di invito per Vaccinazione): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
