<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.17.1
Name: Tessera portatore di impianto (TPI)
Description: 
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010">
   <title>Tessera portatore di impianto (TPI)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]
Item: (Tessera portatore di impianto (TPI))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]"
         id="d45e8-false-d168e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(Tessera portatore di impianto (TPI)): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Tessera portatore di impianto (TPI)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:realmCode) &gt;= 1">(Tessera portatore di impianto (TPI)): element hl7:realmCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &gt;= 1">(Tessera portatore di impianto (TPI)): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']) &gt;= 1">(Tessera portatore di impianto (TPI)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:id) &gt;= 1">(Tessera portatore di impianto (TPI)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:id) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:code[(@code = '101881-1' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']) &gt;= 1">(Tessera portatore di impianto (TPI)): element hl7:code[(@code = '101881-1' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:code[(@code = '101881-1' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:code[(@code = '101881-1' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:title) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Tessera portatore di impianto (TPI)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &gt;= 1">(Tessera portatore di impianto (TPI)): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:languageCode) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:languageCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:setId) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:versionNumber) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:versionNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]) &gt;= 1">(Tessera portatore di impianto (TPI)): element hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">(Tessera portatore di impianto (TPI)): element hl7:author[hl7:assignedAuthor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1">(Tessera portatore di impianto (TPI)): element hl7:custodian[hl7:assignedCustodian] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">(Tessera portatore di impianto (TPI)): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:componentOf[hl7:encompassingEncounter]) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:componentOf[hl7:encompassingEncounter] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:component[hl7:structuredBody]) &gt;= 1">(Tessera portatore di impianto (TPI)): element hl7:component[hl7:structuredBody] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:component[hl7:structuredBody]) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:component[hl7:structuredBody] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:realmCode
Item: (Tessera portatore di impianto (TPI))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:realmCode"
         id="d45e11-false-d422e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="@code">(Tessera portatore di impianto (TPI)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Tessera portatore di impianto (TPI)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']
Item: (Tessera portatore di impianto (TPI))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']"
         id="d45e31-false-d438e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@root) = ('2.16.840.1.113883.1.3')">(Tessera portatore di impianto (TPI)): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@extension) = ('POCD_MT000040UV02')">(Tessera portatore di impianto (TPI)): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Tessera portatore di impianto (TPI)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']
Item: (Tessera portatore di impianto (TPI))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']"
         id="d45e45-false-d457e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.17.1')">(Tessera portatore di impianto (TPI)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.17.1'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@extension) = ('1.0')">(Tessera portatore di impianto (TPI)): The value for extension SHALL be '1.0'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Tessera portatore di impianto (TPI)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Tessera portatore di impianto (TPI)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:id
Item: (Tessera portatore di impianto (TPI))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:id"
         id="d45e78-false-d478e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="@root">(Tessera portatore di impianto (TPI)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Tessera portatore di impianto (TPI)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="@extension">(Tessera portatore di impianto (TPI)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Tessera portatore di impianto (TPI)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="@assigningAuthorityName">(Tessera portatore di impianto (TPI)): attribute @assigningAuthorityName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Tessera portatore di impianto (TPI)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:code[(@code = '101881-1' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']
Item: (Tessera portatore di impianto (TPI))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:code[(@code = '101881-1' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']"
         id="d45e104-false-d502e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.6.1')">(Tessera portatore di impianto (TPI)): The element value SHALL be one of 'codeSystem '2.16.840.1.113883.6.1''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@code) = ('101881-1')">(Tessera portatore di impianto (TPI)): The value for code SHALL be '101881-1'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Tessera portatore di impianto (TPI)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@codeSystemName) = ('LOINC')">(Tessera portatore di impianto (TPI)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Tessera portatore di impianto (TPI)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Tessera portatore di impianto (TPI)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@displayName) = ('Tessera per il portatore di impianto') or not(@displayName)">(Tessera portatore di impianto (TPI)): The value for displayName SHALL be 'Tessera per il portatore di impianto'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Tessera portatore di impianto (TPI)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:title
Item: (Tessera portatore di impianto (TPI))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:effectiveTime
Item: (Tessera portatore di impianto (TPI))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]
Item: (Tessera portatore di impianto (TPI))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]"
         id="d45e147-false-d557e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="@nullFlavor or (@code='N' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Normal' and @codeSystemName='HL7 Confidentiality') or (@code='V' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Very Restricted' and @codeSystemName='HL7 Confidentiality') or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Tessera portatore di impianto (TPI)): The element value SHALL be one of 'code 'N' codeSystem '2.16.840.1.113883.5.25' displayName='Normal' codeSystemName='HL7 Confidentiality' or code 'V' codeSystem '2.16.840.1.113883.5.25' displayName='Very Restricted' codeSystemName='HL7 Confidentiality' or 2.16.840.1.113883.1.11.16926 x_BasicConfidentialityKind (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:languageCode
Item: (Tessera portatore di impianto (TPI))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:setId
Item: (Tessera portatore di impianto (TPI))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:versionNumber
Item: (Tessera portatore di impianto (TPI))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]
Item: (CDA recordTarget TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]"
         id="d602e15-false-d609e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="string(@typeCode) = ('RCT')">(CDA recordTarget TPI): The value for typeCode SHALL be 'RCT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="string(@contextControlCode) = ('OP')">(CDA recordTarget TPI): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]) &gt;= 1">(CDA recordTarget TPI): element hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]) &lt;= 1">(CDA recordTarget TPI): element hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]
Item: (CDA recordTarget TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]"
         id="d602e23-false-d633e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="string(@classCode) = ('PAT')">(CDA recordTarget TPI): The value for classCode SHALL be 'PAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:id) &gt;= 1">(CDA recordTarget TPI): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(CDA recordTarget TPI): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(CDA recordTarget TPI): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:id
Item: (CDA recordTarget TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:id"
         id="d602e30-false-d662e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="@root">(CDA recordTarget TPI): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTarget TPI): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="@extension">(CDA recordTarget TPI): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTarget TPI): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA recordTarget TPI): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (CDA recordTarget TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
         id="d602e111-false-d686e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="string(@classCode) = ('PSN')">(CDA recordTarget TPI): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDA recordTarget TPI): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:name) &gt;= 1">(CDA recordTarget TPI): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTarget TPI): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(CDA recordTarget TPI): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA recordTarget TPI): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:birthTime) &gt;= 1">(CDA recordTarget TPI): element hl7:birthTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:birthTime) &lt;= 1">(CDA recordTarget TPI): element hl7:birthTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]) &gt;= 1">(CDA recordTarget TPI): element hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]) &lt;= 1">(CDA recordTarget TPI): element hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name
Item: (CDA recordTarget TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name"
         id="d602e119-false-d737e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:family) &gt;= 1">(CDA recordTarget TPI): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:family) &lt;= 1">(CDA recordTarget TPI): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:given) &gt;= 1">(CDA recordTarget TPI): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:given) &lt;= 1">(CDA recordTarget TPI): element hl7:given appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:family
Item: (CDA recordTarget TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:given
Item: (CDA recordTarget TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA recordTarget TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d602e149-false-d780e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA recordTarget TPI): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="@code">(CDA recordTarget TPI): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA recordTarget TPI): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.1')">(CDA recordTarget TPI): The value for codeSystem SHALL be '2.16.840.1.113883.5.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="string(@codeSystemName) = ('HL7 AdministrativeGender') or not(@codeSystemName)">(CDA recordTarget TPI): The value for codeSystemName SHALL be 'HL7 AdministrativeGender'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA recordTarget TPI): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA recordTarget TPI): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime
Item: (CDA recordTarget TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime"
         id="d602e174-false-d815e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="@value">(CDA recordTarget TPI): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDA recordTarget TPI): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]
Item: (CDA recordTarget TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]"
         id="d602e185-false-d828e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="string(@classCode) = ('BIRTHPL')">(CDA recordTarget TPI): The value for classCode SHALL be 'BIRTHPL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']) &gt;= 1">(CDA recordTarget TPI): element hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDA recordTarget TPI): element hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']
Item: (CDA recordTarget TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']"
         id="d602e192-false-d848e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="string(@classCode) = ('PLC')">(CDA recordTarget TPI): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDA recordTarget TPI): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:addr) &gt;= 1">(CDA recordTarget TPI): element hl7:addr is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:addr) &lt;= 1">(CDA recordTarget TPI): element hl7:addr appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDA recordTarget TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']/hl7:addr"
         id="d602e217-false-d872e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:country) &gt;= 1">(CDA recordTarget TPI): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:country) &lt;= 1">(CDA recordTarget TPI): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA recordTarget TPI): element hl7:censusTract appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.720-2025-07-14T151718.html"
              test="count(hl7:city) &lt;= 1">(CDA recordTarget TPI): element hl7:city appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDA recordTarget TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDA recordTarget TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.720
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDA recordTarget TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.741
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]
Item: (CDA author TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]"
         id="d918e14-false-d962e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA author TPI): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA author TPI): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="count(hl7:time) &gt;= 1">(CDA author TPI): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="count(hl7:time) &lt;= 1">(CDA author TPI): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA author TPI): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA author TPI): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.741
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA author TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.741
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA author TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
         id="d918e23-false-d1076e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA author TPI): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="count(hl7:id) &gt;= 1">(CDA author TPI): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA author TPI): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA author TPI): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.741
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA author TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
         id="d918e39-false-d1147e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="@root">(CDA author TPI): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA author TPI): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="@extension">(CDA author TPI): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA author TPI): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA author TPI): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.741
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA author TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom"
         id="d918e48-false-d1168e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="@use">(CDA author TPI): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author TPI): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.741
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA author TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d1398e0-false-d1404e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d1398e0-false-d1404e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d1562e0-false-d1598e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d1562e0-false-d1598e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d1768e0-false-d1772e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d1768e0-false-d1772e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d1938e0-false-d1944e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d1938e0-false-d1944e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d2102e0-false-d2138e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d2102e0-false-d2138e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.741
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA author TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <extends rule="d2337e0-false-d2347e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="string(@ classCode) = ('PSN') or not(@ classCode)">(CDA author TPI): The value for  classCode SHALL be 'PSN'. Found: "<value-of select="@ classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.741-2025-07-16T165509.html"
              test="string(@ determinerCode) = ('INSTANCE') or not(@ determinerCode)">(CDA author TPI): The value for  determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@ determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.750
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person TPI)
-->
   <rule fpi="RULC-1" id="d2337e0-false-d2347e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.750-2025-07-25T152609.html"
              test="count(hl7:name) &gt;= 1">(CDA person TPI): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.750-2025-07-25T152609.html"
              test="count(hl7:name) &lt;= 1">(CDA person TPI): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.750
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.751
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.751-2025-07-25T152754.html"
              test="count(hl7:given) &gt;= 1">(CDA name TPI): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.751-2025-07-25T152754.html"
              test="count(hl7:given) &lt;= 1">(CDA name TPI): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.751-2025-07-25T152754.html"
              test="count(hl7:family) &gt;= 1">(CDA name TPI): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.751-2025-07-25T152754.html"
              test="count(hl7:family) &lt;= 1">(CDA name TPI): element hl7:family appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.751
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.751
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name TPI)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.724
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]
Item: (CDA custodian TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]"
         id="d2326e59-false-d2427e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.724-2025-07-14T153935.html"
              test="string(@typeCode) = ('CST') or not(@typeCode)">(CDA custodian TPI): The value for typeCode SHALL be 'CST'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.724-2025-07-14T153935.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1">(CDA custodian TPI): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.724-2025-07-14T153935.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1">(CDA custodian TPI): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.724
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA custodian TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]"
         id="d2326e66-false-d2447e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.724-2025-07-14T153935.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA custodian TPI): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.724-2025-07-14T153935.html"
              test="count(hl7:representedCustodianOrganization) &gt;= 1">(CDA custodian TPI): element hl7:representedCustodianOrganization is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.724-2025-07-14T153935.html"
              test="count(hl7:representedCustodianOrganization) &lt;= 1">(CDA custodian TPI): element hl7:representedCustodianOrganization appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.724
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (CDA custodian TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization"
         id="d2326e68-false-d2467e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.724-2025-07-14T153935.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA custodian TPI): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.724-2025-07-14T153935.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA custodian TPI): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.724-2025-07-14T153935.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(CDA custodian TPI): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.724-2025-07-14T153935.html"
              test="count(hl7:name) &lt;= 1">(CDA custodian TPI): element hl7:name appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.724
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id[not(@nullFlavor)]
Item: (CDA custodian TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.724
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:name
Item: (CDA custodian TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.723
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]
Item: (CDA legalAuthenticator TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
         id="d2505e14-false-d2524e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.723-2025-07-14T153753.html"
              test="string(@typeCode) = ('LA') or not(@typeCode)">(CDA legalAuthenticator TPI): The value for typeCode SHALL be 'LA'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.723-2025-07-14T153753.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA legalAuthenticator TPI): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.723-2025-07-14T153753.html"
              test="count(hl7:time) &gt;= 1">(CDA legalAuthenticator TPI): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.723-2025-07-14T153753.html"
              test="count(hl7:time) &lt;= 1">(CDA legalAuthenticator TPI): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.723-2025-07-14T153753.html"
              test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">(CDA legalAuthenticator TPI): element hl7:signatureCode[@code = 'S'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.723-2025-07-14T153753.html"
              test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">(CDA legalAuthenticator TPI): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.723-2025-07-14T153753.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA legalAuthenticator TPI): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.723-2025-07-14T153753.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA legalAuthenticator TPI): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.723
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time
Item: (CDA legalAuthenticator TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.723
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']
Item: (CDA legalAuthenticator TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
         id="d2505e28-false-d2585e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.723-2025-07-14T153753.html"
              test="string(@code) = ('S')">(CDA legalAuthenticator TPI): The value for code SHALL be 'S'. Found: "<value-of select="@code"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.723
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA legalAuthenticator TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.749
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA AssignedEntity TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.749-2025-07-25T152519.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity TPI): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.749-2025-07-25T152519.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity TPI): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.749-2025-07-25T152519.html"
              test="count(hl7:id) &lt;= 1">(CDA AssignedEntity TPI): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.749-2025-07-25T152519.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity TPI): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.749
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.749-2025-07-25T152519.html"
              test="@root">(CDA AssignedEntity TPI): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.749-2025-07-25T152519.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity TPI): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.749-2025-07-25T152519.html"
              test="@extension">(CDA AssignedEntity TPI): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.749-2025-07-25T152519.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity TPI): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.749-2025-07-25T152519.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity TPI): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.749
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.750
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.750-2025-07-25T152609.html"
              test="count(hl7:name) &gt;= 1">(CDA person TPI): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.750-2025-07-25T152609.html"
              test="count(hl7:name) &lt;= 1">(CDA person TPI): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.750
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.751
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.751-2025-07-25T152754.html"
              test="count(hl7:given) &gt;= 1">(CDA name TPI): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.751-2025-07-25T152754.html"
              test="count(hl7:given) &lt;= 1">(CDA name TPI): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.751-2025-07-25T152754.html"
              test="count(hl7:family) &gt;= 1">(CDA name TPI): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.751-2025-07-25T152754.html"
              test="count(hl7:family) &lt;= 1">(CDA name TPI): element hl7:family appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.751
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.751
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name TPI)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.722
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]
Item: (CDA relatedDocument TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
         id="d2612e84-false-d2789e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.722-2025-07-14T152249.html"
              test="@typeCode">(CDA relatedDocument TPI): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.722-2025-07-14T152249.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA relatedDocument TPI): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.722-2025-07-14T152249.html"
              test="count(hl7:parentDocument) &gt;= 1">(CDA relatedDocument TPI): element hl7:parentDocument is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.722-2025-07-14T152249.html"
              test="count(hl7:parentDocument) &lt;= 1">(CDA relatedDocument TPI): element hl7:parentDocument appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.722
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument
Item: (CDA relatedDocument TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
         id="d2612e87-false-d2820e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.722-2025-07-14T152249.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(CDA relatedDocument TPI): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.722-2025-07-14T152249.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA relatedDocument TPI): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.722-2025-07-14T152249.html"
              test="count(hl7:id) &gt;= 1">(CDA relatedDocument TPI): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.722-2025-07-14T152249.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]) &lt;= 1">(CDA relatedDocument TPI): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.722-2025-07-14T152249.html"
              test="count(hl7:text) &lt;= 1">(CDA relatedDocument TPI): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.722-2025-07-14T152249.html"
              test="count(hl7:setId) &lt;= 1">(CDA relatedDocument TPI): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.722-2025-07-14T152249.html"
              test="count(hl7:versionNumber) &lt;= 1">(CDA relatedDocument TPI): element hl7:versionNumber appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.722
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id
Item: (CDA relatedDocument TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.722
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]
Item: (CDA relatedDocument TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]"
         id="d2612e91-false-d2876e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.722-2025-07-14T152249.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.6.1')">(CDA relatedDocument TPI): The element value SHALL be one of 'codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.722
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:text
Item: (CDA relatedDocument TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.722
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:setId
Item: (CDA relatedDocument TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.722
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:versionNumber
Item: (CDA relatedDocument TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.622
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]
Item: (CDA componentOf TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]"
         id="d2907e15-false-d2914e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(CDA componentOf TPI): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="count(hl7:encompassingEncounter) &gt;= 1">(CDA componentOf TPI): element hl7:encompassingEncounter is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="count(hl7:encompassingEncounter) &lt;= 1">(CDA componentOf TPI): element hl7:encompassingEncounter appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.622
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter
Item: (CDA componentOf TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter"
         id="d2907e27-false-d2934e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="string(@classCode) = ('ENC') or not(@classCode)">(CDA componentOf TPI): The value for classCode SHALL be 'ENC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA componentOf TPI): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="count(hl7:id) &lt;= 1">(CDA componentOf TPI): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA componentOf TPI): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="count(hl7:effectiveTime) &gt;= 1">(CDA componentOf TPI): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA componentOf TPI): element hl7:effectiveTime appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.622
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:id
Item: (CDA componentOf TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:id"
         id="d2907e30-false-d2973e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="@root">(CDA componentOf TPI): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf TPI): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="@extension">(CDA componentOf TPI): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA componentOf TPI): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA componentOf TPI): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.622
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA componentOf TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d2907e39-false-d2997e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA componentOf TPI): The element value SHALL be one of '2.16.840.1.113883.1.11.13955 ActEncounterCode (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="@code">(CDA componentOf TPI): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA componentOf TPI): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="@codeSystem">(CDA componentOf TPI): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf TPI): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA componentOf TPI): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA componentOf TPI): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA componentOf TPI): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.622
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:effectiveTime
Item: (CDA componentOf TPI)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:effectiveTime"
         id="d2907e54-false-d3033e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="@value">(CDA componentOf TPI): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.622-2025-05-22T112200.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDA componentOf TPI): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]
Item: (Tessera portatore di impianto (TPI))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]"
         id="d45e210-false-d3058e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Tessera portatore di impianto (TPI)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Tessera portatore di impianto (TPI)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:structuredBody[hl7:component]) &gt;= 1">(Tessera portatore di impianto (TPI)): element hl7:structuredBody[hl7:component] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:structuredBody[hl7:component]) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:structuredBody[hl7:component] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]
Item: (Tessera portatore di impianto (TPI))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]"
         id="d45e213-false-d3106e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@classCode) = ('DOCBODY') or not(@classCode)">(Tessera portatore di impianto (TPI)): The value for classCode SHALL be 'DOCBODY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Tessera portatore di impianto (TPI)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]) &gt;= 1">(Tessera portatore di impianto (TPI)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]) &lt;= 1">(Tessera portatore di impianto (TPI)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.17.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]
Item: (Tessera portatore di impianto (TPI))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]">
      <extends rule="d3170e0-false-d3174e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Tessera portatore di impianto (TPI)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.2.9.10.1.17.1-2025-07-14T101010.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Tessera portatore di impianto (TPI)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.733
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]
Item: (Impianto dispositivo TPI)
-->
   <rule fpi="RULC-1" id="d3170e0-false-d3174e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]) &gt;= 1">(Impianto dispositivo TPI): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]) &lt;= 1">(Impianto dispositivo TPI): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.733
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]
Item: (Impianto dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Impianto dispositivo TPI): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Impianto dispositivo TPI): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']) &gt;= 1">(Impianto dispositivo TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']) &lt;= 1">(Impianto dispositivo TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="count(hl7:code[(@code = '74720-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Impianto dispositivo TPI): element hl7:code[(@code = '74720-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="count(hl7:code[(@code = '74720-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Impianto dispositivo TPI): element hl7:code[(@code = '74720-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="count(hl7:title) &lt;= 1">(Impianto dispositivo TPI): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="count(hl7:text) &lt;= 1">(Impianto dispositivo TPI): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="count(hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]) &gt;= 1">(Impianto dispositivo TPI): element hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]] is required [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.733
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']
Item: (Impianto dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.733')">(Impianto dispositivo TPI): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.733'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.733
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:code[(@code = '74720-4' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Impianto dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:code[(@code = '74720-4' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="string(@code) = ('74720-4')">(Impianto dispositivo TPI): The value for code SHALL be '74720-4'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Impianto dispositivo TPI): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Impianto dispositivo TPI): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Impianto dispositivo TPI): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Impianto dispositivo TPI): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="string(@displayName) = ('Dispositivo') or not(@displayName)">(Impianto dispositivo TPI): The value for displayName SHALL be 'Dispositivo'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Impianto dispositivo TPI): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.733
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:title
Item: (Impianto dispositivo TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.733
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:text
Item: (Impianto dispositivo TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.733
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]
Item: (Impianto dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]">
      <extends rule="d3388e0-false-d3392e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.733-2025-07-16T082741.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Impianto dispositivo TPI): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.899
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]
Item: (Dispositivo (Organizer) TPI)
-->
   <rule fpi="RULC-1" id="d3388e0-false-d3392e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.899-2026-01-12T150619.html"
              test="count(hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]) &gt;= 1">(Dispositivo (Organizer) TPI): element hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.899-2026-01-12T150619.html"
              test="count(hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]) &lt;= 1">(Dispositivo (Organizer) TPI): element hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.899
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]
Item: (Dispositivo (Organizer) TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.899-2026-01-12T150619.html"
              test="string(@classCode) = ('CLUSTER')">(Dispositivo (Organizer) TPI): The value for classCode SHALL be 'CLUSTER'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.899-2026-01-12T150619.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Dispositivo (Organizer) TPI): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.899-2026-01-12T150619.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']) &gt;= 1">(Dispositivo (Organizer) TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.899-2026-01-12T150619.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']) &lt;= 1">(Dispositivo (Organizer) TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.899-2026-01-12T150619.html"
              test="count(hl7:text[hl7:reference]) &lt;= 1">(Dispositivo (Organizer) TPI): element hl7:text[hl7:reference] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.899-2026-01-12T150619.html"
              test="count(hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]) &gt;= 1">(Dispositivo (Organizer) TPI): element hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.899-2026-01-12T150619.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]]) &lt;= 1">(Dispositivo (Organizer) TPI): element hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.899
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']
Item: (Dispositivo (Organizer) TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.899-2026-01-12T150619.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.757')">(Dispositivo (Organizer) TPI): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.757'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.899
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:text[hl7:reference]
Item: (Dispositivo (Organizer) TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:text[hl7:reference]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.899-2026-01-12T150619.html"
              test="count(hl7:reference) &gt;= 1">(Dispositivo (Organizer) TPI): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.899-2026-01-12T150619.html"
              test="count(hl7:reference) &lt;= 1">(Dispositivo (Organizer) TPI): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.899
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:text[hl7:reference]/hl7:reference
Item: (Dispositivo (Organizer) TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.899
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]
Item: (Dispositivo (Organizer) TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]">
      <extends rule="d3603e0-false-d3607e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.899-2026-01-12T150619.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Dispositivo (Organizer) TPI): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1" id="d3603e0-false-d3607e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="string(@classCode) = ('SPLY') or not(@classCode)">(Dettaglio Dispositivo TPI): The value for classCode SHALL be 'SPLY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="string(@moodCode) = ('EVN')">(Dettaglio Dispositivo TPI): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:id) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:id) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:code) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:code) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:statusCode[@code = 'completed'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:statusCode[@code = 'completed'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:effectiveTime[hl7:low]) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:effectiveTime[hl7:low] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:effectiveTime[hl7:low]) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:effectiveTime[hl7:low] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:participant[@typeCode = 'LOC'][hl7:participantRole]) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:participant[@typeCode = 'LOC'][hl7:participantRole] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:participant[hl7:participantRole]) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:participant[hl7:participantRole] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:participant[hl7:participantRole]) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:participant[hl7:participantRole] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]]) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.753')">(Dettaglio Dispositivo TPI): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.753'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:id
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="@root">(Dettaglio Dispositivo TPI): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$')">(Dettaglio Dispositivo TPI): Attribute @root SHALL be of data type 'oid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="@extension">(Dettaglio Dispositivo TPI): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Dettaglio Dispositivo TPI): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Dettaglio Dispositivo TPI): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:code
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="@code">(Dettaglio Dispositivo TPI): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Dettaglio Dispositivo TPI): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="@codeSystem">(Dettaglio Dispositivo TPI): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Dettaglio Dispositivo TPI): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Dettaglio Dispositivo TPI): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Dettaglio Dispositivo TPI): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Dettaglio Dispositivo TPI): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:statusCode[@code = 'completed']
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:statusCode[@code = 'completed']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="string(@code) = ('completed')">(Dettaglio Dispositivo TPI): The value for code SHALL be 'completed'. Found: "<value-of select="@code"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:effectiveTime[hl7:low]
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:effectiveTime[hl7:low]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:low) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:low) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:low appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:high) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:high appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:effectiveTime[hl7:low]/hl7:low
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:effectiveTime[hl7:low]/hl7:low">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Dettaglio Dispositivo TPI): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:effectiveTime[hl7:low]/hl7:high
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:effectiveTime[hl7:low]/hl7:high">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Dettaglio Dispositivo TPI): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]">
      <extends rule="d3957e0-false-d3961e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="string(@typeCode) = ('PRD') or not(@typeCode)">(Dettaglio Dispositivo TPI): The value for typeCode SHALL be 'PRD'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.754
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]
Item: (manufacturedProduct TPI)
-->
   <rule fpi="RULC-1" id="d3957e0-false-d3961e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.754-2025-07-25T171736.html"
              test="count(hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]) &gt;= 1">(manufacturedProduct TPI): element hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.754-2025-07-25T171736.html"
              test="count(hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]) &lt;= 1">(manufacturedProduct TPI): element hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.754
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]
Item: (manufacturedProduct TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.754-2025-07-25T171736.html"
              test="string(@classCode) = ('MANU') or not(@classCode)">(manufacturedProduct TPI): The value for classCode SHALL be 'MANU'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.754-2025-07-25T171736.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']) &gt;= 1">(manufacturedProduct TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.754-2025-07-25T171736.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']) &lt;= 1">(manufacturedProduct TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.754-2025-07-25T171736.html"
              test="count(hl7:manufacturedMaterial[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']]) &gt;= 1">(manufacturedProduct TPI): element hl7:manufacturedMaterial[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.754-2025-07-25T171736.html"
              test="count(hl7:manufacturedMaterial[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']]) &lt;= 1">(manufacturedProduct TPI): element hl7:manufacturedMaterial[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.754-2025-07-25T171736.html"
              test="count(hl7:manufacturerOrganization) &gt;= 1">(manufacturedProduct TPI): element hl7:manufacturerOrganization is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.754-2025-07-25T171736.html"
              test="count(hl7:manufacturerOrganization) &lt;= 1">(manufacturedProduct TPI): element hl7:manufacturerOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.754
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']
Item: (manufacturedProduct TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.754-2025-07-25T171736.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.754')">(manufacturedProduct TPI): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.754'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.754
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturedMaterial[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']]
Item: (manufacturedProduct TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.755
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturedMaterial[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']]
Item: (Dettaglio manufacturedMaterial TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturedMaterial[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.755-2025-07-25T172010.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']) &gt;= 1">(Dettaglio manufacturedMaterial TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.755-2025-07-25T172010.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']) &lt;= 1">(Dettaglio manufacturedMaterial TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.755-2025-07-25T172010.html"
              test="count(hl7:name) &gt;= 1">(Dettaglio manufacturedMaterial TPI): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.755-2025-07-25T172010.html"
              test="count(hl7:name) &lt;= 1">(Dettaglio manufacturedMaterial TPI): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.755-2025-07-25T172010.html"
              test="count(hl7:lotNumberText) &gt;= 1">(Dettaglio manufacturedMaterial TPI): element hl7:lotNumberText is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.755-2025-07-25T172010.html"
              test="count(hl7:lotNumberText) &lt;= 1">(Dettaglio manufacturedMaterial TPI): element hl7:lotNumberText appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.755
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturedMaterial[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']
Item: (Dettaglio manufacturedMaterial TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturedMaterial[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.755-2025-07-25T172010.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.755')">(Dettaglio manufacturedMaterial TPI): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.755'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.755
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturedMaterial[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']]/hl7:name
Item: (Dettaglio manufacturedMaterial TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.755
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturedMaterial[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.755']]/hl7:lotNumberText
Item: (Dettaglio manufacturedMaterial TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.754
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization
Item: (manufacturedProduct TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.756
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization
Item: (manufacturerOrganization TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(manufacturerOrganization TPI): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(manufacturerOrganization TPI): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="count(hl7:id) &lt;= 1">(manufacturerOrganization TPI): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="count(hl7:name) &gt;= 1">(manufacturerOrganization TPI): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="count(hl7:name) &lt;= 1">(manufacturerOrganization TPI): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="count(hl7:telecom) &gt;= 1">(manufacturerOrganization TPI): element hl7:telecom is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="count(hl7:telecom) &lt;= 1">(manufacturerOrganization TPI): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="count(hl7:addr) &gt;= 1">(manufacturerOrganization TPI): element hl7:addr is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="count(hl7:addr) &lt;= 1">(manufacturerOrganization TPI): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.756
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:id
Item: (manufacturerOrganization TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="@root">(manufacturerOrganization TPI): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(manufacturerOrganization TPI): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="@extension">(manufacturerOrganization TPI): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="not(@extension) or string-length(@extension)&gt;0">(manufacturerOrganization TPI): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(manufacturerOrganization TPI): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.756
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:name
Item: (manufacturerOrganization TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.756
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:telecom
Item: (manufacturerOrganization TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="@use">(manufacturerOrganization TPI): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(manufacturerOrganization TPI): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.756
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:addr
Item: (manufacturerOrganization TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:addr">
      <extends rule="d4346e0-false-d4352e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="@use">(manufacturerOrganization TPI): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.756-2025-07-25T174249.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(manufacturerOrganization TPI): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d4346e0-false-d4352e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.754']]/hl7:manufacturerOrganization/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[@typeCode = 'LOC'][hl7:participantRole]
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[@typeCode = 'LOC'][hl7:participantRole]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="string(@typeCode) = ('LOC')">(Dettaglio Dispositivo TPI): The value for typeCode SHALL be 'LOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@contextControlCode) or (string-length(@contextControlCode) &gt; 0 and not(matches(@contextControlCode,'\s')))">(Dettaglio Dispositivo TPI): Attribute @contextControlCode SHALL be of data type 'cs'  - '<value-of select="@contextControlCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:participantRole[hl7:playingEntity]) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:participantRole[hl7:playingEntity] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:participantRole[hl7:playingEntity]) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:participantRole[hl7:playingEntity] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[@typeCode = 'LOC'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity]
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[@typeCode = 'LOC'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="string(@classCode) = ('SDLOC') or not(@classCode)">(Dettaglio Dispositivo TPI): The value for classCode SHALL be 'SDLOC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:addr) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:playingEntity[hl7:name]) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:playingEntity[hl7:name] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:playingEntity[hl7:name]) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:playingEntity[hl7:name] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:id) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:id appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[@typeCode = 'LOC'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity]/hl7:addr
Item: (Dettaglio Dispositivo TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[@typeCode = 'LOC'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[hl7:name]
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[@typeCode = 'LOC'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[hl7:name]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:name) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:name) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[@typeCode = 'LOC'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[hl7:name]/hl7:name
Item: (Dettaglio Dispositivo TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[@typeCode = 'LOC'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity]/hl7:id
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[@typeCode = 'LOC'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity]/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="@root">(Dettaglio Dispositivo TPI): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$')">(Dettaglio Dispositivo TPI): Attribute @root SHALL be of data type 'oid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="@extension">(Dettaglio Dispositivo TPI): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Dettaglio Dispositivo TPI): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Dettaglio Dispositivo TPI): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[hl7:participantRole]
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[hl7:participantRole]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="string(@typeCode) = ('DEV') or not(@typeCode)">(Dettaglio Dispositivo TPI): The value for typeCode SHALL be 'DEV'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:participantRole[hl7:playingDevice]) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:participantRole[hl7:playingDevice] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:participantRole[hl7:playingDevice]) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:participantRole[hl7:playingDevice] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingDevice]
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingDevice]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="string(@classCode) = ('MANU') or not(@classCode)">(Dettaglio Dispositivo TPI): The value for classCode SHALL be 'MANU'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:playingDevice[hl7:manufacturerModelName]) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:playingDevice[hl7:manufacturerModelName] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:playingDevice[hl7:manufacturerModelName]) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:playingDevice[hl7:manufacturerModelName] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingDevice]/hl7:playingDevice[hl7:manufacturerModelName]
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingDevice]/hl7:playingDevice[hl7:manufacturerModelName]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:manufacturerModelName) &gt;= 1">(Dettaglio Dispositivo TPI): element hl7:manufacturerModelName is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(Dettaglio Dispositivo TPI): element hl7:manufacturerModelName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingDevice]/hl7:playingDevice[hl7:manufacturerModelName]/hl7:manufacturerModelName
Item: (Dettaglio Dispositivo TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]">
      <extends rule="d4650e0-false-d4654e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Dettaglio Dispositivo TPI): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.759
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]
Item: (Act riferimento a tessera precedente(TPI))
-->
   <rule fpi="RULC-1" id="d4650e0-false-d4654e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]) &gt;= 1">(Act riferimento a tessera precedente(TPI)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]) &lt;= 1">(Act riferimento a tessera precedente(TPI)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.759
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]
Item: (Act riferimento a tessera precedente(TPI))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="string(@moodCode) = ('EVN')">(Act riferimento a tessera precedente(TPI)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="string(@classCode) = ('ACT')">(Act riferimento a tessera precedente(TPI)): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']) &gt;= 1">(Act riferimento a tessera precedente(TPI)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']) &lt;= 1">(Act riferimento a tessera precedente(TPI)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Act riferimento a tessera precedente(TPI)): element hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Act riferimento a tessera precedente(TPI)): element hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="count(hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]) &gt;= 1">(Act riferimento a tessera precedente(TPI)): element hl7:reference[@typeCode = 'REFR'][hl7:externalDocument] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="count(hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]) &lt;= 1">(Act riferimento a tessera precedente(TPI)): element hl7:reference[@typeCode = 'REFR'][hl7:externalDocument] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.759
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']
Item: (Act riferimento a tessera precedente(TPI))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.759')">(Act riferimento a tessera precedente(TPI)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.759'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.759
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]/hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Act riferimento a tessera precedente(TPI))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]/hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="string(@code) = ('55107-7')">(Act riferimento a tessera precedente(TPI)): The value for code SHALL be '55107-7'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Act riferimento a tessera precedente(TPI)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Act riferimento a tessera precedente(TPI)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Act riferimento a tessera precedente(TPI)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="string(@displayName) = ('External documents') or not(@displayName)">(Act riferimento a tessera precedente(TPI)): The value for displayName SHALL be 'External documents'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Act riferimento a tessera precedente(TPI)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.759
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]
Item: (Act riferimento a tessera precedente(TPI))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="string(@typeCode) = ('REFR')">(Act riferimento a tessera precedente(TPI)): The value for typeCode SHALL be 'REFR'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="count(hl7:externalDocument[not(@nullFlavor)][hl7:id]) &gt;= 1">(Act riferimento a tessera precedente(TPI)): element hl7:externalDocument[not(@nullFlavor)][hl7:id] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="count(hl7:externalDocument[not(@nullFlavor)][hl7:id]) &lt;= 1">(Act riferimento a tessera precedente(TPI)): element hl7:externalDocument[not(@nullFlavor)][hl7:id] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.759
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[not(@nullFlavor)][hl7:id]
Item: (Act riferimento a tessera precedente(TPI))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[not(@nullFlavor)][hl7:id]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(Act riferimento a tessera precedente(TPI)): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Act riferimento a tessera precedente(TPI)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="count(hl7:id) &gt;= 1">(Act riferimento a tessera precedente(TPI)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="count(hl7:id) &lt;= 1">(Act riferimento a tessera precedente(TPI)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="count(hl7:code) &lt;= 1">(Act riferimento a tessera precedente(TPI)): element hl7:code appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.759
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[not(@nullFlavor)][hl7:id]/hl7:id
Item: (Act riferimento a tessera precedente(TPI))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[not(@nullFlavor)][hl7:id]/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="@root">(Act riferimento a tessera precedente(TPI)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Act riferimento a tessera precedente(TPI)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="@extension">(Act riferimento a tessera precedente(TPI)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Act riferimento a tessera precedente(TPI)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Act riferimento a tessera precedente(TPI)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.759
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[not(@nullFlavor)][hl7:id]/hl7:code
Item: (Act riferimento a tessera precedente(TPI))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.759']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[not(@nullFlavor)][hl7:id]/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="@code">(Act riferimento a tessera precedente(TPI)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Act riferimento a tessera precedente(TPI)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="@codeSystem">(Act riferimento a tessera precedente(TPI)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Act riferimento a tessera precedente(TPI)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Act riferimento a tessera precedente(TPI)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.759-2025-07-31T161543.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Act riferimento a tessera precedente(TPI)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.753
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]]
Item: (Dettaglio Dispositivo TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]]">
      <extends rule="d4864e0-false-d4868e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.753-2025-07-25T163155.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Dettaglio Dispositivo TPI): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.761
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]]
Item: (Stato dispositivo (Observation) TPI)
-->
   <rule fpi="RULC-1" id="d4864e0-false-d4868e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]) &gt;= 1">(Stato dispositivo (Observation) TPI): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]) &lt;= 1">(Stato dispositivo (Observation) TPI): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.761
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]
Item: (Stato dispositivo (Observation) TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Stato dispositivo (Observation) TPI): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="string(@moodCode) = ('EVN')">(Stato dispositivo (Observation) TPI): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']) &gt;= 1">(Stato dispositivo (Observation) TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']) &lt;= 1">(Stato dispositivo (Observation) TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="count(hl7:code[(@code = '104959-2 ' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Stato dispositivo (Observation) TPI): element hl7:code[(@code = '104959-2 ' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="count(hl7:code[(@code = '104959-2 ' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Stato dispositivo (Observation) TPI): element hl7:code[(@code = '104959-2 ' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.6.1']) &gt;= 1">(Stato dispositivo (Observation) TPI): element hl7:value[@codeSystem = '2.16.840.1.113883.6.1'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.6.1']) &lt;= 1">(Stato dispositivo (Observation) TPI): element hl7:value[@codeSystem = '2.16.840.1.113883.6.1'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.761
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']
Item: (Stato dispositivo (Observation) TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.761')">(Stato dispositivo (Observation) TPI): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.761'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.761
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]/hl7:code[(@code = '104959-2 ' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Stato dispositivo (Observation) TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]/hl7:code[(@code = '104959-2 ' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="string(@code) = ('104959-2')">(Stato dispositivo (Observation) TPI): The value for code SHALL be '104959-2'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Stato dispositivo (Observation) TPI): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Stato dispositivo (Observation) TPI): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Stato dispositivo (Observation) TPI): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Stato dispositivo (Observation) TPI): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="string(@displayName) = ('Device fitting or implant status') or not(@displayName)">(Stato dispositivo (Observation) TPI): The value for displayName SHALL be 'Device fitting or implant status'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Stato dispositivo (Observation) TPI): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.761
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]/hl7:value[@codeSystem = '2.16.840.1.113883.6.1']
Item: (Stato dispositivo (Observation) TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.753']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.761']]/hl7:value[@codeSystem = '2.16.840.1.113883.6.1']">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Stato dispositivo (Observation) TPI): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="@code">(Stato dispositivo (Observation) TPI): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Stato dispositivo (Observation) TPI): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Stato dispositivo (Observation) TPI): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Stato dispositivo (Observation) TPI): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Stato dispositivo (Observation) TPI): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Stato dispositivo (Observation) TPI): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.761-2025-09-09T153950.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Stato dispositivo (Observation) TPI): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.899
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]]
Item: (Dispositivo (Organizer) TPI)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.758
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]]
Item: (Sede anatomica (Observation) TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]) &gt;= 1">(Sede anatomica (Observation) TPI): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]) &lt;= 1">(Sede anatomica (Observation) TPI): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.758
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]
Item: (Sede anatomica (Observation) TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Sede anatomica (Observation) TPI): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="string(@moodCode) = ('EVN')">(Sede anatomica (Observation) TPI): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']) &gt;= 1">(Sede anatomica (Observation) TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']) &lt;= 1">(Sede anatomica (Observation) TPI): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="count(hl7:code[(@code = '20228-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Sede anatomica (Observation) TPI): element hl7:code[(@code = '20228-3' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="count(hl7:code[(@code = '20228-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Sede anatomica (Observation) TPI): element hl7:code[(@code = '20228-3' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.34-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(Sede anatomica (Observation) TPI): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.34-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.34-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Sede anatomica (Observation) TPI): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.34-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.758
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']
Item: (Sede anatomica (Observation) TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.758')">(Sede anatomica (Observation) TPI): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.758'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.758
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]/hl7:code[(@code = '20228-3' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Sede anatomica (Observation) TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]/hl7:code[(@code = '20228-3' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="string(@code) = ('20228-3')">(Sede anatomica (Observation) TPI): The value for code SHALL be '20228-3'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Sede anatomica (Observation) TPI): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Sede anatomica (Observation) TPI): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Sede anatomica (Observation) TPI): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Sede anatomica (Observation) TPI): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="string(@displayName) = ('Lateralità') or not(@displayName)">(Sede anatomica (Observation) TPI): The value for displayName SHALL be 'Lateralità'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Sede anatomica (Observation) TPI): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.758
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.34-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Sede anatomica (Observation) TPI)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.17.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.733']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.757']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.758']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.34-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.34-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Sede anatomica (Observation) TPI): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.34 ActSite (DYNAMIC)'.</assert>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Sede anatomica (Observation) TPI): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="@code">(Sede anatomica (Observation) TPI): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Sede anatomica (Observation) TPI): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="@codeSystem">(Sede anatomica (Observation) TPI): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(Sede anatomica (Observation) TPI): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Sede anatomica (Observation) TPI): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Sede anatomica (Observation) TPI): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20260115T093950/tmp-2.16.840.1.113883.3.1937.777.63.10.758-2025-07-31T155000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Sede anatomica (Observation) TPI): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
</pattern>
