<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
   <title>Schematron file for transaction Relazione Finale di Telemonitoraggio (2.16.840.1.113883.3.1937.777.63.4.50 2025-10-06T00:00:00)</title>
   <ns uri="urn:hl7-org:v3" prefix="hl7"/>
   <ns uri="urn:hl7-org:v3" prefix="cda"/>
   <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
   <ns uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
   <!-- Add extra namespaces -->
   <ns uri="urn:hl7-org:sdtc" prefix="sdtc"/>
   <ns uri="urn:ihe:pharm:medication" prefix="pharm"/>
   <ns uri="http://www.w3.org/XML/1998/namespace" prefix="xml"/>
   <!-- Include realm specific schematron -->
   <!-- Include scenario label -->
   <let name="scenariolabel" value="'2.16.840.1.113883.3.1937.777.63.4.50'"/>
   <!-- Include datatype abstract schematrons -->
   <pattern>
      <include href="include/DTr1_AD.sch"/>
      <include href="include/DTr1_AD.CA.sch"/>
      <include href="include/DTr1_AD.CA.BASIC.sch"/>
      <include href="include/DTr1_AD.DE.sch"/>
      <include href="include/DTr1_AD.EPSOS.sch"/>
      <include href="include/DTr1_AD.IPS.sch"/>
      <include href="include/DTr1_AD.NL.sch"/>
      <include href="include/DTr1_ADXP.sch"/>
      <include href="include/DTr1_ANY.sch"/>
      <include href="include/DTr1_BIN.sch"/>
      <include href="include/DTr1_BL.sch"/>
      <include href="include/DTr1_BN.sch"/>
      <include href="include/DTr1_BXIT_IVL_PQ.sch"/>
      <include href="include/DTr1_CD.sch"/>
      <include href="include/DTr1_CD.EPSOS.sch"/>
      <include href="include/DTr1_CD.IPS.sch"/>
      <include href="include/DTr1_CD.SDTC.sch"/>
      <include href="include/DTr1_CE.sch"/>
      <include href="include/DTr1_CE.EPSOS.sch"/>
      <include href="include/DTr1_CE.IPS.sch"/>
      <include href="include/DTr1_CO.sch"/>
      <include href="include/DTr1_CO.EPSOS.sch"/>
      <include href="include/DTr1_CR.sch"/>
      <include href="include/DTr1_CS.sch"/>
      <include href="include/DTr1_CS.LANG.sch"/>
      <include href="include/DTr1_CV.sch"/>
      <include href="include/DTr1_CV.EPSOS.sch"/>
      <include href="include/DTr1_CV.IPS.sch"/>
      <include href="include/DTr1_ED.sch"/>
      <include href="include/DTr1_EIVL.event.sch"/>
      <include href="include/DTr1_EIVL_TS.sch"/>
      <include href="include/DTr1_EN.sch"/>
      <include href="include/DTr1_ENXP.sch"/>
      <include href="include/DTr1_GLIST.sch"/>
      <include href="include/DTr1_GLIST_PQ.sch"/>
      <include href="include/DTr1_GLIST_TS.sch"/>
      <include href="include/DTr1_hl7nl-INT.sch"/>
      <include href="include/DTr1_hl7nl-IVL_QTY.sch"/>
      <include href="include/DTr1_hl7nl-IVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PIVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PQ.sch"/>
      <include href="include/DTr1_hl7nl-QSET_QTY.sch"/>
      <include href="include/DTr1_hl7nl-RTO.sch"/>
      <include href="include/DTr1_hl7nl-TS.sch"/>
      <include href="include/DTr1_II.sch"/>
      <include href="include/DTr1_II.AT.ATU.sch"/>
      <include href="include/DTr1_II.AT.BLZ.sch"/>
      <include href="include/DTr1_II.AT.DVR.sch"/>
      <include href="include/DTr1_II.AT.KTONR.sch"/>
      <include href="include/DTr1_II.EPSOS.sch"/>
      <include href="include/DTr1_II.NL.AGB.sch"/>
      <include href="include/DTr1_II.NL.BIG.sch"/>
      <include href="include/DTr1_II.NL.BSN.sch"/>
      <include href="include/DTr1_II.NL.URA.sch"/>
      <include href="include/DTr1_II.NL.UZI.sch"/>
      <include href="include/DTr1_INT.sch"/>
      <include href="include/DTr1_INT.NONNEG.sch"/>
      <include href="include/DTr1_INT.POS.sch"/>
      <include href="include/DTr1_IVL_INT.sch"/>
      <include href="include/DTr1_IVL_MO.sch"/>
      <include href="include/DTr1_IVL_PQ.sch"/>
      <include href="include/DTr1_IVL_REAL.sch"/>
      <include href="include/DTr1_IVL_TS.sch"/>
      <include href="include/DTr1_IVL_TS.CH.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_IVL_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_IVXB_INT.sch"/>
      <include href="include/DTr1_IVXB_MO.sch"/>
      <include href="include/DTr1_IVXB_PQ.sch"/>
      <include href="include/DTr1_IVXB_REAL.sch"/>
      <include href="include/DTr1_IVXB_TS.sch"/>
      <include href="include/DTr1_list_int.sch"/>
      <include href="include/DTr1_MO.sch"/>
      <include href="include/DTr1_ON.sch"/>
      <include href="include/DTr1_PIVL_TS.sch"/>
      <include href="include/DTr1_PN.sch"/>
      <include href="include/DTr1_PN.CA.sch"/>
      <include href="include/DTr1_PN.NL.sch"/>
      <include href="include/DTr1_PQ.sch"/>
      <include href="include/DTr1_PQR.sch"/>
      <include href="include/DTr1_QTY.sch"/>
      <include href="include/DTr1_REAL.sch"/>
      <include href="include/DTr1_REAL.NONNEG.sch"/>
      <include href="include/DTr1_REAL.POS.sch"/>
      <include href="include/DTr1_RTO.sch"/>
      <include href="include/DTr1_RTO_PQ_PQ.sch"/>
      <include href="include/DTr1_RTO_QTY_QTY.sch"/>
      <include href="include/DTr1_SC.sch"/>
      <include href="include/DTr1_SD.TEXT.sch"/>
      <include href="include/DTr1_SLIST.sch"/>
      <include href="include/DTr1_SLIST_PQ.sch"/>
      <include href="include/DTr1_SLIST_TS.sch"/>
      <include href="include/DTr1_ST.sch"/>
      <include href="include/DTr1_SXCM_INT.sch"/>
      <include href="include/DTr1_SXCM_MO.sch"/>
      <include href="include/DTr1_SXCM_PQ.sch"/>
      <include href="include/DTr1_SXCM_REAL.sch"/>
      <include href="include/DTr1_SXCM_TS.sch"/>
      <include href="include/DTr1_SXPR_TS.sch"/>
      <include href="include/DTr1_TEL.sch"/>
      <include href="include/DTr1_TEL.AT.sch"/>
      <include href="include/DTr1_TEL.CA.EMAIL.sch"/>
      <include href="include/DTr1_TEL.CA.PHONE.sch"/>
      <include href="include/DTr1_TEL.EPSOS.sch"/>
      <include href="include/DTr1_TEL.IPS.sch"/>
      <include href="include/DTr1_TEL.NL.EXTENDED.sch"/>
      <include href="include/DTr1_thumbnail.sch"/>
      <include href="include/DTr1_TN.sch"/>
      <include href="include/DTr1_TS.sch"/>
      <include href="include/DTr1_TS.AT.TZ.sch"/>
      <include href="include/DTr1_TS.AT.VAR.sch"/>
      <include href="include/DTr1_TS.CH.TZ.sch"/>
      <include href="include/DTr1_TS.DATE.sch"/>
      <include href="include/DTr1_TS.DATE.FULL.sch"/>
      <include href="include/DTr1_TS.DATE.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIME.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIMETZ.MIN.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_URL.sch"/>
      <include href="include/DTr1_URL.NL.EXTENDED.sch"/>
   </pattern>

   <!-- Include the project schematrons related to scenario 2.16.840.1.113883.3.1937.777.63.4.50 -->

   <!-- RelazioneFinalediTelemonitoraggio -->
   <pattern>
      <title>RelazioneFinalediTelemonitoraggio</title>
      <rule fpi="RUL-EXPEL" context="/">
         <assert role="warning"
                 test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.3.1']]"
                 see="https://hl7itig.art-decor.pub/hl7itig-html-20251222T162403/tmp-2.16.840.1.113883.2.9.10.1.16.3.1-2025-12-15T121753.html">(Relazione Finale di Telemonitoraggio): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.3.1']]</assert>
      </rule>
   </pattern>
   <include href="include/2.16.840.1.113883.2.9.10.1.16.3.1-2025-12-15T121753.sch"/>
   <include href="include/2.16.840.1.113883.2.9.10.1.16.3.1-2025-12-15T121753-closed.sch"/>


   <!-- Create phases for more targeted validation on large instances -->
   <phase id="AllExceptClosed">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.16.3.1-2025-12-15T121753"/>
      <active pattern="template-2.16.840.1.113883.10.12.301-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.302-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.303-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.304-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.305-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.306-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.307-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.308-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.309-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.648-2025-05-27T122852"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.649-2025-05-27T123135"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.650-2025-05-27T123341"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.653-2025-05-27T124936"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.656-2025-05-28T091826"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.657-2025-05-28T094719"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.669-2025-05-28T163032"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.694-2025-06-05T143248"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.695-2025-06-05T143825"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.696-2025-06-05T144330"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.698-2025-06-05T145439"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.699-2025-06-06T113859"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.701-2025-06-09T105549"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.702-2025-06-09T105920"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.716-2025-07-11T103950"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.718-2025-07-11T121308"/>
   </phase>
   <phase id="RelazioneFinalediTelemonitoraggio">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.16.3.1-2025-12-15T121753"/>
   </phase>
   <phase id="RelazioneFinalediTelemonitoraggio-closed">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.16.3.1-2025-12-15T121753-closed"/>
   </phase>
   <phase id="CDAAct">
      <active pattern="template-2.16.840.1.113883.10.12.301-2005-09-07T000000"/>
   </phase>
   <phase id="CDAEncounter">
      <active pattern="template-2.16.840.1.113883.10.12.302-2005-09-07T000000"/>
   </phase>
   <phase id="CDAObservation">
      <active pattern="template-2.16.840.1.113883.10.12.303-2005-09-07T000000"/>
   </phase>
   <phase id="CDAObservationMedia">
      <active pattern="template-2.16.840.1.113883.10.12.304-2005-09-07T000000"/>
   </phase>
   <phase id="CDAOrganizer">
      <active pattern="template-2.16.840.1.113883.10.12.305-2005-09-07T000000"/>
   </phase>
   <phase id="CDAProcedure">
      <active pattern="template-2.16.840.1.113883.10.12.306-2005-09-07T000000"/>
   </phase>
   <phase id="CDARegionOfInterest">
      <active pattern="template-2.16.840.1.113883.10.12.307-2005-09-07T000000"/>
   </phase>
   <phase id="CDASubstanceAdministration">
      <active pattern="template-2.16.840.1.113883.10.12.308-2005-09-07T000000"/>
   </phase>
   <phase id="CDASupply">
      <active pattern="template-2.16.840.1.113883.10.12.309-2005-09-07T000000"/>
   </phase>
   <phase id="QuesitoDiagnosticoTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.648-2025-05-27T122852"/>
   </phase>
   <phase id="StoriaClinicaTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.649-2025-05-27T123135"/>
   </phase>
   <phase id="AnamnesiFisiologicaPatologicaTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.650-2025-05-27T123341"/>
   </phase>
   <phase id="AnamnesiFamiliareTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809"/>
   </phase>
   <phase id="AllergieTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138"/>
   </phase>
   <phase id="TerapiaFarmacologicaInAttoTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.653-2025-05-27T124936"/>
   </phase>
   <phase id="PrecedentiEsamiEseguitiTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.656-2025-05-28T091826"/>
   </phase>
   <phase id="PrestazioniTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.657-2025-05-28T094719"/>
   </phase>
   <phase id="EsameObiettivoTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.669-2025-05-28T163032"/>
   </phase>
   <phase id="ConfrontoConPrecedentiEsamiEseguitiTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.694-2025-06-05T143248"/>
   </phase>
   <phase id="RefertoTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.695-2025-06-05T143825"/>
   </phase>
   <phase id="DiagnosiTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.696-2025-06-05T144330"/>
   </phase>
   <phase id="ConclusioniTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.698-2025-06-05T145439"/>
   </phase>
   <phase id="SuggerimentiPerIlMedicoPrescrittoreTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.699-2025-06-06T113859"/>
   </phase>
   <phase id="AccertamentieControlliConsigliatiTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.701-2025-06-09T105549"/>
   </phase>
   <phase id="TerapiaFarmacologicaConsigliataTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.702-2025-06-09T105920"/>
   </phase>
   <phase id="AllergieactTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.716-2025-07-11T103950"/>
   </phase>
   <phase id="TerapieFarmacologicheSubstanceAdministrationTele">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.718-2025-07-11T121308"/>
   </phase>

   <!-- Include schematrons from templates with explicit * or ** context (but no representing templates), only those used in scenario template -->

   <!-- CDAAct -->
   <include href="include/2.16.840.1.113883.10.12.301-2005-09-07T000000.sch"/>
   <!-- CDAEncounter -->
   <include href="include/2.16.840.1.113883.10.12.302-2005-09-07T000000.sch"/>
   <!-- CDAObservation -->
   <include href="include/2.16.840.1.113883.10.12.303-2005-09-07T000000.sch"/>
   <!-- CDAObservationMedia -->
   <include href="include/2.16.840.1.113883.10.12.304-2005-09-07T000000.sch"/>
   <!-- CDAOrganizer -->
   <include href="include/2.16.840.1.113883.10.12.305-2005-09-07T000000.sch"/>
   <!-- CDAProcedure -->
   <include href="include/2.16.840.1.113883.10.12.306-2005-09-07T000000.sch"/>
   <!-- CDARegionOfInterest -->
   <include href="include/2.16.840.1.113883.10.12.307-2005-09-07T000000.sch"/>
   <!-- CDASubstanceAdministration -->
   <include href="include/2.16.840.1.113883.10.12.308-2005-09-07T000000.sch"/>
   <!-- CDASupply -->
   <include href="include/2.16.840.1.113883.10.12.309-2005-09-07T000000.sch"/>
   <!-- QuesitoDiagnosticoTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.648-2025-05-27T122852.sch"/>
   <!-- StoriaClinicaTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.649-2025-05-27T123135.sch"/>
   <!-- AnamnesiFisiologicaPatologicaTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.650-2025-05-27T123341.sch"/>
   <!-- AnamnesiFamiliareTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.sch"/>
   <!-- AllergieTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.sch"/>
   <!-- TerapiaFarmacologicaInAttoTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.653-2025-05-27T124936.sch"/>
   <!-- PrecedentiEsamiEseguitiTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.656-2025-05-28T091826.sch"/>
   <!-- PrestazioniTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.657-2025-05-28T094719.sch"/>
   <!-- EsameObiettivoTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.669-2025-05-28T163032.sch"/>
   <!-- ConfrontoConPrecedentiEsamiEseguitiTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.694-2025-06-05T143248.sch"/>
   <!-- RefertoTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.695-2025-06-05T143825.sch"/>
   <!-- DiagnosiTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.696-2025-06-05T144330.sch"/>
   <!-- ConclusioniTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.698-2025-06-05T145439.sch"/>
   <!-- SuggerimentiPerIlMedicoPrescrittoreTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.699-2025-06-06T113859.sch"/>
   <!-- AccertamentieControlliConsigliatiTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.701-2025-06-09T105549.sch"/>
   <!-- TerapiaFarmacologicaConsigliataTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.702-2025-06-09T105920.sch"/>
   <!-- AllergieactTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.716-2025-07-11T103950.sch"/>
   <!-- TerapieFarmacologicheSubstanceAdministrationTele -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.718-2025-07-11T121308.sch"/>

</schema>
