<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.18.1
Name: Cartella Clinica
Description: Template CDA ClinicalDocument (prototype, contains ClinicalDocument.component as nonXMLBody)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017">
   <title>Cartella Clinica</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /
Item: (Cartella Clinica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]"
         id="d45e61-false-d1133e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@classCode) = ('DOCCLIN')">(Cartella Clinica): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@moodCode) = ('EVN')">(Cartella Clinica): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:realmCode) &gt;= 1">(Cartella Clinica): element hl7:realmCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1">(Cartella Clinica): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1">(Cartella Clinica): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']) &gt;= 1">(Cartella Clinica): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(Cartella Clinica): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(Cartella Clinica): element hl7:id[not(@nullFlavor)] appears too often [max 1x].</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt; 1">(Cartella Clinica): element hl7:code is coded with binding strength 'extensible' and contains a code other than the specified set.</report>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Cartella Clinica): element hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:title) &lt;= 1">(Cartella Clinica): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(sdtc:statusCode[@code = 'active']) &lt;= 1">(Cartella Clinica): element sdtc:statusCode[@code = 'active'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Cartella Clinica): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Cartella Clinica): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &gt;= 1">(Cartella Clinica): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &lt;= 1">(Cartella Clinica): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:languageCode) &gt;= 1">(Cartella Clinica): element hl7:languageCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:languageCode) &lt;= 1">(Cartella Clinica): element hl7:languageCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:setId) &gt;= 1">(Cartella Clinica): element hl7:setId is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:setId) &lt;= 1">(Cartella Clinica): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:versionNumber) &gt;= 1">(Cartella Clinica): element hl7:versionNumber is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:versionNumber) &lt;= 1">(Cartella Clinica): element hl7:versionNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1">(Cartella Clinica): element hl7:recordTarget[hl7:patientRole] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1">(Cartella Clinica): element hl7:recordTarget[hl7:patientRole] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">(Cartella Clinica): element hl7:author[hl7:assignedAuthor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1">(Cartella Clinica): element hl7:custodian[hl7:assignedCustodian] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1">(Cartella Clinica): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:legalAuthenticator[hl7:assignedEntity]) &gt;= 1">(Cartella Clinica): element hl7:legalAuthenticator[hl7:assignedEntity] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:legalAuthenticator[hl7:assignedEntity]) &lt;= 1">(Cartella Clinica): element hl7:legalAuthenticator[hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">(Cartella Clinica): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:componentOf[hl7:encompassingEncounter]) &gt;= 1">(Cartella Clinica): element hl7:componentOf[hl7:encompassingEncounter] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:componentOf[hl7:encompassingEncounter]) &lt;= 1">(Cartella Clinica): element hl7:componentOf[hl7:encompassingEncounter] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]) &gt;= 1">(Cartella Clinica): element hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]) &lt;= 1">(Cartella Clinica): element hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:realmCode
Item: (Cartella Clinica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']"
         id="d45e74-false-d1849e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@root) = ('2.16.840.1.113883.1.3')">(Cartella Clinica): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@extension) = ('POCD_MT000040UV02')">(Cartella Clinica): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Cartella Clinica): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']"
         id="d45e94-false-d1868e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.18 .1')">(Cartella Clinica): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.18 .1'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@extension) = ('1.0')">(Cartella Clinica): The value for extension SHALL be '1.0'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Cartella Clinica): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:id[not(@nullFlavor)]
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:id[not(@nullFlavor)]"
         id="d45e113-false-d1887e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@root">(Cartella Clinica): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Cartella Clinica): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@extension">(Cartella Clinica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Cartella Clinica): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Cartella Clinica): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d45e144-false-d1909e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@code) = ('100971-1')">(Cartella Clinica): The value for code SHALL be '100971-1'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Cartella Clinica): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Cartella Clinica): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Cartella Clinica): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@displayName) = ('Cartella clinica') or not(@displayName)">(Cartella Clinica): The value for displayName SHALL be 'Cartella clinica'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Cartella Clinica): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation"
         id="d45e159-false-d1940e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@code">(Cartella Clinica): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Cartella Clinica): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@codeSystem">(Cartella Clinica): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(Cartella Clinica): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Cartella Clinica): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Cartella Clinica): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:title
Item: (Cartella Clinica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/sdtc:statusCode[@code = 'active']
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/sdtc:statusCode[@code = 'active']"
         id="d45e180-false-d1973e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@code) = ('active')">(Cartella Clinica): The value for code SHALL be 'active'. Found: "<value-of select="@code"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:effectiveTime
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:effectiveTime"
         id="d45e202-false-d1984e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@value">(Cartella Clinica): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Cartella Clinica): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']"
         id="d45e213-false-d1998e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@nullFlavor or (@code='N') or (@code='V')">(Cartella Clinica): The element value SHALL be one of 'code 'N' or code 'V''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@code">(Cartella Clinica): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Cartella Clinica): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.25')">(Cartella Clinica): The value for codeSystem SHALL be '2.16.840.1.113883.5.25'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName)">(Cartella Clinica): The value for codeSystemName SHALL be 'HL7 Confidentiality'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Cartella Clinica): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Cartella Clinica): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:languageCode
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:languageCode"
         id="d45e256-false-d2031e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@code">(Cartella Clinica): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Cartella Clinica): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:setId
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:setId"
         id="d45e267-false-d2044e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@root">(Cartella Clinica): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Cartella Clinica): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@extension">(Cartella Clinica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Cartella Clinica): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Cartella Clinica): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:versionNumber
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:versionNumber"
         id="d45e315-false-d2065e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@value">(Cartella Clinica): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]"
         id="d2070e17-false-d2184e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@typeCode) = ('RCT') or not(@typeCode)">(CDA recordTarget (Cartella Clinica)): The value for typeCode SHALL be 'RCT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA recordTarget (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:patientRole[hl7:patient]) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:patientRole[hl7:patient] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:patientRole[hl7:patient]) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:patientRole[hl7:patient] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]"
         id="d2070e44-false-d2422e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@classCode) = ('PAT') or not(@classCode)">(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'PAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:id) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:providerOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id"
         id="d2070e51-false-d2573e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTarget (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@extension">(CDA recordTarget (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTarget (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA recordTarget (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr">
      <extends rule="d2622e0-false-d2628e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@use">(CDA recordTarget (Cartella Clinica)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d2622e0-false-d2628e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom"
         id="d2070e210-false-d2740e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@use">(CDA recordTarget (Cartella Clinica)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
         id="d2070e232-false-d2834e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTarget (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:name) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:birthTime) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:birthTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:birthTime) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:birthTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:birthplace[hl7:place]) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:birthplace[hl7:place] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name
Item: (CDA recordTarget (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d2070e252-false-d3047e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA recordTarget (Cartella Clinica)): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@code">(CDA recordTarget (Cartella Clinica)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@codeSystem">(CDA recordTarget (Cartella Clinica)): attribute @codeSystem SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime
Item: (CDA recordTarget (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian"
         id="d2070e307-false-d3127e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:code) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:guardianPerson | hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTarget (Cartella Clinica)): choice (hl7:guardianPerson  or  hl7:guardianOrganization[@classCode = 'ORG']) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:guardianPerson) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:guardianPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:guardianOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id"
         id="d2070e313-false-d3262e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@root">(CDA recordTarget (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTarget (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@extension">(CDA recordTarget (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTarget (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code"
         id="d2070e317-false-d3280e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@code">(CDA recordTarget (Cartella Clinica)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@codeSystem">(CDA recordTarget (Cartella Clinica)): attribute @codeSystem SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr
Item: (CDA recordTarget (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:telecom
Item: (CDA recordTarget (Cartella Clinica))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson
Item: (CDA recordTarget (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson">
      <extends rule="d3464e0-false-d3476e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTarget (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1" id="d3464e0-false-d3476e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA recordTarget (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3794e0-false-d3800e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d3794e0-false-d3800e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3958e0-false-d3994e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d3958e0-false-d3994e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d4164e0-false-d4168e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d4164e0-false-d4168e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d4334e0-false-d4340e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d4334e0-false-d4340e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4498e0-false-d4534e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d4498e0-false-d4534e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]"
         id="d2070e339-false-d4724e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@classCode) = ('BIRTHPL') or not(@classCode)">(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'BIRTHPL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:place) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:place is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:place) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:place appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place"
         id="d2070e372-false-d4772e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTarget (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:addr[hl7:country]) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:addr[hl7:country] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name
Item: (CDA recordTarget (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]
Item: (CDA recordTarget (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:country) &gt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:country) &lt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:state) &lt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:county) &lt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:city) &lt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:censusTract appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:postalCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:country
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:state
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:county
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:city
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:censusTract
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:postalCode
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA recordTarget (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']">
      <extends rule="d5059e0-false-d5063e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(CDA recordTarget (Cartella Clinica)): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA recordTarget (Cartella Clinica)): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d5059e0-false-d5063e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d5229e0-false-d5235e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d5229e0-false-d5235e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d5393e0-false-d5429e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d5393e0-false-d5429e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d5599e0-false-d5603e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d5599e0-false-d5603e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d5769e0-false-d5775e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d5769e0-false-d5775e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d5933e0-false-d5969e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d5933e0-false-d5969e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]
Item: (CDA author (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]"
         id="d5049e408-false-d6194e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:time) &gt;= 1">(CDA author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:time) &lt;= 1">(CDA author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:assignedAuthor[hl7:id]) &gt;= 1">(CDA author (Cartella Clinica)): element hl7:assignedAuthor[hl7:id] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:assignedAuthor[hl7:id]) &lt;= 1">(CDA author (Cartella Clinica)): element hl7:assignedAuthor[hl7:id] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]
Item: (CDA author (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]"
         id="d5049e426-false-d6330e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:id) &gt;= 1">(CDA author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA author (Cartella Clinica)): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:id
Item: (CDA author (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:id"
         id="d5049e430-false-d6412e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr
Item: (CDA author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr">
      <extends rule="d6459e0-false-d6465e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="@use">(CDA author (Cartella Clinica)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d6459e0-false-d6465e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:telecom
Item: (CDA author (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:telecom"
         id="d5049e449-false-d6577e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="@use">(CDA author (Cartella Clinica)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson
Item: (CDA author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson">
      <extends rule="d6625e0-false-d6637e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA author (Cartella Clinica)): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA author (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1" id="d6625e0-false-d6637e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d6955e0-false-d6961e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d6955e0-false-d6961e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d7119e0-false-d7155e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d7119e0-false-d7155e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d7325e0-false-d7329e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d7325e0-false-d7329e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d7495e0-false-d7501e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d7495e0-false-d7501e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d7659e0-false-d7695e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d7659e0-false-d7695e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.837
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]
Item: (CDA custodian (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]"
         id="d6781e393-false-d7890e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html"
              test="string(@typeCode) = ('CST') or not(@typeCode)">(CDA custodian (Cartella Clinica)): The value for typeCode SHALL be 'CST'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1">(CDA custodian (Cartella Clinica)): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1">(CDA custodian (Cartella Clinica)): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.837
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA custodian (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]">
      <extends rule="d7956e0-false-d7960e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA custodian (Cartella Clinica)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.895
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA assignedCustodian v1.0)
-->
   <rule fpi="RULC-1" id="d7956e0-false-d7960e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.895-2025-12-18T112920.html"
              test="count(hl7:representedCustodianOrganization) &gt;= 1">(CDA assignedCustodian v1.0): element hl7:representedCustodianOrganization is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.895-2025-12-18T112920.html"
              test="count(hl7:representedCustodianOrganization) &lt;= 1">(CDA assignedCustodian v1.0): element hl7:representedCustodianOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.895
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (CDA assignedCustodian v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.896
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (custodianOrganization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(custodianOrganization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(custodianOrganization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="count(hl7:id) &gt;= 1">(custodianOrganization v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="count(hl7:name) &gt;= 1">(custodianOrganization v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="count(hl7:name) &lt;= 1">(custodianOrganization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="count(hl7:addr) &lt;= 1">(custodianOrganization v1.0): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.896
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id
Item: (custodianOrganization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="@root">(custodianOrganization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(custodianOrganization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="@extension">(custodianOrganization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="not(@extension) or string-length(@extension)&gt;0">(custodianOrganization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(custodianOrganization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.896
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:name
Item: (custodianOrganization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.896
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom
Item: (custodianOrganization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="@use">(custodianOrganization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.896
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (custodianOrganization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr">
      <extends rule="d8164e0-false-d8170e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="@use">(custodianOrganization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d8164e0-false-d8170e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.838
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]
Item: (CDA legalAuthenticator (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]"
         id="d7949e141-false-d8332e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="string(@typeCode) = ('LA') or not(@typeCode)">(CDA legalAuthenticator (Cartella Clinica)): The value for typeCode SHALL be 'LA'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA legalAuthenticator (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="count(hl7:time) &gt;= 1">(CDA legalAuthenticator (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="count(hl7:time) &lt;= 1">(CDA legalAuthenticator (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="count(hl7:signatureCode) &gt;= 1">(CDA legalAuthenticator (Cartella Clinica)): element hl7:signatureCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="count(hl7:signatureCode) &lt;= 1">(CDA legalAuthenticator (Cartella Clinica)): element hl7:signatureCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA legalAuthenticator (Cartella Clinica)): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA legalAuthenticator (Cartella Clinica)): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.838
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:time
Item: (CDA legalAuthenticator (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.838
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:signatureCode
Item: (CDA legalAuthenticator (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:signatureCode"
         id="d7949e171-false-d8429e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="@code">(CDA legalAuthenticator (Cartella Clinica)): attribute @code SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.838
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA legalAuthenticator (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity v1.0): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@root">(CDA AssignedEntity v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@extension">(CDA AssignedEntity v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@code">(CDA AssignedEntity v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@codeSystem">(CDA AssignedEntity v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d8729e0-false-d8735e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@use">(CDA AssignedEntity v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d8729e0-false-d8735e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@use">(CDA AssignedEntity v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d9218e0-false-d9224e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d9218e0-false-d9224e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d9382e0-false-d9418e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d9382e0-false-d9418e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d9588e0-false-d9592e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d9588e0-false-d9592e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d9758e0-false-d9764e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d9758e0-false-d9764e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d9922e0-false-d9958e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d9922e0-false-d9958e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
         id="d8494e564-false-d10135e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="@typeCode">(CDA relatedDocument (Cartella Clinica)): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA relatedDocument (Cartella Clinica)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:parentDocument) &gt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:parentDocument is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:parentDocument) &lt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:parentDocument appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
         id="d8494e603-false-d10166e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(CDA relatedDocument (Cartella Clinica)): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA relatedDocument (Cartella Clinica)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:id) &gt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:code) &lt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:text) &lt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:setId) &lt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:versionNumber) &lt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:versionNumber appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
         id="d8494e626-false-d10212e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="@root">(CDA relatedDocument (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocument (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="@extension">(CDA relatedDocument (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA relatedDocument (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA relatedDocument (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
         id="d8494e635-false-d10233e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="@code">(CDA relatedDocument (Cartella Clinica)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA relatedDocument (Cartella Clinica)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="@codeSystem">(CDA relatedDocument (Cartella Clinica)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(CDA relatedDocument (Cartella Clinica)): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA relatedDocument (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA relatedDocument (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:text
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:setId
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:setId"
         id="d8494e641-false-d10265e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="@root">(CDA relatedDocument (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocument (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="@extension">(CDA relatedDocument (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA relatedDocument (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA relatedDocument (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:versionNumber
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:versionNumber"
         id="d8494e650-false-d10286e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')">(CDA relatedDocument (Cartella Clinica)): Attribute @value is not a valid int number <value-of select="@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]"
         id="d10291e18-false-d10382e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(CDA componentOf (Cartella Clinica)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:encompassingEncounter[hl7:location]) &gt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:encompassingEncounter[hl7:location] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:encompassingEncounter[hl7:location]) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:encompassingEncounter[hl7:location] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]"
         id="d10291e23-false-d10570e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@classCode) = ('ENC') or not(@classCode)">(CDA componentOf (Cartella Clinica)): The value for classCode SHALL be 'ENC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA componentOf (Cartella Clinica)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:id) &gt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:id) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:effectiveTime) &gt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:responsibleParty) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:responsibleParty appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:location[hl7:healthCareFacility]) &gt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:location[hl7:healthCareFacility] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:location[hl7:healthCareFacility]) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:location[hl7:healthCareFacility] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:id
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:id"
         id="d10291e26-false-d10709e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@root">(CDA componentOf (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@extension">(CDA componentOf (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d10291e37-false-d10733e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA componentOf (Cartella Clinica)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.1 ActEncounterCode (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@code">(CDA componentOf (Cartella Clinica)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA componentOf (Cartella Clinica)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@codeSystem">(CDA componentOf (Cartella Clinica)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf (Cartella Clinica)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:effectiveTime
Item: (CDA componentOf (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty"
         id="d10291e63-false-d10823e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@typeCode) = ('RESP') or not(@typeCode)">(CDA componentOf (Cartella Clinica)): The value for typeCode SHALL be 'RESP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity
Item: (CDA componentOf (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity v1.0): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity v1.0): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@root">(CDA AssignedEntity v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@extension">(CDA AssignedEntity v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@code">(CDA AssignedEntity v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@codeSystem">(CDA AssignedEntity v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:addr">
      <extends rule="d11179e0-false-d11185e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@use">(CDA AssignedEntity v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d11179e0-false-d11185e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="@use">(CDA AssignedEntity v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.894
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d11668e0-false-d11674e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d11668e0-false-d11674e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d11832e0-false-d11868e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d11832e0-false-d11868e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d12038e0-false-d12042e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1" id="d12038e0-false-d12042e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('ORG')">(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization v1.0): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization v1.0): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@root">(CDA Organization v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@extension">(CDA Organization v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d12208e0-false-d12214e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="@use">(CDA Organization v1.0): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d12208e0-false-d12214e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.890
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d12372e0-false-d12408e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1" id="d12372e0-false-d12408e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@root">(CDA organizationPartOf v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@extension">(CDA organizationPartOf v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@code">(CDA organizationPartOf v1.0): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="@codeSystem">(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.897
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]"
         id="d10291e69-false-d12619e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@typeCode) = ('LOC') or not(@typeCode)">(CDA componentOf (Cartella Clinica)): The value for typeCode SHALL be 'LOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]) &gt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]"
         id="d10291e83-false-d12711e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@classCode) = ('SDLOC') or not(@classCode)">(CDA componentOf (Cartella Clinica)): The value for classCode SHALL be 'SDLOC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']) &gt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:location) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:location appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]) &gt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']"
         id="d10291e88-false-d12790e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.1.6')">(CDA componentOf (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.2.9.4.1.6'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@extension">(CDA componentOf (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d10291e105-false-d12813e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA componentOf (Cartella Clinica)): The element value SHALL be one of '2.16.840.1.113883.1.11.17660 ServiceDeliveryLocationRoleType (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@code">(CDA componentOf (Cartella Clinica)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA componentOf (Cartella Clinica)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@codeSystem">(CDA componentOf (Cartella Clinica)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf (Cartella Clinica)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location
Item: (CDA componentOf (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location">
      <extends rule="d12875e0-false-d12890e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA componentOf (Cartella Clinica)): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA componentOf (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.889
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location
Item: (CDA place (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d12875e0-false-d12890e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.889-2025-12-17T114241.html"
              test="count(hl7:name) &lt;= 1">(CDA place (Cartella Clinica)): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.889-2025-12-17T114241.html"
              test="count(hl7:addr) &lt;= 1">(CDA place (Cartella Clinica)): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.889
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/hl7:name
Item: (CDA place (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.889
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/hl7:addr
Item: (CDA place (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/hl7:addr">
      <extends rule="d12960e0-false-d12966e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.889-2025-12-17T114241.html"
              test="@use">(CDA place (Cartella Clinica)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.889-2025-12-17T114241.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA place (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d12960e0-false-d12966e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]
Item: (CDA componentOf (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.887
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]
Item: (CDA Organization (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="string(@classCode) = ('ORG')">(CDA Organization (Cartella Clinica)): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']) &gt;= 1">(CDA Organization (Cartella Clinica)): element hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']) &lt;= 1">(CDA Organization (Cartella Clinica)): element hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization (Cartella Clinica)): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization (Cartella Clinica)): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.887
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']
Item: (CDA Organization (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.1.2')">(CDA Organization (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.2.9.4.1.2'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="@extension">(CDA Organization (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.887
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:name
Item: (CDA Organization (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.887
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:telecom
Item: (CDA Organization (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="@use">(CDA Organization (Cartella Clinica)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.887
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:addr
Item: (CDA Organization (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:addr">
      <extends rule="d13257e0-false-d13263e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="@use">(CDA Organization (Cartella Clinica)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:addr
Item: (CDA addr v1.0)
-->
   <rule fpi="RULC-1" id="d13257e0-false-d13263e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &gt;= 1">(CDA addr v1.0): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:country) &lt;= 1">(CDA addr v1.0): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:state) &lt;= 1">(CDA addr v1.0): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:county) &lt;= 1">(CDA addr v1.0): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &gt;= 1">(CDA addr v1.0): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:city) &lt;= 1">(CDA addr v1.0): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr v1.0): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr v1.0): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:addr/hl7:country
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:addr/hl7:state
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:addr/hl7:county
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:addr/hl7:city
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:addr/hl7:postalCode
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.892
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:addr/hl7:censusTract
Item: (CDA addr v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.887
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:asOrganizationPartOf
Item: (CDA Organization (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:asOrganizationPartOf">
      <extends rule="d13397e0-false-d13403e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization (Cartella Clinica)): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization (Cartella Clinica)): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.888
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d13397e0-false-d13403e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf (Cartella Clinica)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf (Cartella Clinica)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf (Cartella Clinica)): element hl7:effectiveTime appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.888
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:asOrganizationPartOf/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.1']
Item: (CDA organizationPartOf (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:asOrganizationPartOf/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.1']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.1.1')">(CDA organizationPartOf (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.2.9.4.1.1'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="@extension">(CDA organizationPartOf (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.888
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="@code">(CDA organizationPartOf (Cartella Clinica)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf (Cartella Clinica)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="@codeSystem">(CDA organizationPartOf (Cartella Clinica)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf (Cartella Clinica)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf (Cartella Clinica)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.888
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.888
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf (Cartella Clinica))
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]"
         id="d45e344-false-d13693e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP')">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@contextConductionInd) = ('true')">(Cartella Clinica): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']) &gt;= 1">(Cartella Clinica): element hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']) &lt;= 1">(Cartella Clinica): element hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']"
         id="d45e347-false-d14107e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@moodCode) = ('EVN')">(Cartella Clinica): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@classCode) = ('DOCBODY')">(Cartella Clinica): The value for classCode SHALL be 'DOCBODY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]">
      <extends rule="d14511e0-false-d14515e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]
Item: ( Inquadramento clinico (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d14511e0-false-d14515e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]) &gt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]) &lt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]
Item: ( Inquadramento clinico (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']) &gt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']) &lt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:title) &lt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:text) &gt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:text) &lt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']
Item: ( Inquadramento clinico (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.851')">( Inquadramento clinico (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.851'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: ( Inquadramento clinico (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="string(@code) = ('47039-3')">( Inquadramento clinico (Cartella Clinica)): The value for code SHALL be '47039-3'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">( Inquadramento clinico (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">( Inquadramento clinico (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">( Inquadramento clinico (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="string(@displayName) = ('Hospital Admission history and physical note') or not(@displayName)">( Inquadramento clinico (Cartella Clinica)): The value for displayName SHALL be 'Hospital Admission history and physical note'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">( Inquadramento clinico (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:title
Item: ( Inquadramento clinico (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:text
Item: ( Inquadramento clinico (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]
Item: ( Inquadramento clinico (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@value">(author (Cartella Clinica)_v1.0): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@root">(author (Cartella Clinica)_v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@extension">(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]">
      <extends rule="d14990e0-false-d14994e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]
Item: (Accertamento assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d14990e0-false-d14994e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]) &gt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]) &lt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]
Item: (Accertamento assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']) &gt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']) &lt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:title) &lt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:text) &gt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:text) &lt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']
Item: (Accertamento assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.844')">(Accertamento assistenziale (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.844'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Accertamento assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="string(@code) = ('67851-6')">(Accertamento assistenziale (Cartella Clinica)): The value for code SHALL be '67851-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Accertamento assistenziale (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Accertamento assistenziale (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Accertamento assistenziale (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="string(@displayName) = ('Admission evaluation note') or not(@displayName)">(Accertamento assistenziale (Cartella Clinica)): The value for displayName SHALL be 'Admission evaluation note'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Accertamento assistenziale (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:title
Item: (Accertamento assistenziale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:text
Item: (Accertamento assistenziale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]
Item: (Accertamento assistenziale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@value">(author (Cartella Clinica)_v1.0): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@root">(author (Cartella Clinica)_v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@extension">(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]">
      <extends rule="d15469e0-false-d15473e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]
Item: (Allergie e intolleranze (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d15469e0-false-d15473e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]) &gt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]) &lt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]
Item: (Allergie e intolleranze (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']) &gt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']) &lt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:title) &lt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:text) &gt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:text) &lt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']
Item: (Allergie e intolleranze (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.852')">(Allergie e intolleranze (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.852'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Allergie e intolleranze (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="string(@code) = ('48765-2')">(Allergie e intolleranze (Cartella Clinica)): The value for code SHALL be '48765-2'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Allergie e intolleranze (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Allergie e intolleranze (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie e intolleranze (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="string(@displayName) = ('Allergies and adverse reactions Document') or not(@displayName)">(Allergie e intolleranze (Cartella Clinica)): The value for displayName SHALL be 'Allergies and adverse reactions Document'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie e intolleranze (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:title
Item: (Allergie e intolleranze (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:text
Item: (Allergie e intolleranze (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]
Item: (Allergie e intolleranze (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@value">(author (Cartella Clinica)_v1.0): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@root">(author (Cartella Clinica)_v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@extension">(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]">
      <extends rule="d15948e0-false-d15952e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]
Item: (Processo Terapeutico  (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d15948e0-false-d15952e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]) &gt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]) &lt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]
Item: (Processo Terapeutico  (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']) &gt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']) &lt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:title) &lt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:text) &gt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:text) &lt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']
Item: (Processo Terapeutico  (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.853')">(Processo Terapeutico  (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.853'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Processo Terapeutico  (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="string(@code) = ('84172-6')">(Processo Terapeutico  (Cartella Clinica)): The value for code SHALL be '84172-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Processo Terapeutico  (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Processo Terapeutico  (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Processo Terapeutico  (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="string(@displayName) = ('Interdisciplinary Hospital Plan of care note') or not(@displayName)">(Processo Terapeutico  (Cartella Clinica)): The value for displayName SHALL be 'Interdisciplinary Hospital Plan of care note'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Processo Terapeutico  (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:title
Item: (Processo Terapeutico  (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:text
Item: (Processo Terapeutico  (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]
Item: (Processo Terapeutico  (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@value">(author (Cartella Clinica)_v1.0): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@root">(author (Cartella Clinica)_v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@extension">(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]">
      <extends rule="d16427e0-false-d16431e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]
Item: ( Parametri (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d16427e0-false-d16431e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]) &gt;= 1">( Parametri (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]) &lt;= 1">( Parametri (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]
Item: ( Parametri (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']) &gt;= 1">( Parametri (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']) &lt;= 1">( Parametri (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">( Parametri (Cartella Clinica)): element hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">( Parametri (Cartella Clinica)): element hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:title) &lt;= 1">( Parametri (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:text) &gt;= 1">( Parametri (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:text) &lt;= 1">( Parametri (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']
Item: ( Parametri (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.854')">( Parametri (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.854'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: ( Parametri (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="string(@code) = ('8716-3')">( Parametri (Cartella Clinica)): The value for code SHALL be '8716-3'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">( Parametri (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">( Parametri (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">( Parametri (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="string(@displayName) = ('Vital signs note') or not(@displayName)">( Parametri (Cartella Clinica)): The value for displayName SHALL be 'Vital signs note'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">( Parametri (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:title
Item: ( Parametri (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:text
Item: ( Parametri (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]
Item: ( Parametri (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@value">(author (Cartella Clinica)_v1.0): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@root">(author (Cartella Clinica)_v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@extension">(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <extends rule="d16906e0-false-d16910e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d16906e0-false-d16910e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:templateId) &gt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:templateId is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:templateId) &lt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:templateId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:title) &lt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:text) &gt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:text) &lt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.855') or not(@root)">(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.855'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="string(@code) = ('83734-4')">(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for code SHALL be '83734-4'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Piano riabilitativo individuale PRI (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="string(@displayName) = ('Physical medicine and rehabilitation Interdisciplinary Plan of care note') or not(@displayName)">(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for displayName SHALL be 'Physical medicine and rehabilitation Interdisciplinary Plan of care note'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Piano riabilitativo individuale PRI (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:title
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@value">(author (Cartella Clinica)_v1.0): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@root">(author (Cartella Clinica)_v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@extension">(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]">
      <extends rule="d17383e0-false-d17387e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]
Item: (Piano assistenziale individuale (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d17383e0-false-d17387e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]) &gt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]) &lt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]
Item: (Piano assistenziale individuale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']) &gt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']) &lt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:title) &lt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:text) &gt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:text) &lt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']
Item: (Piano assistenziale individuale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.856')">(Piano assistenziale individuale (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.856'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Piano assistenziale individuale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="string(@code) = ('101541-1')">(Piano assistenziale individuale (Cartella Clinica)): The value for code SHALL be '101541-1'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Piano assistenziale individuale (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Piano assistenziale individuale (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Piano assistenziale individuale (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="string(@displayName) = ('Multidisciplinary Comprehensive plan of care note') or not(@displayName)">(Piano assistenziale individuale (Cartella Clinica)): The value for displayName SHALL be 'Multidisciplinary Comprehensive plan of care note'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Piano assistenziale individuale (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:title
Item: (Piano assistenziale individuale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:text
Item: (Piano assistenziale individuale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]
Item: (Piano assistenziale individuale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@value">(author (Cartella Clinica)_v1.0): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@root">(author (Cartella Clinica)_v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@extension">(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]">
      <extends rule="d17865e0-false-d17869e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]
Item: (Consensi (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d17865e0-false-d17869e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]) &gt;= 1">(Consensi (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]) &lt;= 1">(Consensi (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]
Item: (Consensi (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']) &gt;= 1">(Consensi (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']) &lt;= 1">(Consensi (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Consensi (Cartella Clinica)): element hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Consensi (Cartella Clinica)): element hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:title) &lt;= 1">(Consensi (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:text) &gt;= 1">(Consensi (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:text) &lt;= 1">(Consensi (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']
Item: (Consensi (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.865')">(Consensi (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.865'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Consensi (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="string(@code) = ('59284-0')">(Consensi (Cartella Clinica)): The value for code SHALL be '59284-0'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Consensi (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Consensi (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Consensi (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="string(@displayName) = ('Consent Document') or not(@displayName)">(Consensi (Cartella Clinica)): The value for displayName SHALL be 'Consent Document'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Consensi (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:title
Item: (Consensi (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:text
Item: (Consensi (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]
Item: (Consensi (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@value">(author (Cartella Clinica)_v1.0): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@root">(author (Cartella Clinica)_v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@extension">(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]
Item: (Consensi (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]">
      <extends rule="d18356e0-false-d18360e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Consensi (Cartella Clinica)): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Consensi (Cartella Clinica)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.866
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]
Item: (observationMedia (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d18356e0-false-d18360e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]) &gt;= 1">(observationMedia (Cartella Clinica)): element hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]) &lt;= 1">(observationMedia (Cartella Clinica)): element hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.866
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]
Item: (observationMedia (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(observationMedia (Cartella Clinica)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(observationMedia (Cartella Clinica)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']) &gt;= 1">(observationMedia (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']) &lt;= 1">(observationMedia (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:value) &gt;= 1">(observationMedia (Cartella Clinica)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:value) &lt;= 1">(observationMedia (Cartella Clinica)): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.866
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']
Item: (observationMedia (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.866')">(observationMedia (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.866'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.866
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/hl7:value
Item: (observationMedia (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/hl7:value">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s')))">(observationMedia (Cartella Clinica)): Attribute @xsi:type SHALL be of data type 'cs'  - '<value-of select="@xsi:type"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="not(@mediaType) or string-length(@mediaType)&gt;0">(observationMedia (Cartella Clinica)): Attribute @mediaType SHALL be of data type 'st'  - '<value-of select="@mediaType"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="not(@representation) or (string-length(@representation) &gt; 0 and not(matches(@representation,'\s')))">(observationMedia (Cartella Clinica)): Attribute @representation SHALL be of data type 'cs'  - '<value-of select="@representation"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]">
      <extends rule="d18459e0-false-d18463e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]
Item: (Richieste (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d18459e0-false-d18463e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]) &gt;= 1">(Richieste (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]) &lt;= 1">(Richieste (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]
Item: (Richieste (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']) &gt;= 1">(Richieste (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']) &lt;= 1">(Richieste (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Richieste (Cartella Clinica)): element hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Richieste (Cartella Clinica)): element hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:title) &lt;= 1">(Richieste (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:text) &gt;= 1">(Richieste (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:text) &lt;= 1">(Richieste (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']
Item: (Richieste (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.857')">(Richieste (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.857'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Richieste (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="string(@code) = ('11487-6')">(Richieste (Cartella Clinica)): The value for code SHALL be '11487-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Richieste (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Richieste (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Richieste (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="string(@displayName) = ('Consultation request (narrative)') or not(@displayName)">(Richieste (Cartella Clinica)): The value for displayName SHALL be 'Consultation request (narrative)'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Richieste (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:title
Item: (Richieste (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:text
Item: (Richieste (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]
Item: (Richieste (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@value">(author (Cartella Clinica)_v1.0): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@root">(author (Cartella Clinica)_v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@extension">(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]">
      <extends rule="d18938e0-false-d18942e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]
Item: (Diario clinico assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d18938e0-false-d18942e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]) &gt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]) &lt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]
Item: (Diario clinico assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']) &gt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']) &lt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:title) &lt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:text) &gt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:text) &lt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']
Item: (Diario clinico assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.849')">(Diario clinico assistenziale (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.849'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Diario clinico assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="string(@code) = ('11506-3')">(Diario clinico assistenziale (Cartella Clinica)): The value for code SHALL be '11506-3'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Diario clinico assistenziale (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Diario clinico assistenziale (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Diario clinico assistenziale (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="string(@displayName) = ('Progress note') or not(@displayName)">(Diario clinico assistenziale (Cartella Clinica)): The value for displayName SHALL be 'Progress note'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Diario clinico assistenziale (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:title
Item: (Diario clinico assistenziale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:text
Item: (Diario clinico assistenziale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]
Item: (Diario clinico assistenziale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@value">(author (Cartella Clinica)_v1.0): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@root">(author (Cartella Clinica)_v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@extension">(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]">
      <extends rule="d19420e0-false-d19424e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]
Item: (Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d19420e0-false-d19424e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]) &gt;= 1">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]) &lt;= 1">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]
Item: (Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']) &gt;= 1">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']) &lt;= 1">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:title) &lt;= 1">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:text) &gt;= 1">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:text) &lt;= 1">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']
Item: (Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.847')">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.847'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="string(@code) = ('108277-5')">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): The value for code SHALL be '108277-5'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="string(@displayName) = ('Implanted device note') or not(@displayName)">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): The value for displayName SHALL be 'Implanted device note'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:title
Item: (Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:text
Item: (Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]
Item: (Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@value">(author (Cartella Clinica)_v1.0): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@root">(author (Cartella Clinica)_v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@extension">(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]
Item: (Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]">
      <extends rule="d19912e0-false-d19916e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.866
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]
Item: (observationMedia (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d19912e0-false-d19916e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]) &gt;= 1">(observationMedia (Cartella Clinica)): element hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]) &lt;= 1">(observationMedia (Cartella Clinica)): element hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.866
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]
Item: (observationMedia (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(observationMedia (Cartella Clinica)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(observationMedia (Cartella Clinica)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']) &gt;= 1">(observationMedia (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']) &lt;= 1">(observationMedia (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:value) &gt;= 1">(observationMedia (Cartella Clinica)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:value) &lt;= 1">(observationMedia (Cartella Clinica)): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.866
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']
Item: (observationMedia (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.866')">(observationMedia (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.866'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.866
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/hl7:value
Item: (observationMedia (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/hl7:value">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s')))">(observationMedia (Cartella Clinica)): Attribute @xsi:type SHALL be of data type 'cs'  - '<value-of select="@xsi:type"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="not(@mediaType) or string-length(@mediaType)&gt;0">(observationMedia (Cartella Clinica)): Attribute @mediaType SHALL be of data type 'st'  - '<value-of select="@mediaType"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="not(@representation) or (string-length(@representation) &gt; 0 and not(matches(@representation,'\s')))">(observationMedia (Cartella Clinica)): Attribute @representation SHALL be of data type 'cs'  - '<value-of select="@representation"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]">
      <extends rule="d20015e0-false-d20019e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]
Item: (Lesioni e ferite (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d20015e0-false-d20019e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]) &gt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]) &lt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]
Item: (Lesioni e ferite (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']) &gt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']) &lt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:code[(@code = '46215-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:code[(@code = '46215-0' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:code[(@code = '46215-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:code[(@code = '46215-0' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:title) &lt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:text) &gt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:text) &lt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']
Item: (Lesioni e ferite (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.846')">(Lesioni e ferite (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.846'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:code[(@code = '46215-0' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Lesioni e ferite (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:code[(@code = '46215-0' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="string(@code) = ('46215-0')">(Lesioni e ferite (Cartella Clinica)): The value for code SHALL be '46215-0'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Lesioni e ferite (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Lesioni e ferite (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Lesioni e ferite (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="string(@displayName) = ('Wound care management Note') or not(@displayName)">(Lesioni e ferite (Cartella Clinica)): The value for displayName SHALL be 'Wound care management Note'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Lesioni e ferite (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:title
Item: (Lesioni e ferite (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:text
Item: (Lesioni e ferite (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]
Item: (Lesioni e ferite (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@value">(author (Cartella Clinica)_v1.0): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica)_v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@root">(author (Cartella Clinica)_v1.0): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="@extension">(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.898
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica)_v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &gt;= 1">(CDA person v1.0): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html"
              test="count(hl7:name) &lt;= 1">(CDA person v1.0): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.891
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name v1.0)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &gt;= 1">(CDA name v1.0): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:given) &lt;= 1">(CDA name v1.0): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &gt;= 1">(CDA name v1.0): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:family) &lt;= 1">(CDA name v1.0): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name v1.0): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name v1.0): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.893
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name v1.0)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]">
      <extends rule="d20494e0-false-d20498e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.845
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]
Item: (Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d20494e0-false-d20498e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]) &gt;= 1">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]) &lt;= 1">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.845
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]
Item: (Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']) &gt;= 1">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']) &lt;= 1">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="count(hl7:code[(@code = '51848-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): element hl7:code[(@code = '51848-0' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="count(hl7:code[(@code = '51848-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): element hl7:code[(@code = '51848-0' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="count(hl7:title) &lt;= 1">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="count(hl7:text) &gt;= 1">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="count(hl7:text) &lt;= 1">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.845
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']
Item: (Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.845')">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.845'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.845
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]/hl7:code[(@code = '51848-0' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]/hl7:code[(@code = '51848-0' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="string(@code) = ('51848-0')">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): The value for code SHALL be '51848-0'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="string(@displayName) = ('Evaluation note') or not(@displayName)">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): The value for displayName SHALL be 'Evaluation note'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.845-2025-11-06T150518.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.845
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]/hl7:title
Item: (Scale e altri strumenti di valutazione e monitoraggio (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.