<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.18.1
Name: Cartella Clinica
Description: Template CDA ClinicalDocument (prototype, contains ClinicalDocument.component as nonXMLBody)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017-closed">
   <title>Cartella Clinica</title>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/*[not(@xsi:nil = 'true')][not(self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']])]"
         id="d45e3-true-d26268e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e3-true-d26268e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']] (rule-reference: d45e3-true-d26268e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/*[not(@xsi:nil = 'true')][not(self::hl7:realmCode | self::hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] | self::hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0'] | self::hl7:id[not(@nullFlavor)] | self::hl7:code | self::hl7:title | self::sdtc:statusCode[@code = 'active'] | self::hl7:effectiveTime | self::hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] | self::hl7:languageCode | self::hl7:setId | self::hl7:versionNumber | self::hl7:recordTarget[hl7:patientRole] | self::hl7:author[hl7:assignedAuthor] | self::hl7:custodian[hl7:assignedCustodian] | self::hl7:legalAuthenticator[hl7:assignedEntity] | self::hl7:relatedDocument[@typeCode][hl7:parentDocument] | self::hl7:componentOf[hl7:encompassingEncounter] | self::hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']])]"
         id="d45e61-true-d27509e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e61-true-d27509e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:realmCode | hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] | hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0'] | hl7:id[not(@nullFlavor)] | hl7:code | hl7:title | sdtc:statusCode[@code = 'active'] | hl7:effectiveTime | hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] | hl7:languageCode | hl7:setId | hl7:versionNumber | hl7:recordTarget[hl7:patientRole] | hl7:author[hl7:assignedAuthor] | hl7:custodian[hl7:assignedCustodian] | hl7:legalAuthenticator[hl7:assignedEntity] | hl7:relatedDocument[@typeCode][hl7:parentDocument] | hl7:componentOf[hl7:encompassingEncounter] | hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']] (rule-reference: d45e61-true-d27509e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]/*[not(@xsi:nil = 'true')][not(self::hl7:translation)]"
         id="d45e144-true-d27546e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e144-true-d27546e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:translation (rule-reference: d45e144-true-d27546e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/*[not(@xsi:nil = 'true')][not(self::hl7:patientRole[hl7:patient])]"
         id="d27592e11-true-d27925e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e11-true-d27925e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:patientRole[hl7:patient] (rule-reference: d27592e11-true-d27925e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:addr | self::hl7:telecom | self::hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] | self::hl7:providerOrganization[@classCode = 'ORG'])]"
         id="d27592e38-true-d28286e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e38-true-d28286e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:addr | hl7:telecom | hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] | hl7:providerOrganization[@classCode = 'ORG'] (rule-reference: d27592e38-true-d28286e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d27592e138-true-d28338e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e138-true-d28338e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d27592e138-true-d28338e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/*[not(@xsi:nil = 'true')][not(self::hl7:name | self::hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] | self::hl7:birthTime | self::hl7:guardian | self::hl7:birthplace[hl7:place])]"
         id="d27592e226-true-d28625e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e226-true-d28625e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name | hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] | hl7:birthTime | hl7:guardian | hl7:birthplace[hl7:place] (rule-reference: d27592e226-true-d28625e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d27592e234-true-d28657e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e234-true-d28657e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d27592e234-true-d28657e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:addr | self::hl7:telecom | self::hl7:guardianPerson | self::hl7:guardianOrganization[@classCode = 'ORG'])]"
         id="d27592e301-true-d28828e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e301-true-d28828e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:addr | hl7:telecom | hl7:guardianPerson | hl7:guardianOrganization[@classCode = 'ORG'] (rule-reference: d27592e301-true-d28828e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d27592e316-true-d28885e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e316-true-d28885e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d27592e316-true-d28885e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d27592e319-true-d28960e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e319-true-d28960e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d27592e319-true-d28960e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d28930e8-true-d28992e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d28930e8-true-d28992e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d28930e8-true-d28992e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr | self::hl7:asOrganizationPartOf)]"
         id="d27592e327-true-d29166e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e327-true-d29166e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr | hl7:asOrganizationPartOf (rule-reference: d27592e327-true-d29166e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d29017e30-true-d29228e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d29017e30-true-d29228e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d29017e30-true-d29228e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:statusCode | self::hl7:effectiveTime | self::hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'])]"
         id="d29017e40-true-d29390e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d29017e40-true-d29390e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:statusCode | hl7:effectiveTime | hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] (rule-reference: d29017e40-true-d29390e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr | self::hl7:asOrganizationPartOf)]"
         id="d29268e41-true-d29564e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d29268e41-true-d29564e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr | hl7:asOrganizationPartOf (rule-reference: d29268e41-true-d29564e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d29415e38-true-d29626e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d29415e38-true-d29626e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d29415e38-true-d29626e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:statusCode | self::hl7:effectiveTime | self::hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'])]"
         id="d29415e48-true-d29788e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d29415e48-true-d29788e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:statusCode | hl7:effectiveTime | hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] (rule-reference: d29415e48-true-d29788e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/*[not(@xsi:nil = 'true')][not(self::hl7:place)]"
         id="d27592e333-true-d29921e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e333-true-d29921e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:place (rule-reference: d27592e333-true-d29921e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/*[not(@xsi:nil = 'true')][not(self::hl7:name | self::hl7:addr[hl7:country])]"
         id="d27592e366-true-d29982e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e366-true-d29982e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name | hl7:addr[hl7:country] (rule-reference: d27592e366-true-d29982e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d27592e369-true-d30014e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e369-true-d30014e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d27592e369-true-d30014e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:censusTract | self::hl7:postalCode)]"
         id="d27592e370-true-d30076e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e370-true-d30076e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:censusTract | hl7:postalCode (rule-reference: d27592e370-true-d30076e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr | self::hl7:asOrganizationPartOf)]"
         id="d27592e371-true-d30260e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d27592e371-true-d30260e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr | hl7:asOrganizationPartOf (rule-reference: d27592e371-true-d30260e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d30111e32-true-d30322e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d30111e32-true-d30322e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d30111e32-true-d30322e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:statusCode | self::hl7:effectiveTime | self::hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'])]"
         id="d30111e42-true-d30484e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d30111e42-true-d30484e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:statusCode | hl7:effectiveTime | hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] (rule-reference: d30111e42-true-d30484e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr | self::hl7:asOrganizationPartOf)]"
         id="d30362e41-true-d30658e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d30362e41-true-d30658e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr | hl7:asOrganizationPartOf (rule-reference: d30362e41-true-d30658e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d30509e38-true-d30720e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d30509e38-true-d30720e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d30509e38-true-d30720e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:statusCode | self::hl7:effectiveTime | self::hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'])]"
         id="d30509e48-true-d30882e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(.)">(CDA recordTarget (Cartella Clinica))/d30509e48-true-d30882e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:statusCode | hl7:effectiveTime | hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] (rule-reference: d30509e48-true-d30882e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor[hl7:id])]"
         id="d30963e11-true-d31124e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(.)">(CDA author (Cartella Clinica))/d30963e11-true-d31124e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor[hl7:id] (rule-reference: d30963e11-true-d31124e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:addr | self::hl7:telecom | self::hl7:assignedPerson | self::hl7:representedOrganization[@classCode = 'ORG'])]"
         id="d30963e29-true-d31307e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(.)">(CDA author (Cartella Clinica))/d30963e29-true-d31307e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:addr | hl7:telecom | hl7:assignedPerson | hl7:representedOrganization[@classCode = 'ORG'] (rule-reference: d30963e29-true-d31307e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d30963e49-true-d31359e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(.)">(CDA author (Cartella Clinica))/d30963e49-true-d31359e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d30963e49-true-d31359e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d30963e69-true-d31434e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(.)">(CDA author (Cartella Clinica))/d30963e69-true-d31434e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d30963e69-true-d31434e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d31404e13-true-d31466e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(.)">(CDA author (Cartella Clinica))/d31404e13-true-d31466e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d31404e13-true-d31466e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr | self::hl7:asOrganizationPartOf)]"
         id="d30963e82-true-d31640e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(.)">(CDA author (Cartella Clinica))/d30963e82-true-d31640e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr | hl7:asOrganizationPartOf (rule-reference: d30963e82-true-d31640e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d31491e30-true-d31702e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(.)">(CDA author (Cartella Clinica))/d31491e30-true-d31702e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d31491e30-true-d31702e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:statusCode | self::hl7:effectiveTime | self::hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'])]"
         id="d31491e40-true-d31864e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(.)">(CDA author (Cartella Clinica))/d31491e40-true-d31864e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:statusCode | hl7:effectiveTime | hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] (rule-reference: d31491e40-true-d31864e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr | self::hl7:asOrganizationPartOf)]"
         id="d31742e41-true-d32038e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(.)">(CDA author (Cartella Clinica))/d31742e41-true-d32038e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr | hl7:asOrganizationPartOf (rule-reference: d31742e41-true-d32038e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d31889e38-true-d32100e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(.)">(CDA author (Cartella Clinica))/d31889e38-true-d32100e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d31889e38-true-d32100e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:statusCode | self::hl7:effectiveTime | self::hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'])]"
         id="d31889e48-true-d32262e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(.)">(CDA author (Cartella Clinica))/d31889e48-true-d32262e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:statusCode | hl7:effectiveTime | hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] (rule-reference: d31889e48-true-d32262e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/*[not(@xsi:nil = 'true')][not(self::hl7:assignedCustodian[hl7:representedCustodianOrganization])]"
         id="d32343e9-true-d32409e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html"
              test="not(.)">(CDA custodian (Cartella Clinica))/d32343e9-true-d32409e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:assignedCustodian[hl7:representedCustodianOrganization] (rule-reference: d32343e9-true-d32409e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/*[not(@xsi:nil = 'true')][not(self::hl7:representedCustodianOrganization)]"
         id="d32343e16-true-d32471e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html"
              test="not(.)">(CDA custodian (Cartella Clinica))/d32343e16-true-d32471e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:representedCustodianOrganization (rule-reference: d32343e16-true-d32471e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr)]"
         id="d32414e9-true-d32530e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html"
              test="not(.)">(CDA custodian (Cartella Clinica))/d32414e9-true-d32530e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr (rule-reference: d32414e9-true-d32530e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d32476e46-true-d32592e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html"
              test="not(.)">(CDA custodian (Cartella Clinica))/d32476e46-true-d32592e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d32476e46-true-d32592e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:signatureCode | self::hl7:assignedEntity)]"
         id="d32631e11-true-d32800e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="not(.)">(CDA legalAuthenticator (Cartella Clinica))/d32631e11-true-d32800e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:signatureCode | hl7:assignedEntity (rule-reference: d32631e11-true-d32800e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:addr | self::hl7:telecom | self::hl7:assignedPerson | self::hl7:representedOrganization[@classCode = 'ORG'])]"
         id="d32631e52-true-d32996e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="not(.)">(CDA legalAuthenticator (Cartella Clinica))/d32631e52-true-d32996e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:addr | hl7:telecom | hl7:assignedPerson | hl7:representedOrganization[@classCode = 'ORG'] (rule-reference: d32631e52-true-d32996e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d32815e27-true-d33053e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="not(.)">(CDA legalAuthenticator (Cartella Clinica))/d32815e27-true-d33053e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d32815e27-true-d33053e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d32815e36-true-d33128e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="not(.)">(CDA legalAuthenticator (Cartella Clinica))/d32815e36-true-d33128e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d32815e36-true-d33128e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d33098e4-true-d33160e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="not(.)">(CDA legalAuthenticator (Cartella Clinica))/d33098e4-true-d33160e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d33098e4-true-d33160e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr | self::hl7:asOrganizationPartOf)]"
         id="d32815e40-true-d33334e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="not(.)">(CDA legalAuthenticator (Cartella Clinica))/d32815e40-true-d33334e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr | hl7:asOrganizationPartOf (rule-reference: d32815e40-true-d33334e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d33185e25-true-d33396e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="not(.)">(CDA legalAuthenticator (Cartella Clinica))/d33185e25-true-d33396e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d33185e25-true-d33396e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:statusCode | self::hl7:effectiveTime | self::hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'])]"
         id="d33185e35-true-d33558e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="not(.)">(CDA legalAuthenticator (Cartella Clinica))/d33185e35-true-d33558e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:statusCode | hl7:effectiveTime | hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] (rule-reference: d33185e35-true-d33558e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr | self::hl7:asOrganizationPartOf)]"
         id="d33436e41-true-d33732e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="not(.)">(CDA legalAuthenticator (Cartella Clinica))/d33436e41-true-d33732e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr | hl7:asOrganizationPartOf (rule-reference: d33436e41-true-d33732e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d33583e38-true-d33794e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="not(.)">(CDA legalAuthenticator (Cartella Clinica))/d33583e38-true-d33794e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d33583e38-true-d33794e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:statusCode | self::hl7:effectiveTime | self::hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'])]"
         id="d33583e48-true-d33956e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="not(.)">(CDA legalAuthenticator (Cartella Clinica))/d33583e48-true-d33956e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:statusCode | hl7:effectiveTime | hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] (rule-reference: d33583e48-true-d33956e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/*[not(@xsi:nil = 'true')][not(self::hl7:parentDocument)]"
         id="d34037e12-true-d34049e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(.)">(CDA relatedDocument (Cartella Clinica))/d34037e12-true-d34049e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:parentDocument (rule-reference: d34037e12-true-d34049e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:text | self::hl7:setId | self::hl7:versionNumber)]"
         id="d34037e51-true-d34083e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(.)">(CDA relatedDocument (Cartella Clinica))/d34037e51-true-d34083e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:text | hl7:setId | hl7:versionNumber (rule-reference: d34037e51-true-d34083e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/*[not(@xsi:nil = 'true')][not(self::hl7:encompassingEncounter[hl7:location])]"
         id="d34112e11-true-d34376e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d34112e11-true-d34376e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:encompassingEncounter[hl7:location] (rule-reference: d34112e11-true-d34376e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:effectiveTime | self::hl7:responsibleParty | self::hl7:location[hl7:healthCareFacility])]"
         id="d34112e16-true-d34663e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d34112e16-true-d34663e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:effectiveTime | hl7:responsibleParty | hl7:location[hl7:healthCareFacility] (rule-reference: d34112e16-true-d34663e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/*[not(@xsi:nil = 'true')][not(self::hl7:assignedEntity)]"
         id="d34112e56-true-d34842e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d34112e56-true-d34842e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:assignedEntity (rule-reference: d34112e56-true-d34842e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:addr | self::hl7:telecom | self::hl7:assignedPerson | self::hl7:representedOrganization[@classCode = 'ORG'])]"
         id="d34112e61-true-d35028e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d34112e61-true-d35028e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:addr | hl7:telecom | hl7:assignedPerson | hl7:representedOrganization[@classCode = 'ORG'] (rule-reference: d34112e61-true-d35028e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d34847e27-true-d35085e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d34847e27-true-d35085e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d34847e27-true-d35085e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d34847e36-true-d35160e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d34847e36-true-d35160e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d34847e36-true-d35160e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d35130e4-true-d35192e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d35130e4-true-d35192e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d35130e4-true-d35192e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr | self::hl7:asOrganizationPartOf)]"
         id="d34847e40-true-d35366e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d34847e40-true-d35366e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr | hl7:asOrganizationPartOf (rule-reference: d34847e40-true-d35366e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d35217e25-true-d35428e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d35217e25-true-d35428e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d35217e25-true-d35428e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:statusCode | self::hl7:effectiveTime | self::hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'])]"
         id="d35217e35-true-d35590e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d35217e35-true-d35590e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:statusCode | hl7:effectiveTime | hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] (rule-reference: d35217e35-true-d35590e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr | self::hl7:asOrganizationPartOf)]"
         id="d35468e41-true-d35764e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d35468e41-true-d35764e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr | hl7:asOrganizationPartOf (rule-reference: d35468e41-true-d35764e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d35615e38-true-d35826e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d35615e38-true-d35826e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d35615e38-true-d35826e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:statusCode | self::hl7:effectiveTime | self::hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'])]"
         id="d35615e48-true-d35988e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d35615e48-true-d35988e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:statusCode | hl7:effectiveTime | hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] (rule-reference: d35615e48-true-d35988e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/*[not(@xsi:nil = 'true')][not(self::hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']])]"
         id="d34112e62-true-d36186e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d34112e62-true-d36186e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']] (rule-reference: d34112e62-true-d36186e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/*[not(@xsi:nil = 'true')][not(self::hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6'] | self::hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] | self::hl7:location | self::hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']])]"
         id="d34112e76-true-d36331e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d34112e76-true-d36331e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6'] | hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] | hl7:location | hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']] (rule-reference: d34112e76-true-d36331e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/*[not(@xsi:nil = 'true')][not(self::hl7:name | self::hl7:addr)]"
         id="d34112e111-true-d36394e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d34112e111-true-d36394e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name | hl7:addr (rule-reference: d34112e111-true-d36394e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d36350e17-true-d36446e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d36350e17-true-d36446e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d36350e17-true-d36446e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/*[not(@xsi:nil = 'true')][not(self::hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2'] | self::hl7:name | self::hl7:telecom | self::hl7:addr | self::hl7:asOrganizationPartOf)]"
         id="d34112e117-true-d36566e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d34112e117-true-d36566e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2'] | hl7:name | hl7:telecom | hl7:addr | hl7:asOrganizationPartOf (rule-reference: d34112e117-true-d36566e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
         id="d36486e40-true-d36629e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d36486e40-true-d36629e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d36486e40-true-d36629e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:asOrganizationPartOf/*[not(@xsi:nil = 'true')][not(self::hl7:id[@root = '2.16.840.1.113883.2.9.4.1.1'] | self::hl7:code | self::hl7:statusCode | self::hl7:effectiveTime)]"
         id="d36486e46-true-d36698e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(.)">(CDA componentOf (Cartella Clinica))/d36486e46-true-d36698e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id[@root = '2.16.840.1.113883.2.9.4.1.1'] | hl7:code | hl7:statusCode | hl7:effectiveTime (rule-reference: d36486e46-true-d36698e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/*[not(@xsi:nil = 'true')][not(self::hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN'])]"
         id="d45e344-true-d37318e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e344-true-d37318e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN'] (rule-reference: d45e344-true-d37318e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/*[not(@xsi:nil = 'true')][not(self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]] | self::hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]])]"
         id="d45e347-true-d38066e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e347-true-d38066e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]] | hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]] (rule-reference: d45e347-true-d38066e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']])]"
         id="d45e350-true-d38095e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e350-true-d38095e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']] (rule-reference: d45e350-true-d38095e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848'] | self::hl7:id | self::hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] | self::hl7:title | self::hl7:text | self::hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.850']]])]"
         id="d38071e72-true-d38150e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38071e72-true-d38150e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848'] | hl7:id | hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] | hl7:title | hl7:text | hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.850']]] (rule-reference: d38071e72-true-d38150e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.850']]]/*[not(@xsi:nil = 'true')][not(self::hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.850']])]"
         id="d38071e174-true-d38197e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38071e174-true-d38197e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.850']] (rule-reference: d38071e174-true-d38197e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.850']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.850']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.850'] | self::hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:reference[@typeCode = 'REFR'][hl7:externalDocument])]"
         id="d38182e17-true-d38226e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38182e17-true-d38226e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.850'] | hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:reference[@typeCode = 'REFR'][hl7:externalDocument] (rule-reference: d38182e17-true-d38226e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.850']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.850']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/*[not(@xsi:nil = 'true')][not(self::hl7:externalDocument[hl7:id])]"
         id="d38182e27-true-d38252e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38182e27-true-d38252e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:externalDocument[hl7:id] (rule-reference: d38182e27-true-d38252e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.850']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.850']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[hl7:id]/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code)]"
         id="d38182e29-true-d38271e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38182e29-true-d38271e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code (rule-reference: d38182e29-true-d38271e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']])]"
         id="d45e422-true-d38334e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e422-true-d38334e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']] (rule-reference: d45e422-true-d38334e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851'] | self::hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d38286e38-true-d38406e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38286e38-true-d38406e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851'] | hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d38286e38-true-d38406e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d38286e80-true-d38472e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38286e80-true-d38472e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d38286e80-true-d38472e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d38445e1-true-d38518e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38445e1-true-d38518e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d38445e1-true-d38518e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d38445e26-true-d38569e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38445e26-true-d38569e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d38445e26-true-d38569e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d38445e61-true-d38609e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38445e61-true-d38609e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d38445e61-true-d38609e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d38579e18-true-d38641e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38579e18-true-d38641e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d38579e18-true-d38641e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']])]"
         id="d45e460-true-d38714e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e460-true-d38714e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']] (rule-reference: d45e460-true-d38714e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844'] | self::hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d38666e21-true-d38786e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38666e21-true-d38786e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844'] | hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d38666e21-true-d38786e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d38666e45-true-d38852e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38666e45-true-d38852e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d38666e45-true-d38852e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d38825e1-true-d38898e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38825e1-true-d38898e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d38825e1-true-d38898e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d38825e26-true-d38949e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38825e26-true-d38949e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d38825e26-true-d38949e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d38825e61-true-d38989e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38825e61-true-d38989e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d38825e61-true-d38989e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d38959e18-true-d39021e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d38959e18-true-d39021e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d38959e18-true-d39021e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']])]"
         id="d45e481-true-d39094e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e481-true-d39094e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']] (rule-reference: d45e481-true-d39094e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852'] | self::hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d39046e5-true-d39166e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39046e5-true-d39166e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852'] | hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d39046e5-true-d39166e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d39046e27-true-d39232e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39046e27-true-d39232e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d39046e27-true-d39232e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d39205e1-true-d39278e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39205e1-true-d39278e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d39205e1-true-d39278e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d39205e26-true-d39329e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39205e26-true-d39329e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d39205e26-true-d39329e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d39205e61-true-d39369e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39205e61-true-d39369e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d39205e61-true-d39369e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d39339e18-true-d39401e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39339e18-true-d39401e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d39339e18-true-d39401e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']])]"
         id="d45e486-true-d39474e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e486-true-d39474e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']] (rule-reference: d45e486-true-d39474e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853'] | self::hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d39426e44-true-d39546e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39426e44-true-d39546e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853'] | hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d39426e44-true-d39546e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d39426e105-true-d39612e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39426e105-true-d39612e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d39426e105-true-d39612e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d39585e1-true-d39658e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39585e1-true-d39658e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d39585e1-true-d39658e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d39585e26-true-d39709e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39585e26-true-d39709e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d39585e26-true-d39709e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d39585e61-true-d39749e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39585e61-true-d39749e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d39585e61-true-d39749e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d39719e18-true-d39781e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39719e18-true-d39781e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d39719e18-true-d39781e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']])]"
         id="d45e530-true-d39854e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e530-true-d39854e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']] (rule-reference: d45e530-true-d39854e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854'] | self::hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d39806e44-true-d39926e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39806e44-true-d39926e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854'] | hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d39806e44-true-d39926e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d39806e68-true-d39992e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39806e68-true-d39992e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d39806e68-true-d39992e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d39965e1-true-d40038e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39965e1-true-d40038e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d39965e1-true-d40038e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d39965e26-true-d40089e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39965e26-true-d40089e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d39965e26-true-d40089e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d39965e61-true-d40129e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d39965e61-true-d40129e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d39965e61-true-d40129e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d40099e18-true-d40161e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40099e18-true-d40161e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d40099e18-true-d40161e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]])]"
         id="d45e574-true-d40234e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e574-true-d40234e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]] (rule-reference: d45e574-true-d40234e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId | self::hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d40186e5-true-d40304e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40186e5-true-d40304e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId | hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d40186e5-true-d40304e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d40186e29-true-d40369e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40186e29-true-d40369e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d40186e29-true-d40369e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d40342e1-true-d40415e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40342e1-true-d40415e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d40342e1-true-d40415e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d40342e26-true-d40466e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40342e26-true-d40466e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d40342e26-true-d40466e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d40342e61-true-d40506e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40342e61-true-d40506e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d40342e61-true-d40506e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d40476e18-true-d40538e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40476e18-true-d40538e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d40476e18-true-d40538e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']])]"
         id="d45e579-true-d40611e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e579-true-d40611e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']] (rule-reference: d45e579-true-d40611e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856'] | self::hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d40563e5-true-d40683e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40563e5-true-d40683e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856'] | hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d40563e5-true-d40683e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d40563e29-true-d40749e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40563e29-true-d40749e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d40563e29-true-d40749e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d40722e1-true-d40795e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40722e1-true-d40795e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d40722e1-true-d40795e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d40722e26-true-d40846e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40722e26-true-d40846e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d40722e26-true-d40846e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d40722e61-true-d40886e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40722e61-true-d40886e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d40722e61-true-d40886e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d40856e18-true-d40918e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40856e18-true-d40918e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d40856e18-true-d40918e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']])]"
         id="d45e584-true-d41000e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e584-true-d41000e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']] (rule-reference: d45e584-true-d41000e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865'] | self::hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author] | self::hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]])]"
         id="d40943e34-true-d41088e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40943e34-true-d41088e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865'] | hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] | hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]] (rule-reference: d40943e34-true-d41088e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d40943e58-true-d41154e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40943e58-true-d41154e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d40943e58-true-d41154e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d41127e1-true-d41200e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41127e1-true-d41200e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d41127e1-true-d41200e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d41127e26-true-d41251e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41127e26-true-d41251e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d41127e26-true-d41251e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d41127e61-true-d41291e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41127e61-true-d41291e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d41127e61-true-d41291e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d41261e18-true-d41323e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41261e18-true-d41323e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d41261e18-true-d41323e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/*[not(@xsi:nil = 'true')][not(self::hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']])]"
         id="d40943e59-true-d41363e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d40943e59-true-d41363e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']] (rule-reference: d40943e59-true-d41363e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | self::hl7:value)]"
         id="d41348e6-true-d41385e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41348e6-true-d41385e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | hl7:value (rule-reference: d41348e6-true-d41385e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']])]"
         id="d45e619-true-d41449e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e619-true-d41449e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']] (rule-reference: d45e619-true-d41449e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857'] | self::hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d41401e5-true-d41521e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41401e5-true-d41521e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857'] | hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d41401e5-true-d41521e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d41401e29-true-d41587e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41401e29-true-d41587e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d41401e29-true-d41587e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d41560e1-true-d41633e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41560e1-true-d41633e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d41560e1-true-d41633e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d41560e26-true-d41684e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41560e26-true-d41684e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d41560e26-true-d41684e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d41560e61-true-d41724e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41560e61-true-d41724e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d41560e61-true-d41724e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d41694e18-true-d41756e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41694e18-true-d41756e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d41694e18-true-d41756e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']])]"
         id="d45e624-true-d41829e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e624-true-d41829e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']] (rule-reference: d45e624-true-d41829e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849'] | self::hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d41781e8-true-d41901e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41781e8-true-d41901e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849'] | hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d41781e8-true-d41901e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d41781e33-true-d41967e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41781e33-true-d41967e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d41781e33-true-d41967e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d41940e1-true-d42013e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41940e1-true-d42013e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d41940e1-true-d42013e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d41940e26-true-d42064e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41940e26-true-d42064e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d41940e26-true-d42064e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d41940e61-true-d42104e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d41940e61-true-d42104e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d41940e61-true-d42104e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d42074e18-true-d42136e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42074e18-true-d42136e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d42074e18-true-d42136e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']])]"
         id="d45e632-true-d42218e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e632-true-d42218e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']] (rule-reference: d45e632-true-d42218e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847'] | self::hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author] | self::hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]])]"
         id="d42161e32-true-d42306e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42161e32-true-d42306e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847'] | hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] | hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]] (rule-reference: d42161e32-true-d42306e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d42161e54-true-d42372e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42161e54-true-d42372e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d42161e54-true-d42372e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d42345e1-true-d42418e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42345e1-true-d42418e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d42345e1-true-d42418e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d42345e26-true-d42469e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42345e26-true-d42469e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d42345e26-true-d42469e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d42345e61-true-d42509e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42345e61-true-d42509e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d42345e61-true-d42509e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d42479e18-true-d42541e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42479e18-true-d42541e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d42479e18-true-d42541e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/*[not(@xsi:nil = 'true')][not(self::hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']])]"
         id="d42161e55-true-d42581e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42161e55-true-d42581e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']] (rule-reference: d42161e55-true-d42581e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | self::hl7:value)]"
         id="d42566e6-true-d42603e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42566e6-true-d42603e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | hl7:value (rule-reference: d42566e6-true-d42603e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']])]"
         id="d45e664-true-d42667e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e664-true-d42667e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']] (rule-reference: d45e664-true-d42667e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846'] | self::hl7:code[(@code = '46215-0' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d42619e5-true-d42739e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42619e5-true-d42739e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846'] | hl7:code[(@code = '46215-0' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d42619e5-true-d42739e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d42619e29-true-d42805e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42619e29-true-d42805e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d42619e29-true-d42805e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d42778e1-true-d42851e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42778e1-true-d42851e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d42778e1-true-d42851e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d42778e26-true-d42902e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42778e26-true-d42902e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d42778e26-true-d42902e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d42778e61-true-d42942e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42778e61-true-d42942e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d42778e61-true-d42942e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d42912e18-true-d42974e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42912e18-true-d42974e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d42912e18-true-d42974e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']])]"
         id="d45e669-true-d43047e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e669-true-d43047e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']] (rule-reference: d45e669-true-d43047e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845'] | self::hl7:code[(@code = '51848-0' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d42999e8-true-d43119e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42999e8-true-d43119e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845'] | hl7:code[(@code = '51848-0' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d42999e8-true-d43119e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d42999e33-true-d43185e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d42999e33-true-d43185e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d42999e33-true-d43185e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d43158e1-true-d43231e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43158e1-true-d43231e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d43158e1-true-d43231e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d43158e26-true-d43282e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43158e26-true-d43282e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d43158e26-true-d43282e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d43158e61-true-d43322e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43158e61-true-d43322e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d43158e61-true-d43322e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d43292e18-true-d43354e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43292e18-true-d43354e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d43292e18-true-d43354e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']])]"
         id="d45e677-true-d43436e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e677-true-d43436e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']] (rule-reference: d45e677-true-d43436e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843'] | self::hl7:code[(@code = '70007-0' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author] | self::hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]])]"
         id="d43379e5-true-d43524e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43379e5-true-d43524e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843'] | hl7:code[(@code = '70007-0' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] | hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]] (rule-reference: d43379e5-true-d43524e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d43379e32-true-d43590e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43379e32-true-d43590e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d43379e32-true-d43590e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d43563e1-true-d43636e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43563e1-true-d43636e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d43563e1-true-d43636e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d43563e26-true-d43687e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43563e26-true-d43687e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d43563e26-true-d43687e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d43563e61-true-d43727e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43563e61-true-d43727e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d43563e61-true-d43727e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d43697e18-true-d43759e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43697e18-true-d43759e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d43697e18-true-d43759e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/*[not(@xsi:nil = 'true')][not(self::hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']])]"
         id="d43379e33-true-d43799e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43379e33-true-d43799e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']] (rule-reference: d43379e33-true-d43799e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | self::hl7:value)]"
         id="d43784e6-true-d43821e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43784e6-true-d43821e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | hl7:value (rule-reference: d43784e6-true-d43821e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']])]"
         id="d45e682-true-d43885e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e682-true-d43885e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']] (rule-reference: d45e682-true-d43885e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842'] | self::hl7:code[(@code = '80754-5' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d43837e8-true-d43957e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43837e8-true-d43957e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842'] | hl7:code[(@code = '80754-5' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d43837e8-true-d43957e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d43837e33-true-d44023e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43837e33-true-d44023e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d43837e33-true-d44023e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d43996e1-true-d44069e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43996e1-true-d44069e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d43996e1-true-d44069e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d43996e26-true-d44120e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43996e26-true-d44120e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d43996e26-true-d44120e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d43996e61-true-d44160e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d43996e61-true-d44160e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d43996e61-true-d44160e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d44130e18-true-d44192e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44130e18-true-d44192e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d44130e18-true-d44192e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']])]"
         id="d45e690-true-d44274e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e690-true-d44274e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']] (rule-reference: d45e690-true-d44274e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841'] | self::hl7:code[(@code = '34750-0' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author] | self::hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]])]"
         id="d44217e5-true-d44362e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44217e5-true-d44362e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841'] | hl7:code[(@code = '34750-0' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] | hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]] (rule-reference: d44217e5-true-d44362e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d44217e27-true-d44428e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44217e27-true-d44428e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d44217e27-true-d44428e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d44401e1-true-d44474e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44401e1-true-d44474e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d44401e1-true-d44474e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d44401e26-true-d44525e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44401e26-true-d44525e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d44401e26-true-d44525e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d44401e61-true-d44565e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44401e61-true-d44565e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d44401e61-true-d44565e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d44535e18-true-d44597e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44535e18-true-d44597e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d44535e18-true-d44597e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/*[not(@xsi:nil = 'true')][not(self::hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']])]"
         id="d44217e28-true-d44637e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44217e28-true-d44637e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']] (rule-reference: d44217e28-true-d44637e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | self::hl7:value)]"
         id="d44622e6-true-d44659e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44622e6-true-d44659e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | hl7:value (rule-reference: d44622e6-true-d44659e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']])]"
         id="d45e695-true-d44732e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e695-true-d44732e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']] (rule-reference: d45e695-true-d44732e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864'] | self::hl7:code[(@code = '34848-2' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author] | self::hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]])]"
         id="d44675e5-true-d44820e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44675e5-true-d44820e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864'] | hl7:code[(@code = '34848-2' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] | hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]] (rule-reference: d44675e5-true-d44820e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d44675e28-true-d44886e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44675e28-true-d44886e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d44675e28-true-d44886e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d44859e1-true-d44932e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44859e1-true-d44932e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d44859e1-true-d44932e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d44859e26-true-d44983e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44859e26-true-d44983e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d44859e26-true-d44983e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d44859e61-true-d45023e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44859e61-true-d45023e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d44859e61-true-d45023e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d44993e18-true-d45055e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44993e18-true-d45055e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d44993e18-true-d45055e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/*[not(@xsi:nil = 'true')][not(self::hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']])]"
         id="d44675e29-true-d45095e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d44675e29-true-d45095e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']] (rule-reference: d44675e29-true-d45095e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | self::hl7:value)]"
         id="d45080e6-true-d45117e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45080e6-true-d45117e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | hl7:value (rule-reference: d45080e6-true-d45117e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']])]"
         id="d45e700-true-d45190e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e700-true-d45190e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']] (rule-reference: d45e700-true-d45190e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863'] | self::hl7:code[(@code = '15508-5' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author] | self::hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]])]"
         id="d45133e5-true-d45278e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45133e5-true-d45278e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863'] | hl7:code[(@code = '15508-5' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] | hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]] (rule-reference: d45133e5-true-d45278e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d45133e28-true-d45344e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45133e28-true-d45344e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d45133e28-true-d45344e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d45317e1-true-d45390e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45317e1-true-d45390e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d45317e1-true-d45390e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d45317e26-true-d45441e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45317e26-true-d45441e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d45317e26-true-d45441e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d45317e61-true-d45481e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45317e61-true-d45481e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d45317e61-true-d45481e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d45451e18-true-d45513e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45451e18-true-d45513e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d45451e18-true-d45513e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/*[not(@xsi:nil = 'true')][not(self::hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']])]"
         id="d45133e29-true-d45553e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45133e29-true-d45553e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']] (rule-reference: d45133e29-true-d45553e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | self::hl7:value)]"
         id="d45538e6-true-d45575e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45538e6-true-d45575e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | hl7:value (rule-reference: d45538e6-true-d45575e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']])]"
         id="d45e705-true-d45639e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e705-true-d45639e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']] (rule-reference: d45e705-true-d45639e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862'] | self::hl7:code[(@code = '104920-4' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d45591e5-true-d45711e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45591e5-true-d45711e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862'] | hl7:code[(@code = '104920-4' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d45591e5-true-d45711e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d45591e28-true-d45777e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45591e28-true-d45777e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d45591e28-true-d45777e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d45750e1-true-d45823e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45750e1-true-d45823e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d45750e1-true-d45823e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d45750e26-true-d45874e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45750e26-true-d45874e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d45750e26-true-d45874e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d45750e61-true-d45914e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45750e61-true-d45914e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d45750e61-true-d45914e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d45884e18-true-d45946e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45884e18-true-d45946e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d45884e18-true-d45946e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']])]"
         id="d45e711-true-d46019e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e711-true-d46019e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']] (rule-reference: d45e711-true-d46019e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861'] | self::hl7:code[(@code = '8650-4' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author])]"
         id="d45971e5-true-d46091e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45971e5-true-d46091e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861'] | hl7:code[(@code = '8650-4' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] (rule-reference: d45971e5-true-d46091e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d45971e30-true-d46157e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45971e30-true-d46157e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d45971e30-true-d46157e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d46130e1-true-d46203e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d46130e1-true-d46203e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d46130e1-true-d46203e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d46130e26-true-d46254e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d46130e26-true-d46254e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d46130e26-true-d46254e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d46130e61-true-d46294e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d46130e61-true-d46294e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d46130e61-true-d46294e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d46264e18-true-d46326e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d46264e18-true-d46326e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d46264e18-true-d46326e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']])]"
         id="d45e716-true-d46408e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d45e716-true-d46408e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']] (rule-reference: d45e716-true-d46408e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860'] | self::hl7:code[(@code = '68674-1' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:author[hl7:author] | self::hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]])]"
         id="d46351e5-true-d46496e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d46351e5-true-d46496e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860'] | hl7:code[(@code = '68674-1' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:author[hl7:author] | hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]] (rule-reference: d46351e5-true-d46496e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]/hl7:author[hl7:author]/*[not(@xsi:nil = 'true')][not(self::hl7:author[hl7:assignedAuthor])]"
         id="d46351e33-true-d46562e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d46351e33-true-d46562e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:author[hl7:assignedAuthor] (rule-reference: d46351e33-true-d46562e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
         id="d46535e1-true-d46608e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d46535e1-true-d46608e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d46535e1-true-d46608e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
         id="d46535e26-true-d46659e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d46535e26-true-d46659e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d46535e26-true-d46659e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
         id="d46535e61-true-d46699e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d46535e61-true-d46699e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d46535e61-true-d46699e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family | self::hl7:prefix | self::hl7:suffix)]"
         id="d46669e18-true-d46731e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d46669e18-true-d46731e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family | hl7:prefix | hl7:suffix (rule-reference: d46669e18-true-d46731e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/*[not(@xsi:nil = 'true')][not(self::hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']])]"
         id="d46351e34-true-d46771e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d46351e34-true-d46771e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']] (rule-reference: d46351e34-true-d46771e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule fpi="RUL-QQQ"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | self::hl7:value)]"
         id="d46756e6-true-d46793e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(.)">(Cartella Clinica)/d46756e6-true-d46793e0: '<value-of select="name(..)"/>' is defined as closed, and this element '<name/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] | hl7:value (rule-reference: d46756e6-true-d46793e0)</assert>
   </rule>
</pattern>
