<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:hl7="urn:hl7-org:v3"
                xmlns:cda="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:sdtc="urn:hl7-org:sdtc"
                xmlns:pharm="urn:ihe:pharm:medication"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
   <xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


   <!--PROLOG-->
   <xsl:output method="text"/>

   <!--XSD TYPES FOR XSLT2-->


   <!--KEYS AND FUNCTIONS-->


   <!--DEFAULT RULES-->


   <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
   <!--This mode can be used to generate prefixed XPath for humans-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
   <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
   <xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
   <xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters-->
   <xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
   <xsl:template match="/">
      <xsl:apply-templates select="/" mode="M9"/>
      <xsl:apply-templates select="/" mode="M10"/>
      <xsl:apply-templates select="/" mode="M11"/>
      <xsl:apply-templates select="/" mode="M12"/>
      <xsl:apply-templates select="/" mode="M17"/>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->
   <xsl:param name="scenariolabel" select="'2.16.840.1.113883.3.1937.777.63.4.58'"/>

   <!--PATTERN -->
   <xsl:template match="text()" priority="-1" mode="M9"/>
   <xsl:template match="@*|node()" priority="-2" mode="M9">
      <xsl:apply-templates select="*" mode="M9"/>
   </xsl:template>

   <!--PATTERN CartellaClinica-->


	  <!--RULE -->
   <xsl:template match="/" priority="1000" mode="M10">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']] (descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M10"/>
   <xsl:template match="@*|node()" priority="-2" mode="M10">
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017Cartella Clinica-->


	  <!--RULE d45e61-false-d1133e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]"
                 priority="1464"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('DOCCLIN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:realmCode) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:realmCode is required [min 1x]. (count(hl7:realmCode) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] is required [min 1x]. (count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] appears too often [max 1x]. (count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0'] is mandatory [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[not(@nullFlavor)]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:id[not(@nullFlavor)] is mandatory [min 1x]. (count(hl7:id[not(@nullFlavor)]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[not(@nullFlavor)]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:id[not(@nullFlavor)] appears too often [max 1x]. (count(hl7:id[not(@nullFlavor)]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="count(hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt; 1">
         <xsl:message>(Cartella Clinica): element hl7:code is coded with binding strength 'extensible' and contains a code other than the specified set. (count(hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt; 1 / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(sdtc:statusCode[@code = 'active']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element sdtc:statusCode[@code = 'active'] appears too often [max 1x]. (count(sdtc:statusCode[@code = 'active']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:effectiveTime is required [min 1x]. (count(hl7:effectiveTime) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] is required [min 1x]. (count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] appears too often [max 1x]. (count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:languageCode is required [min 1x]. (count(hl7:languageCode) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:languageCode appears too often [max 1x]. (count(hl7:languageCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:setId is required [min 1x]. (count(hl7:setId) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:setId appears too often [max 1x]. (count(hl7:setId) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:versionNumber is required [min 1x]. (count(hl7:versionNumber) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:versionNumber appears too often [max 1x]. (count(hl7:versionNumber) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:recordTarget[hl7:patientRole] is required [min 1x]. (count(hl7:recordTarget[hl7:patientRole]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:recordTarget[hl7:patientRole] appears too often [max 1x]. (count(hl7:recordTarget[hl7:patientRole]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:author[hl7:assignedAuthor] is required [min 1x]. (count(hl7:author[hl7:assignedAuthor]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:custodian[hl7:assignedCustodian] is required [min 1x]. (count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x]. (count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:legalAuthenticator[hl7:assignedEntity]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:legalAuthenticator[hl7:assignedEntity] is required [min 1x]. (count(hl7:legalAuthenticator[hl7:assignedEntity]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:legalAuthenticator[hl7:assignedEntity]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:legalAuthenticator[hl7:assignedEntity] appears too often [max 1x]. (count(hl7:legalAuthenticator[hl7:assignedEntity]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x]. (count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:componentOf[hl7:encompassingEncounter]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:componentOf[hl7:encompassingEncounter] is required [min 1x]. (count(hl7:componentOf[hl7:encompassingEncounter]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:componentOf[hl7:encompassingEncounter]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:componentOf[hl7:encompassingEncounter] appears too often [max 1x]. (count(hl7:componentOf[hl7:encompassingEncounter]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']] is required [min 1x]. (count(hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']] appears too often [max 1x]. (count(hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e74-false-d1849e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']"
                 priority="1463"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.1.3')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.1.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('POCD_MT000040UV02')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>" (string(@extension) = ('POCD_MT000040UV02') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e94-false-d1868e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']"
                 priority="1462"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.18 .1')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.18 .1'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.18 .1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('1.0')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for extension SHALL be '1.0'. Found: "<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>" (string(@extension) = ('1.0') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e113-false-d1887e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:id[not(@nullFlavor)]"
                 priority="1461"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e144-false-d1909e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1460"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('100971-1')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for code SHALL be '100971-1'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('100971-1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Cartella clinica') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for displayName SHALL be 'Cartella clinica'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Cartella clinica') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e159-false-d1940e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation"
                 priority="1459"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @codeSystem SHALL be of data type 'oid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e180-false-d1973e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/sdtc:statusCode[@code = 'active']"
                 priority="1458"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('active')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for code SHALL be 'active'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('active') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e202-false-d1984e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:effectiveTime"
                 priority="1457"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e213-false-d1998e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']"
                 priority="1456"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (@code='N') or (@code='V')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The element value SHALL be one of 'code 'N' or code 'V''. (@nullFlavor or (@code='N') or (@code='V') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.25')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for codeSystem SHALL be '2.16.840.1.113883.5.25'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.5.25') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for codeSystemName SHALL be 'HL7 Confidentiality'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e256-false-d2031e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:languageCode"
                 priority="1455"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e267-false-d2044e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:setId"
                 priority="1454"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e315-false-d2065e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:versionNumber"
                 priority="1453"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2070e17-false-d2184e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]"
                 priority="1452"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('RCT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): The value for typeCode SHALL be 'RCT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('RCT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[hl7:patient]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:patientRole[hl7:patient] is required [min 1x]. (count(hl7:patientRole[hl7:patient]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[hl7:patient]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:patientRole[hl7:patient] appears too often [max 1x]. (count(hl7:patientRole[hl7:patient]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2070e44-false-d2422e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]"
                 priority="1451"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PAT') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'PAT'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PAT') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x]. (count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x]. (count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:providerOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2070e51-false-d2573e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id"
                 priority="1450"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr"
                 priority="1449"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2070e210-false-d2740e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom"
                 priority="1447"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2070e232-false-d2834e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
                 priority="1446"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PSN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x]. (count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x]. (count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:birthTime is required [min 1x]. (count(hl7:birthTime) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:birthTime appears too often [max 1x]. (count(hl7:birthTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthplace[hl7:place]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:birthplace[hl7:place] appears too often [max 1x]. (count(hl7:birthplace[hl7:place]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name"
                 priority="1445"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2070e252-false-d3047e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
                 priority="1444"
                 mode="M11">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2070e307-false-d3127e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian"
                 priority="1443"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardianPerson | hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): choice (hl7:guardianPerson  or  hl7:guardianOrganization[@classCode = 'ORG']) contains too many elements [max 1x] (count(hl7:guardianPerson | hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardianPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:guardianPerson appears too often [max 1x]. (count(hl7:guardianPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:guardianOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2070e313-false-d3262e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id"
                 priority="1442"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2070e317-false-d3280e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code"
                 priority="1441"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr"
                 priority="1440"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson"
                 priority="1439"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PSN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name"
                 priority="1437"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']"
                 priority="1436"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1435"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1434"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1433"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1431"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1429"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1428"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1427"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1425"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1424"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1423"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1421"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1419"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1418"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1417"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2070e339-false-d4724e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]"
                 priority="1416"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('BIRTHPL') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'BIRTHPL'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('BIRTHPL') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:place is required [min 1x]. (count(hl7:place) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:place appears too often [max 1x]. (count(hl7:place) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2070e372-false-d4772e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place"
                 priority="1415"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PLC') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'PLC'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PLC') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr[hl7:country]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): element hl7:addr[hl7:country] appears too often [max 1x]. (count(hl7:addr[hl7:country]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name"
                 priority="1414"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]"
                 priority="1413"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (Cartella Clinica)): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (Cartella Clinica)): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (Cartella Clinica)): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (Cartella Clinica)): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (Cartella Clinica)): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (Cartella Clinica)): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (Cartella Clinica)): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']"
                 priority="1412"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): Attribute @classCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>' (not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (Cartella Clinica)): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1410"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1409"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1408"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1406"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1404"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1403"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1402"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1400"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1399"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1398"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1396"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1394"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1393"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1392"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d5049e408-false-d6194e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]"
                 priority="1391"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor[hl7:id]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): element hl7:assignedAuthor[hl7:id] is required [min 1x]. (count(hl7:assignedAuthor[hl7:id]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor[hl7:id]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): element hl7:assignedAuthor[hl7:id] appears too often [max 1x]. (count(hl7:assignedAuthor[hl7:id]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d5049e426-false-d6330e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]"
                 priority="1390"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d5049e430-false-d6412e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:id"
                 priority="1389"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr"
                 priority="1388"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d5049e449-false-d6577e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:telecom"
                 priority="1386"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson"
                 priority="1385"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PSN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name"
                 priority="1383"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1382"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1381"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1380"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1379"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1377"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1375"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1374"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1373"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1371"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1370"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1369"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1367"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1365"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1364"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1363"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d6781e393-false-d7890e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]"
                 priority="1362"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('CST') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian (Cartella Clinica)): The value for typeCode SHALL be 'CST'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('CST') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian (Cartella Clinica)): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x]. (count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian (Cartella Clinica)): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x]. (count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]"
                 priority="1361"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedCustodian v1.0): element hl7:representedCustodianOrganization is required [min 1x]. (count(hl7:representedCustodianOrganization) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.895-2025-12-18T112920.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedCustodian v1.0): element hl7:representedCustodianOrganization appears too often [max 1x]. (count(hl7:representedCustodianOrganization) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.895-2025-12-18T112920.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian (Cartella Clinica)): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization"
                 priority="1359"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id"
                 priority="1358"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom"
                 priority="1357"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr"
                 priority="1356"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.896-2025-12-18T113140.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d7949e141-false-d8332e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]"
                 priority="1354"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('LA') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator (Cartella Clinica)): The value for typeCode SHALL be 'LA'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('LA') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator (Cartella Clinica)): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator (Cartella Clinica)): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator (Cartella Clinica)): element hl7:signatureCode is required [min 1x]. (count(hl7:signatureCode) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator (Cartella Clinica)): element hl7:signatureCode appears too often [max 1x]. (count(hl7:signatureCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator (Cartella Clinica)): element hl7:assignedEntity is required [min 1x]. (count(hl7:assignedEntity) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator (Cartella Clinica)): element hl7:assignedEntity appears too often [max 1x]. (count(hl7:assignedEntity) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d7949e171-false-d8429e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:signatureCode"
                 priority="1353"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator (Cartella Clinica)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity"
                 priority="1352"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): element hl7:telecom appears too often [max 1x]. (count(hl7:telecom) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:id"
                 priority="1351"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:code"
                 priority="1350"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr"
                 priority="1349"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom"
                 priority="1347"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1346"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1345"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1344"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1343"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1342"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1341"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1339"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1337"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1336"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1335"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1333"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1332"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1331"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1329"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1327"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1326"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1325"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d8494e564-false-d10135e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
                 priority="1324"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@typeCode"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): attribute @typeCode SHALL be present. (@typeCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC). (not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:parentDocument) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): element hl7:parentDocument is required [min 1x]. (count(hl7:parentDocument) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:parentDocument) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): element hl7:parentDocument appears too often [max 1x]. (count(hl7:parentDocument) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d8494e603-false-d10166e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
                 priority="1323"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('DOCCLIN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): element hl7:setId appears too often [max 1x]. (count(hl7:setId) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): element hl7:versionNumber appears too often [max 1x]. (count(hl7:versionNumber) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d8494e626-false-d10212e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
                 priority="1322"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d8494e635-false-d10233e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
                 priority="1321"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): Attribute @codeSystem SHALL be of data type 'oid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d8494e641-false-d10265e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:setId"
                 priority="1320"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d8494e650-false-d10286e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:versionNumber"
                 priority="1319"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument (Cartella Clinica)): Attribute @value is not a valid int number <xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>
       (not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d10291e18-false-d10382e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]"
                 priority="1318"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encompassingEncounter[hl7:location]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:encompassingEncounter[hl7:location] is required [min 1x]. (count(hl7:encompassingEncounter[hl7:location]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encompassingEncounter[hl7:location]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:encompassingEncounter[hl7:location] appears too often [max 1x]. (count(hl7:encompassingEncounter[hl7:location]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d10291e23-false-d10570e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]"
                 priority="1317"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ENC') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): The value for classCode SHALL be 'ENC'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ENC') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x]. (count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:effectiveTime is required [min 1x]. (count(hl7:effectiveTime) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:responsibleParty) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:responsibleParty appears too often [max 1x]. (count(hl7:responsibleParty) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:location[hl7:healthCareFacility]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:location[hl7:healthCareFacility] is required [min 1x]. (count(hl7:location[hl7:healthCareFacility]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:location[hl7:healthCareFacility]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:location[hl7:healthCareFacility] appears too often [max 1x]. (count(hl7:location[hl7:healthCareFacility]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d10291e26-false-d10709e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:id"
                 priority="1316"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d10291e37-false-d10733e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
                 priority="1315"
                 mode="M11">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.1 ActEncounterCode (DYNAMIC)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d10291e63-false-d10823e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty"
                 priority="1314"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('RESP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): The value for typeCode SHALL be 'RESP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('RESP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:assignedEntity appears too often [max 1x]. (count(hl7:assignedEntity) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity"
                 priority="1313"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): element hl7:telecom appears too often [max 1x]. (count(hl7:telecom) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:id"
                 priority="1312"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:code"
                 priority="1311"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:addr"
                 priority="1310"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:telecom"
                 priority="1308"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.894-2025-12-18T112333.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1307"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1306"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1305"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1304"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1303"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1302"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1300"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1298"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1297"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1296"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1294"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1293"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1292"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1290"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization v1.0): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.890-2025-12-18T111429.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1288"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1287"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1286"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf v1.0): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.897-2025-12-18T115337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d10291e69-false-d12619e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]"
                 priority="1285"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('LOC') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): The value for typeCode SHALL be 'LOC'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('LOC') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']] is required [min 1x]. (count(hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']] appears too often [max 1x]. (count(hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d10291e83-false-d12711e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]"
                 priority="1284"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('SDLOC') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): The value for classCode SHALL be 'SDLOC'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('SDLOC') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6'] is required [min 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x]. (count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:location) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:location appears too often [max 1x]. (count(hl7:location) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']] is required [min 1x]. (count(hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): element hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']] appears too often [max 1x]. (count(hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d10291e88-false-d12790e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']"
                 priority="1283"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.4.1.6')"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.2.9.4.1.6'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.4.1.6') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d10291e105-false-d12813e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
                 priority="1282"
                 mode="M11">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): The element value SHALL be one of '2.16.840.1.113883.1.11.17660 ServiceDeliveryLocationRoleType (DYNAMIC)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location"
                 priority="1281"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA place (Cartella Clinica)): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.889-2025-12-17T114241.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA place (Cartella Clinica)): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.889-2025-12-17T114241.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PLC') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): The value for classCode SHALL be 'PLC'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PLC') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:location/hl7:addr"
                 priority="1279"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA place (Cartella Clinica)): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.889-2025-12-17T114241.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA place (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.889-2025-12-17T114241.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]"
                 priority="1277"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): element hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2'] is required [min 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): element hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2'] appears too often [max 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']"
                 priority="1276"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.4.1.2')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.2.9.4.1.2'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.4.1.2') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:telecom"
                 priority="1275"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:addr"
                 priority="1274"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr v1.0): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.892-2025-12-18T111745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:asOrganizationPartOf"
                 priority="1272"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization (Cartella Clinica)): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.887-2025-12-16T121640.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:asOrganizationPartOf/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.1']"
                 priority="1270"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.4.1.1')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.2.9.4.1.1'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.4.1.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']]/hl7:serviceProviderOrganization[hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']]/hl7:asOrganizationPartOf/hl7:code"
                 priority="1269"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf (Cartella Clinica)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.888-2025-12-16T122214.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e344-false-d13693e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]"
                 priority="1268"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
               <xsl:value-of select="@contextConductionInd"/>
               <xsl:text/>" (string(@contextConductionInd) = ('true') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN'] is required [min 1x]. (count(hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN'] appears too often [max 1x]. (count(hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e347-false-d14107e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']"
                 priority="1267"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCBODY')"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for classCode SHALL be 'DOCBODY'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('DOCBODY') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]]"
                 priority="1266"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]"
                 priority="1265"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]"
                 priority="1263"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): element hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): element hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']"
                 priority="1262"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.851')"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.851'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.851') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1261"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('47039-3')"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): The value for code SHALL be '47039-3'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('47039-3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Hospital Admission history and physical note') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): The value for displayName SHALL be 'Hospital Admission history and physical note'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Hospital Admission history and physical note') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>( Inquadramento clinico (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]"
                 priority="1260"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x]. (count(hl7:assignedAuthor) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x]. (count(hl7:assignedAuthor) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time"
                 priority="1259"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1258"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1257"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1256"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name"
                 priority="1255"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]"
                 priority="1254"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]"
                 priority="1252"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): element hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): element hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']"
                 priority="1251"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.844')"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.844'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.844') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1250"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('67851-6')"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): The value for code SHALL be '67851-6'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('67851-6') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Admission evaluation note') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): The value for displayName SHALL be 'Admission evaluation note'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Admission evaluation note') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Accertamento assistenziale (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]"
                 priority="1249"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x]. (count(hl7:assignedAuthor) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x]. (count(hl7:assignedAuthor) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time"
                 priority="1248"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1247"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1246"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1245"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name"
                 priority="1244"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]"
                 priority="1243"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]"
                 priority="1241"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']"
                 priority="1240"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.852')"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.852'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.852') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1239"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('48765-2')"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): The value for code SHALL be '48765-2'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('48765-2') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Allergies and adverse reactions Document') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): The value for displayName SHALL be 'Allergies and adverse reactions Document'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Allergies and adverse reactions Document') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Allergie e intolleranze (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]"
                 priority="1238"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x]. (count(hl7:assignedAuthor) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x]. (count(hl7:assignedAuthor) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time"
                 priority="1237"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1236"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1235"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1234"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name"
                 priority="1233"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]"
                 priority="1232"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]"
                 priority="1230"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): element hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): element hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']"
                 priority="1229"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.853')"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.853'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.853') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1228"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('84172-6')"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): The value for code SHALL be '84172-6'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('84172-6') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Interdisciplinary Hospital Plan of care note') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): The value for displayName SHALL be 'Interdisciplinary Hospital Plan of care note'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Interdisciplinary Hospital Plan of care note') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Processo Terapeutico  (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]"
                 priority="1227"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x]. (count(hl7:assignedAuthor) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x]. (count(hl7:assignedAuthor) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time"
                 priority="1226"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1225"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1224"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1223"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name"
                 priority="1222"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]"
                 priority="1221"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]"
                 priority="1219"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): element hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): element hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']"
                 priority="1218"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.854')"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.854'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.854') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1217"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('8716-3')"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): The value for code SHALL be '8716-3'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('8716-3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Vital signs note') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): The value for displayName SHALL be 'Vital signs note'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Vital signs note') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>( Parametri (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]"
                 priority="1216"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x]. (count(hl7:assignedAuthor) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x]. (count(hl7:assignedAuthor) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time"
                 priority="1215"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1214"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1213"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1212"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name"
                 priority="1211"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]"
                 priority="1210"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x]. (count(hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x]. (count(hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]"
                 priority="1208"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:templateId is required [min 1x]. (count(hl7:templateId) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:templateId appears too often [max 1x]. (count(hl7:templateId) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId"
                 priority="1207"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.855') or not(@root)"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.855'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.855') or not(@root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1206"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('83734-4')"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for code SHALL be '83734-4'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('83734-4') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Physical medicine and rehabilitation Interdisciplinary Plan of care note') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for displayName SHALL be 'Physical medicine and rehabilitation Interdisciplinary Plan of care note'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Physical medicine and rehabilitation Interdisciplinary Plan of care note') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Piano riabilitativo individuale PRI (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]"
                 priority="1205"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x]. (count(hl7:assignedAuthor) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x]. (count(hl7:assignedAuthor) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time"
                 priority="1204"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1203"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1202"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1201"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name"
                 priority="1200"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]"
                 priority="1199"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]"
                 priority="1197"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): element hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): element hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']"
                 priority="1196"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.856')"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.856'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.856') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1195"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('101541-1')"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): The value for code SHALL be '101541-1'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('101541-1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Multidisciplinary Comprehensive plan of care note') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): The value for displayName SHALL be 'Multidisciplinary Comprehensive plan of care note'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Multidisciplinary Comprehensive plan of care note') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Piano assistenziale individuale (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]"
                 priority="1194"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x]. (count(hl7:assignedAuthor) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x]. (count(hl7:assignedAuthor) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time"
                 priority="1193"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1192"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1191"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1190"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name"
                 priority="1189"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]"
                 priority="1188"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]"
                 priority="1186"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): element hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): element hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']"
                 priority="1185"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.865')"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.865'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.865') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1184"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('59284-0')"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): The value for code SHALL be '59284-0'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('59284-0') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Consent Document') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): The value for displayName SHALL be 'Consent Document'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Consent Document') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]"
                 priority="1183"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x]. (count(hl7:assignedAuthor) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x]. (count(hl7:assignedAuthor) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time"
                 priority="1182"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1181"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1180"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1179"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name"
                 priority="1178"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]"
                 priority="1177"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(observationMedia (Cartella Clinica)): element hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']] is required [min 1x]. (count(hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(observationMedia (Cartella Clinica)): element hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']] appears too often [max 1x]. (count(hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): Attribute @typeCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>' (not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <xsl:message>(Consensi (Cartella Clinica)): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
               <xsl:value-of select="@contextConductionInd"/>
               <xsl:text/>" (string(@contextConductionInd) = ('true') or not(@contextConductionInd) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]"
                 priority="1175"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(observationMedia (Cartella Clinica)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('OBS') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(observationMedia (Cartella Clinica)): The value for classCode SHALL be 'OBS'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('OBS') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(observationMedia (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(observationMedia (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(observationMedia (Cartella Clinica)): element hl7:value is required [min 1x]. (count(hl7:value) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(observationMedia (Cartella Clinica)): element hl7:value appears too often [max 1x]. (count(hl7:value) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']"
                 priority="1174"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.866')"/>
         <xsl:otherwise>
            <xsl:message>(observationMedia (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.866'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.866') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.866']]/hl7:value"
                 priority="1173"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(observationMedia (Cartella Clinica)): Attribute @xsi:type SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@xsi:type"/>
               <xsl:text/>' (not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@mediaType) or string-length(@mediaType)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(observationMedia (Cartella Clinica)): Attribute @mediaType SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@mediaType"/>
               <xsl:text/>' (not(@mediaType) or string-length(@mediaType)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@representation) or (string-length(@representation) &gt; 0 and not(matches(@representation,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(observationMedia (Cartella Clinica)): Attribute @representation SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@representation"/>
               <xsl:text/>' (not(@representation) or (string-length(@representation) &gt; 0 and not(matches(@representation,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]"
                 priority="1172"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]"
                 priority="1170"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): element hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): element hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']"
                 priority="1169"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.857')"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.857'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.857') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1168"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('11487-6')"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): The value for code SHALL be '11487-6'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('11487-6') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Consultation request (narrative)') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): The value for displayName SHALL be 'Consultation request (narrative)'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Consultation request (narrative)') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Richieste (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]"
                 priority="1167"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x]. (count(hl7:assignedAuthor) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x]. (count(hl7:assignedAuthor) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time"
                 priority="1166"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1165"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1164"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1163"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name"
                 priority="1162"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]"
                 priority="1161"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]"
                 priority="1159"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): element hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): element hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']"
                 priority="1158"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.849')"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.849'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.849') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1157"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('11506-3')"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): The value for code SHALL be '11506-3'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('11506-3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Progress note') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): The value for displayName SHALL be 'Progress note'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Progress note') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Diario clinico assistenziale (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]"
                 priority="1156"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x]. (count(hl7:assignedAuthor) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x]. (count(hl7:assignedAuthor) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time"
                 priority="1155"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1154"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1153"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1152"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name"
                 priority="1151"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name v1.0): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.893-2025-12-18T111925.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]"
                 priority="1150"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]"
                 priority="1148"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']"
                 priority="1147"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.847')"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.847'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.847') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1146"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('108277-5')"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): The value for code SHALL be '108277-5'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('108277-5') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Implanted device note') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): The value for displayName SHALL be 'Implanted device note'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Implanted device note') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Documentazione di dispositivi impiantati o utilizzati (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]"
                 priority="1145"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor is required [min 1x]. (count(hl7:assignedAuthor) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedAuthor appears too often [max 1x]. (count(hl7:assignedAuthor) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time"
                 priority="1144"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1143"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1142"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(author (Cartella Clinica)_v1.0): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.898-2025-12-19T143658.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1141"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person v1.0): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251219T160325/tmp-2.16.840.1.113883.3.1937.777.63.10.891-2025-12-18T111624.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templa