<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:hl7="urn:hl7-org:v3"
                xmlns:cda="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:sdtc="urn:hl7-org:sdtc"
                xmlns:pharm="urn:ihe:pharm:medication"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
   <xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


   <!--PROLOG-->
   <xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
               method="xml"
               omit-xml-declaration="no"
               standalone="yes"
               indent="yes"/>

   <!--XSD TYPES FOR XSLT2-->


   <!--KEYS AND FUNCTIONS-->


   <!--DEFAULT RULES-->


   <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
   <!--This mode can be used to generate prefixed XPath for humans-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
   <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
   <xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
   <xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters-->
   <xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
   <xsl:template match="/">
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                              title="Schematron file for transaction Create Lettera di invito per vaccinazione (2.16.840.1.113883.3.1937.777.63.4.42 2025-06-16T00:00:00)"
                              schemaVersion="">
         <xsl:comment>
            <xsl:value-of select="$archiveDirParameter"/>   
		 <xsl:value-of select="$archiveNameParameter"/>  
		 <xsl:value-of select="$fileNameParameter"/>  
		 <xsl:value-of select="$fileDirParameter"/>
         </xsl:comment>
         <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:v3" prefix="hl7"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:v3" prefix="cda"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:sdtc" prefix="sdtc"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:ihe:pharm:medication" prefix="pharm"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/XML/1998/namespace" prefix="xml"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M9"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="name">LetteradiinvitoperVaccinazione</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M10"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926</xsl:attribute>
            <xsl:attribute name="name">Lettera di invito per Vaccinazione</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M11"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926-closed</xsl:attribute>
            <xsl:attribute name="name">Lettera di invito per Vaccinazione</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M12"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706</xsl:attribute>
            <xsl:attribute name="name">Numero di Dose_Lett_Vacc (Observation)</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M20"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405</xsl:attribute>
            <xsl:attribute name="name">Section per la vaccinazione_Lett_Vacc</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M21"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146</xsl:attribute>
            <xsl:attribute name="name">Lett_Vacc - Malattia (Observation)</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M22"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540</xsl:attribute>
            <xsl:attribute name="name">Riferimento invito precedente_lett_vacc</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M23"/>
      </svrl:schematron-output>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Schematron file for transaction Create Lettera di invito per vaccinazione (2.16.840.1.113883.3.1937.777.63.4.42 2025-06-16T00:00:00)</svrl:text>
   <xsl:param name="scenariolabel" select="'2.16.840.1.113883.3.1937.777.63.4.42'"/>

   <!--PATTERN -->
   <xsl:template match="text()" priority="-1" mode="M9"/>
   <xsl:template match="@*|node()" priority="-2" mode="M9">
      <xsl:apply-templates select="*" mode="M9"/>
   </xsl:template>

   <!--PATTERN LetteradiinvitoperVaccinazione-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">LetteradiinvitoperVaccinazione</svrl:text>

	  <!--RULE -->
   <xsl:template match="/" priority="1000" mode="M10">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M10"/>
   <xsl:template match="@*|node()" priority="-2" mode="M10">
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926Lettera di invito per Vaccinazione-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Lettera di invito per Vaccinazione</svrl:text>

	  <!--RULE d45e15-false-d216e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]"
                 priority="1059"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('DOCCLIN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:realmCode) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:realmCode) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:realmCode is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:title) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:title appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:effectiveTime is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:languageCode) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:languageCode is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:languageCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:languageCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:setId) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:setId appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:versionNumber) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:versionNumber appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:recordTarget[hl7:patientRole] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:recordTarget[hl7:patientRole] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:author[hl7:assignedAuthor] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:custodian[hl7:assignedCustodian] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:structuredBody]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[hl7:structuredBody]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:component[hl7:structuredBody] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:structuredBody]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[hl7:structuredBody]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:component[hl7:structuredBody] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e18-false-d513e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:realmCode"
                 priority="1058"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e38-false-d529e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']"
                 priority="1057"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.1.3')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.1.3')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('POCD_MT000040UV02')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@extension) = ('POCD_MT000040UV02')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e52-false-d548e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']"
                 priority="1056"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.15.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.2.9.10.1.15.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.15.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('1.0')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@extension) = ('1.0')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for extension SHALL be '1.0'. Found: "<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e75-false-d569e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:id"
                 priority="1055"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e99-false-d591e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1054"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('111490-9')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('111490-9')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for code SHALL be '111490-9'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Immunization invitation letter') or not(@displayName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@displayName) = ('Immunization invitation letter') or not(@displayName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for displayName SHALL be 'Immunization invitation letter'. Found: "<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e109-false-d622e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation"
                 priority="1053"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e143-false-d665e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]"
                 priority="1052"
                 mode="M11">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (@code='N' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Normal' and @codeSystemName='HL7 Confidentiality') or (@code='V' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Very Restricted' and @codeSystemName='HL7 Confidentiality') or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@nullFlavor or (@code='N' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Normal' and @codeSystemName='HL7 Confidentiality') or (@code='V' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Very Restricted' and @codeSystemName='HL7 Confidentiality') or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The element value SHALL be one of 'code 'N' codeSystem '2.16.840.1.113883.5.25' displayName='Normal' codeSystemName='HL7 Confidentiality' or code 'V' codeSystem '2.16.840.1.113883.5.25' displayName='Very Restricted' codeSystemName='HL7 Confidentiality' or 2.16.840.1.113883.1.11.16926 x_BasicConfidentialityKind (DYNAMIC)'.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e167-false-d700e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:setId"
                 priority="1051"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d723e18-false-d751e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]"
                 priority="1050"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('RCT') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('RCT') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): The value for typeCode SHALL be 'RCT'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[hl7:patient]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patientRole[hl7:patient]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:patientRole[hl7:patient] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[hl7:patient]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patientRole[hl7:patient]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:patientRole[hl7:patient] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d723e33-false-d817e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]"
                 priority="1049"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PAT') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PAT') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): The value for classCode SHALL be 'PAT'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:addr is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:providerOrganization) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:providerOrganization) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:providerOrganization appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d723e40-false-d883e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id"
                 priority="1048"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr"
                 priority="1047"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d723e171-false-d1055e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom"
                 priority="1045"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d723e200-false-d1092e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
                 priority="1044"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PSN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthTime) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:birthTime is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:birthTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthplace[hl7:place]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthplace[hl7:place]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:birthplace[hl7:place] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthplace[hl7:place]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthplace[hl7:place]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:birthplace[hl7:place] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d723e208-false-d1151e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name"
                 priority="1043"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d723e232-false-d1194e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
                 priority="1042"
                 mode="M11">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d723e283-false-d1218e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime"
                 priority="1041"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d723e294-false-d1239e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]"
                 priority="1040"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('BIRTHPL') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('BIRTHPL') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): The value for classCode SHALL be 'BIRTHPL'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:place) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:place is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:place) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:place appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d723e327-false-d1275e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place"
                 priority="1039"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PLC') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PLC') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): The value for classCode SHALL be 'PLC'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr[hl7:country]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:addr[hl7:country]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:addr[hl7:country] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr[hl7:country]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:addr[hl7:country]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): element hl7:addr[hl7:country] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]"
                 priority="1038"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.883-2025-12-15T162133.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (lettere di invito)): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization"
                 priority="1037"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Lett_Vacc): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Lett_Vacc): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Lett_Vacc): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): Attribute @classCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization/hl7:id"
                 priority="1035"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Lett_Vacc): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Lett_Vacc): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Lett_Vacc): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Lett_Vacc): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.670-2025-05-29T141945.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization_Lett_Vacc): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1443e74-false-d1536e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]"
                 priority="1034"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('AUT') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): element hl7:time is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedAuthor) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): element hl7:assignedAuthor is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedAuthor) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): element hl7:assignedAuthor appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1443e83-false-d1618e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1033"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): element hl7:assignedPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1443e99-false-d1669e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1032"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1031"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.636-2025-05-27T105600.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA personLett_Vacc): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.636-2025-05-27T105600.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA personLett_Vacc): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PSN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name"
                 priority="1029"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameLett_Vacc): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameLett_Vacc): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameLett_Vacc): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameLett_Vacc): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1028"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationLett_Vacc): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationLett_Vacc): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationLett_Vacc): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1027"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationLett_Vacc): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationLett_Vacc): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1026"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationLett_Vacc): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or string-length(@use) &gt; 0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or string-length(@use) &gt; 0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.647-2025-05-27T121825.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA OrganizationLett_Vacc): Attribute @use SHALL be of data type 'set_cs'  - '<xsl:text/>
                  <xsl:value-of select="@use"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1819e99-false-d2056e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]"
                 priority="1024"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('CST') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('CST') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.665-2025-05-28T112505.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianLett_Vacc): The value for typeCode SHALL be 'CST'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.665-2025-05-28T112505.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianLett_Vacc): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.665-2025-05-28T112505.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianLett_Vacc): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]"
                 priority="1023"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedCustodianOrganization) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA assignedCustodian ): element hl7:representedCustodianOrganization is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedCustodianOrganization) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA assignedCustodian ): element hl7:representedCustodianOrganization appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.665-2025-05-28T112505.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianLett_Vacc): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization"
                 priority="1021"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): element hl7:addr appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id"
                 priority="1020"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom"
                 priority="1019"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr"
                 priority="1018"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2115e143-false-d2461e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
                 priority="1016"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('LA') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('LA') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorLett_Vacc): The value for typeCode SHALL be 'LA'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorLett_Vacc): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorLett_Vacc): element hl7:time is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorLett_Vacc): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorLett_Vacc): element hl7:signatureCode[@code = 'S'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorLett_Vacc): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorLett_Vacc): element hl7:assignedEntity is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorLett_Vacc): element hl7:assignedEntity appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2115e164-false-d2522e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
                 priority="1015"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('S')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string(@code) = ('S')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorLett_Vacc): The value for code SHALL be 'S'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity"
                 priority="1014"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityLett_Vacc): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityLett_Vacc): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityLett_Vacc): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityLett_Vacc): element hl7:assignedPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id"
                 priority="1013"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityLett_Vacc): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityLett_Vacc): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityLett_Vacc): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityLett_Vacc): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.635-2025-05-27T105216.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntityLett_Vacc): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1012"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.636-2025-05-27T105600.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA personLett_Vacc): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.636-2025-05-27T105600.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA personLett_Vacc): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1011"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameLett_Vacc): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameLett_Vacc): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameLett_Vacc): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.637-2025-05-27T105846.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA nameLett_Vacc): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2549e87-false-d2727e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]"
                 priority="1010"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('DOC') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('DOC') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc): The value for typeCode SHALL be 'DOC'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc): element hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc): element hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2549e104-false-d2749e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]"
                 priority="1009"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ACT') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ACT') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc): The value for classCode SHALL be 'ACT'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2549e112-false-d2775e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1']"
                 priority="1008"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2795e38-false-d2802e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
                 priority="1007"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@typeCode"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@typeCode">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): attribute @typeCode SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:parentDocument) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:parentDocument) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): element hl7:parentDocument is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:parentDocument) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:parentDocument) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): element hl7:parentDocument appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2795e83-false-d2833e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
                 priority="1006"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('DOCCLIN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): element hl7:text appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:setId) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): element hl7:setId appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:versionNumber) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): element hl7:versionNumber appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2795e89-false-d2879e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
                 priority="1005"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d2795e104-false-d2897e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
                 priority="1004"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e200-false-d2972e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]"
                 priority="1003"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('COMP') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextConductionInd"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:structuredBody[hl7:component]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:structuredBody[hl7:component]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:structuredBody[hl7:component] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:structuredBody[hl7:component]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:structuredBody[hl7:component]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:structuredBody[hl7:component] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e203-false-d3050e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]"
                 priority="1002"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCBODY') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('DOCBODY') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for classCode SHALL be 'DOCBODY'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]"
                 priority="1001"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('COMP') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextConductionInd"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]"
                 priority="1000"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('COMP') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextConductionInd"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M11"/>
   <xsl:template match="@*|node()" priority="-2" mode="M11">
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926-closedLettera di invito per Vaccinazione-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Lettera di invito per Vaccinazione</svrl:text>

	  <!--RULE d45e15-true-d3611e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/*[not(@xsi:nil = 'true')][not(self::hl7:realmCode | self::hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] | self::hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0'] | self::hl7:id | self::hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:effectiveTime | self::hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] | self::hl7:languageCode | self::hl7:setId | self::hl7:versionNumber | self::hl7:recordTarget[hl7:patientRole] | self::hl7:author[hl7:assignedAuthor] | self::hl7:custodian[hl7:assignedCustodian] | self::hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] | self::hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]] | self::hl7:relatedDocument[@typeCode][hl7:parentDocument] | self::hl7:component[hl7:structuredBody])]"
                 priority="1052"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d45e15-true-d3611e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:realmCode | hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] | hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0'] | hl7:id | hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:effectiveTime | hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] | hl7:languageCode | hl7:setId | hl7:versionNumber | hl7:recordTarget[hl7:patientRole] | hl7:author[hl7:assignedAuthor] | hl7:custodian[hl7:assignedCustodian] | hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] | hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]] | hl7:relatedDocument[@typeCode][hl7:parentDocument] | hl7:component[hl7:structuredBody] (rule-reference: d45e15-true-d3611e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d45e99-true-d3648e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:code[(@code = '111490-9' and @codeSystem = '2.16.840.1.113883.6.1')]/*[not(@xsi:nil = 'true')][not(self::hl7:translation)]"
                 priority="1051"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d45e99-true-d3648e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:translation (rule-reference: d45e99-true-d3648e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d3693e14-true-d3768e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/*[not(@xsi:nil = 'true')][not(self::hl7:patientRole[hl7:patient])]"
                 priority="1050"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc)/d3693e14-true-d3768e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:patientRole[hl7:patient] (rule-reference: d3693e14-true-d3768e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d3693e29-true-d3871e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:addr | self::hl7:telecom | self::hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] | self::hl7:providerOrganization)]"
                 priority="1049"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc)/d3693e29-true-d3871e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:addr | hl7:telecom | hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] | hl7:providerOrganization (rule-reference: d3693e29-true-d3871e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d3693e102-true-d3923e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
                 priority="1048"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc)/d3693e102-true-d3923e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d3693e102-true-d3923e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d3693e196-true-d4025e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/*[not(@xsi:nil = 'true')][not(self::hl7:name | self::hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] | self::hl7:birthTime | self::hl7:birthplace[hl7:place])]"
                 priority="1047"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc)/d3693e196-true-d4025e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name | hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] | hl7:birthTime | hl7:birthplace[hl7:place] (rule-reference: d3693e196-true-d4025e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d3693e204-true-d4044e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family)]"
                 priority="1046"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc)/d3693e204-true-d4044e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family (rule-reference: d3693e204-true-d4044e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d3693e290-true-d4105e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/*[not(@xsi:nil = 'true')][not(self::hl7:place)]"
                 priority="1045"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc)/d3693e290-true-d4105e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:place (rule-reference: d3693e290-true-d4105e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d3693e323-true-d4148e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/*[not(@xsi:nil = 'true')][not(self::hl7:name | self::hl7:addr[hl7:country])]"
                 priority="1044"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc)/d3693e323-true-d4148e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name | hl7:addr[hl7:country] (rule-reference: d3693e323-true-d4148e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d3693e327-true-d4195e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:censusTract | self::hl7:postalCode)]"
                 priority="1043"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc)/d3693e327-true-d4195e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:censusTract | hl7:postalCode (rule-reference: d3693e327-true-d4195e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d3693e328-true-d4247e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name)]"
                 priority="1042"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.626-2025-05-26T164314.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTargetLett_Vacc)/d3693e328-true-d4247e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name (rule-reference: d3693e328-true-d4247e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4261e13-true-d4341e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:assignedAuthor)]"
                 priority="1041"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc)/d4261e13-true-d4341e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:assignedAuthor (rule-reference: d4261e13-true-d4341e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4261e22-true-d4433e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson | self::hl7:representedOrganization[@classCode = 'ORG'])]"
                 priority="1040"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc)/d4261e22-true-d4433e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson | hl7:representedOrganization[@classCode = 'ORG'] (rule-reference: d4261e22-true-d4433e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4261e47-true-d4467e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
                 priority="1039"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc)/d4261e47-true-d4467e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d4261e47-true-d4467e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4443e8-true-d4489e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family)]"
                 priority="1038"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc)/d4443e8-true-d4489e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family (rule-reference: d4443e8-true-d4489e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4261e55-true-d4553e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/*[not(@xsi:nil = 'true')][not(self::hl7:name | self::hl7:telecom | self::hl7:addr)]"
                 priority="1037"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc)/d4261e55-true-d4553e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name | hl7:telecom | hl7:addr (rule-reference: d4261e55-true-d4553e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4504e51-true-d4610e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
                 priority="1036"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.631-2025-05-27T102702.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authorLett_Vacc)/d4504e51-true-d4610e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d4504e51-true-d4610e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4649e13-true-d4715e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/*[not(@xsi:nil = 'true')][not(self::hl7:assignedCustodian[hl7:representedCustodianOrganization])]"
                 priority="1035"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.665-2025-05-28T112505.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianLett_Vacc)/d4649e13-true-d4715e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:assignedCustodian[hl7:representedCustodianOrganization] (rule-reference: d4649e13-true-d4715e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4649e23-true-d4777e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/*[not(@xsi:nil = 'true')][not(self::hl7:representedCustodianOrganization)]"
                 priority="1034"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.665-2025-05-28T112505.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianLett_Vacc)/d4649e23-true-d4777e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:representedCustodianOrganization (rule-reference: d4649e23-true-d4777e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4720e3-true-d4836e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr)]"
                 priority="1033"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.665-2025-05-28T112505.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianLett_Vacc)/d4720e3-true-d4836e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:name | hl7:telecom | hl7:addr (rule-reference: d4720e3-true-d4836e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4782e58-true-d4898e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
                 priority="1032"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.665-2025-05-28T112505.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodianLett_Vacc)/d4782e58-true-d4898e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d4782e58-true-d4898e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4937e13-true-d4995e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:signatureCode[@code = 'S'] | self::hl7:assignedEntity)]"
                 priority="1031"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorLett_Vacc)/d4937e13-true-d4995e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:time | hl7:signatureCode[@code = 'S'] | hl7:assignedEntity (rule-reference: d4937e13-true-d4995e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d4937e46-true-d5049e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:assignedPerson)]"
                 priority="1030"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorLett_Vacc)/d4937e46-true-d5049e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:assignedPerson (rule-reference: d4937e46-true-d5049e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5011e34-true-d5083e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
                 priority="1029"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorLett_Vacc)/d5011e34-true-d5083e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d5011e34-true-d5083e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5059e8-true-d5105e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:given | self::hl7:family)]"
                 priority="1028"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.632-2025-05-27T103644.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticatorLett_Vacc)/d5059e8-true-d5105e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:given | hl7:family (rule-reference: d5059e8-true-d5105e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5119e13-true-d5134e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]/*[not(@xsi:nil = 'true')][not(self::hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']])]"
                 priority="1027"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc)/d5119e13-true-d5134e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']] (rule-reference: d5119e13-true-d5134e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5119e30-true-d5151e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.6.1']]/*[not(@xsi:nil = 'true')][not(self::hl7:code[@codeSystem = '2.16.840.1.113883.6.1'])]"
                 priority="1026"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.706-2025-06-12T085304.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA documentationOfLet_Vacc)/d5119e30-true-d5151e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] (rule-reference: d5119e30-true-d5151e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5161e12-true-d5173e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/*[not(@xsi:nil = 'true')][not(self::hl7:parentDocument)]"
                 priority="1025"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc)/d5161e12-true-d5173e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:parentDocument (rule-reference: d5161e12-true-d5173e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5161e57-true-d5207e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:text | self::hl7:setId | self::hl7:versionNumber)]"
                 priority="1024"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.708-2025-06-17T171746.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA relatedDocument Lett_Vacc)/d5161e57-true-d5207e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code | hl7:text | hl7:setId | hl7:versionNumber (rule-reference: d5161e57-true-d5207e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d45e200-true-d5327e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/*[not(@xsi:nil = 'true')][not(self::hl7:structuredBody[hl7:component])]"
                 priority="1023"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d45e200-true-d5327e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:structuredBody[hl7:component] (rule-reference: d45e200-true-d5327e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d45e203-true-d5431e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/*[not(@xsi:nil = 'true')][not(self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]] | self::hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]])]"
                 priority="1022"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d45e203-true-d5431e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]] | hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]] (rule-reference: d45e203-true-d5431e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d45e206-true-d5514e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']])]"
                 priority="1021"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d45e206-true-d5514e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']] (rule-reference: d45e206-true-d5514e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5436e3-true-d5623e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674'] | self::hl7:code[(@code = '112069-0 ' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:entry[hl7:encounter[@moodCode]] | self::hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]])]"
                 priority="1020"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d5436e3-true-d5623e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674'] | hl7:code[(@code = '112069-0 ' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:entry[hl7:encounter[@moodCode]] | hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]] (rule-reference: d5436e3-true-d5623e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5436e40-true-d5689e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/*[not(@xsi:nil = 'true')][not(self::hl7:encounter[@moodCode][hl7:effectiveTime])]"
                 priority="1019"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d5436e40-true-d5689e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:encounter[@moodCode][hl7:effectiveTime] (rule-reference: d5436e40-true-d5689e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5650e7-true-d5742e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/*[not(@xsi:nil = 'true')][not(self::hl7:effectiveTime | self::hl7:participant | self::hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]])]"
                 priority="1018"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d5650e7-true-d5742e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:effectiveTime | hl7:participant | hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]] (rule-reference: d5650e7-true-d5742e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5650e33-true-d5788e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:participant/*[not(@xsi:nil = 'true')][not(self::hl7:participantRole)]"
                 priority="1017"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d5650e33-true-d5788e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:participantRole (rule-reference: d5650e33-true-d5788e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5650e40-true-d5844e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:participant/hl7:participantRole/*[not(@xsi:nil = 'true')][not(self::hl7:playingEntity[hl7:name] | self::hl7:addr | self::hl7:telecom | self::hl7:id)]"
                 priority="1016"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d5650e40-true-d5844e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:playingEntity[hl7:name] | hl7:addr | hl7:telecom | hl7:id (rule-reference: d5650e40-true-d5844e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5650e42-true-d5858e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:playingEntity[hl7:name]/*[not(@xsi:nil = 'true')][not(self::hl7:name)]"
                 priority="1015"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d5650e42-true-d5858e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:name (rule-reference: d5650e42-true-d5858e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5650e44-true-d5910e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:country | self::hl7:state | self::hl7:county | self::hl7:city | self::hl7:postalCode | self::hl7:streetAddressLine | self::hl7:censusTract)]"
                 priority="1014"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d5650e44-true-d5910e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:country | hl7:state | hl7:county | hl7:city | hl7:postalCode | hl7:streetAddressLine | hl7:censusTract (rule-reference: d5650e44-true-d5910e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5650e72-true-d5972e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]/*[not(@xsi:nil = 'true')][not(self::hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]])]"
                 priority="1013"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d5650e72-true-d5972e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]] (rule-reference: d5650e72-true-d5972e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5650e79-true-d5994e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]/*[not(@xsi:nil = 'true')][not(self::hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')] | self::hl7:text)]"
                 priority="1012"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d5650e79-true-d5994e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')] | hl7:text (rule-reference: d5650e79-true-d5994e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d5436e47-true-d6043e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]]/*[not(@xsi:nil = 'true')][not(self::hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']])]"
                 priority="1011"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d5436e47-true-d6043e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']] (rule-reference: d5436e47-true-d6043e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6010e22-true-d6097e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678'] | self::hl7:code[(@code = '112074-2' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:text | self::hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]])]"
                 priority="1010"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d6010e22-true-d6097e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678'] | hl7:code[(@code = '112074-2' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:text | hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]] (rule-reference: d6010e22-true-d6097e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6010e38-true-d6143e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]]/*[not(@xsi:nil = 'true')][not(self::hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']])]"
                 priority="1009"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d6010e38-true-d6143e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']] (rule-reference: d6010e38-true-d6143e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6119e8-true-d6190e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675'] | self::hl7:code[(@code = '75323-6' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:value[@codeSystem = '2.16.840.1.113883.6.103'] | self::hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]])]"
                 priority="1008"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d6119e8-true-d6190e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675'] | hl7:code[(@code = '75323-6' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:value[@codeSystem = '2.16.840.1.113883.6.103'] | hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]] (rule-reference: d6119e8-true-d6190e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6119e42-true-d6228e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]]/*[not(@xsi:nil = 'true')][not(self::hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']])]"
                 priority="1007"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d6119e42-true-d6228e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']] (rule-reference: d6119e42-true-d6228e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6213e3-true-d6257e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672'] | self::hl7:code[(@code = '30973-2' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:value)]"
                 priority="1006"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d6213e3-true-d6257e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672'] | hl7:code[(@code = '30973-2' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:value (rule-reference: d6213e3-true-d6257e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d45e209-true-d6303e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/*[not(@xsi:nil = 'true')][not(self::hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']])]"
                 priority="1005"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d45e209-true-d6303e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']] (rule-reference: d45e209-true-d6303e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6279e3-true-d6353e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680'] | self::hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:title | self::hl7:text | self::hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]])]"
                 priority="1004"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d6279e3-true-d6353e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680'] | hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:title | hl7:text | hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]] (rule-reference: d6279e3-true-d6353e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6279e20-true-d6395e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]/*[not(@xsi:nil = 'true')][not(self::hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']])]"
                 priority="1003"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d6279e20-true-d6395e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']] (rule-reference: d6279e20-true-d6395e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6380e22-true-d6424e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679'] | self::hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:reference[@typeCode = 'REFR'][hl7:externalDocument])]"
                 priority="1002"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d6380e22-true-d6424e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679'] | hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:reference[@typeCode = 'REFR'][hl7:externalDocument] (rule-reference: d6380e22-true-d6424e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6380e32-true-d6450e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/*[not(@xsi:nil = 'true')][not(self::hl7:externalDocument[hl7:id])]"
                 priority="1001"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d6380e32-true-d6450e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:externalDocument[hl7:id] (rule-reference: d6380e32-true-d6450e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

	  <!--RULE d6380e34-true-d6469e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.15.1'][@extension = '1.0']]/hl7:component[hl7:structuredBody]/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[hl7:id]/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code)]"
                 priority="1000"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.2.9.10.1.15.1-2025-05-26T163926.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lettera di invito per Vaccinazione)/d6380e34-true-d6469e0: '<xsl:text/>
                  <xsl:value-of select="name(..)"/>
                  <xsl:text/>' is defined as closed, and this element '<xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>' is not allowed, or not allowed with this content. This may concern the templateId, code or id. Expected in this context:  hl7:id | hl7:code (rule-reference: d6380e34-true-d6469e0)</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M12"/>
   <xsl:template match="@*|node()" priority="-2" mode="M12">
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706Numero di Dose_Lett_Vacc (Observation)-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Numero di Dose_Lett_Vacc (Observation)</svrl:text>

	  <!--RULE d45e1159-false-d6496e0-->
   <xsl:template match="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]]"
                 priority="1004"
                 mode="M20">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M20"/>
   </xsl:template>

	  <!--RULE d45e1171-false-d6513e0-->
   <xsl:template match="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]"
                 priority="1003"
                 mode="M20">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('OBS') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('OBS') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): The value for classCode SHALL be 'OBS'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672'] is mandatory [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '30973-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '30973-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): element hl7:code[(@code = '30973-2' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '30973-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '30973-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): element hl7:code[(@code = '30973-2' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:value) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): element hl7:value is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:value) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): element hl7:value appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M20"/>
   </xsl:template>

	  <!--RULE d45e1179-false-d6556e0-->
   <xsl:template match="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']"
                 priority="1002"
                 mode="M20">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.672')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.672')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.672'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M20"/>
   </xsl:template>

	  <!--RULE d45e1181-false-d6568e0-->
   <xsl:template match="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]/hl7:code[(@code = '30973-2' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1001"
                 mode="M20">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('30973-2')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('30973-2')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): The value for code SHALL be '30973-2'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M20"/>
   </xsl:template>

	  <!--RULE d45e1196-false-d6590e0-->
   <xsl:template match="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]/hl7:value"
                 priority="1000"
                 mode="M20">
      <xsl:variable name="xsiLocalName"
                    select="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <xsl:variable name="xsiLocalNS"
                    select="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or ($xsiLocalName='INT' and $xsiLocalNS='urn:hl7-org:v3')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@nullFlavor or ($xsiLocalName='INT' and $xsiLocalNS='urn:hl7-org:v3')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.672-2025-05-29T142706.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Numero di Dose_Lett_Vacc (Observation)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:INT". Found "{<xsl:text/>
                  <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
                  <xsl:text/>}:<xsl:text/>
                  <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M20"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M20"/>
   <xsl:template match="@*|node()" priority="-2" mode="M20">
      <xsl:apply-templates select="*" mode="M20"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405Section per la vaccinazione_Lett_Vacc-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Section per la vaccinazione_Lett_Vacc</svrl:text>

	  <!--RULE d45e1204-false-d6632e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]"
                 priority="1022"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE d45e1218-false-d6691e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]"
                 priority="1021"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCSECT') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('DOCSECT') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): The value for classCode SHALL be 'DOCSECT'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '112069-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '112069-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): element hl7:code[(@code = '112069-0 ' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '112069-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '112069-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): element hl7:code[(@code = '112069-0 ' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:title) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): element hl7:title appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): element hl7:text is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): element hl7:text appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:encounter[@moodCode]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entry[hl7:encounter[@moodCode]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): element hl7:entry[hl7:encounter[@moodCode]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): element hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE d45e1221-false-d6774e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']"
                 priority="1020"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.674')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.674')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.674'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE d45e1223-false-d6786e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:code[(@code = '112069-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1019"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('112069-0')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('112069-0')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): The value for code SHALL be '112069-0'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Immunization invitation letter') or not(@displayName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@displayName) = ('Immunization invitation letter') or not(@displayName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): The value for displayName SHALL be 'Immunization invitation letter'. Found: "<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]"
                 priority="1018"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encounter[@moodCode][hl7:effectiveTime]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:encounter[@moodCode][hl7:effectiveTime]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:encounter[@moodCode][hl7:effectiveTime] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encounter[@moodCode][hl7:effectiveTime]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:encounter[@moodCode][hl7:effectiveTime]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:encounter[@moodCode][hl7:effectiveTime] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): Attribute @typeCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]"
                 priority="1016"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@moodCode"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@moodCode">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): attribute @moodCode SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@moodCode) or (string-length(@moodCode) &gt; 0 and not(matches(@moodCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@moodCode) or (string-length(@moodCode) &gt; 0 and not(matches(@moodCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): Attribute @moodCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:effectiveTime is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:participant) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:participant) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:participant appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:participant"
                 priority="1015"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode ) = ('LOC') or not(@typeCode )"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode ) = ('LOC') or not(@typeCode )">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): The value for typeCode  SHALL be 'LOC'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode "/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:participantRole) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:participantRole) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:participantRole appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:participant/hl7:participantRole"
                 priority="1014"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode ) = ('SDLOC') or not(@classCode )"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode ) = ('SDLOC') or not(@classCode )">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): The value for classCode  SHALL be 'SDLOC'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode "/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:playingEntity[hl7:name]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:playingEntity[hl7:name]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:playingEntity[hl7:name] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:addr appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:telecom) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:telecom appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:playingEntity[hl7:name]"
                 priority="1013"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr"
                 priority="1012"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or string-length(@use) &gt; 0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or string-length(@use) &gt; 0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): Attribute @use SHALL be of data type 'set_cs'  - '<xsl:text/>
                  <xsl:value-of select="@use"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:telecom"
                 priority="1010"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or string-length(@use) &gt; 0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or string-length(@use) &gt; 0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): Attribute @use SHALL be of data type 'set_cs'  - '<xsl:text/>
                  <xsl:value-of select="@use"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:id"
                 priority="1009"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@ root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@ root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): attribute @ root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@ root) or matches(@ root,'^[0-2](\.(0|[1-9]\d*))*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@ root) or matches(@ root,'^[0-2](\.(0|[1-9]\d*))*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): Attribute @ root SHALL be of data type 'oid'  - '<xsl:text/>
                  <xsl:value-of select="@ root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]"
                 priority="1008"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@ typeCode) = ('COMP') or not(@ typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@ typeCode) = ('COMP') or not(@ typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): The value for  typeCode SHALL be 'COMP'. Found: "<xsl:text/>
                  <xsl:value-of select="@ typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]"
                 priority="1007"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@ classCode) = ('OBS') or not(@ classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@ classCode) = ('OBS') or not(@ classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): The value for  classCode SHALL be 'OBS'. Found: "<xsl:text/>
                  <xsl:value-of select="@ classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): element hl7:text appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:encounter[@moodCode]]/hl7:encounter[@moodCode][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]"
                 priority="1006"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('ASSERTION')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('ASSERTION')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): The value for code SHALL be 'ASSERTION'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.4')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.5.4')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): The value for codeSystem SHALL be '2.16.840.1.113883.5.4'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.715-2025-07-04T115548.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(entry_LettVacc_Appuntamento): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]]"
                 priority="1005"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): Attribute @typeCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.674-2025-05-29T145405.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Section per la vaccinazione_Lett_Vacc): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextConductionInd"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]"
                 priority="1003"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@moodCode"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@moodCode">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): attribute @moodCode SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@moodCode) or (string-length(@moodCode) &gt; 0 and not(matches(@moodCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@moodCode) or (string-length(@moodCode) &gt; 0 and not(matches(@moodCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): Attribute @moodCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@classCode"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@classCode">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): attribute @classCode SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): Attribute @classCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '112074-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '112074-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): element hl7:code[(@code = '112074-2' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '112074-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '112074-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): element hl7:code[(@code = '112074-2' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): element hl7:text is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): element hl7:text appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']"
                 priority="1002"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.678')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.678')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.678'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]/hl7:code[(@code = '112074-2' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1001"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('112074-2')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('112074-2')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): The value for code SHALL be '112074-2'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Immunization letter') or not(@displayName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@displayName) = ('Immunization letter') or not(@displayName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): The value for displayName SHALL be 'Immunization letter'. Found: "<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.674']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.678']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]]"
                 priority="1000"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('RSON')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('RSON')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): The value for typeCode SHALL be 'RSON'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@ inversionInd) = ('false')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@ inversionInd) = ('false')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.678-2025-06-04T113522.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Malattia per cui si effettua la Vaccinazione_Lett_Vacc(entry)): The value for  inversionInd SHALL be 'false'. Found: "<xsl:text/>
                  <xsl:value-of select="@ inversionInd"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M21"/>
   <xsl:template match="@*|node()" priority="-2" mode="M21">
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146Lett_Vacc - Malattia (Observation)-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Lett_Vacc - Malattia (Observation)</svrl:text>

	  <!--RULE d45e1285-false-d7514e0-->
   <xsl:template match="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]]"
                 priority="1005"
                 mode="M22">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M22"/>
   </xsl:template>

	  <!--RULE d45e1297-false-d7537e0-->
   <xsl:template match="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]"
                 priority="1004"
                 mode="M22">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('OBS') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('OBS') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): The value for classCode SHALL be 'OBS'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675'] is mandatory [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '75323-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '75323-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): element hl7:code[(@code = '75323-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '75323-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '75323-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): element hl7:code[(@code = '75323-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value[@codeSystem = '2.16.840.1.113883.6.103']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:value[@codeSystem = '2.16.840.1.113883.6.103']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): element hl7:value[@codeSystem = '2.16.840.1.113883.6.103'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value[@codeSystem = '2.16.840.1.113883.6.103']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:value[@codeSystem = '2.16.840.1.113883.6.103']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): element hl7:value[@codeSystem = '2.16.840.1.113883.6.103'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M22"/>
   </xsl:template>

	  <!--RULE d45e1305-false-d7591e0-->
   <xsl:template match="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']"
                 priority="1003"
                 mode="M22">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.675')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.675')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.675'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M22"/>
   </xsl:template>

	  <!--RULE d45e1307-false-d7603e0-->
   <xsl:template match="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]/hl7:code[(@code = '75323-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1002"
                 mode="M22">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('75323-6')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('75323-6')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): The value for code SHALL be '75323-6'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M22"/>
   </xsl:template>

	  <!--RULE d45e1322-false-d7626e0-->
   <xsl:template match="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]/hl7:value[@codeSystem = '2.16.840.1.113883.6.103']"
                 priority="1001"
                 mode="M22">
      <xsl:variable name="xsiLocalName"
                    select="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <xsl:variable name="xsiLocalNS"
                    select="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<xsl:text/>
                  <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
                  <xsl:text/>}:<xsl:text/>
                  <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.103')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.103')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): The value for codeSystem SHALL be '2.16.840.1.113883.6.103'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('ICD-9-CM') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('ICD-9-CM') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): The value for codeSystemName SHALL be 'ICD-9-CM'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M22"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.675']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.672']]]"
                 priority="1000"
                 mode="M22">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('RSON')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('RSON')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): The value for typeCode SHALL be 'RSON'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@inversionInd) = ('false')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@inversionInd) = ('false')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.675-2025-05-29T151146.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Lett_Vacc - Malattia (Observation)): The value for inversionInd SHALL be 'false'. Found: "<xsl:text/>
                  <xsl:value-of select="@inversionInd"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M22"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M22"/>
   <xsl:template match="@*|node()" priority="-2" mode="M22">
      <xsl:apply-templates select="*" mode="M22"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540Riferimento invito precedente_lett_vacc-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Riferimento invito precedente_lett_vacc</svrl:text>

	  <!--RULE d45e1400-false-d7692e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]"
                 priority="1012"
                 mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>

	  <!--RULE d45e1411-false-d7715e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]"
                 priority="1011"
                 mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCSECT') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('DOCSECT') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): The value for classCode SHALL be 'DOCSECT'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): element hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): element hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:title) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): element hl7:title appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:text) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): element hl7:text appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): element hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): element hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>

	  <!--RULE d45e1414-false-d7774e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']"
                 priority="1010"
                 mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.680')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.680')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.680'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>

	  <!--RULE d45e1416-false-d7786e0-->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1009"
                 mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('55107-7')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('55107-7')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): The value for code SHALL be '55107-7'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('External Documents') or not(@displayName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@displayName) = ('External Documents') or not(@displayName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): The value for displayName SHALL be 'External Documents'. Found: "<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]"
                 priority="1008"
                 mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): Attribute @typeCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.680-2025-06-04T132540.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Riferimento invito precedente_lett_vacc): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextConductionInd"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]"
                 priority="1006"
                 mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ACT')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ACT')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): The value for classCode SHALL be 'ACT'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): element hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): element hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): element hl7:reference[@typeCode = 'REFR'][hl7:externalDocument] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): element hl7:reference[@typeCode = 'REFR'][hl7:externalDocument] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']"
                 priority="1005"
                 mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.679')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.679')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.679'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]/hl7:code[(@code = '55107-7' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1004"
                 mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('55107-7')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('55107-7')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): The value for code SHALL be '55107-7'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('External documents') or not(@displayName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@displayName) = ('External documents') or not(@displayName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): The value for displayName SHALL be 'External documents'. Found: "<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]"
                 priority="1003"
                 mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('REFR')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('REFR')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): The value for typeCode SHALL be 'REFR'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:externalDocument[hl7:id]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:externalDocument[hl7:id]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): element hl7:externalDocument[hl7:id] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:externalDocument[hl7:id]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:externalDocument[hl7:id]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): element hl7:externalDocument[hl7:id] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[hl7:id]"
                 priority="1002"
                 mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('DOCCLIN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[hl7:id]/hl7:id"
                 priority="1001"
                 mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.680']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.679']]/hl7:reference[@typeCode = 'REFR'][hl7:externalDocument]/hl7:externalDocument[hl7:id]/hl7:code"
                 priority="1000"
                 mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): attribute @codeSystem  SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem ) or matches(@codeSystem ,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem ,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem ,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem ) or matches(@codeSystem ,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem ,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem ,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): Attribute @codeSystem  SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem "/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251217T151217/tmp-2.16.840.1.113883.3.1937.777.63.10.679-2025-06-04T123826.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Act riferimento a invito precedente(Lett_Vacc)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M23"/>
   <xsl:template match="@*|node()" priority="-2" mode="M23">
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>
</xsl:stylesheet>
