<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.613
Name: Section per lettera di invito screening
Description: Interventions Narrative (LOINC: 62387-6 )
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632">
   <title>Section per lettera di invito screening</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.613
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]
Item: (Section per lettera di invito screening)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]"
         id="d45e1203-false-d6970e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]) &gt;= 1">(Section per lettera di invito screening): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]) &lt;= 1">(Section per lettera di invito screening): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.613
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]
Item: (Section per lettera di invito screening)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]"
         id="d45e1216-false-d7023e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Section per lettera di invito screening): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Section per lettera di invito screening): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']) &gt;= 1">(Section per lettera di invito screening): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']) &lt;= 1">(Section per lettera di invito screening): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="count(hl7:id) &lt;= 1">(Section per lettera di invito screening): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="count(hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Section per lettera di invito screening): element hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="count(hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Section per lettera di invito screening): element hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="count(hl7:title) &lt;= 1">(Section per lettera di invito screening): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="count(hl7:text) &gt;= 1">(Section per lettera di invito screening): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="count(hl7:text) &lt;= 1">(Section per lettera di invito screening): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="count(hl7:entry[hl7:encounter[@moodCode = 'APT']]) &lt;= 1">(Section per lettera di invito screening): element hl7:entry[hl7:encounter[@moodCode = 'APT']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]) &gt;= 1">(Section per lettera di invito screening): element hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]) &lt;= 1">(Section per lettera di invito screening): element hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.613
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']
Item: (Section per lettera di invito screening)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']"
         id="d45e1219-false-d7111e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.613')">(Section per lettera di invito screening): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.613'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.613
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:id
Item: (Section per lettera di invito screening)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.613
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Section per lettera di invito screening)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:code[(@code = '112071-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d45e1222-false-d7131e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="string(@code) = ('112071-6')">(Section per lettera di invito screening): The value for code SHALL be '112071-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Section per lettera di invito screening): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Section per lettera di invito screening): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Section per lettera di invito screening): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="string(@displayName) = ('Screening invitation letter') or not(@displayName)">(Section per lettera di invito screening): The value for displayName SHALL be 'Screening invitation letter'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Section per lettera di invito screening): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.613
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:title
Item: (Section per lettera di invito screening)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.613
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:text
Item: (Section per lettera di invito screening)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.613
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]
Item: (Section per lettera di invito screening)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]">
      <extends rule="d7197e0-false-d7201e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Section per lettera di invito screening): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]
Item: (entry_Screening_Appuntamento)
-->
   <rule fpi="RULC-1" id="d7197e0-false-d7201e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]) &gt;= 1">(entry_Screening_Appuntamento): element hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]) &lt;= 1">(entry_Screening_Appuntamento): element hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]
Item: (entry_Screening_Appuntamento)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="string(@moodCode) = ('APT')">(entry_Screening_Appuntamento): The value for moodCode SHALL be 'APT'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:effectiveTime) &gt;= 1">(entry_Screening_Appuntamento): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:effectiveTime) &lt;= 1">(entry_Screening_Appuntamento): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:participant) &lt;= 1">(entry_Screening_Appuntamento): element hl7:participant appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]) &lt;= 1">(entry_Screening_Appuntamento): element hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:effectiveTime
Item: (entry_Screening_Appuntamento)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant
Item: (entry_Screening_Appuntamento)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="string(@typeCode ) = ('LOC') or not(@typeCode )">(entry_Screening_Appuntamento): The value for typeCode  SHALL be 'LOC'. Found: "<value-of select="@typeCode "/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:participantRole) &lt;= 1">(entry_Screening_Appuntamento): element hl7:participantRole appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole
Item: (entry_Screening_Appuntamento)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="string(@classCode) = ('SDLOC') or not(@classCode)">(entry_Screening_Appuntamento): The value for classCode SHALL be 'SDLOC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:playingEntity[hl7:name]) &lt;= 1">(entry_Screening_Appuntamento): element hl7:playingEntity[hl7:name] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:addr) &lt;= 1">(entry_Screening_Appuntamento): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:telecom) &lt;= 1">(entry_Screening_Appuntamento): element hl7:telecom appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:playingEntity[hl7:name]
Item: (entry_Screening_Appuntamento)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:playingEntity[hl7:name]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:name) &gt;= 1">(entry_Screening_Appuntamento): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:name) &lt;= 1">(entry_Screening_Appuntamento): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:playingEntity[hl7:name]/hl7:name
Item: (entry_Screening_Appuntamento)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr
Item: (entry_Screening_Appuntamento)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:telecom
Item: (entry_Screening_Appuntamento)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:id
Item: (entry_Screening_Appuntamento)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:participant/hl7:participantRole/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="@root">(entry_Screening_Appuntamento): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$')">(entry_Screening_Appuntamento): Attribute @root SHALL be of data type 'oid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="@extension">(entry_Screening_Appuntamento): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="not(@extension) or string-length(@extension)&gt;0">(entry_Screening_Appuntamento): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="not(@ assignedAuthorityName) or string-length(@ assignedAuthorityName)&gt;0">(entry_Screening_Appuntamento): Attribute @ assignedAuthorityName SHALL be of data type 'st'  - '<value-of select="@ assignedAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]
Item: (entry_Screening_Appuntamento)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="string(@ typeCode) = ('COMP') or not(@ typeCode)">(entry_Screening_Appuntamento): The value for  typeCode SHALL be 'COMP'. Found: "<value-of select="@ typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]) &gt;= 1">(entry_Screening_Appuntamento): element hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]) &lt;= 1">(entry_Screening_Appuntamento): element hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]
Item: (entry_Screening_Appuntamento)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(entry_Screening_Appuntamento): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="string(@moodCode) = ('EVN')">(entry_Screening_Appuntamento): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">(entry_Screening_Appuntamento): element hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">(entry_Screening_Appuntamento): element hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="count(hl7:text) &lt;= 1">(entry_Screening_Appuntamento): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]
Item: (entry_Screening_Appuntamento)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="string(@code) = ('ASSERTION')">(entry_Screening_Appuntamento): The value for code SHALL be 'ASSERTION'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.4')">(entry_Screening_Appuntamento): The value for codeSystem SHALL be '2.16.840.1.113883.5.4'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(entry_Screening_Appuntamento): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.714-2025-07-04T104143.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(entry_Screening_Appuntamento): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.714
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:encounter[@moodCode = 'APT']]/hl7:encounter[@moodCode = 'APT'][hl7:effectiveTime]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:text
Item: (entry_Screening_Appuntamento)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.613
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]
Item: (Section per lettera di invito screening)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]">
      <extends rule="d7675e0-false-d7679e0"/>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19446-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Section per lettera di invito screening): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19446' x_ActRelationshipEntry (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.613-2025-05-22T081632.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Section per lettera di invito screening): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.614
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]
Item: (ActLivelloScreening)
-->
   <rule fpi="RULC-1" id="d7675e0-false-d7679e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]) &gt;= 1">(ActLivelloScreening): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]) &lt;= 1">(ActLivelloScreening): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.614
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]
Item: (ActLivelloScreening)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="string(@moodCode) = ('EVN')">(ActLivelloScreening): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="string(@classCode) = ('ACT')">(ActLivelloScreening): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']) &gt;= 1">(ActLivelloScreening): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']) &lt;= 1">(ActLivelloScreening): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &gt;= 1">(ActLivelloScreening): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &lt;= 1">(ActLivelloScreening): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="count(hl7:text) &gt;= 1">(ActLivelloScreening): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="count(hl7:text) &lt;= 1">(ActLivelloScreening): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="count(hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]) &gt;= 1">(ActLivelloScreening): element hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="count(hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]) &lt;= 1">(ActLivelloScreening): element hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.614
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']
Item: (ActLivelloScreening)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.614')">(ActLivelloScreening): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.614'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.614
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1']
Item: (ActLivelloScreening)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="@code">(ActLivelloScreening): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.61-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(ActLivelloScreening): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.61' Livello screening (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(ActLivelloScreening): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(ActLivelloScreening): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(ActLivelloScreening): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(ActLivelloScreening): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.614
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:text
Item: (ActLivelloScreening)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.614
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]
Item: (ActLivelloScreening)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]">
      <extends rule="d7828e0-false-d7832e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.614-2025-05-22T085944.html"
              test="string(@typeCode) = ('COMP')">(ActLivelloScreening): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.623
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]
Item: (PrestazioneScreening)
-->
   <rule fpi="RULC-1" id="d7828e0-false-d7832e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="count(hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]) &gt;= 1">(PrestazioneScreening): element hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="count(hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]) &lt;= 1">(PrestazioneScreening): element hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.623
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]
Item: (PrestazioneScreening)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="string(@classCode) = ('PROC') or not(@classCode)">(PrestazioneScreening): The value for classCode SHALL be 'PROC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(PrestazioneScreening): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']) &gt;= 1">(PrestazioneScreening): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']) &lt;= 1">(PrestazioneScreening): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="count(hl7:code) &gt;= 1">(PrestazioneScreening): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="count(hl7:code) &lt;= 1">(PrestazioneScreening): element hl7:code appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.623
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']
Item: (PrestazioneScreening)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.623')">(PrestazioneScreening): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.623'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.623
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]/hl7:code
Item: (PrestazioneScreening)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.613']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.614']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.623']]/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="@code">(PrestazioneScreening): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(PrestazioneScreening): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="@codeSystem">(PrestazioneScreening): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(PrestazioneScreening): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(PrestazioneScreening): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251216T115550/tmp-2.16.840.1.113883.3.1937.777.63.10.623-2025-05-22T114735.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(PrestazioneScreening): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
</pattern>
