<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.18.1
Name: Cartella Clinica
Description: Template CDA ClinicalDocument (prototype, contains ClinicalDocument.component as nonXMLBody)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017">
   <title>Cartella Clinica</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /
Item: (Cartella Clinica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]"
         id="d45e128-false-d1123e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@classCode) = ('DOCCLIN')">(Cartella Clinica): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@moodCode) = ('EVN')">(Cartella Clinica): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:realmCode) &gt;= 1">(Cartella Clinica): element hl7:realmCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1">(Cartella Clinica): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1">(Cartella Clinica): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']) &gt;= 1">(Cartella Clinica): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(Cartella Clinica): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(Cartella Clinica): element hl7:id[not(@nullFlavor)] appears too often [max 1x].</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt; 1">(Cartella Clinica): element hl7:code is coded with binding strength 'extensible' and contains a code other than the specified set.</report>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Cartella Clinica): element hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:title) &lt;= 1">(Cartella Clinica): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(sdtc:statusCode[@code = 'active']) &lt;= 1">(Cartella Clinica): element sdtc:statusCode[@code = 'active'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Cartella Clinica): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Cartella Clinica): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &gt;= 1">(Cartella Clinica): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &lt;= 1">(Cartella Clinica): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:languageCode) &gt;= 1">(Cartella Clinica): element hl7:languageCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:languageCode) &lt;= 1">(Cartella Clinica): element hl7:languageCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:setId) &gt;= 1">(Cartella Clinica): element hl7:setId is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:setId) &lt;= 1">(Cartella Clinica): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:versionNumber) &gt;= 1">(Cartella Clinica): element hl7:versionNumber is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:versionNumber) &lt;= 1">(Cartella Clinica): element hl7:versionNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1">(Cartella Clinica): element hl7:recordTarget[hl7:patientRole] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1">(Cartella Clinica): element hl7:recordTarget[hl7:patientRole] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">(Cartella Clinica): element hl7:author[hl7:assignedAuthor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1">(Cartella Clinica): element hl7:custodian[hl7:assignedCustodian] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1">(Cartella Clinica): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:legalAuthenticator[hl7:assignedEntity]) &lt;= 1">(Cartella Clinica): element hl7:legalAuthenticator[hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">(Cartella Clinica): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:componentOf[hl7:encompassingEncounter]) &lt;= 1">(Cartella Clinica): element hl7:componentOf[hl7:encompassingEncounter] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]) &gt;= 1">(Cartella Clinica): element hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]) &lt;= 1">(Cartella Clinica): element hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:realmCode
Item: (Cartella Clinica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']"
         id="d45e141-false-d1844e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@root) = ('2.16.840.1.113883.1.3')">(Cartella Clinica): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@extension) = ('POCD_MT000040UV02')">(Cartella Clinica): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Cartella Clinica): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']"
         id="d45e161-false-d1863e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.18 .1')">(Cartella Clinica): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.18 .1'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@extension) = ('1.0')">(Cartella Clinica): The value for extension SHALL be '1.0'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Cartella Clinica): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:id[not(@nullFlavor)]
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:id[not(@nullFlavor)]"
         id="d45e180-false-d1882e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@root">(Cartella Clinica): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Cartella Clinica): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@extension">(Cartella Clinica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Cartella Clinica): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Cartella Clinica): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d45e211-false-d1904e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@code) = ('100971-1')">(Cartella Clinica): The value for code SHALL be '100971-1'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Cartella Clinica): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Cartella Clinica): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Cartella Clinica): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@displayName) = ('Cartella clinica') or not(@displayName)">(Cartella Clinica): The value for displayName SHALL be 'Cartella clinica'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Cartella Clinica): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:code[(@code = '100971-1' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation"
         id="d45e226-false-d1935e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@code">(Cartella Clinica): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Cartella Clinica): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@codeSystem">(Cartella Clinica): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(Cartella Clinica): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Cartella Clinica): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Cartella Clinica): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:title
Item: (Cartella Clinica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/sdtc:statusCode[@code = 'active']
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/sdtc:statusCode[@code = 'active']"
         id="d45e247-false-d1968e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@code) = ('active')">(Cartella Clinica): The value for code SHALL be 'active'. Found: "<value-of select="@code"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:effectiveTime
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:effectiveTime"
         id="d45e269-false-d1979e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@value">(Cartella Clinica): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Cartella Clinica): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']"
         id="d45e280-false-d1993e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@nullFlavor or (@code='N') or (@code='V')">(Cartella Clinica): The element value SHALL be one of 'code 'N' or code 'V''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@code">(Cartella Clinica): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Cartella Clinica): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.25')">(Cartella Clinica): The value for codeSystem SHALL be '2.16.840.1.113883.5.25'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName)">(Cartella Clinica): The value for codeSystemName SHALL be 'HL7 Confidentiality'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Cartella Clinica): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Cartella Clinica): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:languageCode
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:languageCode"
         id="d45e323-false-d2026e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@code">(Cartella Clinica): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Cartella Clinica): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:setId
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:setId"
         id="d45e334-false-d2039e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@root">(Cartella Clinica): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Cartella Clinica): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@extension">(Cartella Clinica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Cartella Clinica): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Cartella Clinica): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:versionNumber
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:versionNumber"
         id="d45e382-false-d2060e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="@value">(Cartella Clinica): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]"
         id="d2065e17-false-d2179e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@typeCode) = ('RCT') or not(@typeCode)">(CDA recordTarget (Cartella Clinica)): The value for typeCode SHALL be 'RCT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA recordTarget (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:patientRole[hl7:patient]) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:patientRole[hl7:patient] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:patientRole[hl7:patient]) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:patientRole[hl7:patient] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]"
         id="d2065e44-false-d2417e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@classCode) = ('PAT') or not(@classCode)">(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'PAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:id) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:providerOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id"
         id="d2065e51-false-d2568e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTarget (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@extension">(CDA recordTarget (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTarget (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA recordTarget (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr">
      <extends rule="d2617e0-false-d2623e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@use">(CDA recordTarget (Cartella Clinica)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d2617e0-false-d2623e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom"
         id="d2065e210-false-d2735e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@use">(CDA recordTarget (Cartella Clinica)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
         id="d2065e232-false-d2829e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTarget (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:name) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:birthTime) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:birthTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:birthTime) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:birthTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:birthplace[hl7:place]) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:birthplace[hl7:place] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name
Item: (CDA recordTarget (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:suffix
Item: (CDA name )
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d2065e252-false-d3042e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA recordTarget (Cartella Clinica)): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@code">(CDA recordTarget (Cartella Clinica)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@codeSystem">(CDA recordTarget (Cartella Clinica)): attribute @codeSystem SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime
Item: (CDA recordTarget (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian"
         id="d2065e307-false-d3122e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:code) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:guardianPerson) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:guardianPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:guardianOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id"
         id="d2065e313-false-d3212e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@root">(CDA recordTarget (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTarget (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@extension">(CDA recordTarget (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTarget (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code"
         id="d2065e317-false-d3230e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@code">(CDA recordTarget (Cartella Clinica)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="@codeSystem">(CDA recordTarget (Cartella Clinica)): attribute @codeSystem SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr
Item: (CDA recordTarget (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:telecom
Item: (CDA recordTarget (Cartella Clinica))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson
Item: (CDA recordTarget (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson">
      <extends rule="d3414e0-false-d3426e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTarget (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1" id="d3414e0-false-d3426e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA recordTarget (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3744e0-false-d3750e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3744e0-false-d3750e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3908e0-false-d3944e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3908e0-false-d3944e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d4114e0-false-d4118e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d4114e0-false-d4118e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d4284e0-false-d4290e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4284e0-false-d4290e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4448e0-false-d4484e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4448e0-false-d4484e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]"
         id="d2065e341-false-d4674e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@classCode) = ('BIRTHPL') or not(@classCode)">(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'BIRTHPL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:place) &gt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:place is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:place) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:place appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place
Item: (CDA recordTarget (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place"
         id="d2065e374-false-d4722e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA recordTarget (Cartella Clinica)): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTarget (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="count(hl7:addr[hl7:country]) &lt;= 1">(CDA recordTarget (Cartella Clinica)): element hl7:addr[hl7:country] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name
Item: (CDA recordTarget (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]
Item: (CDA recordTarget (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:country) &gt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:country) &lt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:state) &lt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:county) &lt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:city) &lt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:censusTract appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.867-2025-11-17T141419.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA AddressBirthPlace (Cartella Clinica)): element hl7:postalCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:country
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:state
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:county
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:city
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:censusTract
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.867
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:postalCode
Item: (CDA AddressBirthPlace (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.835
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA recordTarget (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']">
      <extends rule="d5009e0-false-d5013e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(CDA recordTarget (Cartella Clinica)): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.835-2025-11-03T155224.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA recordTarget (Cartella Clinica)): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d5009e0-false-d5013e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d5179e0-false-d5185e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d5179e0-false-d5185e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d5343e0-false-d5379e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d5343e0-false-d5379e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d5549e0-false-d5553e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d5549e0-false-d5553e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d5719e0-false-d5725e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d5719e0-false-d5725e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d5883e0-false-d5919e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d5883e0-false-d5919e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]
Item: (CDA author (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]"
         id="d4999e408-false-d6159e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:time) &gt;= 1">(CDA author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:time) &lt;= 1">(CDA author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:assignedAuthor[hl7:id]) &gt;= 1">(CDA author (Cartella Clinica)): element hl7:assignedAuthor[hl7:id] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:assignedAuthor[hl7:id]) &lt;= 1">(CDA author (Cartella Clinica)): element hl7:assignedAuthor[hl7:id] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]
Item: (CDA author (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]"
         id="d4999e426-false-d6325e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:id) &gt;= 1">(CDA author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:assignedAuthoringDevice[hl7:templateId]) &lt;= 1">(CDA author (Cartella Clinica)): element hl7:assignedAuthoringDevice[hl7:templateId] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA author (Cartella Clinica)): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:id
Item: (CDA author (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:id"
         id="d4999e432-false-d6427e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr
Item: (CDA author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr">
      <extends rule="d6474e0-false-d6480e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="@use">(CDA author (Cartella Clinica)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d6474e0-false-d6480e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:telecom
Item: (CDA author (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:telecom"
         id="d4999e451-false-d6592e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="@use">(CDA author (Cartella Clinica)): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author (Cartella Clinica)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson
Item: (CDA author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson">
      <extends rule="d6640e0-false-d6652e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA author (Cartella Clinica)): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA author (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1" id="d6640e0-false-d6652e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]
Item: (CDA author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]">
      <extends rule="d6792e0-false-d6796e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA author (Cartella Clinica)): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.836-2025-11-03T155438.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA author (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1" id="d6792e0-false-d6796e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:templateId) &gt;= 1">(CDA assignedAuthoringDevice ): element hl7:templateId is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:code) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:softwareName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:templateId
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:templateId">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@root">(CDA assignedAuthoringDevice ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA assignedAuthoringDevice ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@extension">(CDA assignedAuthoringDevice ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA assignedAuthoringDevice ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:code
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@code">(CDA assignedAuthoringDevice ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA assignedAuthoringDevice ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@codeSystem">(CDA assignedAuthoringDevice ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA assignedAuthoringDevice ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA assignedAuthoringDevice ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA assignedAuthoringDevice ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:manufacturerModelName
Item: (CDA assignedAuthoringDevice )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:softwareName
Item: (CDA assignedAuthoringDevice )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]">
      <extends rule="d6932e0-false-d6936e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="string(@classCode) = ('MNT') or not(@classCode)">(CDA assignedAuthoringDevice ): The value for classCode SHALL be 'MNT'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]
Item: (MaintainedEntity)
-->
   <rule fpi="RULC-1" id="d6932e0-false-d6936e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']) &gt;= 1">(MaintainedEntity): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']) &lt;= 1">(MaintainedEntity): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:effectiveTime) &lt;= 1">(MaintainedEntity): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:maintainingPerson) &gt;= 1">(MaintainedEntity): element hl7:maintainingPerson is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:maintainingPerson) &lt;= 1">(MaintainedEntity): element hl7:maintainingPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']
Item: (MaintainedEntity)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.272')">(MaintainedEntity): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.272'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:effectiveTime
Item: (MaintainedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson
Item: (MaintainedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.836
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d7344e0-false-d7350e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d7344e0-false-d7350e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d7508e0-false-d7544e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d7508e0-false-d7544e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d7714e0-false-d7718e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d7714e0-false-d7718e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d7884e0-false-d7890e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d7884e0-false-d7890e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d8048e0-false-d8084e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d8048e0-false-d8084e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.837
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]
Item: (CDA custodian (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]"
         id="d7170e393-false-d8279e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html"
              test="string(@typeCode) = ('CST') or not(@typeCode)">(CDA custodian (Cartella Clinica)): The value for typeCode SHALL be 'CST'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1">(CDA custodian (Cartella Clinica)): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1">(CDA custodian (Cartella Clinica)): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.837
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA custodian (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]">
      <extends rule="d8345e0-false-d8349e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.837-2025-11-03T155745.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA custodian (Cartella Clinica)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.75
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA assignedCustodian )
-->
   <rule fpi="RULC-1" id="d8345e0-false-d8349e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html"
              test="count(hl7:representedCustodianOrganization) &gt;= 1">(CDA assignedCustodian ): element hl7:representedCustodianOrganization is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html"
              test="count(hl7:representedCustodianOrganization) &lt;= 1">(CDA assignedCustodian ): element hl7:representedCustodianOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.75
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (CDA assignedCustodian )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(custodianOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(custodianOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:id) &gt;= 1">(custodianOrganization): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:name) &gt;= 1">(custodianOrganization): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:name) &lt;= 1">(custodianOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:addr) &lt;= 1">(custodianOrganization): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@root">(custodianOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(custodianOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@extension">(custodianOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@extension) or string-length(@extension)&gt;0">(custodianOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(custodianOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:name
Item: (custodianOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@use">(custodianOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr">
      <extends rule="d8553e0-false-d8559e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@use">(custodianOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d8553e0-false-d8559e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.838
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]
Item: (CDA legalAuthenticator (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]"
         id="d8338e141-false-d8721e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="string(@typeCode) = ('LA') or not(@typeCode)">(CDA legalAuthenticator (Cartella Clinica)): The value for typeCode SHALL be 'LA'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA legalAuthenticator (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="count(hl7:time) &gt;= 1">(CDA legalAuthenticator (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="count(hl7:time) &lt;= 1">(CDA legalAuthenticator (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="count(hl7:signatureCode) &gt;= 1">(CDA legalAuthenticator (Cartella Clinica)): element hl7:signatureCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="count(hl7:signatureCode) &lt;= 1">(CDA legalAuthenticator (Cartella Clinica)): element hl7:signatureCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA legalAuthenticator (Cartella Clinica)): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.838-2025-11-03T155927.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA legalAuthenticator (Cartella Clinica)): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.838
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:time
Item: (CDA legalAuthenticator (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.838
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:signatureCode
Item: (CDA legalAuthenticator (Cartella Clinica))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.838
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA legalAuthenticator (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d9115e0-false-d9121e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d9115e0-false-d9121e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d9604e0-false-d9610e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d9604e0-false-d9610e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d9768e0-false-d9804e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d9768e0-false-d9804e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d9974e0-false-d9978e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d9974e0-false-d9978e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d10144e0-false-d10150e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d10144e0-false-d10150e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d10308e0-false-d10344e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d10308e0-false-d10344e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
         id="d8880e564-false-d10521e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="@typeCode">(CDA relatedDocument (Cartella Clinica)): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA relatedDocument (Cartella Clinica)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:parentDocument) &gt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:parentDocument is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:parentDocument) &lt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:parentDocument appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
         id="d8880e603-false-d10552e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(CDA relatedDocument (Cartella Clinica)): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA relatedDocument (Cartella Clinica)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:id) &gt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:code) &lt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:text) &lt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:setId) &lt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="count(hl7:versionNumber) &lt;= 1">(CDA relatedDocument (Cartella Clinica)): element hl7:versionNumber appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
         id="d8880e626-false-d10598e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="@root">(CDA relatedDocument (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocument (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="@extension">(CDA relatedDocument (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA relatedDocument (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA relatedDocument (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
         id="d8880e635-false-d10619e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="@code">(CDA relatedDocument (Cartella Clinica)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA relatedDocument (Cartella Clinica)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="@codeSystem">(CDA relatedDocument (Cartella Clinica)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(CDA relatedDocument (Cartella Clinica)): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA relatedDocument (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.868-2025-11-17T142426.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA relatedDocument (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:text
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:setId
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.868
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:versionNumber
Item: (CDA relatedDocument (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]"
         id="d10661e15-false-d10761e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(CDA componentOf (Cartella Clinica)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:encompassingEncounter) &gt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:encompassingEncounter is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:encompassingEncounter) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:encompassingEncounter appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter"
         id="d10661e22-false-d10967e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@classCode) = ('ENC') or not(@classCode)">(CDA componentOf (Cartella Clinica)): The value for classCode SHALL be 'ENC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA componentOf (Cartella Clinica)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:effectiveTime) &gt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:responsibleParty) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:responsibleParty appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:location[hl7:healthCareFacility]) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:location[hl7:healthCareFacility] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:id
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:id"
         id="d10661e25-false-d11109e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@root">(CDA componentOf (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@extension">(CDA componentOf (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d10661e38-false-d11133e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA componentOf (Cartella Clinica)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.1 ActEncounterCode (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@code">(CDA componentOf (Cartella Clinica)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA componentOf (Cartella Clinica)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@codeSystem">(CDA componentOf (Cartella Clinica)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf (Cartella Clinica)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:effectiveTime
Item: (CDA componentOf (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty"
         id="d10661e89-false-d11223e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@typeCode) = ('RESP') or not(@typeCode)">(CDA componentOf (Cartella Clinica)): The value for typeCode SHALL be 'RESP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity
Item: (CDA componentOf (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr">
      <extends rule="d11579e0-false-d11585e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d11579e0-false-d11585e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d12068e0-false-d12074e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d12068e0-false-d12074e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d12232e0-false-d12268e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d12232e0-false-d12268e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d12438e0-false-d12442e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d12438e0-false-d12442e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d12608e0-false-d12614e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d12608e0-false-d12614e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d12772e0-false-d12808e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d12772e0-false-d12808e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]"
         id="d10661e107-false-d13028e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@typeCode) = ('LOC') or not(@typeCode)">(CDA componentOf (Cartella Clinica)): The value for typeCode SHALL be 'LOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:healthCareFacility) &gt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:healthCareFacility is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:healthCareFacility) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:healthCareFacility appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility"
         id="d10661e145-false-d13136e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@classCode) = ('SDLOC') or not(@classCode)">(CDA componentOf (Cartella Clinica)): The value for classCode SHALL be 'SDLOC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:location) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:location appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="count(hl7:serviceProviderOrganization[@classCode = 'ORG']) &lt;= 1">(CDA componentOf (Cartella Clinica)): element hl7:serviceProviderOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:id
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:id"
         id="d10661e166-false-d13217e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@root">(CDA componentOf (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@extension">(CDA componentOf (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA componentOf (Cartella Clinica))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d10661e174-false-d13241e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA componentOf (Cartella Clinica)): The element value SHALL be one of '2.16.840.1.113883.1.11.17660 ServiceDeliveryLocationRoleType (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@code">(CDA componentOf (Cartella Clinica)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA componentOf (Cartella Clinica)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="@codeSystem">(CDA componentOf (Cartella Clinica)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf (Cartella Clinica)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA componentOf (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location
Item: (CDA componentOf (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location">
      <extends rule="d13304e0-false-d13319e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA componentOf (Cartella Clinica)): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.839-2025-11-03T160059.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA componentOf (Cartella Clinica)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location
Item: (CDA place )
-->
   <rule fpi="RULC-1" id="d13304e0-false-d13319e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="count(hl7:name) &lt;= 1">(CDA place ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="count(hl7:addr) &lt;= 1">(CDA place ): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:templateId
Item: (CDA place )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:name
Item: (CDA place )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr
Item: (CDA place )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr">
      <extends rule="d13401e0-false-d13407e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="@use">(CDA place ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA place ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d13401e0-false-d13407e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.839
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']
Item: (CDA componentOf (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d13726e0-false-d13732e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d13726e0-false-d13732e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d13890e0-false-d13926e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d13890e0-false-d13926e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d14096e0-false-d14100e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d14096e0-false-d14100e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d14266e0-false-d14272e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d14266e0-false-d14272e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d14430e0-false-d14466e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d14430e0-false-d14466e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]"
         id="d45e411-false-d14822e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP')">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@contextConductionInd) = ('true')">(Cartella Clinica): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']) &gt;= 1">(Cartella Clinica): element hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']) &lt;= 1">(Cartella Clinica): element hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']
Item: (Cartella Clinica)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']"
         id="d45e414-false-d15206e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@moodCode) = ('EVN')">(Cartella Clinica): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@classCode) = ('DOCBODY')">(Cartella Clinica): The value for classCode SHALL be 'DOCBODY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.845']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.843']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.842']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.841']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.864']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.863']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.862']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.861']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]]) &lt;= 1">(Cartella Clinica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.860']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.848']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]">
      <extends rule="d15595e0-false-d15599e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]
Item: ( Inquadramento clinico (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d15595e0-false-d15599e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]) &gt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]) &lt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]
Item: ( Inquadramento clinico (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']) &gt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']) &lt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:title) &lt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:text) &gt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="count(hl7:text) &lt;= 1">( Inquadramento clinico (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']
Item: ( Inquadramento clinico (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.851')">( Inquadramento clinico (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.851'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: ( Inquadramento clinico (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:code[(@code = '47039-3' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="string(@code) = ('47039-3')">( Inquadramento clinico (Cartella Clinica)): The value for code SHALL be '47039-3'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">( Inquadramento clinico (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">( Inquadramento clinico (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">( Inquadramento clinico (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="string(@displayName) = ('Ricovero, anamnesi e visita medica') or not(@displayName)">( Inquadramento clinico (Cartella Clinica)): The value for displayName SHALL be 'Ricovero, anamnesi e visita medica'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.851-2025-11-06T152624.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">( Inquadramento clinico (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:title
Item: ( Inquadramento clinico (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:text
Item: ( Inquadramento clinico (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.851
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]
Item: ( Inquadramento clinico (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@value">(author (Cartella Clinica)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@root">(author (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@extension">(author (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.851']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]">
      <extends rule="d16074e0-false-d16078e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]
Item: (Accertamento assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d16074e0-false-d16078e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]) &gt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]) &lt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]
Item: (Accertamento assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']) &gt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']) &lt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:title) &lt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:text) &gt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="count(hl7:text) &lt;= 1">(Accertamento assistenziale (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']
Item: (Accertamento assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.844')">(Accertamento assistenziale (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.844'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Accertamento assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:code[(@code = '67851-6' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="string(@code) = ('67851-6')">(Accertamento assistenziale (Cartella Clinica)): The value for code SHALL be '67851-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Accertamento assistenziale (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Accertamento assistenziale (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Accertamento assistenziale (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="string(@displayName) = ('Ricovero, nota di valutazione') or not(@displayName)">(Accertamento assistenziale (Cartella Clinica)): The value for displayName SHALL be 'Ricovero, nota di valutazione'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.844-2025-11-06T145606.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Accertamento assistenziale (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:title
Item: (Accertamento assistenziale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:text
Item: (Accertamento assistenziale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.844
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]
Item: (Accertamento assistenziale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@value">(author (Cartella Clinica)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@root">(author (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@extension">(author (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.844']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]">
      <extends rule="d16553e0-false-d16557e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]
Item: (Allergie e intolleranze (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d16553e0-false-d16557e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]) &gt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]) &lt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]
Item: (Allergie e intolleranze (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']) &gt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']) &lt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:title) &lt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:text) &gt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="count(hl7:text) &lt;= 1">(Allergie e intolleranze (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']
Item: (Allergie e intolleranze (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.852')">(Allergie e intolleranze (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.852'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Allergie e intolleranze (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="string(@code) = ('48765-2')">(Allergie e intolleranze (Cartella Clinica)): The value for code SHALL be '48765-2'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Allergie e intolleranze (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Allergie e intolleranze (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie e intolleranze (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="string(@displayName) = ('Allergie &amp;o reazioni avverse') or not(@displayName)">(Allergie e intolleranze (Cartella Clinica)): The value for displayName SHALL be 'Allergie &amp;o reazioni avverse'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.852-2025-11-06T153215.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie e intolleranze (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:title
Item: (Allergie e intolleranze (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:text
Item: (Allergie e intolleranze (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.852
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]
Item: (Allergie e intolleranze (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@value">(author (Cartella Clinica)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@root">(author (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@extension">(author (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.852']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]">
      <extends rule="d17032e0-false-d17036e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]
Item: (Processo Terapeutico  (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d17032e0-false-d17036e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]) &gt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]) &lt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]
Item: (Processo Terapeutico  (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']) &gt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']) &lt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:title) &lt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:text) &gt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="count(hl7:text) &lt;= 1">(Processo Terapeutico  (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']
Item: (Processo Terapeutico  (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.853')">(Processo Terapeutico  (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.853'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Processo Terapeutico  (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:code[(@code = '84172-6' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="string(@code) = ('84172-6')">(Processo Terapeutico  (Cartella Clinica)): The value for code SHALL be '84172-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Processo Terapeutico  (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Processo Terapeutico  (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Processo Terapeutico  (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="string(@displayName) = ('Interdisciplinare, Piano di cura') or not(@displayName)">(Processo Terapeutico  (Cartella Clinica)): The value for displayName SHALL be 'Interdisciplinare, Piano di cura'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.853-2025-11-06T153846.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Processo Terapeutico  (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:title
Item: (Processo Terapeutico  (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:text
Item: (Processo Terapeutico  (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.853
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]
Item: (Processo Terapeutico  (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@value">(author (Cartella Clinica)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@root">(author (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@extension">(author (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.853']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]">
      <extends rule="d17511e0-false-d17515e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]
Item: ( Parametri (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d17511e0-false-d17515e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]) &gt;= 1">( Parametri (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]) &lt;= 1">( Parametri (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]
Item: ( Parametri (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']) &gt;= 1">( Parametri (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']) &lt;= 1">( Parametri (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">( Parametri (Cartella Clinica)): element hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">( Parametri (Cartella Clinica)): element hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:title) &lt;= 1">( Parametri (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:text) &gt;= 1">( Parametri (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="count(hl7:text) &lt;= 1">( Parametri (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']
Item: ( Parametri (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.854')">( Parametri (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.854'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: ( Parametri (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="string(@code) = ('8716-3')">( Parametri (Cartella Clinica)): The value for code SHALL be '8716-3'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">( Parametri (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">( Parametri (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">( Parametri (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="string(@displayName) = ('Parametri Vitali') or not(@displayName)">( Parametri (Cartella Clinica)): The value for displayName SHALL be 'Parametri Vitali'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.854-2025-11-06T154314.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">( Parametri (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:title
Item: ( Parametri (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:text
Item: ( Parametri (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.854
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]
Item: ( Parametri (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@value">(author (Cartella Clinica)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@root">(author (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@extension">(author (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.854']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <extends rule="d17990e0-false-d17994e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d17990e0-false-d17994e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:templateId) &gt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:templateId is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:templateId) &lt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:templateId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:title) &lt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:text) &gt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="count(hl7:text) &lt;= 1">(Piano riabilitativo individuale PRI (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.855') or not(@root)">(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.855'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="string(@code) = ('83734-4')">(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for code SHALL be '83734-4'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Piano riabilitativo individuale PRI (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="string(@displayName) = ('Medicina fisica e riabilitazione.interdisciplinare, Piano di cura') or not(@displayName)">(Piano riabilitativo individuale PRI (Cartella Clinica)): The value for displayName SHALL be 'Medicina fisica e riabilitazione.interdisciplinare, Piano di cura'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.855-2025-11-06T155425.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Piano riabilitativo individuale PRI (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:title
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.855
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]
Item: (Piano riabilitativo individuale PRI (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@value">(author (Cartella Clinica)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@root">(author (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@extension">(author (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '83734-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]">
      <extends rule="d18467e0-false-d18471e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]
Item: (Piano assistenziale individuale (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d18467e0-false-d18471e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]) &gt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]) &lt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]
Item: (Piano assistenziale individuale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']) &gt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']) &lt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:title) &lt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:text) &gt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="count(hl7:text) &lt;= 1">(Piano assistenziale individuale (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']
Item: (Piano assistenziale individuale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.856')">(Piano assistenziale individuale (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.856'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Piano assistenziale individuale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:code[(@code = '101541-1' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="string(@code) = ('101541-1')">(Piano assistenziale individuale (Cartella Clinica)): The value for code SHALL be '101541-1'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Piano assistenziale individuale (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Piano assistenziale individuale (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Piano assistenziale individuale (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="string(@displayName) = ('Piano Assistenziale Individuale') or not(@displayName)">(Piano assistenziale individuale (Cartella Clinica)): The value for displayName SHALL be 'Piano Assistenziale Individuale'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.856-2025-11-06T155901.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Piano assistenziale individuale (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:title
Item: (Piano assistenziale individuale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:text
Item: (Piano assistenziale individuale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.856
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]
Item: (Piano assistenziale individuale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@value">(author (Cartella Clinica)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@root">(author (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@extension">(author (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.856']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]">
      <extends rule="d18949e0-false-d18953e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]
Item: (Consensi (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d18949e0-false-d18953e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]) &gt;= 1">(Consensi (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]) &lt;= 1">(Consensi (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]
Item: (Consensi (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']) &gt;= 1">(Consensi (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']) &lt;= 1">(Consensi (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Consensi (Cartella Clinica)): element hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Consensi (Cartella Clinica)): element hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:title) &lt;= 1">(Consensi (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:text) &gt;= 1">(Consensi (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="count(hl7:text) &lt;= 1">(Consensi (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']
Item: (Consensi (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.865')">(Consensi (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.865'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Consensi (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:code[(@code = '59284-0' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="string(@code) = ('59284-0')">(Consensi (Cartella Clinica)): The value for code SHALL be '59284-0'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Consensi (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Consensi (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Consensi (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="string(@displayName) = ('Consenso') or not(@displayName)">(Consensi (Cartella Clinica)): The value for displayName SHALL be 'Consenso'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Consensi (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:title
Item: (Consensi (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:text
Item: (Consensi (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]
Item: (Consensi (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@value">(author (Cartella Clinica)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@root">(author (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@extension">(author (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.865
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]]
Item: (Consensi (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]]">
      <extends rule="d19440e0-false-d19444e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Consensi (Cartella Clinica)): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.865-2025-11-14T164851.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Consensi (Cartella Clinica)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.866
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]]
Item: (observationMedia (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d19440e0-false-d19444e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]) &gt;= 1">(observationMedia (Cartella Clinica)): element hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]) &lt;= 1">(observationMedia (Cartella Clinica)): element hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.866
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]
Item: (observationMedia (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(observationMedia (Cartella Clinica)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(observationMedia (Cartella Clinica)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']) &gt;= 1">(observationMedia (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']) &lt;= 1">(observationMedia (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:value) &gt;= 1">(observationMedia (Cartella Clinica)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="count(hl7:value) &lt;= 1">(observationMedia (Cartella Clinica)): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.866
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']
Item: (observationMedia (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.802')">(observationMedia (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.802'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.866
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]/hl7:value
Item: (observationMedia (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.865']]/hl7:entry[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.802']]/hl7:value">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s')))">(observationMedia (Cartella Clinica)): Attribute @xsi:type SHALL be of data type 'cs'  - '<value-of select="@xsi:type"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="not(@mediaType) or string-length(@mediaType)&gt;0">(observationMedia (Cartella Clinica)): Attribute @mediaType SHALL be of data type 'st'  - '<value-of select="@mediaType"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.866-2025-11-14T170032.html"
              test="not(@representation) or (string-length(@representation) &gt; 0 and not(matches(@representation,'\s')))">(observationMedia (Cartella Clinica)): Attribute @representation SHALL be of data type 'cs'  - '<value-of select="@representation"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]">
      <extends rule="d19543e0-false-d19547e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]
Item: (Richieste (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d19543e0-false-d19547e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]) &gt;= 1">(Richieste (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]) &lt;= 1">(Richieste (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]
Item: (Richieste (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']) &gt;= 1">(Richieste (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']) &lt;= 1">(Richieste (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Richieste (Cartella Clinica)): element hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Richieste (Cartella Clinica)): element hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:title) &lt;= 1">(Richieste (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:text) &gt;= 1">(Richieste (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="count(hl7:text) &lt;= 1">(Richieste (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']
Item: (Richieste (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.857')">(Richieste (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.857'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Richieste (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:code[(@code = '11487-6' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="string(@code) = ('11487-6')">(Richieste (Cartella Clinica)): The value for code SHALL be '11487-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Richieste (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Richieste (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Richieste (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="string(@displayName) = ('Richiesta consulto') or not(@displayName)">(Richieste (Cartella Clinica)): The value for displayName SHALL be 'Richiesta consulto'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.857-2025-11-06T160312.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Richieste (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:title
Item: (Richieste (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:text
Item: (Richieste (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.857
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]
Item: (Richieste (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@value">(author (Cartella Clinica)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@root">(author (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@extension">(author (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.857']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]">
      <extends rule="d20022e0-false-d20026e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]
Item: (Diario clinico assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d20022e0-false-d20026e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]) &gt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]) &lt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]
Item: (Diario clinico assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']) &gt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']) &lt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:title) &lt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:text) &gt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="count(hl7:text) &lt;= 1">(Diario clinico assistenziale (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']
Item: (Diario clinico assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.849')">(Diario clinico assistenziale (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.849'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Diario clinico assistenziale (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:code[(@code = '11506-3' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="string(@code) = ('11506-3')">(Diario clinico assistenziale (Cartella Clinica)): The value for code SHALL be '11506-3'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Diario clinico assistenziale (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Diario clinico assistenziale (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Diario clinico assistenziale (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="string(@displayName) = ('Progresso, nota') or not(@displayName)">(Diario clinico assistenziale (Cartella Clinica)): The value for displayName SHALL be 'Progresso, nota'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.849-2025-11-06T152231.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Diario clinico assistenziale (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:title
Item: (Diario clinico assistenziale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:text
Item: (Diario clinico assistenziale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.849
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]
Item: (Diario clinico assistenziale (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@value">(author (Cartella Clinica)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@root">(author (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@extension">(author (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.849']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]">
      <extends rule="d20501e0-false-d20505e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]
Item: (Doc dispositivi impiantati o utilizzati (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d20501e0-false-d20505e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]) &gt;= 1">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]) &lt;= 1">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]
Item: (Doc dispositivi impiantati o utilizzati (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']) &gt;= 1">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']) &lt;= 1">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:title) &lt;= 1">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:text) &gt;= 1">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="count(hl7:text) &lt;= 1">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']
Item: (Doc dispositivi impiantati o utilizzati (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.847')">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.847'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Doc dispositivi impiantati o utilizzati (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:code[(@code = '108277-5' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="string(@code) = ('108277-5')">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): The value for code SHALL be '108277-5'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="string(@displayName) = ('Implanted device note') or not(@displayName)">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): The value for displayName SHALL be 'Implanted device note'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.847-2025-11-06T151741.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Doc dispositivi impiantati o utilizzati (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:title
Item: (Doc dispositivi impiantati o utilizzati (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:text
Item: (Doc dispositivi impiantati o utilizzati (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.847
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]
Item: (Doc dispositivi impiantati o utilizzati (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@value">(author (Cartella Clinica)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@root">(author (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@extension">(author (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.847']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.18.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]
Item: (Cartella Clinica)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]">
      <extends rule="d20980e0-false-d20984e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.2.9.10.1.18.1-2025-11-03T155017.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Cartella Clinica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]
Item: (Lesioni e ferite (Cartella Clinica))
-->
   <rule fpi="RULC-1" id="d20980e0-false-d20984e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]) &gt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]) &lt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]
Item: (Lesioni e ferite (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']) &gt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']) &lt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]) &gt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]) &lt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:title) &lt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:text) &gt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="count(hl7:text) &lt;= 1">(Lesioni e ferite (Cartella Clinica)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']
Item: (Lesioni e ferite (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.846')">(Lesioni e ferite (Cartella Clinica)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.846'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]
Item: (Lesioni e ferite (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="string(@code) = ('46215-0') or not(@code)">(Lesioni e ferite (Cartella Clinica)): The value for code SHALL be '46215-0'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Lesioni e ferite (Cartella Clinica)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Lesioni e ferite (Cartella Clinica)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Lesioni e ferite (Cartella Clinica)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="string(@displayName) = ('Ferita, gestione della cura') or not(@displayName)">(Lesioni e ferite (Cartella Clinica)): The value for displayName SHALL be 'Ferita, gestione della cura'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.846-2025-11-06T151044.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Lesioni e ferite (Cartella Clinica)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:title
Item: (Lesioni e ferite (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:text
Item: (Lesioni e ferite (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.846
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]
Item: (Lesioni e ferite (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(author (Cartella Clinica)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(author (Cartella Clinica)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &gt;= 1">(author (Cartella Clinica)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:time) &lt;= 1">(author (Cartella Clinica)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@value">(author (Cartella Clinica)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(author (Cartella Clinica)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:id) &gt;= 1">(author (Cartella Clinica)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="count(hl7:assignedPerson) &lt;= 1">(author (Cartella Clinica)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (author (Cartella Clinica))
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@root">(author (Cartella Clinica)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(author (Cartella Clinica)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="@extension">(author (Cartella Clinica)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@extension) or string-length(@extension)&gt;0">(author (Cartella Clinica)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.859-2025-11-12T092557.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(author (Cartella Clinica)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.859
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (author (Cartella Clinica))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.18 .1'][@extension = '1.0']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.846']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251118T162323/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test=