<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:hl7="urn:hl7-org:v3"
                xmlns:cda="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:sdtc="urn:hl7-org:sdtc"
                xmlns:pharm="urn:ihe:pharm:medication"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
   <xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


   <!--PROLOG-->
   <xsl:output method="text"/>

   <!--XSD TYPES FOR XSLT2-->


   <!--KEYS AND FUNCTIONS-->


   <!--DEFAULT RULES-->


   <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
   <!--This mode can be used to generate prefixed XPath for humans-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
   <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
   <xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
   <xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters-->
   <xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
   <xsl:template match="/">
      <xsl:apply-templates select="/" mode="M9"/>
      <xsl:apply-templates select="/" mode="M10"/>
      <xsl:apply-templates select="/" mode="M11"/>
      <xsl:apply-templates select="/" mode="M12"/>
      <xsl:apply-templates select="/" mode="M28"/>
      <xsl:apply-templates select="/" mode="M29"/>
      <xsl:apply-templates select="/" mode="M30"/>
      <xsl:apply-templates select="/" mode="M31"/>
      <xsl:apply-templates select="/" mode="M32"/>
      <xsl:apply-templates select="/" mode="M33"/>
      <xsl:apply-templates select="/" mode="M34"/>
      <xsl:apply-templates select="/" mode="M35"/>
      <xsl:apply-templates select="/" mode="M36"/>
      <xsl:apply-templates select="/" mode="M37"/>
      <xsl:apply-templates select="/" mode="M38"/>
      <xsl:apply-templates select="/" mode="M39"/>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->
   <xsl:param name="scenariolabel" select="'2.16.840.1.113883.3.1937.777.63.4.32'"/>

   <!--PATTERN -->
   <xsl:template match="text()" priority="-1" mode="M9"/>
   <xsl:template match="@*|node()" priority="-2" mode="M9">
      <xsl:apply-templates select="*" mode="M9"/>
   </xsl:template>

   <!--PATTERN CDAClinicalDocument-->


	  <!--RULE -->
   <xsl:template match="/" priority="1000" mode="M10">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']] (descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M10"/>
   <xsl:template match="@*|node()" priority="-2" mode="M10">
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915Profilo_Sanitario_Sintetico-->


	  <!--RULE d45e21-false-d753e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]"
                 priority="1654"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('DOCCLIN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:realmCode[@code = 'IT']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:realmCode[@code = 'IT'] is required [min 1x]. (count(hl7:realmCode[@code = 'IT']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] is required [min 1x]. (count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] appears too often [max 1x]. (count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@code = '60591-5']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:code[@code = '60591-5'] is required [min 1x]. (count(hl7:code[@code = '60591-5']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@code = '60591-5']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:code[@code = '60591-5'] appears too often [max 1x]. (count(hl7:code[@code = '60591-5']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:effectiveTime is required [min 1x]. (count(hl7:effectiveTime) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N'] is required [min 1x]. (count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N'] appears too often [max 1x]. (count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:languageCode is required [min 1x]. (count(hl7:languageCode) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:languageCode appears too often [max 1x]. (count(hl7:languageCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:setId appears too often [max 1x]. (count(hl7:setId) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:versionNumber appears too often [max 1x]. (count(hl7:versionNumber) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:recordTarget[hl7:patientRole] is required [min 1x]. (count(hl7:recordTarget[hl7:patientRole]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:recordTarget[hl7:patientRole] appears too often [max 1x]. (count(hl7:recordTarget[hl7:patientRole]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:author[hl7:assignedAuthor] is required [min 1x]. (count(hl7:author[hl7:assignedAuthor]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:author[hl7:assignedAuthor]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:author[hl7:assignedAuthor] appears too often [max 1x]. (count(hl7:author[hl7:assignedAuthor]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:dataEnterer[hl7:assignedEntity]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:dataEnterer[hl7:assignedEntity] appears too often [max 1x]. (count(hl7:dataEnterer[hl7:assignedEntity]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:custodian[hl7:assignedCustodian] is required [min 1x]. (count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x]. (count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x]. (count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:authenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:authenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x]. (count(hl7:authenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:documentationOf[hl7:serviceEvent]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:documentationOf[hl7:serviceEvent] is required [min 1x]. (count(hl7:documentationOf[hl7:serviceEvent]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:documentationOf[hl7:serviceEvent]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:documentationOf[hl7:serviceEvent] appears too often [max 1x]. (count(hl7:documentationOf[hl7:serviceEvent]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x]. (count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:structuredBody]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:structuredBody] is required [min 1x]. (count(hl7:component[hl7:structuredBody]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:structuredBody]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:structuredBody] appears too often [max 1x]. (count(hl7:component[hl7:structuredBody]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e29-false-d1519e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:realmCode[@code = 'IT']"
                 priority="1653"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('IT')"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for code SHALL be 'IT'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('IT') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e40-false-d1533e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']"
                 priority="1652"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.1.3')"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.1.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('POCD_MT000040UV02')"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>" (string(@extension) = ('POCD_MT000040UV02') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e53-false-d1552e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']"
                 priority="1651"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.1.1')"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.1.1'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.4.1.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('1.5')"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for extension SHALL be '1.5'. Found: "<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>" (string(@extension) = ('1.5') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e66-false-d1570e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:id"
                 priority="1650"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e90-false-d1592e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:code[@code = '60591-5']"
                 priority="1649"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('60591-5')"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for code SHALL be '60591-5'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('60591-5') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1') or not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') or not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Profilo Sanitario Sintetico') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for displayName SHALL be 'Profilo Sanitario Sintetico'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Profilo Sanitario Sintetico') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e101-false-d1626e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:code[@code = '60591-5']/hl7:translation"
                 priority="1648"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e143-false-d1661e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:effectiveTime"
                 priority="1647"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e159-false-d1677e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N']"
                 priority="1646"
                 mode="M11">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (@code='V' and @displayName='Very Restricted') or (@code='N' and @displayName='Normal') or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The element value SHALL be one of 'code 'V' displayName='Very Restricted' or code 'N' displayName='Normal' or 2.16.840.1.113883.1.11.16926 x_BasicConfidentialityKind (DYNAMIC)'. (@nullFlavor or (@code='V' and @displayName='Very Restricted') or (@code='N' and @displayName='Normal') or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.25')"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for codeSystem SHALL be '2.16.840.1.113883.5.25'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.5.25') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('HL7 Confidentiality')"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for codeSystemName SHALL be 'HL7 Confidentiality'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('HL7 Confidentiality') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e178-false-d1716e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:languageCode"
                 priority="1645"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e194-false-d1729e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:setId"
                 priority="1644"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e218-false-d1750e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:versionNumber"
                 priority="1643"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): Attribute @value is not a valid int number <xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>
       (not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1757e11-false-d1859e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]"
                 priority="1642"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('RCT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for typeCode SHALL be 'RCT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('RCT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[hl7:patient]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:patientRole[hl7:patient] is required [min 1x]. (count(hl7:patientRole[hl7:patient]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[hl7:patient]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:patientRole[hl7:patient] appears too often [max 1x]. (count(hl7:patientRole[hl7:patient]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1757e23-false-d2073e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]"
                 priority="1641"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PAT') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for classCode SHALL be 'PAT'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PAT') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:addr is required [min 1x]. (count(hl7:addr) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']] is required [min 1x]. (count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']] appears too often [max 1x]. (count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:providerOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1757e33-false-d2211e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id"
                 priority="1640"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr"
                 priority="1639"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr PSS_v2): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr PSS_v2): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr PSS_v2): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr PSS_v2): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr PSS_v2): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr PSS_v2): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr PSS_v2): element hl7:censusTract is required [min 1x]. (count(hl7:censusTract) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr PSS_v2): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr PSS_v2): element hl7:postalCode is required [min 1x]. (count(hl7:postalCode) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr PSS_v2): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr PSS_v2): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr PSS_v2): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1757e198-false-d2387e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom"
                 priority="1637"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or string-length(@value)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1757e224-false-d2472e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]"
                 priority="1636"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PSN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1'] is required [min 1x]. (count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1'] appears too often [max 1x]. (count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:birthTime is required [min 1x]. (count(hl7:birthTime) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:birthTime appears too often [max 1x]. (count(hl7:birthTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthPlace[hl7:place]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:birthPlace[hl7:place] is required [min 1x]. (count(hl7:birthPlace[hl7:place]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthPlace[hl7:place]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:birthPlace[hl7:place] appears too often [max 1x]. (count(hl7:birthPlace[hl7:place]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1757e230-false-d2581e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:name"
                 priority="1635"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1757e272-false-d2622e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']"
                 priority="1634"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.1' AdministrativeGender (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.1')"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for codeSystem SHALL be '2.16.840.1.113883.5.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.5.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('HL7 AdministrativeGender') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for codeSystemName SHALL be 'HL7 AdministrativeGender'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('HL7 AdministrativeGender') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1757e318-false-d2717e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian"
                 priority="1633"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardianPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:guardianPerson appears too often [max 1x]. (count(hl7:guardianPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:guardianOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1757e320-false-d2806e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:id"
                 priority="1632"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1757e329-false-d2827e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:code"
                 priority="1631"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:addr"
                 priority="1630"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianPerson"
                 priority="1629"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PSN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianPerson/hl7:name"
                 priority="1627"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']"
                 priority="1626"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1625"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1624"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1623"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1621"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1619"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1618"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1617"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1615"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1614"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1613"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1611"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1609"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1608"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1607"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1757e372-false-d4278e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:birthPlace[hl7:place]"
                 priority="1606"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or string-length(@classCode) &gt; 0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @classCode SHALL be of data type 'set_cs'  - '<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>' (not(@classCode) or string-length(@classCode) &gt; 0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:place is required [min 1x]. (count(hl7:place) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:place appears too often [max 1x]. (count(hl7:place) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d1757e385-false-d4313e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:birthPlace[hl7:place]/hl7:place"
                 priority="1605"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PLC') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for classCode SHALL be 'PLC'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PLC') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr[hl7:country]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:addr[hl7:country] is required [min 1x]. (count(hl7:addr[hl7:country]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr[hl7:country]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): element hl7:addr[hl7:country] appears too often [max 1x]. (count(hl7:addr[hl7:country]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:birthPlace[hl7:place]/hl7:place/hl7:addr[hl7:country]"
                 priority="1604"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (PSS)): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (PSS)): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (PSS)): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (PSS)): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (PSS)): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (PSS)): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace (PSS)): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']"
                 priority="1603"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @classCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>' (not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget (PSS)V2): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1601"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1600"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1599"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1597"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1595"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1594"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1593"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1591"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1590"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1589"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1587"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1585"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1584"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1583"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d4505e409-false-d5650e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]"
                 priority="1582"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): element hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']] is required [min 1x]. (count(hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): element hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']] appears too often [max 1x]. (count(hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d4505e430-false-d5788e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]"
                 priority="1581"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2'] is required [min 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.13']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.13'] appears too often [max 1x]. (count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.13']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): element hl7:telecom is required [min 1x]. (count(hl7:telecom) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): element hl7:assignedPerson is required [min 1x]. (count(hl7:assignedPerson) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d4505e461-false-d5888e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']"
                 priority="1580"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.4.3.2')"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.2'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.4.3.2') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d4505e492-false-d5909e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.13']"
                 priority="1579"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.51-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.51' assignedAuthorCode_PSSIT (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.51-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.2.9.77.22.11.13')"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.77.22.11.13'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.2.9.77.22.11.13') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:addr"
                 priority="1578"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d4505e523-false-d6096e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:telecom"
                 priority="1576"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedPerson"
                 priority="1575"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PSN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author PSS_v2): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedPerson/hl7:name"
                 priority="1573"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1572"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1571"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1570"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1569"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1567"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1565"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1564"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1563"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1561"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1560"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1559"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1557"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1555"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1554"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1553"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d6300e397-false-d7440e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]"
                 priority="1552"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('ENT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA dataEntererPSS): The value for typeCode SHALL be 'ENT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('ENT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA dataEntererPSS): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA dataEntererPSS): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA dataEntererPSS): element hl7:assignedEntity is required [min 1x]. (count(hl7:assignedEntity) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA dataEntererPSS): element hl7:assignedEntity appears too often [max 1x]. (count(hl7:assignedEntity) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d6300e409-false-d7519e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:time"
                 priority="1551"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDA dataEntererPSS): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(CDA dataEntererPSS): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity"
                 priority="1550"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x]. (count(hl7:telecom) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id"
                 priority="1549"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code"
                 priority="1548"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr"
                 priority="1547"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom"
                 priority="1545"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1544"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1543"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1542"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1541"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1540"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1539"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1537"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1535"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1534"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1533"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1531"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1530"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1529"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1527"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1525"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1524"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1523"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d7586e555-false-d9233e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:informant"
                 priority="1522"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA informant PSS): element hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']] appears too often [max 1x]. (count(hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d7586e557-false-d9261e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:informant/hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]"
                 priority="1521"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA informant PSS): Attribute @classCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>' (not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA informant PSS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2'] is required [min 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA informant PSS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2'] appears too often [max 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:relatedPerson[hl7:name]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA informant PSS): element hl7:relatedPerson[hl7:name] appears too often [max 1x]. (count(hl7:relatedPerson[hl7:name]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d7586e568-false-d9294e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:informant/hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']"
                 priority="1520"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.4.3.2')"/>
         <xsl:otherwise>
            <xsl:message>(CDA informant PSS): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.2'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.4.3.2') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA informant PSS): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assignedAuthorityName) or string-length(@assignedAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA informant PSS): Attribute @assignedAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assignedAuthorityName"/>
               <xsl:text/>' (not(@assignedAuthorityName) or string-length(@assignedAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d7586e577-false-d9318e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:informant/hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:relatedPerson[hl7:name]"
                 priority="1519"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA informant PSS): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA informant PSS): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:informant/hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:relatedPerson[hl7:name]/hl7:name"
                 priority="1518"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d9351e46-false-d9445e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]"
                 priority="1517"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('CST') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): The value for typeCode SHALL be 'CST'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('CST') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x]. (count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x]. (count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d9351e56-false-d9495e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]"
                 priority="1516"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization[hl7:name]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): element hl7:representedCustodianOrganization[hl7:name] is required [min 1x]. (count(hl7:representedCustodianOrganization[hl7:name]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization[hl7:name]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): element hl7:representedCustodianOrganization[hl7:name] appears too often [max 1x]. (count(hl7:representedCustodianOrganization[hl7:name]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d9351e66-false-d9545e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[hl7:name]"
                 priority="1515"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d9351e72-false-d9602e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[hl7:name]/hl7:id"
                 priority="1514"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[hl7:name]/hl7:name"
                 priority="1513"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d9351e112-false-d9712e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[hl7:name]/hl7:telecom"
                 priority="1512"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or string-length(@value)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[hl7:name]/hl7:addr"
                 priority="1511"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian PSS): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d9754e71-false-d9942e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
                 priority="1509"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('LA') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator PSS): The value for typeCode SHALL be 'LA'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('LA') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator PSS): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator PSS): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator PSS): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator PSS): element hl7:signatureCode[@code = 'S'] is required [min 1x]. (count(hl7:signatureCode[@code = 'S']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator PSS): element hl7:signatureCode[@code = 'S'] appears too often [max 1x]. (count(hl7:signatureCode[@code = 'S']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator PSS): element hl7:assignedEntity is required [min 1x]. (count(hl7:assignedEntity) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator PSS): element hl7:assignedEntity appears too often [max 1x]. (count(hl7:assignedEntity) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d9754e83-false-d10032e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time"
                 priority="1508"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator PSS): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator PSS): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d9754e112-false-d10046e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
                 priority="1507"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('S')"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator PSS): The value for code SHALL be 'S'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('S') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity"
                 priority="1506"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x]. (count(hl7:telecom) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id"
                 priority="1505"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code"
                 priority="1504"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr"
                 priority="1503"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom"
                 priority="1501"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1500"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1499"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1498"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1497"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1496"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1495"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1493"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1491"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1490"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1489"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1487"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1486"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1485"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1483"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1481"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1480"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1479"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d10111e564-false-d11802e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]"
                 priority="1478"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUTHEN') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticatorPSS): The value for typeCode SHALL be 'AUTHEN'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUTHEN') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticatorPSS): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticatorPSS): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticatorPSS): element hl7:signatureCode[@code = 'S'] is required [min 1x]. (count(hl7:signatureCode[@code = 'S']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticatorPSS): element hl7:signatureCode[@code = 'S'] appears too often [max 1x]. (count(hl7:signatureCode[@code = 'S']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticatorPSS): element hl7:assignedEntity is required [min 1x]. (count(hl7:assignedEntity) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticatorPSS): element hl7:assignedEntity appears too often [max 1x]. (count(hl7:assignedEntity) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d10111e574-false-d11888e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:time"
                 priority="1477"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticatorPSS): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticatorPSS): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d10111e590-false-d11902e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
                 priority="1476"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('S')"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticatorPSS): The value for code SHALL be 'S'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('S') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or string-length(@code)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticatorPSS): Attribute @code SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or string-length(@code)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity"
                 priority="1475"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x]. (count(hl7:telecom) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id"
                 priority="1474"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code"
                 priority="1473"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr"
                 priority="1472"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom"
                 priority="1470"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1469"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1468"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1467"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1466"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1465"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1464"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1462"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1460"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1459"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1458"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1456"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1455"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1454"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1452"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1450"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1449"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1448"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d11970e563-false-d13629e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]"
                 priority="1447"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@typeCode"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): attribute @typeCode SHALL be present. (@typeCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC). (not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity[@classCode]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): element hl7:associatedEntity[@classCode] is required [min 1x]. (count(hl7:associatedEntity[@classCode]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity[@classCode]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): element hl7:associatedEntity[@classCode] appears too often [max 1x]. (count(hl7:associatedEntity[@classCode]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d11970e697-false-d13714e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]"
                 priority="1446"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@classCode"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): attribute @classCode SHALL be present. (@classCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.19313' RoleClassAssociative (DYNAMIC). (not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): element hl7:associatedPerson appears too often [max 1x]. (count(hl7:associatedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d11970e704-false-d13781e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id"
                 priority="1445"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d11970e713-false-d13802e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code"
                 priority="1444"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@ codeSystemVersion) or string-length(@ codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): Attribute @ codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@ codeSystemVersion"/>
               <xsl:text/>' (not(@ codeSystemVersion) or string-length(@ codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr"
                 priority="1443"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d11970e734-false-d13980e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom"
                 priority="1441"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant PSS): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson"
                 priority="1440"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name"
                 priority="1439"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d14017e56-false-d14145e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:documentationOf[hl7:serviceEvent]"
                 priority="1438"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceEvent) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf PSS): element hl7:serviceEvent is required [min 1x]. (count(hl7:serviceEvent) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.409-2024-01-08T121009.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceEvent) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf PSS): element hl7:serviceEvent appears too often [max 1x]. (count(hl7:serviceEvent) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.409-2024-01-08T121009.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d14017e64-false-d14161e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent"
                 priority="1437"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf PSS): element hl7:effectiveTime is required [min 1x]. (count(hl7:effectiveTime) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.409-2024-01-08T121009.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf PSS): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.409-2024-01-08T121009.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d14017e66-false-d14177e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:effectiveTime"
                 priority="1436"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf PSS): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.409-2024-01-08T121009.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf PSS): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.409-2024-01-08T121009.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d14184e22-false-d14191e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
                 priority="1435"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@typeCode"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): attribute @typeCode SHALL be present. (@typeCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC). (not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:parentDocument) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): element hl7:parentDocument is required [min 1x]. (count(hl7:parentDocument) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:parentDocument) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): element hl7:parentDocument appears too often [max 1x]. (count(hl7:parentDocument) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d14184e112-false-d14222e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
                 priority="1434"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('DOCCLIN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): element hl7:setId appears too often [max 1x]. (count(hl7:setId) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): element hl7:versionNumber appears too often [max 1x]. (count(hl7:versionNumber) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d14184e118-false-d14268e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
                 priority="1433"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d14184e131-false-d14286e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
                 priority="1432"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@ codeSystemVersion) or string-length(@ codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): Attribute @ codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@ codeSystemVersion"/>
               <xsl:text/>' (not(@ codeSystemVersion) or string-length(@ codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument PSS): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.410-2024-01-08T123341.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e286-false-d14526e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]"
                 priority="1431"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
               <xsl:value-of select="@contextConductionInd"/>
               <xsl:text/>" (string(@contextConductionInd) = ('true') or not(@contextConductionInd) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:structuredBody) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:structuredBody is required [min 1x]. (count(hl7:structuredBody) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:structuredBody) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:structuredBody appears too often [max 1x]. (count(hl7:structuredBody) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE d45e289-false-d14928e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody"
                 priority="1430"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCBODY') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for classCode SHALL be 'DOCBODY'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('DOCBODY') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.1']]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.1']]] is required [min 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.1']]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.1']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.1']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.1']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.2']]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.2']]] is required [min 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.2']]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.2']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.2']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.2']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.3 ']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.3 ']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.3 ']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]] is required [min 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]] is required [min 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.8']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.8']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.8']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.9']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.9']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.9']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.10']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.10']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.10']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.11']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.11']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.11']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.12']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.12']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.12']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = ' 2.16.840.1.113883.2.9.10.1.4.2.13']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = ' 2.16.840.1.113883.2.9.10.1.4.2.13']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = ' 2.16.840.1.113883.2.9.10.1.4.2.13']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = ' 2.16.840.1.113883.2.9.10.1.4.2.14']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = ' 2.16.840.1.113883.2.9.10.1.4.2.14']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = ' 2.16.840.1.113883.2.9.10.1.4.2.14']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.15']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.15']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.15']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.17']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.17']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.17']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.18']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.18']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.18']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.1']]]"
                 priority="1429"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
               <xsl:value-of select="@contextConductionInd"/>
               <xsl:text/>" (string(@contextConductionInd) = ('true') or not(@contextConductionInd) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.2']]]"
                 priority="1428"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
               <xsl:value-of select="@contextConductionInd"/>
               <xsl:text/>" (string(@contextConductionInd) = ('true') or not(@contextConductionInd) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.3 ']]]"
                 priority="1427"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
               <xsl:value-of select="@contextConductionInd"/>
               <xsl:text/>" (string(@contextConductionInd) = ('true') or not(@contextConductionInd) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]]"
                 priority="1426"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
               <xsl:value-of select="@contextConductionInd"/>
               <xsl:text/>" (string(@contextConductionInd) = ('true') or not(@contextConductionInd) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]"
                 priority="1424"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '11450-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): element hl7:code[(@code = '11450-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '11450-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '11450-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): element hl7:code[(@code = '11450-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '11450-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): element hl7:title is required [min 1x]. (count(hl7:title) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): element hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']] is required [min 1x]. (count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']"
                 priority="1423"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.2.4')"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.2.4'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.4.2.4') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]/hl7:id"
                 priority="1422"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.4']]/hl7:code[(@code = '11450-4' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1421"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('11450-4')"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): The value for code SHALL be '11450-4'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('11450-4') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Lista dei Problemi (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.430-2024-01-11T145316.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]"
                 priority="1420"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
               <xsl:value-of select="@contextConductionInd"/>
               <xsl:text/>" (string(@contextConductionInd) = ('true') or not(@contextConductionInd) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]"
                 priority="1418"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): element hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): element hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): element hl7:title is required [min 1x]. (count(hl7:title) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]] | hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): choice (hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]  or  hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]) does not contain enough elements [min 1x] (count(hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]] | hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]] | hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): choice (hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]  or  hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]) contains too many elements [max 1x] (count(hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]] | hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): element hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]] appears too often [max 1x]. (count(hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']"
                 priority="1417"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.2.16')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.2.16'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.4.2.16') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:id"
                 priority="1416"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1415"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('10157-6')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): The value for code SHALL be '10157-6'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('10157-6') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.439-2024-01-12T180723.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]"
                 priority="1414"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']] is required [min 1x]. (count(hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']] appears too often [max 1x]. (count(hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]"
                 priority="1413"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('CLUSTER')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): The value for classCode SHALL be 'CLUSTER'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('CLUSTER') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:statusCode is required [min 1x]. (count(hl7:statusCode) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:subject[@typeCode = 'SBJ'][hl7:realtedSubject[@classCode = 'PRS']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:subject[@typeCode = 'SBJ'][hl7:realtedSubject[@classCode = 'PRS']] is required [min 1x]. (count(hl7:subject[@typeCode = 'SBJ'][hl7:realtedSubject[@classCode = 'PRS']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:subject[@typeCode = 'SBJ'][hl7:realtedSubject[@classCode = 'PRS']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:subject[@typeCode = 'SBJ'][hl7:realtedSubject[@classCode = 'PRS']] appears too often [max 1x]. (count(hl7:subject[@typeCode = 'SBJ'][hl7:realtedSubject[@classCode = 'PRS']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:observation[@moodCode = 'EVN']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:component[hl7:observation[@moodCode = 'EVN']] is required [min 1x]. (count(hl7:component[hl7:observation[@moodCode = 'EVN']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']"
                 priority="1412"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.16.1')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.16.1'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.16.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:id"
                 priority="1411"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1410"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('10157-6')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): The value for code SHALL be '10157-6'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('10157-6') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or matches(string(@codeSystemName), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): Attribute @codeSystemName SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or matches(string(@codeSystemName), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or matches(string(@displayName), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): Attribute @displayName SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or matches(string(@displayName), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:statusCode"
                 priority="1409"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.15933' ActStatus (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:subject[@typeCode = 'SBJ'][hl7:realtedSubject[@classCode = 'PRS']]"
                 priority="1408"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('SBJ')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): The value for typeCode SHALL be 'SBJ'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('SBJ') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:realtedSubject[@classCode = 'PRS'][hl7:subject]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:realtedSubject[@classCode = 'PRS'][hl7:subject] is required [min 1x]. (count(hl7:realtedSubject[@classCode = 'PRS'][hl7:subject]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:realtedSubject[@classCode = 'PRS'][hl7:subject]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:realtedSubject[@classCode = 'PRS'][hl7:subject] appears too often [max 1x]. (count(hl7:realtedSubject[@classCode = 'PRS'][hl7:subject]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:subject[@typeCode = 'SBJ'][hl7:realtedSubject[@classCode = 'PRS']]/hl7:realtedSubject[@classCode = 'PRS'][hl7:subject]"
                 priority="1407"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PRS')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): The value for classCode SHALL be 'PRS'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PRS') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:code is required [min 1x]. (count(hl7:code) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:subject[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:subject[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']] is required [min 1x]. (count(hl7:subject[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:subject[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:subject[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']] appears too often [max 1x]. (count(hl7:subject[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:subject[@typeCode = 'SBJ'][hl7:realtedSubject[@classCode = 'PRS']]/hl7:realtedSubject[@classCode = 'PRS'][hl7:subject]/hl7:code"
                 priority="1406"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:subject[@typeCode = 'SBJ'][hl7:realtedSubject[@classCode = 'PRS']]/hl7:realtedSubject[@classCode = 'PRS'][hl7:subject]/hl7:subject[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]"
                 priority="1405"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1'] is required [min 1x]. (count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1'] appears too often [max 1x]. (count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:subject[@typeCode = 'SBJ'][hl7:realtedSubject[@classCode = 'PRS']]/hl7:realtedSubject[@classCode = 'PRS'][hl7:subject]/hl7:subject[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']"
                 priority="1404"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.1' AdministrativeGender (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.1')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.5.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.5.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('HL7 AdministrativeGender') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): The value for codeSystemName SHALL be 'HL7 AdministrativeGender'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('HL7 AdministrativeGender') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (Organizer) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.440-2024-01-15T102714.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]"
                 priority="1403"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:statusCode[@code = 'completed']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:observation[hl7:statusCode[@code = 'completed']] is required [min 1x]. (count(hl7:observation[hl7:statusCode[@code = 'completed']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:statusCode[@code = 'completed']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:observation[hl7:statusCode[@code = 'completed']] appears too often [max 1x]. (count(hl7:observation[hl7:statusCode[@code = 'completed']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]"
                 priority="1402"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('OBS') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): The value for classCode SHALL be 'OBS'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('OBS') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.2']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.2'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.2']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text[hl7:reference]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:text[hl7:reference] appears too often [max 1x]. (count(hl7:text[hl7:reference]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode[@code = 'completed']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:statusCode[@code = 'completed'] is required [min 1x]. (count(hl7:statusCode[@code = 'completed']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode[@code = 'completed']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:statusCode[@code = 'completed'] appears too often [max 1x]. (count(hl7:statusCode[@code = 'completed']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:value is required [min 1x]. (count(hl7:value) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:value appears too often [max 1x]. (count(hl7:value) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]] appears too often [max 1x]. (count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entryRelationship[hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:entryRelationship[hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x]. (count(hl7:entryRelationship[hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.2']"
                 priority="1401"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.16.2')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.16.2'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.16.2') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:id"
                 priority="1400"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:code"
                 priority="1399"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.53-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.53' ProblemObservation_PSSIT	 (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.53-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:text[hl7:reference]"
                 priority="1398"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:reference is required [min 1x]. (count(hl7:reference) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): element hl7:reference appears too often [max 1x]. (count(hl7:reference) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:text[hl7:reference]/hl7:reference"
                 priority="1397"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:statusCode[@code = 'completed']"
                 priority="1396"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('completed')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): The value for code SHALL be 'completed'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('completed') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.15933' ActStatus (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:effectiveTime"
                 priority="1395"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:value"
                 priority="1394"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@xsi:type"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): attribute @xsi:type SHALL be present. (@xsi:type / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): Attribute @xsi:type SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@xsi:type"/>
               <xsl:text/>' (not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]]"
                 priority="1393"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']] is required [min 1x]. (count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']] appears too often [max 1x]. (count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('SUBJ')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): The value for typeCode SHALL be 'SUBJ'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('SUBJ') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19447-2014-03-26T000000.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19447' x_ActRelationshipEntryRelationship (2014-03-26T00:00:00). (not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19447-2014-03-26T000000.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]"
                 priority="1391"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('OBS')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): The value for classCode SHALL be 'OBS'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('OBS') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('SUBJ')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): The value for typeCode SHALL be 'SUBJ'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('SUBJ') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@code = '35267-4']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): element hl7:code[@code = '35267-4'] is required [min 1x]. (count(hl7:code[@code = '35267-4']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@code = '35267-4']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): element hl7:code[@code = '35267-4'] appears too often [max 1x]. (count(hl7:code[@code = '35267-4']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode[@code = 'completed']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): element hl7:statusCode[@code = 'completed'] is required [min 1x]. (count(hl7:statusCode[@code = 'completed']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode[@code = 'completed']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): element hl7:statusCode[@code = 'completed'] appears too often [max 1x]. (count(hl7:statusCode[@code = 'completed']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): element hl7:value is required [min 1x]. (count(hl7:value) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): element hl7:value appears too often [max 1x]. (count(hl7:value) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']"
                 priority="1390"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.16.3')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.16.3'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.16.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]/hl7:code[@code = '35267-4']"
                 priority="1389"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('35267-4')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): The value for code SHALL be '35267-4'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('35267-4') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.42-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.42' EtaInsorgenza_PSSIT (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.42-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]/hl7:statusCode[@code = 'completed']"
                 priority="1388"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('completed')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): The value for code SHALL be 'completed'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('completed') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.3']]/hl7:value"
                 priority="1387"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@xsi:type"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Insorgenza (observation) (PSS)): attribute @xsi:type SHALL be present. (@xsi:type / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.442-2024-01-15T125539.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]"
                 priority="1386"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): element hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x]. (count(hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): element hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x]. (count(hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('SUBJ')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio (observation) (PSS)): The value for typeCode SHALL be 'SUBJ'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('SUBJ') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.441-2024-01-15T120111.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]"
                 priority="1384"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('OBS')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): The value for classCode SHALL be 'OBS'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('OBS') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('SUBJ')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): The value for typeCode SHALL be 'SUBJ'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('SUBJ') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): element hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): element hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode[@code = 'completed']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): element hl7:statusCode[@code = 'completed'] is required [min 1x]. (count(hl7:statusCode[@code = 'completed']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode[@code = 'completed']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): element hl7:statusCode[@code = 'completed'] appears too often [max 1x]. (count(hl7:statusCode[@code = 'completed']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): element hl7:value is required [min 1x]. (count(hl7:value) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): element hl7:value appears too often [max 1x]. (count(hl7:value) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId"
                 priority="1383"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.16.3') or not(@root)"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.16.3'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.16.3') or not(@root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1382"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('39016-1')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): The value for code SHALL be '39016-1'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('39016-1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = 'completed']"
                 priority="1381"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('completed')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): The value for code SHALL be 'completed'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('completed') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]]/hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.1']]/hl7:component[hl7:observation[@moodCode = 'EVN']]/hl7:observation[hl7:statusCode[@code = 'completed']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value"
                 priority="1380"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@xsi:type"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Dettaglio Età Decesso (PSS)): attribute @xsi:type SHALL be present. (@xsi:type / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.443-2024-01-15T132420.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]"
                 priority="1379"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']] is required [min 1x]. (count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']] appears too often [max 1x]. (count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]"
                 priority="1378"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('OBS') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): The value for classCode SHALL be 'OBS'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('OBS') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text[hl7:reference]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): element hl7:text[hl7:reference] appears too often [max 1x]. (count(hl7:text[hl7:reference]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): element hl7:statusCode is required [min 1x]. (count(hl7:statusCode) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): element hl7:value appears too often [max 1x]. (count(hl7:value) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']"
                 priority="1377"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.16.4')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.16.4'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.16.4') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]/hl7:id"
                 priority="1376"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]/hl7:code"
                 priority="1375"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.53-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.53' ProblemObservation_PSSIT	 (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.53-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.2.9.77.22.11.9') or not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.77.22.11.9'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.2.9.77.22.11.9') or not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('ProblemObservation_PSSIT') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): The value for codeSystemName SHALL be 'ProblemObservation_PSSIT'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('ProblemObservation_PSSIT') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]/hl7:text[hl7:reference]"
                 priority="1374"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): element hl7:reference is required [min 1x]. (count(hl7:reference) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): element hl7:reference appears too often [max 1x]. (count(hl7:reference) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]/hl7:text[hl7:reference]/hl7:reference"
                 priority="1373"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]/hl7:statusCode"
                 priority="1372"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.15933' ActStatus (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.16']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.16.4']]/hl7:value"
                 priority="1371"
                 mode="M11">
      <xsl:variable name="xsiLocalName"
                    select="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <xsl:variable name="xsiLocalNS"
                    select="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" (@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.39-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.39' IPSNoProbsInfos (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.39-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.11.22.9 ') or not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.11.22.9 '. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.11.22.9 ') or not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('IPSNoProbsInfos') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): The value for codeSystemName SHALL be 'IPSNoProbsInfos'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('IPSNoProbsInfos') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Informazioni non note sull''anamnesi familiare') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): The value for displayName SHALL be 'Informazioni non note sull''anamnesi familiare'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Informazioni non note sull''anamnesi familiare') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Anamnesi Familiare - Assenza (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.760-2025-09-08T153735.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]"
                 priority="1370"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
               <xsl:value-of select="@contextConductionInd"/>
               <xsl:text/>" (string(@contextConductionInd) = ('true') or not(@contextConductionInd) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]"
                 priority="1368"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '29762-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): element hl7:code[(@code = '29762-2' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '29762-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '29762-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): element hl7:code[(@code = '29762-2' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '29762-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): element hl7:title is required [min 1x]. (count(hl7:title) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): element hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]] is required [min 1x]. (count(hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']"
                 priority="1367"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.2.6')"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.2.6'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.4.2.6') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]/hl7:id"
                 priority="1366"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]/hl7:code[(@code = '29762-2' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1365"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('29762-2')"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): The value for code SHALL be '29762-2'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('29762-2') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.444-2024-01-15T151940.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]]"
                 priority="1364"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']] is required [min 1x]. (count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']] appears too often [max 1x]. (count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]"
                 priority="1363"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('OBS') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): The value for classCode SHALL be 'OBS'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('OBS') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:code is required [min 1x]. (count(hl7:code) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text[hl7:reference]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:text[hl7:reference] appears too often [max 1x]. (count(hl7:text[hl7:reference]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:statusCode is required [min 1x]. (count(hl7:statusCode) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:value appears too often [max 1x]. (count(hl7:value) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']"
                 priority="1362"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]/hl7:id"
                 priority="1361"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]/hl7:code"
                 priority="1360"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]/hl7:text[hl7:reference]"
                 priority="1359"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:reference is required [min 1x]. (count(hl7:reference) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): element hl7:reference appears too often [max 1x]. (count(hl7:reference) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]/hl7:text[hl7:reference]/hl7:reference"
                 priority="1358"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]/hl7:statusCode"
                 priority="1357"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.15933' ActStatus (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]/hl7:effectiveTime"
                 priority="1356"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.6']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.6.1']]/hl7:value"
                 priority="1355"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@xsi:type"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): attribute @xsi:type SHALL be present. (@xsi:type / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Stile di Vita - (Observation) (PSS)): Attribute @xsi:type SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@xsi:type"/>
               <xsl:text/>' (not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.445-2024-01-15T153659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]]"
                 priority="1354"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']] is required [min 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']] appears too often [max 1x]. (count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <xsl:message>(Profilo_Sanitario_Sintetico): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
               <xsl:value-of select="@contextConductionInd"/>
               <xsl:text/>" (string(@contextConductionInd) = ('true') or not(@contextConductionInd) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.2.9.10.1.4.1.1-2023-12-20T153915.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]"
                 priority="1352"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '10162-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): element hl7:code[(@code = '10162-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '10162-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '10162-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): element hl7:code[(@code = '10162-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '10162-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): element hl7:title is required [min 1x]. (count(hl7:title) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): element hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]] is required [min 1x]. (count(hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']"
                 priority="1351"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.2.7')"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.2.7'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.4.2.7') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]/hl7:id"
                 priority="1350"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]/hl7:code[(@code = '10162-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1349"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('10162-6')"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): The value for code SHALL be '10162-6'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('10162-6') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.446-2024-01-16T095824.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]]"
                 priority="1348"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']] is required [min 1x]. (count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']] appears too often [max 1x]. (count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]"
                 priority="1347"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('OBS') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): The value for classCode SHALL be 'OBS'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('OBS') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): element hl7:code is required [min 1x]. (count(hl7:code) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text[hl7:reference]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): element hl7:text[hl7:reference] appears too often [max 1x]. (count(hl7:text[hl7:reference]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): element hl7:statusCode is required [min 1x]. (count(hl7:statusCode) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): element hl7:value appears too often [max 1x]. (count(hl7:value) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']"
                 priority="1346"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.7.1')"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.7.1'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.7.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]/hl7:id"
                 priority="1345"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.2.7']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.7.1']]/hl7:code"
                 priority="1344"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.44-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.44' PregnancyObservation_PSSIT (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.44-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Gravidanze e Parto - (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251112T165325/tmp-2.16.840.1.113883.3.1937.777.63.10.447-2024-01-16T100751.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:tem