<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.655
Name: CDA Organization Tele
Description: Template CDA Organization (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304">
   <title>CDA Organization Tele</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655
Item: (CDA Organization Tele)
-->

   <rule fpi="RULC-1"
         context="2.16.840.1.113883.3.1937.777.63.10.655"
         id="d44e5386-false-d921088e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251030T104952/tmp-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304.html"
              test="count(hl7:id) &gt;= 1">(CDA Organization Tele): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251030T104952/tmp-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization Tele): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251030T104952/tmp-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization Tele): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251030T104952/tmp-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization Tele): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:id
Item: (CDA Organization Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:name
Item: (CDA Organization Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:telecom
Item: (CDA Organization Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:addr
Item: (CDA Organization Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:standardIndustryClassCode
Item: (CDA Organization Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf
Item: (CDA Organization Tele)
-->

   <rule fpi="RULC-1"
         context="2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf"
         id="d44e5417-false-d921167e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251030T104952/tmp-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization Tele): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251030T104952/tmp-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization Tele): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251030T104952/tmp-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization Tele): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251030T104952/tmp-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization Tele): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251030T104952/tmp-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization Tele): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization Tele)
-->

   <rule fpi="RULC-1"
         context="2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]"
         id="d44e5428-false-d921229e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251030T104952/tmp-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization Tele): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization Tele)
-->

   <rule fpi="RULC-1"
         context="2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf/hl7:wholeOrganization"
         id="d44e5436-false-d921254e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251030T104952/tmp-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization Tele): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251030T104952/tmp-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization Tele): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251030T104952/tmp-2.16.840.1.113883.3.1937.777.63.10.655-2025-05-27T131304.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization Tele): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.655
Context: 2.16.840.1.113883.3.1937.777.63.10.655/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization Tele)
-->
</pattern>
