<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.10.12.303
Name: CDA Observation
Description: Template CDA Observation (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.10.12.303-2005-09-07T000000">
   <title>CDA Observation</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]"
         id="d44e409-false-d20678e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="string(@classCode) = ('OBS')">(CDA Observation): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="@moodCode">(CDA Observation): attribute @moodCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@moodCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="not(@moodCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.18943-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Observation): The value for moodCode SHALL be selected from value set '2.16.840.1.113883.1.11.18943' x_ActMoodDocumentObservation (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(CDA Observation): Attribute @negationInd SHALL be of data type 'bl'  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.12.303']) &gt;= 1">(CDA Observation): element hl7:templateId[@root = '2.16.840.1.113883.10.12.303'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.12.303']) &lt;= 1">(CDA Observation): element hl7:templateId[@root = '2.16.840.1.113883.10.12.303'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:code) &gt;= 1">(CDA Observation): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Observation): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:derivationExpr) &lt;= 1">(CDA Observation): element hl7:derivationExpr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:text) &lt;= 1">(CDA Observation): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Observation): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Observation): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Observation): element hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:repeatNumber) &lt;= 1">(CDA Observation): element hl7:repeatNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:languageCode) &lt;= 1">(CDA Observation): element hl7:languageCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:subject[hl7:relatedSubject[@classCode]]) &lt;= 1">(CDA Observation): element hl7:subject[hl7:relatedSubject[@classCode]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:templateId[@root = '2.16.840.1.113883.10.12.303']
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:templateId[@root = '2.16.840.1.113883.10.12.303']"
         id="d44e422-false-d21292e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="string(@root) = ('2.16.840.1.113883.10.12.303')">(CDA Observation): The value for root SHALL be '2.16.840.1.113883.10.12.303'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:id
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:code
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:code"
         id="d44e430-false-d21314e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16226-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Observation): The element value SHALL be one of '2.16.840.1.113883.1.11.16226 ObservationType (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:derivationExpr
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:text
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]"
         id="d44e441-false-d21350e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Observation): The element value SHALL be one of '2.16.840.1.113883.1.11.15933 ActStatus (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:effectiveTime
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e450-false-d21378e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Observation): The element value SHALL be one of '2.16.840.1.113883.1.11.16866 ActPriority (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:repeatNumber
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:languageCode
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:value
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.78-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.78-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e469-false-d21428e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.78-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Observation): The element value SHALL be one of '2.16.840.1.113883.1.11.78 ObservationInterpretation (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:methodCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14079-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:methodCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14079-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e476-false-d21448e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.14079-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Observation): The element value SHALL be one of '2.16.840.1.113883.1.11.14079 ObservationMethod (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:targetSiteCode
Item: (CDA Observation)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.320
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]
Item: (CDA Subject (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="string(@typeCode) = ('SBJ') or not(@typeCode)">(CDA Subject (Body)): The value for typeCode SHALL be 'SBJ'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Subject (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="count(hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Subject (Body)): element hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="count(hl7:relatedSubject[@classCode]) &gt;= 1">(CDA Subject (Body)): element hl7:relatedSubject[@classCode] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="count(hl7:relatedSubject[@classCode]) &lt;= 1">(CDA Subject (Body)): element hl7:relatedSubject[@classCode] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.320
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Subject (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Subject (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10310 TargetAwareness (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.320
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]
Item: (CDA Subject (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="@classCode">(CDA Subject (Body)): attribute @classCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19368-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Subject (Body)): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.19368' x_DocumentSubject (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Subject (Body)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="count(hl7:subject) &lt;= 1">(CDA Subject (Body)): element hl7:subject appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.320
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Subject (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Subject (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.19563 PersonalRelationshipRoleType (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.320
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:addr
Item: (CDA Subject (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.320
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:telecom
Item: (CDA Subject (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.320
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject
Item: (CDA Subject (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Subject (Body)): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Subject (Body)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Subject (Body)): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="count(hl7:birthTime) &lt;= 1">(CDA Subject (Body)): element hl7:birthTime appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.320
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject/hl7:name
Item: (CDA Subject (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.320
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Subject (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.320-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Subject (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.320
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject/hl7:birthTime
Item: (CDA Subject (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:specimen[hl7:specimenRole]
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.322
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:specimen[hl7:specimenRole]
Item: (CDA Specimen)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:specimen[hl7:specimenRole]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.322-2005-09-07T000000.html"
              test="string(@typeCode) = ('SPC') or not(@typeCode)">(CDA Specimen): The value for typeCode SHALL be 'SPC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.322-2005-09-07T000000.html"
              test="count(hl7:specimenRole) &gt;= 1">(CDA Specimen): element hl7:specimenRole is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.322-2005-09-07T000000.html"
              test="count(hl7:specimenRole) &lt;= 1">(CDA Specimen): element hl7:specimenRole appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.322
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole
Item: (CDA Specimen)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.322-2005-09-07T000000.html"
              test="string(@classCode) = ('SPEC') or not(@classCode)">(CDA Specimen): The value for classCode SHALL be 'SPEC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.322-2005-09-07T000000.html"
              test="count(hl7:specimenPlayingEntity) &lt;= 1">(CDA Specimen): element hl7:specimenPlayingEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.322
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:id
Item: (CDA Specimen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.322
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity
Item: (CDA Specimen)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.322-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA Specimen): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.322-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Specimen): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.322-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Specimen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.322-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA Specimen): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.322
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:code
Item: (CDA Specimen)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.322-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Specimen): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.322
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:quantity
Item: (CDA Specimen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.322
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:name
Item: (CDA Specimen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.322
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:desc
Item: (CDA Specimen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.323
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]
Item: (CDA Performer (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="string(@typeCode) = ('PRF') or not(@typeCode)">(CDA Performer (Body)): The value for typeCode SHALL be 'PRF'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Performer (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Performer (Body)): element hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA Performer (Body)): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA Performer (Body)): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.323
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]/hl7:time
Item: (CDA Performer (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.323
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]/hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Performer (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]/hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Performer (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.16543 ParticipationMode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.323
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA Performer (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA Performer (Body)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA Performer (Body)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Performer (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA Performer (Body)): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA Performer (Body)): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA Author (Body)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Author (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Author (Body)): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &gt;= 1">(CDA Author (Body)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Author (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA Author (Body)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA Author (Body)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Author (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA Author (Body)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA Author (Body)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Author (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedPerson | hl7:assignedAuthoringDevice) &lt;= 1">(CDA Author (Body)): choice (hl7:assignedPerson  or  hl7:assignedAuthoringDevice) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA Author (Body)): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.319
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant
Item: (CDA Informant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.319-2005-09-07T000000.html"
              test="string(@typeCode) = ('INF') or not(@typeCode)">(CDA Informant (Body)): The value for typeCode SHALL be 'INF'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.319-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Informant (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.319-2005-09-07T000000.html"
              test="count(hl7:assignedEntity | hl7:relatedEntity[@classCode]) &gt;= 1">(CDA Informant (Body)): choice (hl7:assignedEntity  or  hl7:relatedEntity[@classCode]) does not contain enough elements [min 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.319-2005-09-07T000000.html"
              test="count(hl7:assignedEntity | hl7:relatedEntity[@classCode]) &lt;= 1">(CDA Informant (Body)): choice (hl7:assignedEntity  or  hl7:relatedEntity[@classCode]) contains too many elements [max 1x]</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.319
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity
Item: (CDA Informant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity
Item: (CDA AssignedEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA AssignedEntity): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.319
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:relatedEntity[@classCode]
Item: (CDA Informant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.316
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:relatedEntity[@classCode]
Item: (CDA RelatedEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:relatedEntity[@classCode]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.316-2005-09-07T000000.html"
              test="@classCode">(CDA RelatedEntity): attribute @classCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.316-2005-09-07T000000.html"
              test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19316-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA RelatedEntity): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.19316' RoleClassMutualRelationship (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.316-2005-09-07T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA RelatedEntity): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.316-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA RelatedEntity): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.316-2005-09-07T000000.html"
              test="count(hl7:relatedPerson) &lt;= 1">(CDA RelatedEntity): element hl7:relatedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.316
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA RelatedEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.316-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA RelatedEntity): The element value SHALL be one of '2.16.840.1.113883.1.11.19563 PersonalRelationshipRoleType (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.316
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:addr
Item: (CDA RelatedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.316
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:telecom
Item: (CDA RelatedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.316
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:effectiveTime
Item: (CDA RelatedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.316
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:relatedPerson
Item: (CDA RelatedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:relatedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:relatedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:relatedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@typeCode">(CDA Participant (Body)): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Participant (Body)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Participant (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Participant (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Participant (Body)): element hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:participantRole) &gt;= 1">(CDA Participant (Body)): element hl7:participantRole is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:participantRole) &lt;= 1">(CDA Participant (Body)): element hl7:participantRole appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:time
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Participant (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10310 TargetAwareness (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(CDA Participant (Body)): The value for classCode SHALL be 'ROL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Participant (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:playingDevice | hl7:playingEntity) &lt;= 1">(CDA Participant (Body)): choice (hl7:playingDevice  or  hl7:playingEntity) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:scopingEntity) &lt;= 1">(CDA Participant (Body)): element hl7:scopingEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:id
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:code
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:addr
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:telecom
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingDevice
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingEntity
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingEntity
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA PlayingEntity): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA PlayingEntity): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA PlayingEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA PlayingEntity): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingEntity/hl7:code
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA PlayingEntity): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingEntity/hl7:quantity
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:playingEntity/hl7:desc
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA Participant (Body)): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Participant (Body)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Participant (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA Participant (Body)): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity/hl7:id
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity/hl7:code
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Participant (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:participant[@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity/hl7:desc
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:entryRelationship[@typeCode]
Item: (CDA Observation)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:entryRelationship[@typeCode]">
      <extends rule="d24327e0-false-d24331e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="@typeCode">(CDA Observation): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19447-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Observation): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19447' x_ActRelationshipEntryRelationship (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="not(@contextConductionInd) or string(@contextConductionInd)=('true','false')">(CDA Observation): Attribute @contextConductionInd SHALL be of data type 'bl'  - '<value-of select="@contextConductionInd"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="not(@inversionInd) or string(@inversionInd)=('true','false')">(CDA Observation): Attribute @inversionInd SHALL be of data type 'bl'  - '<value-of select="@inversionInd"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(CDA Observation): Attribute @negationInd SHALL be of data type 'bl'  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:sequenceNumber) &lt;= 1">(CDA Observation): element hl7:sequenceNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:seperatableInd) &lt;= 1">(CDA Observation): element hl7:seperatableInd appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:entryRelationship[@typeCode]/hl7:sequenceNumber
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:entryRelationship[@typeCode]/hl7:seperatableInd
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.300
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:entryRelationship[@typeCode]
Item: (CDA Clinical Statement)
-->
   <rule fpi="RULC-1" id="d24327e0-false-d24331e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.300-2005-09-07T000000.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.12.301']] | hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']] | hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']] | hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.10.12.304']] | hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.10.12.305']] | hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.10.12.306']] | hl7:regionOfInterest[hl7:templateId[@root = '2.16.840.1.113883.10.12.307']] | hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.10.12.308']] | hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.12.309']]) &gt;= 1">(CDA Clinical Statement): choice (hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.12.301']]  or  hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]  or  hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]  or  hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.10.12.304']]  or  hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.10.12.305']]  or  hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.10.12.306']]  or  hl7:regionOfInterest[hl7:templateId[@root = '2.16.840.1.113883.10.12.307']]  or  hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.10.12.308']]  or  hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.12.309']]) does not contain enough elements [min 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.300-2005-09-07T000000.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.12.301']] | hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']] | hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']] | hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.10.12.304']] | hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.10.12.305']] | hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.10.12.306']] | hl7:regionOfInterest[hl7:templateId[@root = '2.16.840.1.113883.10.12.307']] | hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.10.12.308']] | hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.12.309']]) &lt;= 1">(CDA Clinical Statement): choice (hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.12.301']]  or  hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]  or  hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]  or  hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.10.12.304']]  or  hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.10.12.305']]  or  hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.10.12.306']]  or  hl7:regionOfInterest[hl7:templateId[@root = '2.16.840.1.113883.10.12.307']]  or  hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.10.12.308']]  or  hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.12.309']]) contains too many elements [max 1x]</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.324
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]
Item: (CDA Reference)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.324-2005-09-07T000000.html"
              test="@typeCode">(CDA Reference): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.324-2005-09-07T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19000-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Reference): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19000' x_ActRelationshipExternalReference (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.324-2005-09-07T000000.html"
              test="count(hl7:seperatableInd) &lt;= 1">(CDA Reference): element hl7:seperatableInd appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.324-2005-09-07T000000.html"
              test="count(hl7:externalAct | hl7:externalObservation | hl7:externalProcedure | hl7:externalDocument) &gt;= 1">(CDA Reference): choice (hl7:externalAct  or  hl7:externalObservation  or  hl7:externalProcedure  or  hl7:externalDocument) does not contain enough elements [min 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.324-2005-09-07T000000.html"
              test="count(hl7:externalAct | hl7:externalObservation | hl7:externalProcedure | hl7:externalDocument) &lt;= 1">(CDA Reference): choice (hl7:externalAct  or  hl7:externalObservation  or  hl7:externalProcedure  or  hl7:externalDocument) contains too many elements [max 1x]</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.324
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:seperatableInd
Item: (CDA Reference)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.325
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalAct
Item: (CDA ExternalAct)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalAct">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.325-2005-09-07T000000.html"
              test="string(@classCode) = ('ACT') or not(@classCode)">(CDA ExternalAct): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.325-2005-09-07T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA ExternalAct): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.325-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA ExternalAct): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.325-2005-09-07T000000.html"
              test="count(hl7:text) &lt;= 1">(CDA ExternalAct): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.325
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalAct/hl7:id
Item: (CDA ExternalAct)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.325
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalAct/hl7:code
Item: (CDA ExternalAct)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.325
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalAct/hl7:text
Item: (CDA ExternalAct)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.326
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalObservation
Item: (CDA ExternalObservation)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalObservation">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.326-2005-09-07T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(CDA ExternalObservation): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.326-2005-09-07T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA ExternalObservation): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.326-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA ExternalObservation): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.326-2005-09-07T000000.html"
              test="count(hl7:text) &lt;= 1">(CDA ExternalObservation): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.326
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalObservation/hl7:id
Item: (CDA ExternalObservation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.326
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalObservation/hl7:code
Item: (CDA ExternalObservation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.326
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalObservation/hl7:text
Item: (CDA ExternalObservation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.327
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalProcedure
Item: (CDA ExternalProcedure)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalProcedure">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.327-2005-09-07T000000.html"
              test="string(@classCode) = ('PROC') or not(@classCode)">(CDA ExternalProcedure): The value for classCode SHALL be 'PROC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.327-2005-09-07T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA ExternalProcedure): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.327-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA ExternalProcedure): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.327-2005-09-07T000000.html"
              test="count(hl7:text) &lt;= 1">(CDA ExternalProcedure): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.327
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalProcedure/hl7:id
Item: (CDA ExternalProcedure)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.327
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalProcedure/hl7:code
Item: (CDA ExternalProcedure)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.327
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalProcedure/hl7:text
Item: (CDA ExternalProcedure)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.328
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalDocument
Item: (CDA ExternalDocument)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalDocument">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.328-2005-09-07T000000.html"
              test="string(@classCode) = ('DOC') or not(@classCode)">(CDA ExternalDocument): The value for classCode SHALL be 'DOC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.328-2005-09-07T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA ExternalDocument): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.328-2005-09-07T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]) &lt;= 1">(CDA ExternalDocument): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.328-2005-09-07T000000.html"
              test="count(hl7:text) &lt;= 1">(CDA ExternalDocument): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.328-2005-09-07T000000.html"
              test="count(hl7:setId) &lt;= 1">(CDA ExternalDocument): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.328-2005-09-07T000000.html"
              test="count(hl7:versionNumber) &lt;= 1">(CDA ExternalDocument): element hl7:versionNumber appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.328
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalDocument/hl7:id
Item: (CDA ExternalDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.328
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalDocument/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]
Item: (CDA ExternalDocument)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalDocument/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.328-2005-09-07T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.6.1')">(CDA ExternalDocument): The element value SHALL be one of 'codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.328
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalDocument/hl7:text
Item: (CDA ExternalDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.328
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalDocument/hl7:setId
Item: (CDA ExternalDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.328
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:reference[@typeCode]/hl7:externalDocument/hl7:versionNumber
Item: (CDA ExternalDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:precondition[hl7:criterion]
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.329
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:precondition[hl7:criterion]
Item: (CDA Precondition)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:precondition[hl7:criterion]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.329-2005-09-07T000000.html"
              test="string(@typeCode) = ('PRCN') or not(@typeCode)">(CDA Precondition): The value for typeCode SHALL be 'PRCN'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.329-2005-09-07T000000.html"
              test="count(hl7:criterion) &gt;= 1">(CDA Precondition): element hl7:criterion is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.329-2005-09-07T000000.html"
              test="count(hl7:criterion) &lt;= 1">(CDA Precondition): element hl7:criterion appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.329
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:precondition[hl7:criterion]/hl7:criterion
Item: (CDA Precondition)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:precondition[hl7:criterion]/hl7:criterion">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.329-2005-09-07T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(CDA Precondition): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.329-2005-09-07T000000.html"
              test="string(@moodCode) = ('EVN.CRT') or not(@moodCode)">(CDA Precondition): The value for moodCode SHALL be 'EVN.CRT'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.329-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Precondition): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.329-2005-09-07T000000.html"
              test="count(hl7:text) &lt;= 1">(CDA Precondition): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.329-2005-09-07T000000.html"
              test="count(hl7:value) &lt;= 1">(CDA Precondition): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.329
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:precondition[hl7:criterion]/hl7:criterion/hl7:code
Item: (CDA Precondition)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.329
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:precondition[hl7:criterion]/hl7:criterion/hl7:text
Item: (CDA Precondition)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.329
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:precondition[hl7:criterion]/hl7:criterion/hl7:value
Item: (CDA Precondition)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange]
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange]"
         id="d44e551-false-d28885e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="string(@typeCode) = ('REFV')">(CDA Observation): The value for typeCode SHALL be 'REFV'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:observationRange) &gt;= 1">(CDA Observation): element hl7:observationRange is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:observationRange) &lt;= 1">(CDA Observation): element hl7:observationRange appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange]/hl7:observationRange
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange]/hl7:observationRange"
         id="d44e555-false-d28905e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(CDA Observation): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="string(@moodCode) = ('EVN.CRT') or not(@moodCode)">(CDA Observation): The value for moodCode SHALL be 'EVN.CRT'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Observation): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:text) &lt;= 1">(CDA Observation): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:value) &lt;= 1">(CDA Observation): element hl7:value appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="count(hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.78-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Observation): element hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.78-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange]/hl7:observationRange/hl7:code
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange]/hl7:observationRange/hl7:text
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange]/hl7:observationRange/hl7:value
Item: (CDA Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.303
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange]/hl7:observationRange/hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.78-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange]/hl7:observationRange/hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.78-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e571-false-d28975e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251027T172142/tmp-2.16.840.1.113883.10.12.303-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.78-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Observation): The element value SHALL be one of '2.16.840.1.113883.1.11.78 ObservationInterpretation (DYNAMIC)'.</assert>
   </rule>
</pattern>
