<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.652
Name: Allergie (Tele)
Description: Allergies and adverse reactions Document (LOINC: 48765-2 )
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138">
   <title>Allergie (Tele)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.652
Context: *[hl7:section]
Item: (Allergie (Tele))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.652
Context: *[hl7:section]/hl7:section
Item: (Allergie (Tele))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section]/hl7:section"
         id="d44e6134-false-d927004e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Allergie (Tele)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Allergie (Tele)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.652']) &lt;= 1">(Allergie (Tele)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.652'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="count(hl7:id) &lt;= 1">(Allergie (Tele)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Allergie (Tele)): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="count(hl7:title) &lt;= 1">(Allergie (Tele)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="count(hl7:text) &gt;= 1">(Allergie (Tele)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="count(hl7:text) &lt;= 1">(Allergie (Tele)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &lt;= 1">(Allergie (Tele)): element hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.652
Context: *[hl7:section]/hl7:section/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.652']
Item: (Allergie (Tele))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section]/hl7:section/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.652']"
         id="d44e6140-false-d927083e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.652')">(Allergie (Tele)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.652'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.652
Context: *[hl7:section]/hl7:section/hl7:id
Item: (Allergie (Tele))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.652
Context: *[hl7:section]/hl7:section/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Allergie (Tele))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section]/hl7:section/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d44e6147-false-d927103e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="string(@code) = ('48765-2')">(Allergie (Tele)): The value for code SHALL be '48765-2'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Allergie (Tele)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Allergie (Tele)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie (Tele)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie (Tele)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.652
Context: *[hl7:section]/hl7:section/hl7:title
Item: (Allergie (Tele))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.652
Context: *[hl7:section]/hl7:section/hl7:text
Item: (Allergie (Tele))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.652
Context: *[hl7:section]/hl7:section/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]
Item: (Allergie (Tele))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section]/hl7:section/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19446-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie (Tele)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19446' x_ActRelationshipEntry (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.652-2025-05-27T124138.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Allergie (Tele)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
