<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.651
Name: Anamnesi Familiare (Tele)
Description: Template CDA Organizer (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809">
   <title>Anamnesi Familiare (Tele)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.651
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Anamnesi Familiare (Tele))
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]"
         id="d44e6047-false-d925958e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="count(hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(Anamnesi Familiare (Tele)): element hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="count(hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Anamnesi Familiare (Tele)): element hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.651
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Anamnesi Familiare (Tele))
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]"
         id="d44e6060-false-d925999e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="string(@classCode) = ('CLUSTER')">(Anamnesi Familiare (Tele)): The value for classCode SHALL be 'CLUSTER'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Anamnesi Familiare (Tele)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.651']) &lt;= 1">(Anamnesi Familiare (Tele)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.651'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="count(hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Anamnesi Familiare (Tele)): element hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="count(hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Anamnesi Familiare (Tele)): element hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(Anamnesi Familiare (Tele)): element hl7:statusCode[@code = 'completed' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(Anamnesi Familiare (Tele)): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Anamnesi Familiare (Tele)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="count(hl7:subject[hl7:relatedSubject]) &gt;= 1">(Anamnesi Familiare (Tele)): element hl7:subject[hl7:relatedSubject] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]) &gt;= 1">(Anamnesi Familiare (Tele)): element hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]] is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.651
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.651']
Item: (Anamnesi Familiare (Tele))
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.651']"
         id="d44e6072-false-d926071e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.651')">(Anamnesi Familiare (Tele)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.651'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.651
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Anamnesi Familiare (Tele))
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d44e6077-false-d926083e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="string(@code) = ('10157-6')">(Anamnesi Familiare (Tele)): The value for code SHALL be '10157-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Anamnesi Familiare (Tele)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Anamnesi Familiare (Tele)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Anamnesi Familiare (Tele)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.651
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (Anamnesi Familiare (Tele))
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = 'completed' or @nullFlavor]"
         id="d44e6103-false-d926106e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="@nullFlavor or (@code='completed')">(Anamnesi Familiare (Tele)): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.651
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime
Item: (Anamnesi Familiare (Tele))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.651
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]
Item: (Anamnesi Familiare (Tele))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.139
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]
Item: (Grado di parentela )
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="string(@typeCode) = ('SBJ') or not(@typeCode)">(Grado di parentela ): The value for typeCode SHALL be 'SBJ'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(Grado di parentela ): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="count(hl7:relatedSubject) &gt;= 1">(Grado di parentela ): element hl7:relatedSubject is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="count(hl7:relatedSubject) &lt;= 1">(Grado di parentela ): element hl7:relatedSubject appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.139
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]/hl7:relatedSubject
Item: (Grado di parentela )
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]/hl7:relatedSubject">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="string(@classCode) = ('PRS') or not(@classCode)">(Grado di parentela ): The value for classCode SHALL be 'PRS'. Found: "<value-of select="@classCode"/>"</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="count(hl7:code) &lt; 1">(Grado di parentela ): element hl7:code is coded with binding strength 'extensible' and contains a code other than the specified set.</report>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="count(hl7:code) &lt;= 1">(Grado di parentela ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="count(hl7:subject) &lt;= 1">(Grado di parentela ): element hl7:subject appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.139
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]/hl7:relatedSubject/hl7:code
Item: (Grado di parentela )
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]/hl7:relatedSubject/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="@code">(Grado di parentela ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Grado di parentela ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="@codeSystem">(Grado di parentela ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Grado di parentela ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Grado di parentela ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Grado di parentela ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.139
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]/hl7:relatedSubject/hl7:subject
Item: (Grado di parentela )
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]/hl7:relatedSubject/hl7:subject">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(Grado di parentela ): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Grado di parentela ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="count(hl7:name) &lt;= 1">(Grado di parentela ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Grado di parentela ): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.139
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]/hl7:relatedSubject/hl7:subject/hl7:name
Item: (Grado di parentela )
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]/hl7:relatedSubject/hl7:subject/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="count(hl7:given) &gt;= 1">(Grado di parentela ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="count(hl7:given) &lt;= 1">(Grado di parentela ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="count(hl7:family) &gt;= 1">(Grado di parentela ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="count(hl7:family) &lt;= 1">(Grado di parentela ): element hl7:family appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.139
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]/hl7:relatedSubject/hl7:subject/hl7:name/hl7:given
Item: (Grado di parentela )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.139
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]/hl7:relatedSubject/hl7:subject/hl7:name/hl7:family
Item: (Grado di parentela )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.139
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]/hl7:relatedSubject/hl7:subject/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Grado di parentela )
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:subject[hl7:relatedSubject]/hl7:relatedSubject/hl7:subject/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.139-2022-09-21T163055.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Grado di parentela ): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.651
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]
Item: (Anamnesi Familiare (Tele))
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]">
      <extends rule="d926325e0-false-d926329e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.651-2025-05-27T123809.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Anamnesi Familiare (Tele)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.144
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]
Item: (Dettaglio Anamnesi Familiare)
-->
   <rule fpi="RULC-1" id="d926325e0-false-d926329e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]) &gt;= 1">(Dettaglio Anamnesi Familiare): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]) &lt;= 1">(Dettaglio Anamnesi Familiare): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.144
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]
Item: (Dettaglio Anamnesi Familiare)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Dettaglio Anamnesi Familiare): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="string(@moodCode) = ('EVN')">(Dettaglio Anamnesi Familiare): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']) &gt;= 1">(Dettaglio Anamnesi Familiare): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']) &lt;= 1">(Dettaglio Anamnesi Familiare): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144'] appears too often [max 1x].</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.9-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt; 1">(Dettaglio Anamnesi Familiare): element hl7:code is coded with binding strength 'extensible' and contains a code other than the specified set.</report>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.9-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Dettaglio Anamnesi Familiare): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.9-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:text) &gt;= 1">(Dettaglio Anamnesi Familiare): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:text) &lt;= 1">(Dettaglio Anamnesi Familiare): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(Dettaglio Anamnesi Familiare): element hl7:statusCode[@code = 'completed' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(Dettaglio Anamnesi Familiare): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Dettaglio Anamnesi Familiare): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Dettaglio Anamnesi Familiare): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.6.103']) &gt;= 1">(Dettaglio Anamnesi Familiare): element hl7:value[@codeSystem = '2.16.840.1.113883.6.103'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.6.103']) &lt;= 1">(Dettaglio Anamnesi Familiare): element hl7:value[@codeSystem = '2.16.840.1.113883.6.103'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]) &lt;= 1">(Dettaglio Anamnesi Familiare): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]) &lt;= 1">(Dettaglio Anamnesi Familiare): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.144
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']
Item: (Dettaglio Anamnesi Familiare)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.144')">(Dettaglio Anamnesi Familiare): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.144'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.144
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.9-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Dettaglio Anamnesi Familiare)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.9-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.9-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Dettaglio Anamnesi Familiare): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.9 ProblemObservationRAP (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="@code">(Dettaglio Anamnesi Familiare): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Dettaglio Anamnesi Familiare): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Dettaglio Anamnesi Familiare): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Dettaglio Anamnesi Familiare): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Dettaglio Anamnesi Familiare): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.144
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:text
Item: (Dettaglio Anamnesi Familiare)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.144
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (Dettaglio Anamnesi Familiare)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:statusCode[@code = 'completed' or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="@nullFlavor or (@code='completed')">(Dettaglio Anamnesi Familiare): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.144
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:effectiveTime
Item: (Dettaglio Anamnesi Familiare)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.144
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:value[@codeSystem = '2.16.840.1.113883.6.103']
Item: (Dettaglio Anamnesi Familiare)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:value[@codeSystem = '2.16.840.1.113883.6.103']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="@code">(Dettaglio Anamnesi Familiare): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Dettaglio Anamnesi Familiare): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.103')">(Dettaglio Anamnesi Familiare): The value for codeSystem SHALL be '2.16.840.1.113883.6.103'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Dettaglio Anamnesi Familiare): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Dettaglio Anamnesi Familiare): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.144
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]
Item: (Dettaglio Anamnesi Familiare)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]">
      <extends rule="d926573e0-false-d926577e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="@typeCode">(Dettaglio Anamnesi Familiare): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19447-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Dettaglio Anamnesi Familiare): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19447' x_ActRelationshipEntryRelationship (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.145
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]
Item: (Età Insorgenza)
-->
   <rule fpi="RULC-1" id="d926573e0-false-d926577e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]) &gt;= 1">(Età Insorgenza): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]) &lt;= 1">(Età Insorgenza): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.145
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]
Item: (Età Insorgenza)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="string(@classCode) = ('OBS')">(Età Insorgenza): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="string(@moodCode) = ('EVN')">(Età Insorgenza): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']) &gt;= 1">(Età Insorgenza): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']) &lt;= 1">(Età Insorgenza): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="count(hl7:code[(@code = '35267-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Età Insorgenza): element hl7:code[(@code = '35267-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="count(hl7:code[(@code = '35267-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Età Insorgenza): element hl7:code[(@code = '35267-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="count(hl7:text) &lt;= 1">(Età Insorgenza): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(Età Insorgenza): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Età Insorgenza): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="count(hl7:value) &gt;= 1">(Età Insorgenza): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="count(hl7:value) &lt;= 1">(Età Insorgenza): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.145
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']
Item: (Età Insorgenza)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.145')">(Età Insorgenza): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.145'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.145
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]/hl7:code[(@code = '35267-4' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Età Insorgenza)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]/hl7:code[(@code = '35267-4' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="string(@code) = ('35267-4')">(Età Insorgenza): The value for code SHALL be '35267-4'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Età Insorgenza): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Età Insorgenza): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Età Insorgenza): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.145
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]/hl7:text
Item: (Età Insorgenza)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.145
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (Età Insorgenza)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.145-2022-09-21T180211.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Età Insorgenza): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.10 X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.145
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]/hl7:effectiveTime
Item: (Età Insorgenza)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.145
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.145']]/hl7:value
Item: (Età Insorgenza)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.144
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]
Item: (Dettaglio Anamnesi Familiare)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="@typeCode">(Dettaglio Anamnesi Familiare): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.144-2022-09-21T173126.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19447-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Dettaglio Anamnesi Familiare): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19447' x_ActRelationshipEntryRelationship (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.152
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]
Item: (Età decesso)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.152
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]
Item: (Età decesso)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Età decesso): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="string(@moodCode) = ('EVN')">(Età decesso): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']) &gt;= 1">(Età decesso): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']) &lt;= 1">(Età decesso): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="count(hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Età decesso): element hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="count(hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Età decesso): element hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="count(hl7:text) &lt;= 1">(Età decesso): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(Età decesso): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Età decesso): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="count(hl7:value) &gt;= 1">(Età decesso): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="count(hl7:value) &lt;= 1">(Età decesso): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.152
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']
Item: (Età decesso)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.152')">(Età decesso): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.152'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.152
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]/hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Età decesso)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]/hl7:code[(@code = '39016-1' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="string(@code) = ('39016-1')">(Età decesso): The value for code SHALL be '39016-1'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Età decesso): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Età decesso): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Età decesso): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.152
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]/hl7:text
Item: (Età decesso)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.152
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (Età decesso)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T111406/tmp-2.16.840.1.113883.3.1937.777.63.10.152-2022-09-22T145122.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Età decesso): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.10 X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.152
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]/hl7:effectiveTime
Item: (Età decesso)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.152
Context: *[hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:organizer[hl7:code[(@code = '10157-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.144']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.152']]/hl7:value
Item: (Età decesso)
--></pattern>
