<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.732
Name: Impianto dispositivo (TPI)
Description: Template CDA Procedure (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056">
   <title>Impianto dispositivo (TPI)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.732
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]]
Item: (Impianto dispositivo (TPI))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.732
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]
Item: (Impianto dispositivo (TPI))
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]"
         id="d44e107083-false-d4853256e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="string(@classCode) = ('PROC') or not(@classCode)">(Impianto dispositivo (TPI)): The value for classCode SHALL be 'PROC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="string(@moodCode) = ('EVN')">(Impianto dispositivo (TPI)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']) &gt;= 1">(Impianto dispositivo (TPI)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']) &lt;= 1">(Impianto dispositivo (TPI)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="count(hl7:code) &gt;= 1">(Impianto dispositivo (TPI)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="count(hl7:code) &lt;= 1">(Impianto dispositivo (TPI)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="count(hl7:text) &lt;= 1">(Impianto dispositivo (TPI)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(Impianto dispositivo (TPI)): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Impianto dispositivo (TPI)): element hl7:effectiveTime appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.732
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']
Item: (Impianto dispositivo (TPI))
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']"
         id="d44e107089-false-d4853311e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.183')">(Impianto dispositivo (TPI)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.183'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.732
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]/hl7:code
Item: (Impianto dispositivo (TPI))
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]/hl7:code"
         id="d44e107094-false-d4853322e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="@code">(Impianto dispositivo (TPI)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Impianto dispositivo (TPI)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="@codeSystem">(Impianto dispositivo (TPI)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Impianto dispositivo (TPI)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Impianto dispositivo (TPI)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Impianto dispositivo (TPI)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.732
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]/hl7:text
Item: (Impianto dispositivo (TPI))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.732
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (Impianto dispositivo (TPI))
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]"
         id="d44e107124-false-d4853357e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.732-2025-07-16T020056.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Impianto dispositivo (TPI)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.10 X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.732
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.183']]/hl7:effectiveTime
Item: (Impianto dispositivo (TPI))
-->
</pattern>
