<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.726
Name: CDA Encounter (TPI)
Description: Template CDA Encounter (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.726-2025-07-15T134952">
   <title>CDA Encounter (TPI)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.726
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]]
Item: (CDA Encounter (TPI))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.726
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]
Item: (CDA Encounter (TPI))
-->

   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]"
         id="d44e106589-false-d4852760e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.726-2025-07-15T134952.html"
              test="string(@classCode) = ('DOCSECT')">(CDA Encounter (TPI)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.726-2025-07-15T134952.html"
              test="string(@moodCode) = ('EVN')">(CDA Encounter (TPI)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.726-2025-07-15T134952.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.12.302']) &gt;= 1">(CDA Encounter (TPI)): element hl7:templateId[@root = '2.16.840.1.113883.10.12.302'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.726-2025-07-15T134952.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.12.302']) &lt;= 1">(CDA Encounter (TPI)): element hl7:templateId[@root = '2.16.840.1.113883.10.12.302'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.726-2025-07-15T134952.html"
              test="count(hl7:id) &lt;= 1">(CDA Encounter (TPI)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.726-2025-07-15T134952.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.60-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Encounter (TPI)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.60-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.726-2025-07-15T134952.html"
              test="count(hl7:text) &lt;= 1">(CDA Encounter (TPI)): element hl7:text appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.726
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]/hl7:templateId[@root = '2.16.840.1.113883.10.12.302']
Item: (CDA Encounter (TPI))
-->

   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]/hl7:templateId[@root = '2.16.840.1.113883.10.12.302']"
         id="d44e106595-false-d4852807e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.726-2025-07-15T134952.html"
              test="string(@root) = ('2.16.840.1.113883.10.12.302')">(CDA Encounter (TPI)): The value for root SHALL be '2.16.840.1.113883.10.12.302'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.726
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]/hl7:id
Item: (CDA Encounter (TPI))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.726
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.60-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Encounter (TPI))
-->

   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.60-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e106602-false-d4852829e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.726-2025-07-15T134952.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.60-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Encounter (TPI)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.60 EncounterCode (TPI) (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.726
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]/hl7:text
Item: (CDA Encounter (TPI))
-->
</pattern>
