<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.598
Name: Referto di Televisita 
Description: Referto di Specialistica Ambulatoriale (RSA)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302">
   <title>Referto di Televisita </title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]
Item: (Referto di Televisita )
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]"
         id="d44e90170-false-d4746403e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(Referto di Televisita ): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Referto di Televisita ): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:realmCode) &gt;= 1">(Referto di Televisita ): element hl7:realmCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &gt;= 1">(Referto di Televisita ): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &lt;= 1">(Referto di Televisita ): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']) &gt;= 1">(Referto di Televisita ): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:id) &gt;= 1">(Referto di Televisita ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:id) &lt;= 1">(Referto di Televisita ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:code[(@code = '11488-4' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']) &gt;= 1">(Referto di Televisita ): element hl7:code[(@code = '11488-4' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:code[(@code = '11488-4' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']) &lt;= 1">(Referto di Televisita ): element hl7:code[(@code = '11488-4' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:title) &lt;= 1">(Referto di Televisita ): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Referto di Televisita ): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Referto di Televisita ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &gt;= 1">(Referto di Televisita ): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &lt;= 1">(Referto di Televisita ): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:languageCode) &lt;= 1">(Referto di Televisita ): element hl7:languageCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:setId) &lt;= 1">(Referto di Televisita ): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:versionNumber) &lt;= 1">(Referto di Televisita ): element hl7:versionNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1">(Referto di Televisita ): element hl7:recordTarget[hl7:patientRole] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1">(Referto di Televisita ): element hl7:recordTarget[hl7:patientRole] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">(Referto di Televisita ): element hl7:author[hl7:assignedAuthor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]) &lt;= 1">(Referto di Televisita ): element hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1">(Referto di Televisita ): element hl7:custodian[hl7:assignedCustodian] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1">(Referto di Televisita ): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1">(Referto di Televisita ): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">(Referto di Televisita ): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:componentOf[hl7:encompassingEncounter]) &gt;= 1">(Referto di Televisita ): element hl7:componentOf[hl7:encompassingEncounter] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:componentOf[hl7:encompassingEncounter]) &lt;= 1">(Referto di Televisita ): element hl7:componentOf[hl7:encompassingEncounter] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:structuredBody]) &gt;= 1">(Referto di Televisita ): element hl7:component[hl7:structuredBody] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:structuredBody]) &lt;= 1">(Referto di Televisita ): element hl7:component[hl7:structuredBody] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:realmCode
Item: (Referto di Televisita )
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:realmCode"
         id="d44e90176-false-d4747224e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="@code">(Referto di Televisita ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Referto di Televisita ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']
Item: (Referto di Televisita )
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']"
         id="d44e90203-false-d4747238e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@root) = ('2.16.840.1.113883.1.3')">(Referto di Televisita ): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@extension) = ('POCD_MT000040UV02')">(Referto di Televisita ): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Referto di Televisita ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']
Item: (Referto di Televisita )
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']"
         id="d44e90222-false-d4747257e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.9.1')">(Referto di Televisita ): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.9.1'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="@extension">(Referto di Televisita ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Referto di Televisita ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Referto di Televisita ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:id
Item: (Referto di Televisita )
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:id"
         id="d44e90254-false-d4747277e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="@root">(Referto di Televisita ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Referto di Televisita ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="@extension">(Referto di Televisita ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Referto di Televisita ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="@assigningAuthorityName">(Referto di Televisita ): attribute @assigningAuthorityName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Referto di Televisita ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:code[(@code = '11488-4' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']
Item: (Referto di Televisita )
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:code[(@code = '11488-4' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']"
         id="d44e90294-false-d4747301e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.6.1')">(Referto di Televisita ): The element value SHALL be one of 'codeSystem '2.16.840.1.113883.6.1''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@code) = ('11488-4')">(Referto di Televisita ): The value for code SHALL be '11488-4'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Referto di Televisita ): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@codeSystemName) = ('LOINC')">(Referto di Televisita ): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Referto di Televisita ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Referto di Televisita ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:code[(@code = '11488-4' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']/hl7:translation
Item: (Referto di Televisita )
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:code[(@code = '11488-4' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']/hl7:translation"
         id="d44e90320-false-d4747334e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="@code">(Referto di Televisita ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Referto di Televisita ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="@codeSystem">(Referto di Televisita ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Referto di Televisita ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="@codeSystemName">(Referto di Televisita ): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Referto di Televisita ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Referto di Televisita ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:title
Item: (Referto di Televisita )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:effectiveTime
Item: (Referto di Televisita )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]
Item: (Referto di Televisita )
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]"
         id="d44e90367-false-d4747379e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="@nullFlavor or (@code='N' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Normal' and @codeSystemName='HL7 Confidentiality') or (@code='V' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Very Restricted' and @codeSystemName='HL7 Confidentiality') or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Referto di Televisita ): The element value SHALL be one of 'code 'N' codeSystem '2.16.840.1.113883.5.25' displayName='Normal' codeSystemName='HL7 Confidentiality' or code 'V' codeSystem '2.16.840.1.113883.5.25' displayName='Very Restricted' codeSystemName='HL7 Confidentiality' or 2.16.840.1.113883.1.11.16926 x_BasicConfidentialityKind (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:languageCode
Item: (Referto di Televisita )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:setId
Item: (Referto di Televisita )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:versionNumber
Item: (Referto di Televisita )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]
Item: (CDA recordTargetTV)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]"
         id="d4747424e28-false-d4747526e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="string(@typeCode) = ('RCT') or not(@typeCode)">(CDA recordTargetTV): The value for typeCode SHALL be 'RCT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA recordTargetTV): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:patientRole[hl7:patient]) &gt;= 1">(CDA recordTargetTV): element hl7:patientRole[hl7:patient] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:patientRole[hl7:patient]) &lt;= 1">(CDA recordTargetTV): element hl7:patientRole[hl7:patient] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]
Item: (CDA recordTargetTV)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]"
         id="d4747424e49-false-d4747740e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="string(@classCode) = ('PAT') or not(@classCode)">(CDA recordTargetTV): The value for classCode SHALL be 'PAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:id) &gt;= 1">(CDA recordTargetTV): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(CDA recordTargetTV): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(CDA recordTargetTV): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTargetTV): element hl7:providerOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id
Item: (CDA recordTargetTV)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id"
         id="d4747424e59-false-d4747878e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="@root">(CDA recordTargetTV): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTargetTV): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="@extension">(CDA recordTargetTV): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTargetTV): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA recordTargetTV): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA recordTargetTV)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr">
      <extends rule="d4747932e0-false-d4747938e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="@use">(CDA recordTargetTV): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTargetTV): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4747932e0-false-d4747938e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom
Item: (CDA recordTargetTV)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom"
         id="d4747424e269-false-d4748050e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="@use">(CDA recordTargetTV): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTargetTV): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="@value">(CDA recordTargetTV): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (CDA recordTargetTV)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
         id="d4747424e302-false-d4748135e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTargetTV): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTargetTV): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:name) &gt;= 1">(CDA recordTargetTV): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTargetTV): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(CDA recordTargetTV): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA recordTargetTV): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:birthTime) &gt;= 1">(CDA recordTargetTV): element hl7:birthTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:birthTime) &lt;= 1">(CDA recordTargetTV): element hl7:birthTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:birthplace[hl7:place]) &lt;= 1">(CDA recordTargetTV): element hl7:birthplace[hl7:place] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name
Item: (CDA recordTargetTV)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name"
         id="d4747424e314-false-d4748244e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:given) &gt;= 1">(CDA recordTargetTV): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:family) &gt;= 1">(CDA recordTargetTV): element hl7:family is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:given
Item: (CDA recordTargetTV)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:family
Item: (CDA recordTargetTV)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA recordTargetTV)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d4747424e347-false-d4748283e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA recordTargetTV): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="@code">(CDA recordTargetTV): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="@codeSystem">(CDA recordTargetTV): attribute @codeSystem SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime
Item: (CDA recordTargetTV)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian
Item: (CDA recordTargetTV)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian"
         id="d4747424e418-false-d4748363e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:code) &lt;= 1">(CDA recordTargetTV): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:guardianPerson) &lt;= 1">(CDA recordTargetTV): element hl7:guardianPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTargetTV): element hl7:guardianOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id
Item: (CDA recordTargetTV)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id"
         id="d4747424e426-false-d4748450e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="@root">(CDA recordTargetTV): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTargetTV): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="@extension">(CDA recordTargetTV): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTargetTV): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code
Item: (CDA recordTargetTV)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code"
         id="d4747424e435-false-d4748468e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="@code">(CDA recordTargetTV): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="@codeSystem">(CDA recordTargetTV): attribute @codeSystem SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr
Item: (CDA recordTargetTV)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:telecom
Item: (CDA recordTargetTV)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson
Item: (CDA recordTargetTV)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson">
      <extends rule="d4748652e0-false-d4748664e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTargetTV): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTargetTV): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1" id="d4748652e0-false-d4748664e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA recordTargetTV)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d4748982e0-false-d4748988e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4748982e0-false-d4748988e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4749146e0-false-d4749182e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4749146e0-false-d4749182e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d4749352e0-false-d4749356e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d4749352e0-false-d4749356e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d4749522e0-false-d4749528e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4749522e0-false-d4749528e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4749686e0-false-d4749722e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4749686e0-false-d4749722e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]
Item: (CDA recordTargetTV)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]"
         id="d4747424e481-false-d4749906e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="string(@classCode) = ('BIRTHPL') or not(@classCode)">(CDA recordTargetTV): The value for classCode SHALL be 'BIRTHPL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:place) &gt;= 1">(CDA recordTargetTV): element hl7:place is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:place) &lt;= 1">(CDA recordTargetTV): element hl7:place appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place
Item: (CDA recordTargetTV)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place"
         id="d4747424e519-false-d4749942e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA recordTargetTV): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTargetTV): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTargetTV): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="count(hl7:addr) &lt;= 1">(CDA recordTargetTV): element hl7:addr appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name
Item: (CDA recordTargetTV)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr
Item: (CDA recordTargetTV)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr
Item: (CDA AddressBirthPlace)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:country) &gt;= 1">(CDA AddressBirthPlace): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:country) &lt;= 1">(CDA AddressBirthPlace): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:state) &lt;= 1">(CDA AddressBirthPlace): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:county) &lt;= 1">(CDA AddressBirthPlace): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:city) &gt;= 1">(CDA AddressBirthPlace): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:city) &lt;= 1">(CDA AddressBirthPlace): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA AddressBirthPlace): element hl7:censusTract appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA AddressBirthPlace): element hl7:postalCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:country
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:state
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:county
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:city
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:censusTract
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:postalCode
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.599
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA recordTargetTV)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']">
      <extends rule="d4750148e0-false-d4750152e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(CDA recordTargetTV): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.599-2025-05-02T124610.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA recordTargetTV): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d4750148e0-false-d4750152e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d4750318e0-false-d4750324e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4750318e0-false-d4750324e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4750482e0-false-d4750518e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4750482e0-false-d4750518e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d4750688e0-false-d4750692e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d4750688e0-false-d4750692e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d4750858e0-false-d4750864e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4750858e0-false-d4750864e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4751022e0-false-d4751058e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4751022e0-false-d4751058e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.364
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]
Item: (CDA author RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]"
         id="d4750138e417-false-d4751298e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA author RSA): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA author RSA): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="count(hl7:functionCode) &lt;= 1">(CDA author RSA): element hl7:functionCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="count(hl7:time) &gt;= 1">(CDA author RSA): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="count(hl7:time) &lt;= 1">(CDA author RSA): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA author RSA): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA author RSA): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.364
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode
Item: (CDA author RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.364
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA author RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.364
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA author RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
         id="d4750138e434-false-d4751478e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA author RSA): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="count(hl7:id) &gt;= 1">(CDA author RSA): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="count(hl7:code) &lt;= 1">(CDA author RSA): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA author RSA): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="count(hl7:assignedAuthoringDevice[hl7:templateId]) &lt;= 1">(CDA author RSA): element hl7:assignedAuthoringDevice[hl7:templateId] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA author RSA): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.364
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA author RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
         id="d4750138e453-false-d4751590e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="@root">(CDA author RSA): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA author RSA): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="@extension">(CDA author RSA): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA author RSA): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA author RSA): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.364
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDA author RSA)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.364
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA author RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr">
      <extends rule="d4751652e0-false-d4751658e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="@use">(CDA author RSA): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author RSA): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4751652e0-false-d4751658e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.364
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA author RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom"
         id="d4750138e485-false-d4751770e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="@use">(CDA author RSA): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author RSA): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.364
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA author RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <extends rule="d4751818e0-false-d4751830e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA author RSA): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA author RSA): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1" id="d4751818e0-false-d4751830e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.364
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]
Item: (CDA author RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]">
      <extends rule="d4751970e0-false-d4751974e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA author RSA): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.364-2023-11-20T150104.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA author RSA): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1" id="d4751970e0-false-d4751974e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:templateId) &gt;= 1">(CDA assignedAuthoringDevice ): element hl7:templateId is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:code) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:softwareName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:templateId
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:templateId">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@root">(CDA assignedAuthoringDevice ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA assignedAuthoringDevice ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@extension">(CDA assignedAuthoringDevice ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA assignedAuthoringDevice ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:code
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@code">(CDA assignedAuthoringDevice ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA assignedAuthoringDevice ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@codeSystem">(CDA assignedAuthoringDevice ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA assignedAuthoringDevice ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA assignedAuthoringDevice ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA assignedAuthoringDevice ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:manufacturerModelName
Item: (CDA assignedAuthoringDevice )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:softwareName
Item: (CDA assignedAuthoringDevice )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]">
      <extends rule="d4752110e0-false-d4752114e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="string(@classCode) = ('MNT') or not(@classCode)">(CDA assignedAuthoringDevice ): The value for classCode SHALL be 'MNT'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]
Item: (MaintainedEntity)
-->
   <rule fpi="RULC-1" id="d4752110e0-false-d4752114e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']) &gt;= 1">(MaintainedEntity): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']) &lt;= 1">(MaintainedEntity): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:effectiveTime) &lt;= 1">(MaintainedEntity): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:maintainingPerson) &gt;= 1">(MaintainedEntity): element hl7:maintainingPerson is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:maintainingPerson) &lt;= 1">(MaintainedEntity): element hl7:maintainingPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']
Item: (MaintainedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.272')">(MaintainedEntity): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.272'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:effectiveTime
Item: (MaintainedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson
Item: (MaintainedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.364
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA author RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d4752522e0-false-d4752528e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4752522e0-false-d4752528e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4752686e0-false-d4752722e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4752686e0-false-d4752722e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d4752892e0-false-d4752896e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d4752892e0-false-d4752896e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d4753062e0-false-d4753068e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4753062e0-false-d4753068e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4753226e0-false-d4753262e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4753226e0-false-d4753262e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.365
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]
Item: (CDA dataEntererRSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]"
         id="d4752348e406-false-d4753488e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.365-2023-11-22T153143.html"
              test="string(@typeCode) = ('ENT')">(CDA dataEntererRSA): The value for typeCode SHALL be 'ENT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.365-2023-11-22T153143.html"
              test="string(@contextControlCode) = ('OP')">(CDA dataEntererRSA): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.365-2023-11-22T153143.html"
              test="count(hl7:time) &gt;= 1">(CDA dataEntererRSA): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.365-2023-11-22T153143.html"
              test="count(hl7:time) &lt;= 1">(CDA dataEntererRSA): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.365-2023-11-22T153143.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA dataEntererRSA): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.365-2023-11-22T153143.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA dataEntererRSA): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.365
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:time
Item: (CDA dataEntererRSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:time"
         id="d4752348e418-false-d4753569e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.365-2023-11-22T153143.html"
              test="@value">(CDA dataEntererRSA): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.365-2023-11-22T153143.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDA dataEntererRSA): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.365
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA dataEntererRSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d4753871e0-false-d4753877e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4753871e0-false-d4753877e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d4754360e0-false-d4754366e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4754360e0-false-d4754366e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4754524e0-false-d4754560e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4754524e0-false-d4754560e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d4754730e0-false-d4754734e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d4754730e0-false-d4754734e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d4754900e0-false-d4754906e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4754900e0-false-d4754906e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4755064e0-false-d4755100e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4755064e0-false-d4755100e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.366
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]
Item: (CDA custodian RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]"
         id="d4753636e572-false-d4755295e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.366-2023-11-22T161113.html"
              test="string(@typeCode) = ('CST') or not(@typeCode)">(CDA custodian RSA): The value for typeCode SHALL be 'CST'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.366-2023-11-22T161113.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1">(CDA custodian RSA): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.366-2023-11-22T161113.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1">(CDA custodian RSA): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.366
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA custodian RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]">
      <extends rule="d4755361e0-false-d4755365e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.366-2023-11-22T161113.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA custodian RSA): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.75
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA assignedCustodian )
-->
   <rule fpi="RULC-1" id="d4755361e0-false-d4755365e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html"
              test="count(hl7:representedCustodianOrganization) &gt;= 1">(CDA assignedCustodian ): element hl7:representedCustodianOrganization is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html"
              test="count(hl7:representedCustodianOrganization) &lt;= 1">(CDA assignedCustodian ): element hl7:representedCustodianOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.75
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (CDA assignedCustodian )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(custodianOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(custodianOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:id) &gt;= 1">(custodianOrganization): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:name) &gt;= 1">(custodianOrganization): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:name) &lt;= 1">(custodianOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:addr) &lt;= 1">(custodianOrganization): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@root">(custodianOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(custodianOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@extension">(custodianOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@extension) or string-length(@extension)&gt;0">(custodianOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(custodianOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:name
Item: (custodianOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@use">(custodianOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr">
      <extends rule="d4755569e0-false-d4755575e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@use">(custodianOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4755569e0-false-d4755575e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.367
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]
Item: (CDA legalAuthenticator RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
         id="d4755354e150-false-d4755738e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.367-2023-11-22T170324.html"
              test="string(@typeCode) = ('LA') or not(@typeCode)">(CDA legalAuthenticator RSA): The value for typeCode SHALL be 'LA'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.367-2023-11-22T170324.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA legalAuthenticator RSA): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.367-2023-11-22T170324.html"
              test="count(hl7:time) &gt;= 1">(CDA legalAuthenticator RSA): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.367-2023-11-22T170324.html"
              test="count(hl7:time) &lt;= 1">(CDA legalAuthenticator RSA): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.367-2023-11-22T170324.html"
              test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">(CDA legalAuthenticator RSA): element hl7:signatureCode[@code = 'S'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.367-2023-11-22T170324.html"
              test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">(CDA legalAuthenticator RSA): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.367-2023-11-22T170324.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA legalAuthenticator RSA): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.367-2023-11-22T170324.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA legalAuthenticator RSA): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.367
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time
Item: (CDA legalAuthenticator RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.367
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']
Item: (CDA legalAuthenticator RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
         id="d4755354e181-false-d4755837e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.367-2023-11-22T170324.html"
              test="string(@code) = ('S')">(CDA legalAuthenticator RSA): The value for code SHALL be 'S'. Found: "<value-of select="@code"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.367
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA legalAuthenticator RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr">
      <extends rule="d4756137e0-false-d4756143e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4756137e0-false-d4756143e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d4756626e0-false-d4756632e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4756626e0-false-d4756632e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4756790e0-false-d4756826e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4756790e0-false-d4756826e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d4756996e0-false-d4757000e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d4756996e0-false-d4757000e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d4757166e0-false-d4757172e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4757166e0-false-d4757172e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4757330e0-false-d4757366e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4757330e0-false-d4757366e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.368
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]
Item: (CDA participant RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]"
         id="d4755902e572-false-d4757591e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="@typeCode">(CDA participant RSA): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant RSA): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA participant RSA): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA participant RSA): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="count(hl7:time) &lt;= 1">(CDA participant RSA): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="count(hl7:associatedEntity[@classCode]) &gt;= 1">(CDA participant RSA): element hl7:associatedEntity[@classCode] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="count(hl7:associatedEntity[@classCode]) &lt;= 1">(CDA participant RSA): element hl7:associatedEntity[@classCode] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.368
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA participant RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d4755902e624-false-d4757692e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA participant RSA): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="@code">(CDA participant RSA): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA participant RSA): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="@codeSystem">(CDA participant RSA): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA participant RSA): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA participant RSA): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA participant RSA): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.368
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:time
Item: (CDA participant RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.368
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]
Item: (CDA participant RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]"
         id="d4755902e640-false-d4757781e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="@classCode">(CDA participant RSA): attribute @classCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant RSA): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.19313' RoleClassAssociative (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="count(hl7:id) &gt;= 1">(CDA participant RSA): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="count(hl7:code) &lt;= 1">(CDA participant RSA): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="count(hl7:associatedPerson) &lt;= 1">(CDA participant RSA): element hl7:associatedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="count(hl7:scopingOrganization[@classCode = 'ORG']) &lt;= 1">(CDA participant RSA): element hl7:scopingOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.368
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id
Item: (CDA participant RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id"
         id="d4755902e653-false-d4757884e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="@root">(CDA participant RSA): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA participant RSA): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="@extension">(CDA participant RSA): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA participant RSA): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA participant RSA): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.368
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code
Item: (CDA participant RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code"
         id="d4755902e662-false-d4757905e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA participant RSA): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA participant RSA): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA participant RSA): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA participant RSA): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.368
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr
Item: (CDA participant RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr">
      <extends rule="d4757958e0-false-d4757964e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="@use">(CDA participant RSA): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant RSA): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4757958e0-false-d4757964e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.368
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom
Item: (CDA participant RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom"
         id="d4755902e683-false-d4758076e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="@use">(CDA participant RSA): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.368-2023-11-22T172850.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant RSA): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.368
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson
Item: (CDA participant RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.368
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']
Item: (CDA participant RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d4758447e0-false-d4758453e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4758447e0-false-d4758453e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4758611e0-false-d4758647e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4758611e0-false-d4758647e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d4758817e0-false-d4758821e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d4758817e0-false-d4758821e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d4758987e0-false-d4758993e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4758987e0-false-d4758993e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4759151e0-false-d4759187e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4759151e0-false-d4759187e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.369
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:inFulfillmentOf[hl7:order]
Item: (CDA inFulfillmentOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:inFulfillmentOf[hl7:order]"
         id="d4758273e404-false-d4759364e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="string(@typeCode) = ('FLFS') or not(@typeCode)">(CDA inFulfillmentOf RSA): The value for typeCode SHALL be 'FLFS'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="count(hl7:order) &gt;= 1">(CDA inFulfillmentOf RSA): element hl7:order is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="count(hl7:order) &lt;= 1">(CDA inFulfillmentOf RSA): element hl7:order appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.369
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order
Item: (CDA inFulfillmentOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order"
         id="d4758273e416-false-d4759384e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="string(@classCode) = ('ACT') or not(@classCode)">(CDA inFulfillmentOf RSA): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="string(@moodCode) = ('RQO') or not(@moodCode)">(CDA inFulfillmentOf RSA): The value for moodCode SHALL be 'RQO'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="count(hl7:id) &gt;= 1">(CDA inFulfillmentOf RSA): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="count(hl7:id) &lt;= 1">(CDA inFulfillmentOf RSA): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="count(hl7:code) &lt;= 1">(CDA inFulfillmentOf RSA): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="count(hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.7-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA inFulfillmentOf RSA): element hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.7-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.369
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:id
Item: (CDA inFulfillmentOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:id"
         id="d4758273e424-false-d4759423e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="@root">(CDA inFulfillmentOf RSA): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA inFulfillmentOf RSA): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="@extension">(CDA inFulfillmentOf RSA): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA inFulfillmentOf RSA): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.369
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:code
Item: (CDA inFulfillmentOf RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.369
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.7-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA inFulfillmentOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.7-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d4758273e453-false-d4759452e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.369-2023-11-22T175006.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.5.7-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA inFulfillmentOf RSA): The element value SHALL be one of '2.16.840.1.113883.5.7 HL7  ActPriority (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.371
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]
Item: (CDA documentationOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]"
         id="d4759458e26-false-d4759522e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="string(@typeCode) = ('DOC') or not(@typeCode)">(CDA documentationOf RSA): The value for typeCode SHALL be 'DOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(CDA documentationOf RSA): element hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(CDA documentationOf RSA): element hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.371
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (CDA documentationOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
         id="d4759458e36-false-d4759646e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="string(@classCode) = ('ACT') or not(@classCode)">(CDA documentationOf RSA): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA documentationOf RSA): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(CDA documentationOf RSA): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA documentationOf RSA): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA documentationOf RSA): element hl7:effectiveTime appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.371
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:id
Item: (CDA documentationOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:id"
         id="d4759458e53-false-d4759735e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="@root">(CDA documentationOf RSA): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA documentationOf RSA): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="@extension">(CDA documentationOf RSA): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA documentationOf RSA): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.371
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA documentationOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d4759458e73-false-d4759756e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA documentationOf RSA): The element value SHALL be one of '2.16.840.1.113883.2.9.5.1.4  Estensione Vocabolario ActCode (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="@code">(CDA documentationOf RSA): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA documentationOf RSA): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.5.1.4')">(CDA documentationOf RSA): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.5.1.4'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA documentationOf RSA): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA documentationOf RSA): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.371
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:effectiveTime
Item: (CDA documentationOf RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.371
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]
Item: (CDA documentationOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]"
         id="d4759458e89-false-d4759845e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="@typeCode">(CDA documentationOf RSA): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(CDA documentationOf RSA): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="count(hl7:functionCode) &lt;= 1">(CDA documentationOf RSA): element hl7:functionCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="count(hl7:time) &lt;= 1">(CDA documentationOf RSA): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA documentationOf RSA): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.371-2023-12-17T112250.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA documentationOf RSA): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.371
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:functionCode
Item: (CDA documentationOf RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.371
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:time
Item: (CDA documentationOf RSA)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.371
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA documentationOf RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d4760232e0-false-d4760238e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4760232e0-false-d4760238e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d4760721e0-false-d4760727e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4760721e0-false-d4760727e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4760885e0-false-d4760921e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4760885e0-false-d4760921e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d4761091e0-false-d4761095e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d4761091e0-false-d4761095e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d4761261e0-false-d4761267e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4761261e0-false-d4761267e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4761425e0-false-d4761461e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4761425e0-false-d4761461e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.372
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]
Item: (CDA relatedDocument RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
         id="d4759997e572-false-d4761638e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="@typeCode">(CDA relatedDocument RSA): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA relatedDocument RSA): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="count(hl7:parentDocument) &gt;= 1">(CDA relatedDocument RSA): element hl7:parentDocument is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="count(hl7:parentDocument) &lt;= 1">(CDA relatedDocument RSA): element hl7:parentDocument appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.372
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument
Item: (CDA relatedDocument RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
         id="d4759997e618-false-d4761669e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(CDA relatedDocument RSA): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA relatedDocument RSA): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="count(hl7:id) &gt;= 1">(CDA relatedDocument RSA): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="count(hl7:code) &lt;= 1">(CDA relatedDocument RSA): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="count(hl7:text) &lt;= 1">(CDA relatedDocument RSA): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="count(hl7:setId) &lt;= 1">(CDA relatedDocument RSA): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="count(hl7:versionNumber) &lt;= 1">(CDA relatedDocument RSA): element hl7:versionNumber appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.372
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id
Item: (CDA relatedDocument RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
         id="d4759997e624-false-d4761715e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="@root">(CDA relatedDocument RSA): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocument RSA): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="@extension">(CDA relatedDocument RSA): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA relatedDocument RSA): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.372
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code
Item: (CDA relatedDocument RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
         id="d4759997e644-false-d4761733e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="@code">(CDA relatedDocument RSA): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA relatedDocument RSA): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="@codeSystem">(CDA relatedDocument RSA): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocument RSA): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA relatedDocument RSA): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.372-2023-12-17T115146.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA relatedDocument RSA): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.372
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:text
Item: (CDA relatedDocument RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.372
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:setId
Item: (CDA relatedDocument RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.372
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:versionNumber
Item: (CDA relatedDocument RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.373
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]
Item: (CDA componentOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]"
         id="d4761775e24-false-d4761875e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(CDA componentOf RSA): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:encompassingEncounter[hl7:location]) &gt;= 1">(CDA componentOf RSA): element hl7:encompassingEncounter[hl7:location] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:encompassingEncounter[hl7:location]) &lt;= 1">(CDA componentOf RSA): element hl7:encompassingEncounter[hl7:location] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.373
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]
Item: (CDA componentOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]"
         id="d4761775e36-false-d4762081e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="string(@classCode) = ('ENC') or not(@classCode)">(CDA componentOf RSA): The value for classCode SHALL be 'ENC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA componentOf RSA): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA componentOf RSA): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:effectiveTime) &gt;= 1">(CDA componentOf RSA): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA componentOf RSA): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:responsibleParty[hl7:assignedEntity]) &lt;= 1">(CDA componentOf RSA): element hl7:responsibleParty[hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:location[hl7:healthCareFacility]) &gt;= 1">(CDA componentOf RSA): element hl7:location[hl7:healthCareFacility] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:location[hl7:healthCareFacility]) &lt;= 1">(CDA componentOf RSA): element hl7:location[hl7:healthCareFacility] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.373
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:id
Item: (CDA componentOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:id"
         id="d4761775e44-false-d4762225e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="@root">(CDA componentOf RSA): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf RSA): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="@extension">(CDA componentOf RSA): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA componentOf RSA): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA componentOf RSA): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.373
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA componentOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d4761775e95-false-d4762249e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA componentOf RSA): The element value SHALL be one of '2.16.840.1.113883.1.11.13955 ActEncounterCode (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA componentOf RSA): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf RSA): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA componentOf RSA): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA componentOf RSA): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.373
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:effectiveTime
Item: (CDA componentOf RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.373
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]
Item: (CDA componentOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]"
         id="d4761775e130-false-d4762335e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="string(@typeCode) = ('RESP') or not(@typeCode)">(CDA componentOf RSA): The value for typeCode SHALL be 'RESP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA componentOf RSA): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA componentOf RSA): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.373
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA componentOf RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d4762693e0-false-d4762699e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4762693e0-false-d4762699e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d4763182e0-false-d4763188e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4763182e0-false-d4763188e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4763346e0-false-d4763382e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4763346e0-false-d4763382e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d4763552e0-false-d4763556e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d4763552e0-false-d4763556e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d4763722e0-false-d4763728e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4763722e0-false-d4763728e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4763886e0-false-d4763922e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4763886e0-false-d4763922e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.373
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]
Item: (CDA componentOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]"
         id="d4761775e145-false-d4764142e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="string(@typeCode) = ('LOC') or not(@typeCode)">(CDA componentOf RSA): The value for typeCode SHALL be 'LOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]) &gt;= 1">(CDA componentOf RSA): element hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]) &lt;= 1">(CDA componentOf RSA): element hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.373
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]
Item: (CDA componentOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]"
         id="d4761775e151-false-d4764250e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="string(@classCode) = ('SDLOC') or not(@classCode)">(CDA componentOf RSA): The value for classCode SHALL be 'SDLOC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA componentOf RSA): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:location) &lt;= 1">(CDA componentOf RSA): element hl7:location appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]) &gt;= 1">(CDA componentOf RSA): element hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="count(hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]) &lt;= 1">(CDA componentOf RSA): element hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.373
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']
Item: (CDA componentOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']"
         id="d4761775e184-false-d4764335e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.1.6')">(CDA componentOf RSA): The value for root SHALL be '2.16.840.1.113883.2.9.4.1.6'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="@extension">(CDA componentOf RSA): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA componentOf RSA): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA componentOf RSA): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.373
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA componentOf RSA)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d4761775e209-false-d4764358e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA componentOf RSA): The element value SHALL be one of '2.16.840.1.113883.1.11.17660 ServiceDeliveryLocationRoleType (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA componentOf RSA): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf RSA): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA componentOf RSA): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA componentOf RSA): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.373
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location
Item: (CDA componentOf RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location">
      <extends rule="d4764417e0-false-d4764432e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA componentOf RSA): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.373-2023-12-17T120137.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA componentOf RSA): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location
Item: (CDA place )
-->
   <rule fpi="RULC-1" id="d4764417e0-false-d4764432e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="count(hl7:name) &lt;= 1">(CDA place ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="count(hl7:addr) &lt;= 1">(CDA place ): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:templateId
Item: (CDA place )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:name
Item: (CDA place )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr
Item: (CDA place )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr">
      <extends rule="d4764514e0-false-d4764520e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="@use">(CDA place ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA place ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4764514e0-false-d4764520e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.373
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]
Item: (CDA componentOf RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.374
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]
Item: (CDA Organization RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="string(@classCode) = ('ORG')">(CDA Organization RSA): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization RSA): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization RSA): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="count(hl7:asOrganizationPartOf) &gt;= 1">(CDA Organization RSA): element hl7:asOrganizationPartOf is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization RSA): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.374
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:id
Item: (CDA Organization RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="@root">(CDA Organization RSA): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization RSA): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="@extension">(CDA Organization RSA): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization RSA): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization RSA): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.374
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:name
Item: (CDA Organization RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.374
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:telecom
Item: (CDA Organization RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="@use">(CDA Organization RSA): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization RSA): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.374
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr
Item: (CDA Organization RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr">
      <extends rule="d4764839e0-false-d4764845e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="@use">(CDA Organization RSA): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization RSA): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4764839e0-false-d4764845e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.374
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf
Item: (CDA Organization RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf">
      <extends rule="d4765003e0-false-d4765039e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization RSA): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization RSA): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4765003e0-false-d4765039e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d4765209e0-false-d4765213e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d4765209e0-false-d4765213e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d4765379e0-false-d4765385e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4765379e0-false-d4765385e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d4765543e0-false-d4765579e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d4765543e0-false-d4765579e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d4765749e0-false-d4765753e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d4765749e0-false-d4765753e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d4765919e0-false-d4765925e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d4765919e0-false-d4765925e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]
Item: (Referto di Televisita )
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]"
         id="d44e90444-false-d4766203e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita ): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita ): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:structuredBody) &gt;= 1">(Referto di Televisita ): element hl7:structuredBody is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:structuredBody) &lt;= 1">(Referto di Televisita ): element hl7:structuredBody appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody
Item: (Referto di Televisita )
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody"
         id="d44e90450-false-d4766455e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@classCode) = ('DOCBODY') or not(@classCode)">(Referto di Televisita ): The value for classCode SHALL be 'DOCBODY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Referto di Televisita ): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '29299-5 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '29299-5 ' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '30954-2' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '30954-2 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '30954-2' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '30954-2 ' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '62387-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &gt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '62387-6' and @codeSystem = '2.16.840.1.113883.6.1')]]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '62387-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '62387-6' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '93126-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '93126-1' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '47045-0' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '47045-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &gt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '47045-0' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '47045-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '47045-0' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '47045-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '47045-0' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '47045-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '55110-1' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '55110-1 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '55110-1' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '55110-1 ' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '62385-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '62385-0' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '80615-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '80615-8' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita ): element hl7:component[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '29299-5 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '29299-5 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita ): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita ): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita ): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita ): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '30954-2' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '30954-2 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '30954-2' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '30954-2 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita ): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita ): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita ): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita ): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '62387-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '62387-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita ): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita ): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '93126-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '93126-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita ): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita ): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '47045-0' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '47045-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '47045-0' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '47045-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita ): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita ): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita ): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita ): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '55110-1' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '55110-1 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '55110-1' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '55110-1 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita ): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita ): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '62385-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '62385-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita ): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita ): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '80615-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '80615-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita ): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita ): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.598
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita ): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.598-2025-05-02T124302.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita ): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
