<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.569
Name: Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)
Description: Template CDA SubstanceAdministration (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628">
   <title>Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]"
         id="d44e84592-false-d4646915e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]"
         id="d44e84618-false-d4646978e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="string(@classCode) = ('SBADM')">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): The value for classCode SHALL be 'SBADM'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="string(@moodCode) = ('INT')">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): The value for moodCode SHALL be 'INT'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:text) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:statusCode) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:effectiveTime[hl7:low]) &gt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:effectiveTime[hl7:low] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:effectiveTime[hl7:low]) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:effectiveTime[hl7:low] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:routeCode) &gt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:routeCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:routeCode) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:routeCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:doseQuantity) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:doseQuantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:rateQuantity) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:rateQuantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:administrationUnitCode) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:administrationUnitCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:consumable[hl7:manufacturedProduct]) &gt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:consumable[hl7:manufacturedProduct] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:consumable[hl7:manufacturedProduct]) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:consumable[hl7:manufacturedProduct] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply[@moodCode = 'RQO']]) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply[@moodCode = 'RQO']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:text
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:text"
         id="d44e84626-false-d4647105e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:reference) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:reference appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:text/hl7:reference
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:text/hl7:reference"
         id="d44e84636-false-d4647119e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="@value">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:statusCode
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:statusCode"
         id="d44e84644-false-d4647130e0">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.10' X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:effectiveTime[hl7:low]
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:effectiveTime[hl7:low]"
         id="d44e84661-false-d4647150e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:low) &gt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:low) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:low appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:high) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:high appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:effectiveTime[hl7:low]/hl7:low
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:effectiveTime[hl7:low]/hl7:high
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:effectiveTime
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:routeCode
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:routeCode"
         id="d44e84770-false-d4647196e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="@code">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.14581' RouteOfAdministration (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="@codeSystem">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:originalText[hl7:reference]) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:originalText[hl7:reference] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:routeCode/hl7:originalText[hl7:reference]
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:routeCode/hl7:originalText[hl7:reference]"
         id="d44e84806-false-d4647236e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:reference) &gt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:reference) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:reference appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:routeCode/hl7:originalText[hl7:reference]/hl7:reference
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:routeCode/hl7:originalText[hl7:reference]/hl7:reference"
         id="d44e84810-false-d4647252e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="@value">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:approachSiteCode
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:approachSiteCode"
         id="d44e84819-false-d4647263e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="@code">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.34-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.34' ActSite (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="@codeSystem">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:originalText[hl7:reference]) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:originalText[hl7:reference] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:approachSiteCode/hl7:originalText[hl7:reference]
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:approachSiteCode/hl7:originalText[hl7:reference]"
         id="d44e84855-false-d4647303e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:reference) &gt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:reference) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:reference appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:approachSiteCode/hl7:originalText[hl7:reference]/hl7:reference
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:approachSiteCode/hl7:originalText[hl7:reference]/hl7:reference"
         id="d44e84859-false-d4647319e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="@value">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:doseQuantity
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:doseQuantity"
         id="d44e84868-false-d4647330e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:low) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:low appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:high) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:high appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:originalText[hl7:reference]) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:originalText[hl7:reference] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:doseQuantity/hl7:low
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:doseQuantity/hl7:high
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:doseQuantity/hl7:originalText[hl7:reference]
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:doseQuantity/hl7:originalText[hl7:reference]"
         id="d44e84907-false-d4647372e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:reference) &gt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:reference) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:reference appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:doseQuantity/hl7:originalText[hl7:reference]/hl7:reference
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:doseQuantity/hl7:originalText[hl7:reference]/hl7:reference"
         id="d44e84911-false-d4647388e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="@value">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:rateQuantity
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:rateQuantity"
         id="d44e84920-false-d4647399e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:originalText[hl7:reference]) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:originalText[hl7:reference] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:rateQuantity/hl7:low
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:rateQuantity/hl7:high
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:rateQuantity/hl7:originalText[hl7:reference]
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:rateQuantity/hl7:originalText[hl7:reference]"
         id="d44e84959-false-d4647437e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:reference) &gt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:reference) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:reference appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:rateQuantity/hl7:originalText[hl7:reference]/hl7:reference
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:rateQuantity/hl7:originalText[hl7:reference]/hl7:reference"
         id="d44e84963-false-d4647453e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="@value">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:administrationUnitCode
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:administrationUnitCode"
         id="d44e84973-false-d4647464e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="@code">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="@codeSystem">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.570
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]
Item: (Terapie Farmacologiche Dimissione (manufacturedProduct) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.570-2024-04-25T173517.html"
              test="count(hl7:manufacturedProduct[hl7:manufacturedMaterial]) &gt;= 1">(Terapie Farmacologiche Dimissione (manufacturedProduct) (LDO)): element hl7:manufacturedProduct[hl7:manufacturedMaterial] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.570-2024-04-25T173517.html"
              test="count(hl7:manufacturedProduct[hl7:manufacturedMaterial]) &lt;= 1">(Terapie Farmacologiche Dimissione (manufacturedProduct) (LDO)): element hl7:manufacturedProduct[hl7:manufacturedMaterial] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.570
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedMaterial]
Item: (Terapie Farmacologiche Dimissione (manufacturedProduct) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedMaterial]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.570-2024-04-25T173517.html"
              test="string(@classCode) = ('MANU') or not(@classCode)">(Terapie Farmacologiche Dimissione (manufacturedProduct) (LDO)): The value for classCode SHALL be 'MANU'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.570-2024-04-25T173517.html"
              test="count(hl7:manufacturedMaterial[hl7:code]) &gt;= 1">(Terapie Farmacologiche Dimissione (manufacturedProduct) (LDO)): element hl7:manufacturedMaterial[hl7:code] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.570-2024-04-25T173517.html"
              test="count(hl7:manufacturedMaterial[hl7:code]) &lt;= 1">(Terapie Farmacologiche Dimissione (manufacturedProduct) (LDO)): element hl7:manufacturedMaterial[hl7:code] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.570
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedMaterial]/hl7:manufacturedMaterial[hl7:code]
Item: (Terapie Farmacologiche Dimissione (manufacturedProduct) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.571
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedMaterial]/hl7:manufacturedMaterial[hl7:code]
Item: (Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedMaterial]/hl7:manufacturedMaterial[hl7:code]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="count(hl7:code) &gt;= 1">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="count(hl7:code) &lt;= 1">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): element hl7:code appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.571
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedMaterial]/hl7:manufacturedMaterial[hl7:code]/hl7:code
Item: (Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedMaterial]/hl7:manufacturedMaterial[hl7:code]/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="@code">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="@codeSystem">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="count(hl7:originalText[hl7:reference]) &lt;= 1">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): element hl7:originalText[hl7:reference] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="count(hl7:translation) &lt;= 1">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): element hl7:translation appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.571
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedMaterial]/hl7:manufacturedMaterial[hl7:code]/hl7:code/hl7:originalText[hl7:reference]
Item: (Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedMaterial]/hl7:manufacturedMaterial[hl7:code]/hl7:code/hl7:originalText[hl7:reference]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="count(hl7:reference) &gt;= 1">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="count(hl7:reference) &lt;= 1">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.571
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedMaterial]/hl7:manufacturedMaterial[hl7:code]/hl7:code/hl7:originalText[hl7:reference]/hl7:reference
Item: (Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedMaterial]/hl7:manufacturedMaterial[hl7:code]/hl7:code/hl7:originalText[hl7:reference]/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="@value">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.571
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedMaterial]/hl7:manufacturedMaterial[hl7:code]/hl7:code/hl7:translation
Item: (Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct[hl7:manufacturedMaterial]/hl7:manufacturedMaterial[hl7:code]/hl7:code/hl7:translation">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="@code">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="@codeSystem">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.571-2024-04-25T173632.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terapie Farmacologiche Dimissione (manufacturedMaterial) (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.551
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant
Item: (Participant Esecutore LDO)
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.551-2024-04-24T170151.html"
              test="count(hl7:time) &lt;= 1">(Participant Esecutore LDO): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.551-2024-04-24T170151.html"
              test="count(hl7:participantRole[hl7:playingEntity]) &lt;= 1">(Participant Esecutore LDO): element hl7:participantRole[hl7:playingEntity] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.551
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:time
Item: (Participant Esecutore LDO)
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:time">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.551-2024-04-24T170151.html"
              test="@value">(Participant Esecutore LDO): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.551
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]
Item: (Participant Esecutore LDO)
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.551-2024-04-24T170151.html"
              test="count(hl7:id) &gt;= 1">(Participant Esecutore LDO): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.551-2024-04-24T170151.html"
              test="count(hl7:playingEntity) &gt;= 1">(Participant Esecutore LDO): element hl7:playingEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.551-2024-04-24T170151.html"
              test="count(hl7:playingEntity) &lt;= 1">(Participant Esecutore LDO): element hl7:playingEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.551
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]/hl7:id
Item: (Participant Esecutore LDO)
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.551-2024-04-24T170151.html"
              test="@root">(Participant Esecutore LDO): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.551-2024-04-24T170151.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Participant Esecutore LDO): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.551-2024-04-24T170151.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Participant Esecutore LDO): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.551-2024-04-24T170151.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Participant Esecutore LDO): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.551
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity
Item: (Participant Esecutore LDO)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]">
      <extends rule="d4647960e0-false-d4647964e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="string(@typeCode) = ('COMP')">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.566
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]
Item: (Terap Farm  - Grammatura (Observation) (LDO))
-->
   <rule fpi="RULC-1" id="d4647960e0-false-d4647964e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="count(hl7:observation[@moodCode = 'EVN']) &gt;= 1">(Terap Farm  - Grammatura (Observation) (LDO)): element hl7:observation[@moodCode = 'EVN'] is required [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.566
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]/hl7:observation[@moodCode = 'EVN']
Item: (Terap Farm  - Grammatura (Observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]/hl7:observation[@moodCode = 'EVN']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Terap Farm  - Grammatura (Observation) (LDO)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="string(@moodCode) = ('EVN')">(Terap Farm  - Grammatura (Observation) (LDO)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="count(hl7:code) &lt;= 1">(Terap Farm  - Grammatura (Observation) (LDO)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="count(hl7:value) &lt;= 1">(Terap Farm  - Grammatura (Observation) (LDO)): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.566
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]/hl7:observation[@moodCode = 'EVN']/hl7:code
Item: (Terap Farm  - Grammatura (Observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]/hl7:observation[@moodCode = 'EVN']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="@code">(Terap Farm  - Grammatura (Observation) (LDO)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Terap Farm  - Grammatura (Observation) (LDO)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="@codeSystem">(Terap Farm  - Grammatura (Observation) (LDO)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Terap Farm  - Grammatura (Observation) (LDO)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terap Farm  - Grammatura (Observation) (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terap Farm  - Grammatura (Observation) (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.566
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]/hl7:observation[@moodCode = 'EVN']/hl7:value
Item: (Terap Farm  - Grammatura (Observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]/hl7:observation[@moodCode = 'EVN']/hl7:value">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="@nullFlavor or ($xsiLocalName='REAL' and $xsiLocalNS='urn:hl7-org:v3')">(Terap Farm  - Grammatura (Observation) (LDO)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:REAL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="@value">(Terap Farm  - Grammatura (Observation) (LDO)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="not(@value) or string-length(@value)&gt;0">(Terap Farm  - Grammatura (Observation) (LDO)): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="@unit">(Terap Farm  - Grammatura (Observation) (LDO)): attribute @unit SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.566-2024-04-25T164752.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(Terap Farm  - Grammatura (Observation) (LDO)): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]">
      <extends rule="d4648066e0-false-d4648070e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="string(@typeCode) = ('COMP')">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.567
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]
Item: (Terap Farm  - Quantità (Observation) (LDO))
-->
   <rule fpi="RULC-1" id="d4648066e0-false-d4648070e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="count(hl7:observation[@moodCode = 'EVN']) &gt;= 1">(Terap Farm  - Quantità (Observation) (LDO)): element hl7:observation[@moodCode = 'EVN'] is required [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.567
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]/hl7:observation[@moodCode = 'EVN']
Item: (Terap Farm  - Quantità (Observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]/hl7:observation[@moodCode = 'EVN']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Terap Farm  - Quantità (Observation) (LDO)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="string(@moodCode) = ('EVN')">(Terap Farm  - Quantità (Observation) (LDO)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="count(hl7:code) &lt;= 1">(Terap Farm  - Quantità (Observation) (LDO)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="count(hl7:value) &lt;= 1">(Terap Farm  - Quantità (Observation) (LDO)): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.567
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]/hl7:observation[@moodCode = 'EVN']/hl7:code
Item: (Terap Farm  - Quantità (Observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]/hl7:observation[@moodCode = 'EVN']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="@code">(Terap Farm  - Quantità (Observation) (LDO)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Terap Farm  - Quantità (Observation) (LDO)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="@codeSystem">(Terap Farm  - Quantità (Observation) (LDO)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Terap Farm  - Quantità (Observation) (LDO)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terap Farm  - Quantità (Observation) (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terap Farm  - Quantità (Observation) (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.567
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]/hl7:observation[@moodCode = 'EVN']/hl7:value
Item: (Terap Farm  - Quantità (Observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation[@moodCode = 'EVN']]/hl7:observation[@moodCode = 'EVN']/hl7:value">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="@nullFlavor or ($xsiLocalName='REAL' and $xsiLocalNS='urn:hl7-org:v3')">(Terap Farm  - Quantità (Observation) (LDO)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:REAL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="@value">(Terap Farm  - Quantità (Observation) (LDO)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="not(@value) or string-length(@value)&gt;0">(Terap Farm  - Quantità (Observation) (LDO)): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="@unit">(Terap Farm  - Quantità (Observation) (LDO)): attribute @unit SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.567-2024-04-25T165303.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(Terap Farm  - Quantità (Observation) (LDO)): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply[@moodCode = 'RQO']]
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply[@moodCode = 'RQO']]"
         id="d44e85016-false-d4648159e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="string(@typeCode) = ('COMP')">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:supply[@moodCode = 'RQO']) &gt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:supply[@moodCode = 'RQO'] is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply[@moodCode = 'RQO']]/hl7:supply[@moodCode = 'RQO']
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply[@moodCode = 'RQO']]/hl7:supply[@moodCode = 'RQO']"
         id="d44e85028-false-d4648177e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="string(@classCode) = ('SPLY') or not(@classCode)">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): The value for classCode SHALL be 'SPLY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="string(@moodCode) = ('RQO')">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): The value for moodCode SHALL be 'RQO'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="count(hl7:quantity) &lt;= 1">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): element hl7:quantity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.569
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply[@moodCode = 'RQO']]/hl7:supply[@moodCode = 'RQO']/hl7:quantity
Item: (Terapie Farmacologiche Dimissione (substanceAdministration) (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply[@moodCode = 'RQO']]/hl7:supply[@moodCode = 'RQO']/hl7:quantity"
         id="d44e85036-false-d4648199e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.569-2024-04-25T172628.html"
              test="@value">(Terapie Farmacologiche Dimissione (substanceAdministration) (LDO)): attribute @value SHALL be present.</assert>
   </rule>
</pattern>
