<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.515
Name: Allergie - (act) (RAD)
Description: Template CDA Act (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907">
   <title>Allergie - (act) (RAD)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.515
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]
Item: (Allergie - (act) (RAD))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]"
         id="d44e77387-false-d4639966e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]) &gt;= 1">(Allergie - (act) (RAD)): element hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]) &lt;= 1">(Allergie - (act) (RAD)): element hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.515
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]
Item: (Allergie - (act) (RAD))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]"
         id="d44e77411-false-d4640023e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="string(@classCode) = ('ACT')">(Allergie - (act) (RAD)): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="string(@moodCode) = ('EVN')">(Allergie - (act) (RAD)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:code) &gt;= 1">(Allergie - (act) (RAD)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:code) &lt;= 1">(Allergie - (act) (RAD)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:text) &lt;= 1">(Allergie - (act) (RAD)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:statusCode) &gt;= 1">(Allergie - (act) (RAD)): element hl7:statusCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:statusCode) &lt;= 1">(Allergie - (act) (RAD)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Allergie - (act) (RAD)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Allergie - (act) (RAD)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &gt;= 1">(Allergie - (act) (RAD)): element hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Allergie - (act) (RAD)): element hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.515
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:code
Item: (Allergie - (act) (RAD))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:code"
         id="d44e77428-false-d4640099e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="string(@nullFlavor) = ('NA') or not(@nullFlavor)">(Allergie - (act) (RAD)): The value for nullFlavor SHALL be 'NA'. Found: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.515
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:text
Item: (Allergie - (act) (RAD))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.515
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:statusCode
Item: (Allergie - (act) (RAD))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:statusCode"
         id="d44e77436-false-d4640118e0">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie - (act) (RAD)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.10' X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.515
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:effectiveTime
Item: (Allergie - (act) (RAD))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:effectiveTime"
         id="d44e77444-false-d4640138e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:low) &gt;= 1">(Allergie - (act) (RAD)): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:low) &lt;= 1">(Allergie - (act) (RAD)): element hl7:low appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="count(hl7:high) &lt;= 1">(Allergie - (act) (RAD)): element hl7:high appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.515
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:effectiveTime/hl7:low
Item: (Allergie - (act) (RAD))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:effectiveTime/hl7:low"
         id="d44e77452-false-d4640160e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="@value">(Allergie - (act) (RAD)): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.515
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:effectiveTime/hl7:high
Item: (Allergie - (act) (RAD))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:effectiveTime/hl7:high"
         id="d44e77463-false-d4640171e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="@value">(Allergie - (act) (RAD)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.515
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Allergie - (act) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <extends rule="d4640216e0-false-d4640220e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="@typeCode">(Allergie - (act) (RAD)): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.515-2024-03-14T094907.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Allergie - (act) (RAD)): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Allergie - observation (RAD))
-->
   <rule fpi="RULC-1" id="d4640216e0-false-d4640220e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(Allergie - observation (RAD)): element hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Allergie - observation (RAD)): element hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Allergie - observation (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Allergie - observation (RAD)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="string(@moodCode) = ('EVN')">(Allergie - observation (RAD)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Allergie - observation (RAD)): element hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Allergie - observation (RAD)): element hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:text) &lt;= 1">(Allergie - observation (RAD)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(Allergie - observation (RAD)): element hl7:statusCode[@code = 'completed'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(Allergie - observation (RAD)): element hl7:statusCode[@code = 'completed'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:effectiveTime[hl7:low]) &gt;= 1">(Allergie - observation (RAD)): element hl7:effectiveTime[hl7:low] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:effectiveTime[hl7:low]) &lt;= 1">(Allergie - observation (RAD)): element hl7:effectiveTime[hl7:low] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.28-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(Allergie - observation (RAD)): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.28-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.28-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Allergie - observation (RAD)): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.28-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:participant[@typeCode = 'CSM'][hl7:participantRole]) &gt;= 1">(Allergie - observation (RAD)): element hl7:participant[@typeCode = 'CSM'][hl7:participantRole] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]) &lt;= 1">(Allergie - observation (RAD)): element hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Allergie - observation (RAD)): element hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Allergie - observation (RAD)): element hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Allergie - observation (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="string(@code) = ('52473-6')">(Allergie - observation (RAD)): The value for code SHALL be '52473-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Allergie - observation (RAD)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Allergie - observation (RAD)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie - observation (RAD)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="string(@displayName) = ('Allergia o causa della reazione') or not(@displayName)">(Allergie - observation (RAD)): The value for displayName SHALL be 'Allergia o causa della reazione'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie - observation (RAD)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Allergie - observation (RAD))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text/hl7:reference
Item: (Allergie - observation (RAD))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = 'completed']
Item: (Allergie - observation (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = 'completed']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="string(@code) = ('completed')">(Allergie - observation (RAD)): The value for code SHALL be 'completed'. Found: "<value-of select="@code"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie - observation (RAD)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.10' X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime[hl7:low]
Item: (Allergie - observation (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime[hl7:low]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:low) &gt;= 1">(Allergie - observation (RAD)): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:low) &lt;= 1">(Allergie - observation (RAD)): element hl7:low appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="count(hl7:high) &lt;= 1">(Allergie - observation (RAD)): element hl7:high appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime[hl7:low]/hl7:low
Item: (Allergie - observation (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime[hl7:low]/hl7:low">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="@value">(Allergie - observation (RAD)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime[hl7:low]/hl7:high
Item: (Allergie - observation (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime[hl7:low]/hl7:high">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="@value">(Allergie - observation (RAD)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.28-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Allergie - observation (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.28-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.28-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Allergie - observation (RAD)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.28  ObservationIntoleranceType DINAMIC (DYNAMIC)'.</assert>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Allergie - observation (RAD)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]
Item: (Allergie - observation (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]">
      <extends rule="d4640539e0-false-d4640543e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="string(@typeCode) = ('CSM')">(Allergie - observation (RAD)): The value for typeCode SHALL be 'CSM'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.517
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]
Item: (Allergie -  Agente (participantRole) (RAD))
-->
   <rule fpi="RULC-1" id="d4640539e0-false-d4640543e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.517-2024-03-14T110017.html"
              test="count(hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &gt;= 1">(Allergie -  Agente (participantRole) (RAD)): element hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.517-2024-03-14T110017.html"
              test="count(hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &lt;= 1">(Allergie -  Agente (participantRole) (RAD)): element hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.517
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]
Item: (Allergie -  Agente (participantRole) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.517-2024-03-14T110017.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(Allergie -  Agente (participantRole) (RAD)): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.517-2024-03-14T110017.html"
              test="count(hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(Allergie -  Agente (participantRole) (RAD)): element hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.517-2024-03-14T110017.html"
              test="count(hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(Allergie -  Agente (participantRole) (RAD)): element hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.517
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (Allergie -  Agente (participantRole) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]">
      <extends rule="d4640612e0-false-d4640616e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.517-2024-03-14T110017.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(Allergie -  Agente (participantRole) (RAD)): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.518
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (Allergie- Agente (playingEntity) (RAD))
-->
   <rule fpi="RULC-1" id="d4640612e0-false-d4640616e0" abstract="true">
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt; 1">(Allergie- Agente (playingEntity) (RAD)): element hl7:code is coded with binding strength 'extensible' and contains a code other than the specified set.</report>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Allergie- Agente (playingEntity) (RAD)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.518
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Allergie- Agente (playingEntity) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Allergie- Agente (playingEntity) (RAD)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.56 AllergenNoDrugs_PSSIT (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="@code">(Allergie- Agente (playingEntity) (RAD)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Allergie- Agente (playingEntity) (RAD)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Allergie- Agente (playingEntity) (RAD)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie- Agente (playingEntity) (RAD)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie- Agente (playingEntity) (RAD)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="count(hl7:translation) &lt;= 1">(Allergie- Agente (playingEntity) (RAD)): element hl7:translation appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.518
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]/hl7:translation
Item: (Allergie- Agente (playingEntity) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.56-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]/hl7:translation">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="@code">(Allergie- Agente (playingEntity) (RAD)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Allergie- Agente (playingEntity) (RAD)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="@codeSystem">(Allergie- Agente (playingEntity) (RAD)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Allergie- Agente (playingEntity) (RAD)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie- Agente (playingEntity) (RAD)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.518-2024-03-14T110311.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie- Agente (playingEntity) (RAD)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Allergie - observation (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <extends rule="d4640713e0-false-d4640717e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="string(@typeCode) = ('MFST')">(Allergie - observation (RAD)): The value for typeCode SHALL be 'MFST'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.519
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Allergie- Reazione (observation) (RAD))
-->
   <rule fpi="RULC-1" id="d4640713e0-false-d4640717e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.519
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Allergie- Reazione (observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Allergie- Reazione (observation) (RAD)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="string(@moodCode) = ('EVN')">(Allergie- Reazione (observation) (RAD)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:text[hl7:reference]) &lt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:text[hl7:reference] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:statusCode) &lt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.519
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Allergie- Reazione (observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="string(@code) = ('75321-0')">(Allergie- Reazione (observation) (RAD)): The value for code SHALL be '75321-0'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Allergie- Reazione (observation) (RAD)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Allergie- Reazione (observation) (RAD)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie- Reazione (observation) (RAD)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="string(@displayName) = ('Obiettività Clinica') or not(@displayName)">(Allergie- Reazione (observation) (RAD)): The value for displayName SHALL be 'Obiettività Clinica'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie- Reazione (observation) (RAD)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.519
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text[hl7:reference]
Item: (Allergie- Reazione (observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text[hl7:reference]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:reference) &gt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:reference) &lt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.519
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text[hl7:reference]/hl7:reference
Item: (Allergie- Reazione (observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text[hl7:reference]/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="@value">(Allergie- Reazione (observation) (RAD)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.519
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode
Item: (Allergie- Reazione (observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="@code">(Allergie- Reazione (observation) (RAD)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie- Reazione (observation) (RAD)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.15933' ActStatus (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.519
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime
Item: (Allergie- Reazione (observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:low) &gt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:low) &lt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:low appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="count(hl7:high) &lt;= 1">(Allergie- Reazione (observation) (RAD)): element hl7:high appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.519
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime/hl7:low
Item: (Allergie- Reazione (observation) (RAD))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.519
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime/hl7:high
Item: (Allergie- Reazione (observation) (RAD))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.519
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Allergie- Reazione (observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Allergie- Reazione (observation) (RAD)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.29  ReazioniIntolleranza (DYNAMIC) or 2.16.840.1.113883.3.1937.777.63.11.31 ReazioniAllergiche (DYNAMIC)'.</assert>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Allergie- Reazione (observation) (RAD)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Allergie- Reazione (observation) (RAD)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Allergie- Reazione (observation) (RAD)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie- Reazione (observation) (RAD)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.519-2024-03-14T120235.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie- Reazione (observation) (RAD)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]
Item: (Allergie - observation (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]">
      <extends rule="d4640969e0-false-d4640973e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="string(@typeCode) = ('SUBJ')">(Allergie - observation (RAD)): The value for typeCode SHALL be 'SUBJ'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.520
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]
Item: (Allergie  - Criticità(observation) (RAD))
-->
   <rule fpi="RULC-1" id="d4640969e0-false-d4640973e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="count(hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]) &gt;= 1">(Allergie  - Criticità(observation) (RAD)): element hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="count(hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]) &lt;= 1">(Allergie  - Criticità(observation) (RAD)): element hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.520
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]
Item: (Allergie  - Criticità(observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Allergie  - Criticità(observation) (RAD)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="string(@moodCode) = ('EVN')">(Allergie  - Criticità(observation) (RAD)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="count(hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">(Allergie  - Criticità(observation) (RAD)): element hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="count(hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">(Allergie  - Criticità(observation) (RAD)): element hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="count(hl7:text[hl7:reference]) &lt;= 1">(Allergie  - Criticità(observation) (RAD)): element hl7:text[hl7:reference] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="count(hl7:statusCode) &lt;= 1">(Allergie  - Criticità(observation) (RAD)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.6']) &gt;= 1">(Allergie  - Criticità(observation) (RAD)): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.6'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.6']) &lt;= 1">(Allergie  - Criticità(observation) (RAD)): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.6'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.520
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]
Item: (Allergie  - Criticità(observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="string(@code) = ('SEV')">(Allergie  - Criticità(observation) (RAD)): The value for code SHALL be 'SEV'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.4')">(Allergie  - Criticità(observation) (RAD)): The value for codeSystem SHALL be '2.16.840.1.113883.5.4'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="string(@codeSystemName) = ('ActCode') or not(@codeSystemName)">(Allergie  - Criticità(observation) (RAD)): The value for codeSystemName SHALL be 'ActCode'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie  - Criticità(observation) (RAD)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie  - Criticità(observation) (RAD)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.520
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:text[hl7:reference]
Item: (Allergie  - Criticità(observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:text[hl7:reference]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="count(hl7:reference) &gt;= 1">(Allergie  - Criticità(observation) (RAD)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="count(hl7:reference) &lt;= 1">(Allergie  - Criticità(observation) (RAD)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.520
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:text[hl7:reference]/hl7:reference
Item: (Allergie  - Criticità(observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:text[hl7:reference]/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="@value">(Allergie  - Criticità(observation) (RAD)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.520
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:statusCode
Item: (Allergie  - Criticità(observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:statusCode">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="@code">(Allergie  - Criticità(observation) (RAD)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie  - Criticità(observation) (RAD)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.15933' ActStatus (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.520
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.6']
Item: (Allergie  - Criticità(observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:observation[hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.6']">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Allergie  - Criticità(observation) (RAD)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="@code">(Allergie  - Criticità(observation) (RAD)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.32-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie  - Criticità(observation) (RAD)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.32'  Criticality Observation (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.77.22.11.6')">(Allergie  - Criticità(observation) (RAD)): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.77.22.11.6'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie  - Criticità(observation) (RAD)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.520-2024-03-14T122558.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie  - Criticità(observation) (RAD)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Allergie - observation (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <extends rule="d4641166e0-false-d4641170e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="string(@typeCode) = ('REFR')">(Allergie - observation (RAD)): The value for typeCode SHALL be 'REFR'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.521
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Allergie- Stato dell'Allergia (observation) (RAD))
-->
   <rule fpi="RULC-1" id="d4641166e0-false-d4641170e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="count(hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(Allergie- Stato dell'Allergia (observation) (RAD)): element hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="count(hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Allergie- Stato dell'Allergia (observation) (RAD)): element hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.521
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Allergie- Stato dell'Allergia (observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Allergie- Stato dell'Allergia (observation) (RAD)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="string(@moodCode) = ('EVN')">(Allergie- Stato dell'Allergia (observation) (RAD)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="count(hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Allergie- Stato dell'Allergia (observation) (RAD)): element hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="count(hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Allergie- Stato dell'Allergia (observation) (RAD)): element hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="count(hl7:text) &lt;= 1">(Allergie- Stato dell'Allergia (observation) (RAD)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="count(hl7:statusCode) &lt;= 1">(Allergie- Stato dell'Allergia (observation) (RAD)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="count(hl7:value) &gt;= 1">(Allergie- Stato dell'Allergia (observation) (RAD)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="count(hl7:value) &lt;= 1">(Allergie- Stato dell'Allergia (observation) (RAD)): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.521
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Allergie- Stato dell'Allergia (observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="string(@code) = ('33999-4')">(Allergie- Stato dell'Allergia (observation) (RAD)): The value for code SHALL be '33999-4'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Allergie- Stato dell'Allergia (observation) (RAD)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Allergie- Stato dell'Allergia (observation) (RAD)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie- Stato dell'Allergia (observation) (RAD)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="string(@displayName) = ('Stato') or not(@displayName)">(Allergie- Stato dell'Allergia (observation) (RAD)): The value for displayName SHALL be 'Stato'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie- Stato dell'Allergia (observation) (RAD)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.521
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Allergie- Stato dell'Allergia (observation) (RAD))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.521
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode
Item: (Allergie- Stato dell'Allergia (observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie- Stato dell'Allergia (observation) (RAD)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.15933' ActStatus (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.521
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value
Item: (Allergie- Stato dell'Allergia (observation) (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="@xsi:type">(Allergie- Stato dell'Allergia (observation) (RAD)): attribute @xsi:type SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s')))">(Allergie- Stato dell'Allergia (observation) (RAD)): Attribute @xsi:type SHALL be of data type 'cs'  - '<value-of select="@xsi:type"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="@code">(Allergie- Stato dell'Allergia (observation) (RAD)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.33-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie- Stato dell'Allergia (observation) (RAD)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.33' Stato Clinico Allergia (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="@codeSystem">(Allergie- Stato dell'Allergia (observation) (RAD)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Allergie- Stato dell'Allergia (observation) (RAD)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.521-2024-03-14T123919.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie- Stato dell'Allergia (observation) (RAD)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.516
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Allergie - observation (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <extends rule="d4641340e0-false-d4641344e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.516-2024-03-14T100035.html"
              test="string(@typeCode) = ('SUBJ')">(Allergie - observation (RAD)): The value for typeCode SHALL be 'SUBJ'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.522
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Commenti (RAD))
-->
   <rule fpi="RULC-1" id="d4641340e0-false-d4641344e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="count(hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(Commenti (RAD)): element hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="count(hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Commenti (RAD)): element hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.522
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Commenti (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="string(@classCode) = ('ACT')">(Commenti (RAD)): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="string(@moodCode) = ('EVN')">(Commenti (RAD)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Commenti (RAD)): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Commenti (RAD)): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="count(hl7:text) &gt;= 1">(Commenti (RAD)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="count(hl7:text) &lt;= 1">(Commenti (RAD)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(Commenti (RAD)): element hl7:statusCode[@code = 'completed'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.522
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Commenti (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="string(@code) = ('48767-8')">(Commenti (RAD)): The value for code SHALL be '48767-8'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Commenti (RAD)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Commenti (RAD)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Commenti (RAD)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="string(@displayName) = ('Annotazione e Commenti') or not(@displayName)">(Commenti (RAD)): The value for displayName SHALL be 'Annotazione e Commenti'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Commenti (RAD)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.522
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Commenti (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="count(hl7:reference) &lt;= 1">(Commenti (RAD)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.522
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text/hl7:reference
Item: (Commenti (RAD))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.522
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = 'completed']
Item: (Commenti (RAD))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'][hl7:entryRelationship[@typeCode]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = 'completed']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="string(@code) = ('completed')">(Commenti (RAD)): The value for code SHALL be 'completed'. Found: "<value-of select="@code"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.522-2024-03-14T124432.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Commenti (RAD)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.15933' ActStatus (DYNAMIC).</assert>
   </rule>
</pattern>
