<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.437
Name: Act RifInterniProbl (PSS)
Description: Template CDA Act (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121">
   <title>Act RifInterniProbl (PSS)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.437
Context: *[hl7:act[@classCode = 'ACT']]
Item: (Act RifInterniProbl (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT']]"
         id="d44e66532-false-d4611424e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:act[@classCode = 'ACT']) &gt;= 1">(Act RifInterniProbl (PSS)): element hl7:act[@classCode = 'ACT'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:act[@classCode = 'ACT']) &lt;= 1">(Act RifInterniProbl (PSS)): element hl7:act[@classCode = 'ACT'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.437
Context: *[hl7:act[@classCode = 'ACT']]/hl7:act[@classCode = 'ACT']
Item: (Act RifInterniProbl (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT']]/hl7:act[@classCode = 'ACT']"
         id="d44e66556-false-d4611439e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="string(@classCode) = ('ACT')">(Act RifInterniProbl (PSS)): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']) &lt;= 1">(Act RifInterniProbl (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:id) &gt;= 1">(Act RifInterniProbl (PSS)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:id) &lt;= 1">(Act RifInterniProbl (PSS)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:code) &gt;= 1">(Act RifInterniProbl (PSS)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:code) &lt;= 1">(Act RifInterniProbl (PSS)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:text) &lt;= 1">(Act RifInterniProbl (PSS)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:statusCode) &gt;= 1">(Act RifInterniProbl (PSS)): element hl7:statusCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:statusCode) &lt;= 1">(Act RifInterniProbl (PSS)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Act RifInterniProbl (PSS)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Act RifInterniProbl (PSS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:entryRelationship[@typeCode]) &gt;= 1">(Act RifInterniProbl (PSS)): element hl7:entryRelationship[@typeCode] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="count(hl7:entryRelationship[@typeCode]) &lt;= 1">(Act RifInterniProbl (PSS)): element hl7:entryRelationship[@typeCode] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.437
Context: *[hl7:act[@classCode = 'ACT']]/hl7:act[@classCode = 'ACT']/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']
Item: (Act RifInterniProbl (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT']]/hl7:act[@classCode = 'ACT']/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']"
         id="d44e66566-false-d4611505e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.1.1')">(Act RifInterniProbl (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.1.1'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.437
Context: *[hl7:act[@classCode = 'ACT']]/hl7:act[@classCode = 'ACT']/hl7:id
Item: (Act RifInterniProbl (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT']]/hl7:act[@classCode = 'ACT']/hl7:id"
         id="d44e66571-false-d4611516e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Act RifInterniProbl (PSS)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.437
Context: *[hl7:act[@classCode = 'ACT']]/hl7:act[@classCode = 'ACT']/hl7:code
Item: (Act RifInterniProbl (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT']]/hl7:act[@classCode = 'ACT']/hl7:code"
         id="d44e66576-false-d4611527e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="string(@nullFlavor) = ('NA') or not(@nullFlavor)">(Act RifInterniProbl (PSS)): The value for nullFlavor SHALL be 'NA'. Found: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.437
Context: *[hl7:act[@classCode = 'ACT']]/hl7:act[@classCode = 'ACT']/hl7:text
Item: (Act RifInterniProbl (PSS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.437
Context: *[hl7:act[@classCode = 'ACT']]/hl7:act[@classCode = 'ACT']/hl7:statusCode
Item: (Act RifInterniProbl (PSS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.437
Context: *[hl7:act[@classCode = 'ACT']]/hl7:act[@classCode = 'ACT']/hl7:effectiveTime
Item: (Act RifInterniProbl (PSS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.437
Context: *[hl7:act[@classCode = 'ACT']]/hl7:act[@classCode = 'ACT']/hl7:entryRelationship[@typeCode]
Item: (Act RifInterniProbl (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT']]/hl7:act[@classCode = 'ACT']/hl7:entryRelationship[@typeCode]"
         id="d44e66602-false-d4611562e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="@typeCode">(Act RifInterniProbl (PSS)): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.437-2024-01-12T105121.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Act RifInterniProbl (PSS)): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
   </rule>
</pattern>
