<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.416
Name: Allergie o Intolleranze (act) (PSS)
Description: Template CDA Act (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318">
   <title>Allergie o Intolleranze (act) (PSS)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.416
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]
Item: (Allergie o Intolleranze (act) (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]"
         id="d44e63445-false-d4604320e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]) &gt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]) &lt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.416
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]
Item: (Allergie o Intolleranze (act) (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]"
         id="d44e63469-false-d4604391e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="string(@classCode) = ('ACT')">(Allergie o Intolleranze (act) (PSS)): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="string(@moodCode) = ('EVN')">(Allergie o Intolleranze (act) (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']) &gt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']) &lt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:id) &gt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:code[@nullFlavor = 'NA']) &gt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:code[@nullFlavor = 'NA'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:code[@nullFlavor = 'NA']) &lt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:code[@nullFlavor = 'NA'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:text) &lt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]) &gt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]) &lt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]] | hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]) &gt;= 1">(Allergie o Intolleranze (act) (PSS)): choice (hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]  or  hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]) does not contain enough elements [min 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]] | hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]) &lt;= 1">(Allergie o Intolleranze (act) (PSS)): choice (hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]  or  hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]) &lt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]) &lt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.416
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']
Item: (Allergie o Intolleranze (act) (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']"
         id="d44e63481-false-d4604538e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.1.1')">(Allergie o Intolleranze (act) (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.1.1'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.416
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:id
Item: (Allergie o Intolleranze (act) (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:id"
         id="d44e63486-false-d4604549e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="@root">(Allergie o Intolleranze (act) (PSS)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Allergie o Intolleranze (act) (PSS)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.416
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:code[@nullFlavor = 'NA']
Item: (Allergie o Intolleranze (act) (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:code[@nullFlavor = 'NA']"
         id="d44e63499-false-d4604562e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="string(@nullFlavor) = ('NA')">(Allergie o Intolleranze (act) (PSS)): The value for nullFlavor SHALL be 'NA'. Found: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Allergie o Intolleranze (act) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.416
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:text
Item: (Allergie o Intolleranze (act) (PSS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.416
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]
Item: (Allergie o Intolleranze (act) (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]"
         id="d44e63515-false-d4604588e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Allergie o Intolleranze (act) (PSS)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.10 X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="@code">(Allergie o Intolleranze (act) (PSS)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Allergie o Intolleranze (act) (PSS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.416
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:effectiveTime
Item: (Allergie o Intolleranze (act) (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:effectiveTime"
         id="d44e63528-false-d4604610e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:low) &gt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:low) &lt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:low appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="count(hl7:high) &lt;= 1">(Allergie o Intolleranze (act) (PSS)): element hl7:high appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.416
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:effectiveTime/hl7:low
Item: (Allergie o Intolleranze (act) (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:effectiveTime/hl7:low"
         id="d44e63536-false-d4604632e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="@value">(Allergie o Intolleranze (act) (PSS)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Allergie o Intolleranze (act) (PSS)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.416
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:effectiveTime/hl7:high
Item: (Allergie o Intolleranze (act) (PSS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:effectiveTime/hl7:high"
         id="d44e63547-false-d4604645e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="@value">(Allergie o Intolleranze (act) (PSS)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Allergie o Intolleranze (act) (PSS)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.416
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]
Item: (Allergie o Intolleranze (act) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]">
      <extends rule="d4604692e0-false-d4604696e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="@typeCode">(Allergie o Intolleranze (act) (PSS)): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Allergie o Intolleranze (act) (PSS)): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1" id="d4604692e0-false-d4604696e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]) &gt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@moodCode) = ('EVN')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']) &gt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:id) &gt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:id) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:text[hl7:reference]) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:text[hl7:reference] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:statusCode) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:value) &gt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:value) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:value appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:participant[@typeCode = 'CSM'][hl7:participantRole]) &gt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:participant[@typeCode = 'CSM'][hl7:participantRole] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.1.3')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.1.3'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:id
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="@root">(Allergie e Intolleranze (presenza) - (observation) (PSS)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@code) = ('52473-6')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for code SHALL be '52473-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie e Intolleranze (presenza) - (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@displayName) = ('Allergia o causa della reazione') or not(@displayName)">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for displayName SHALL be 'Allergia o causa della reazione'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie e Intolleranze (presenza) - (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Allergie e Intolleranze (presenza) - (observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:text[hl7:reference]
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:text[hl7:reference]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:reference) &gt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:reference) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:text[hl7:reference]/hl7:reference
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:text[hl7:reference]/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="@value">(Allergie e Intolleranze (presenza) - (observation) (PSS)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@value) or string-length(@value)&gt;0">(Allergie e Intolleranze (presenza) - (observation) (PSS)): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:statusCode
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:statusCode">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="@code">(Allergie e Intolleranze (presenza) - (observation) (PSS)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.15933' ActStatus (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:effectiveTime
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:effectiveTime">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:low) &gt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:low) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:low appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="count(hl7:high) &lt;= 1">(Allergie e Intolleranze (presenza) - (observation) (PSS)): element hl7:high appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:effectiveTime/hl7:low
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:effectiveTime/hl7:low">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="@value">(Allergie e Intolleranze (presenza) - (observation) (PSS)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:effectiveTime/hl7:high
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:effectiveTime/hl7:high">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="@value">(Allergie e Intolleranze (presenza) - (observation) (PSS)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:value
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:value">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.28'  ObservationIntoleranceType DINAMIC (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="@codeSystem">(Allergie e Intolleranze (presenza) - (observation) (PSS)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie e Intolleranze (presenza) - (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie e Intolleranze (presenza) - (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Allergie e Intolleranze (presenza) - (observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]">
      <extends rule="d4605078e0-false-d4605082e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@typeCode) = ('CSM')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for typeCode SHALL be 'CSM'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.484
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]
Item: (Allergie e Intolleranze - Descrizione Agente (participantRole) (PSS))
-->
   <rule fpi="RULC-1" id="d4605078e0-false-d4605082e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.484-2024-01-19T105250.html"
              test="count(hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &gt;= 1">(Allergie e Intolleranze - Descrizione Agente (participantRole) (PSS)): element hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.484-2024-01-19T105250.html"
              test="count(hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &lt;= 1">(Allergie e Intolleranze - Descrizione Agente (participantRole) (PSS)): element hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.484
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]
Item: (Allergie e Intolleranze - Descrizione Agente (participantRole) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.484-2024-01-19T105250.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(Allergie e Intolleranze - Descrizione Agente (participantRole) (PSS)): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.484-2024-01-19T105250.html"
              test="count(hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(Allergie e Intolleranze - Descrizione Agente (participantRole) (PSS)): element hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.484-2024-01-19T105250.html"
              test="count(hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(Allergie e Intolleranze - Descrizione Agente (participantRole) (PSS)): element hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.484
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (Allergie e Intolleranze - Descrizione Agente (participantRole) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]">
      <extends rule="d4605151e0-false-d4605155e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.484-2024-01-19T105250.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(Allergie e Intolleranze - Descrizione Agente (participantRole) (PSS)): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.485
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS))
-->
   <rule fpi="RULC-1" id="d4605151e0-false-d4605155e0" abstract="true">
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.485-2024-01-19T110753.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt; 1">(Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS)): element hl7:code is coded with binding strength 'extensible' and contains a code other than the specified set.</report>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.485-2024-01-19T110753.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.485
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.485-2024-01-19T110753.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.52 IPSNoAllergiesInfo (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.485-2024-01-19T110753.html"
              test="@code">(Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.485-2024-01-19T110753.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.485-2024-01-19T110753.html"
              test="@codeSystem">(Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.485-2024-01-19T110753.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.485-2024-01-19T110753.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.485-2024-01-19T110753.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.485-2024-01-19T110753.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.485-2024-01-19T110753.html"
              test="count(hl7:originalText) &lt;= 1">(Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS)): element hl7:originalText appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.485
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]/hl7:originalText
Item: (Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.485
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:participant[@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]/hl7:originalText/hl7:reference
Item: (Allergie e Intolleranze - Descrizione Agente (playingEntity) (PSS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <extends rule="d4605267e0-false-d4605271e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@typeCode) = ('MFST')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for typeCode SHALL be 'MFST'. Found: "<value-of select="@typeCode"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19447-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19447' x_ActRelationshipEntryRelationship (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@inversionInd) or string(@inversionInd)=('true','false')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): Attribute @inversionInd SHALL be of data type 'bl'  - '<value-of select="@inversionInd"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.482
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Allergie e Intolleranze - Descrizione Reazione (observation) (PSS))
-->
   <rule fpi="RULC-1" id="d4605267e0-false-d4605271e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.482
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Allergie e Intolleranze - Descrizione Reazione (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="string(@moodCode) = ('EVN')">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:templateId) &gt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:templateId is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:templateId) &lt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:templateId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:text[hl7:reference]) &lt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:text[hl7:reference] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]) &lt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.482
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId
Item: (Allergie e Intolleranze - Descrizione Reazione (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="@root">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.482
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Allergie e Intolleranze - Descrizione Reazione (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="string(@code) = ('75321-0')">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): The value for code SHALL be '75321-0'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.482
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text[hl7:reference]
Item: (Allergie e Intolleranze - Descrizione Reazione (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text[hl7:reference]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:reference) &gt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:reference) &lt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.482
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text[hl7:reference]/hl7:reference
Item: (Allergie e Intolleranze - Descrizione Reazione (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text[hl7:reference]/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="@value">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.482
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]
Item: (Allergie e Intolleranze - Descrizione Reazione (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.10 X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="@code">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.482
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime
Item: (Allergie e Intolleranze - Descrizione Reazione (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:low) &gt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:low) &lt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:low appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:high) &lt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:high appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.482
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime/hl7:low
Item: (Allergie e Intolleranze - Descrizione Reazione (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime/hl7:low">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="@value">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.482
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime/hl7:high
Item: (Allergie e Intolleranze - Descrizione Reazione (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime/hl7:high">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="@value">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.482
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Allergie e Intolleranze - Descrizione Reazione (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.29  ReazioniIntolleranza (DYNAMIC) or 2.16.840.1.113883.3.1937.777.63.11.31 ReazioniAllergiche (DYNAMIC)'.</assert>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:orginalText[hl7:reference]) &gt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:orginalText[hl7:reference] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:orginalText[hl7:reference]) &lt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:orginalText[hl7:reference] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.482
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/hl7:orginalText[hl7:reference]
Item: (Allergie e Intolleranze - Descrizione Reazione (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/hl7:orginalText[hl7:reference]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:reference) &gt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="count(hl7:reference) &lt;= 1">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.482
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/hl7:orginalText[hl7:reference]/hl7:reference
Item: (Allergie e Intolleranze - Descrizione Reazione (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.29-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.31-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/hl7:orginalText[hl7:reference]/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.482-2024-01-19T095450.html"
              test="@value">(Allergie e Intolleranze - Descrizione Reazione (observation) (PSS)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]">
      <extends rule="d4605595e0-false-d4605599e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@typeCode) = ('SUBJ')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for typeCode SHALL be 'SUBJ'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@inversionInd) = ('true')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for inversionInd SHALL be 'true'. Found: "<value-of select="@inversionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.483
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]
Item: (Allergie e Intolleranze - Descrizione Criticità(observation) (PSS))
-->
   <rule fpi="RULC-1" id="d4605595e0-false-d4605599e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]) &gt;= 1">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]) &lt;= 1">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.483
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]
Item: (Allergie e Intolleranze - Descrizione Criticità(observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="string(@moodCode) = ('EVN')">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']) &gt;= 1">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']) &lt;= 1">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="count(hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): element hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="count(hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): element hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="count(hl7:text[hl7:reference]) &lt;= 1">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): element hl7:text[hl7:reference] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="count(hl7:statusCode) &lt;= 1">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.6']) &gt;= 1">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.6'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.6']) &lt;= 1">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.6'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.483
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']
Item: (Allergie e Intolleranze - Descrizione Criticità(observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.1.5.3')">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.1.5.3'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.483
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]
Item: (Allergie e Intolleranze - Descrizione Criticità(observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="string(@code) = ('SEV')">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): The value for code SHALL be 'SEV'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.4')">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.5.4'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="string(@codeSystemName) = ('ActCode') or not(@codeSystemName)">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): The value for codeSystemName SHALL be 'ActCode'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.483
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:text[hl7:reference]
Item: (Allergie e Intolleranze - Descrizione Criticità(observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:text[hl7:reference]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="count(hl7:reference) &gt;= 1">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="count(hl7:reference) &lt;= 1">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.483
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:text[hl7:reference]/hl7:reference
Item: (Allergie e Intolleranze - Descrizione Criticità(observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:text[hl7:reference]/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="@value">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.483
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:statusCode
Item: (Allergie e Intolleranze - Descrizione Criticità(observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:statusCode">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.10' X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.483
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:effectiveTime
Item: (Allergie e Intolleranze - Descrizione Criticità(observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:effectiveTime">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="@value">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.483
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.6']
Item: (Allergie e Intolleranze - Descrizione Criticità(observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.5.3']]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.6']">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="@code">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.32-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.32'  Criticality Observation (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.77.22.11.6')">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.77.22.11.6'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.483-2024-01-19T102035.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Allergie e Intolleranze - Descrizione Criticità(observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]">
      <extends rule="d4605839e0-false-d4605843e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@typeCode) = ('REFR')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for typeCode SHALL be 'REFR'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="not(@inversionInd) or string(@inversionInd)=('true','false')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): Attribute @inversionInd SHALL be of data type 'bl'  - '<value-of select="@inversionInd"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.486
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]
Item: (Allergie e Intolleranze - Stato Allergia (observation) (PSS))
-->
   <rule fpi="RULC-1" id="d4605839e0-false-d4605843e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]) &gt;= 1">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]) &lt;= 1">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.486
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]
Item: (Allergie e Intolleranze - Stato Allergia (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="string(@moodCode) = ('EVN')">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']) &gt;= 1">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']) &lt;= 1">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="count(hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): element hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="count(hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): element hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="count(hl7:text[hl7:reference]) &lt;= 1">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): element hl7:text[hl7:reference] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="count(hl7:statusCode) &gt;= 1">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): element hl7:statusCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="count(hl7:statusCode) &lt;= 1">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.7']) &gt;= 1">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.7'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.7']) &lt;= 1">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.7'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.486
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']
Item: (Allergie e Intolleranze - Stato Allergia (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.1.6')">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.1.6'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.486
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]/hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Allergie e Intolleranze - Stato Allergia (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]/hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="string(@code) = ('33999-4')">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): The value for code SHALL be '33999-4'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.486
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]/hl7:text[hl7:reference]
Item: (Allergie e Intolleranze - Stato Allergia (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]/hl7:text[hl7:reference]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="count(hl7:reference) &gt;= 1">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="count(hl7:reference) &lt;= 1">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.486
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]/hl7:text[hl7:reference]/hl7:reference
Item: (Allergie e Intolleranze - Stato Allergia (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]/hl7:text[hl7:reference]/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="@value">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.486
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]/hl7:statusCode
Item: (Allergie e Intolleranze - Stato Allergia (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]/hl7:statusCode">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="@code">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.10' X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.486
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.7']
Item: (Allergie e Intolleranze - Stato Allergia (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.6']]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.7']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="@xsi:type">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): attribute @xsi:type SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s')))">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): Attribute @xsi:type SHALL be of data type 'cs'  - '<value-of select="@xsi:type"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="@code">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.55-2024-03-12T155458.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.55' StatoClinicoProblema_PSSIT (2024-03-12T15:54:58).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.77.22.11.7')">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.77.22.11.7'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.486-2024-01-19T123042.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Allergie e Intolleranze - Stato Allergia (observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.417
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]
Item: (Allergie e Intolleranze (presenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]">
      <extends rule="d4606064e0-false-d4606068e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@typeCode) = ('SUBJ')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for typeCode SHALL be 'SUBJ'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.417-2024-01-09T161001.html"
              test="string(@inversionInd) = ('true')">(Allergie e Intolleranze (presenza) - (observation) (PSS)): The value for inversionInd SHALL be 'true'. Found: "<value-of select="@inversionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1" id="d4606064e0-false-d4606068e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]) &gt;= 1">(Commenti (PSS)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]) &lt;= 1">(Commenti (PSS)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="string(@classCode) = ('ACT')">(Commenti (PSS)): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="string(@moodCode) = ('EVN')">(Commenti (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']) &gt;= 1">(Commenti (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']) &lt;= 1">(Commenti (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Commenti (PSS)): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Commenti (PSS)): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:text[hl7:reference]) &lt;= 1">(Commenti (PSS)): element hl7:text[hl7:reference] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:statusCode) &gt;= 1">(Commenti (PSS)): element hl7:statusCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:statusCode) &lt;= 1">(Commenti (PSS)): element hl7:statusCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.1.7')">(Commenti (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.1.7'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="string(@code) = ('48767-8')">(Commenti (PSS)): The value for code SHALL be '48767-8'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Commenti (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Commenti (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Commenti (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Commenti (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:text[hl7:reference]
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:text[hl7:reference]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:reference) &gt;= 1">(Commenti (PSS)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:reference) &lt;= 1">(Commenti (PSS)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:text[hl7:reference]/hl7:reference
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:text[hl7:reference]/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="@value">(Commenti (PSS)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:statusCode
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.3']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:statusCode">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="@code">(Commenti (PSS)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Commenti (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.15933' ActStatus (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.416
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]
Item: (Allergie o Intolleranze (act) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]">
      <extends rule="d4606241e0-false-d4606245e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="@typeCode">(Allergie o Intolleranze (act) (PSS)): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Allergie o Intolleranze (act) (PSS)): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1" id="d4606241e0-false-d4606245e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]) &gt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Allergie e Intolleranze (assenza) - (observation) (PSS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="string(@moodCode) = ('EVN')">(Allergie e Intolleranze (assenza) - (observation) (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']) &gt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:id) &gt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:id) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:code[(@code = 'OINT' and @codeSystem = '2.16.840.1.113883.1.11.19700')]) &gt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:code[(@code = 'OINT' and @codeSystem = '2.16.840.1.113883.1.11.19700')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:code[(@code = 'OINT' and @codeSystem = '2.16.840.1.113883.1.11.19700')]) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:code[(@code = 'OINT' and @codeSystem = '2.16.840.1.113883.1.11.19700')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:text[hl7:reference]) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:text[hl7:reference] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.11.22.9']) &gt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:value[@codeSystem = '2.16.840.1.113883.11.22.9'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.11.22.9']) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:value[@codeSystem = '2.16.840.1.113883.11.22.9'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.1.4')">(Allergie e Intolleranze (assenza) - (observation) (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.1.4'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:id
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="@root">(Allergie e Intolleranze (assenza) - (observation) (PSS)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Allergie e Intolleranze (assenza) - (observation) (PSS)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:code[(@code = 'OINT' and @codeSystem = '2.16.840.1.113883.1.11.19700')]
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:code[(@code = 'OINT' and @codeSystem = '2.16.840.1.113883.1.11.19700')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="string(@code) = ('OINT')">(Allergie e Intolleranze (assenza) - (observation) (PSS)): The value for code SHALL be 'OINT'. Found: "<value-of select="@code"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie e Intolleranze (assenza) - (observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.28'  ObservationIntoleranceType DINAMIC (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.1.11.19700')">(Allergie e Intolleranze (assenza) - (observation) (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.1.11.19700'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="string(@codeSystemName) = ('ObservationIntoleranceType') or not(@codeSystemName)">(Allergie e Intolleranze (assenza) - (observation) (PSS)): The value for codeSystemName SHALL be 'ObservationIntoleranceType'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie e Intolleranze (assenza) - (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="string(@displayName) = ('Intolerance') or not(@displayName)">(Allergie e Intolleranze (assenza) - (observation) (PSS)): The value for displayName SHALL be 'Intolerance'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie e Intolleranze (assenza) - (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Allergie e Intolleranze (assenza) - (observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:text[hl7:reference]
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:text[hl7:reference]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:reference) &gt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:reference) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:text[hl7:reference]/hl7:reference
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:text[hl7:reference]/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="@value">(Allergie e Intolleranze (assenza) - (observation) (PSS)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:statusCode[@code = 'completed' or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="@nullFlavor or (@code='completed')">(Allergie e Intolleranze (assenza) - (observation) (PSS)): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:effectiveTime
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:effectiveTime">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:low) &gt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:low) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:low appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:high) &gt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:high is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:high) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:high appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:effectiveTime/hl7:low
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:effectiveTime/hl7:low">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="@value">(Allergie e Intolleranze (assenza) - (observation) (PSS)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Allergie e Intolleranze (assenza) - (observation) (PSS)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:effectiveTime/hl7:high
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:effectiveTime/hl7:high">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="@value">(Allergie e Intolleranze (assenza) - (observation) (PSS)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Allergie e Intolleranze (assenza) - (observation) (PSS)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:value[@codeSystem = '2.16.840.1.113883.11.22.9']
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:value[@codeSystem = '2.16.840.1.113883.11.22.9']">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Allergie e Intolleranze (assenza) - (observation) (PSS)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Allergie e Intolleranze (assenza) - (observation) (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="@code">(Allergie e Intolleranze (assenza) - (observation) (PSS)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.52-2024-02-22T123504.xml')/*/valueSet/conceptList/concept/@code))])">(Allergie e Intolleranze (assenza) - (observation) (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.52' IPSNoAllergiesInfo (2024-02-22T12:35:04).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.11.22.9')">(Allergie e Intolleranze (assenza) - (observation) (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.11.22.9'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="string(@codeSystemName) = ('IPSNoAllergiesInfo') or not(@codeSystemName)">(Allergie e Intolleranze (assenza) - (observation) (PSS)): The value for codeSystemName SHALL be 'IPSNoAllergiesInfo'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie e Intolleranze (assenza) - (observation) (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="string(@displayName) = ('Informazioni non note su allergie') or not(@displayName)">(Allergie e Intolleranze (assenza) - (observation) (PSS)): The value for displayName SHALL be 'Informazioni non note su allergie'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie e Intolleranze (assenza) - (observation) (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:originalText) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:originalText appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:value[@codeSystem = '2.16.840.1.113883.11.22.9']/hl7:originalText
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:value[@codeSystem = '2.16.840.1.113883.11.22.9']/hl7:originalText">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="count(hl7:reference) &lt;= 1">(Allergie e Intolleranze (assenza) - (observation) (PSS)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:value[@codeSystem = '2.16.840.1.113883.11.22.9']/hl7:originalText/hl7:reference
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:value[@codeSystem = '2.16.840.1.113883.11.22.9']/hl7:originalText/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.418-2024-01-09T170328.html"
              test="not(@value) or string-length(@value)&gt;0">(Allergie e Intolleranze (assenza) - (observation) (PSS)): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.418
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]
Item: (Allergie e Intolleranze (assenza) - (observation) (PSS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]) &gt;= 1">(Commenti (PSS)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]) &lt;= 1">(Commenti (PSS)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="string(@classCode) = ('ACT')">(Commenti (PSS)): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="string(@moodCode) = ('EVN')">(Commenti (PSS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']) &gt;= 1">(Commenti (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']) &lt;= 1">(Commenti (PSS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Commenti (PSS)): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Commenti (PSS)): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:text[hl7:reference]) &lt;= 1">(Commenti (PSS)): element hl7:text[hl7:reference] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:statusCode) &gt;= 1">(Commenti (PSS)): element hl7:statusCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:statusCode) &lt;= 1">(Commenti (PSS)): element hl7:statusCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.3.1.7')">(Commenti (PSS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.3.1.7'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="string(@code) = ('48767-8')">(Commenti (PSS)): The value for code SHALL be '48767-8'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Commenti (PSS)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Commenti (PSS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(Commenti (PSS)): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Commenti (PSS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:text[hl7:reference]
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:text[hl7:reference]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:reference) &gt;= 1">(Commenti (PSS)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="count(hl7:reference) &lt;= 1">(Commenti (PSS)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:text[hl7:reference]/hl7:reference
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:text[hl7:reference]/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="@value">(Commenti (PSS)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.433
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:statusCode
Item: (Commenti (PSS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.4']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.3.1.7']]/hl7:statusCode">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="@code">(Commenti (PSS)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.433-2024-01-12T093840.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Commenti (PSS)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.15933' ActStatus (DYNAMIC).</assert>
   </rule>
</pattern>
