<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.388
Name: Terapie Farmacologiche_SubstanceAdministration (RSA)
Description: Pharmacological Therapies
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917">
   <title>Terapie Farmacologiche_SubstanceAdministration (RSA)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]"
         id="d44e58371-false-d4546574e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="string(@classCode) = ('SBADM')">(Terapie Farmacologiche_SubstanceAdministration (RSA)): The value for classCode SHALL be 'SBADM'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="string(@moodCode) = ('INT')">(Terapie Farmacologiche_SubstanceAdministration (RSA)): The value for moodCode SHALL be 'INT'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.388']) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.388'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:statusCode) &gt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:statusCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:statusCode) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:routeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:routeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:approachSiteCode) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:approachSiteCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:doseQuantity) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:doseQuantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:rateQuantity) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:rateQuantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:administrationUnitCode) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:administrationUnitCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:consumable[hl7:manufacturedProduct]) &gt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:consumable[hl7:manufacturedProduct] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:consumable[hl7:manufacturedProduct]) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:consumable[hl7:manufacturedProduct] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.388']
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.388']"
         id="d44e58383-false-d4546692e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.388')">(Terapie Farmacologiche_SubstanceAdministration (RSA)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.388'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:statusCode
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:effectiveTime
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:effectiveTime
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:effectiveTime
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:routeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:routeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e58426-false-d4546738e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Terapie Farmacologiche_SubstanceAdministration (RSA)): The element value SHALL be one of '2.16.840.1.113883.1.11.14581 RouteOfAdministration (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:approachSiteCode
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:doseQuantity
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:rateQuantity
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:administrationUnitCode
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct
Item: (Codice Farmaco )
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="string(@classCode) = ('MANU') or not(@classCode)">(Codice Farmaco ): The value for classCode SHALL be 'MANU'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']) &lt;= 1">(Codice Farmaco ): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']
Item: (Codice Farmaco )
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.53')">(Codice Farmaco ): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.53'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:id
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial
Item: (Codice Farmaco )
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="string(@classCode) = ('MMAT') or not(@classCode)">(Codice Farmaco ): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="string(@determinerCode) = ('KIND') or not(@determinerCode)">(Codice Farmaco ): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="count(hl7:code) &gt;= 1">(Codice Farmaco ): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="count(hl7:code) &lt;= 1">(Codice Farmaco ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="count(hl7:name) &lt;= 1">(Codice Farmaco ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial/hl7:code
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial/hl7:code/hl7:translation
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial/hl7:name
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant[hl7:participantRole]
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.385
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant[hl7:participantRole]
Item: (Participant Esecutore (RSA))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant[hl7:participantRole]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="string(@typeCode) = ('PRF') or not(@typeCode)">(Participant Esecutore (RSA)): The value for typeCode SHALL be 'PRF'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="count(hl7:time) &lt;= 1">(Participant Esecutore (RSA)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="count(hl7:participantRole[hl7:playingEntity]) &gt;= 1">(Participant Esecutore (RSA)): element hl7:participantRole[hl7:playingEntity] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="count(hl7:participantRole[hl7:playingEntity]) &lt;= 1">(Participant Esecutore (RSA)): element hl7:participantRole[hl7:playingEntity] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.385
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant[hl7:participantRole]/hl7:time
Item: (Participant Esecutore (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.385
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingEntity]
Item: (Participant Esecutore (RSA))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingEntity]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(Participant Esecutore (RSA)): The value for classCode SHALL be 'ROL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="count(hl7:id) &gt;= 1">(Participant Esecutore (RSA)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="count(hl7:id) &lt;= 1">(Participant Esecutore (RSA)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="count(hl7:playingEntity) &gt;= 1">(Participant Esecutore (RSA)): element hl7:playingEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="count(hl7:playingEntity) &lt;= 1">(Participant Esecutore (RSA)): element hl7:playingEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.385
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingEntity]/hl7:id
Item: (Participant Esecutore (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.385
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity
Item: (Participant Esecutore (RSA))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="count(hl7:name) &gt;= 1">(Participant Esecutore (RSA)): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="count(hl7:name) &lt;= 1">(Participant Esecutore (RSA)): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.385
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity/hl7:name
Item: (Participant Esecutore (RSA))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="count(hl7:given) &gt;= 1">(Participant Esecutore (RSA)): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="count(hl7:given) &lt;= 1">(Participant Esecutore (RSA)): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="count(hl7:family) &gt;= 1">(Participant Esecutore (RSA)): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.385-2023-12-20T130719.html"
              test="count(hl7:family) &lt;= 1">(Participant Esecutore (RSA)): element hl7:family appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.385
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity/hl7:name/hl7:given
Item: (Participant Esecutore (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.385
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:participant[hl7:participantRole]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity/hl7:name/hl7:family
Item: (Participant Esecutore (RSA))
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[hl7:observation]
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[hl7:observation]"
         id="d44e58522-false-d4547056e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:observation) &gt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:observation is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:observation) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:observation appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[hl7:observation]/hl7:observation
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[hl7:observation]/hl7:observation"
         id="d44e58532-false-d4547072e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Terapie Farmacologiche_SubstanceAdministration (RSA)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Terapie Farmacologiche_SubstanceAdministration (RSA)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:code) &gt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:code) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:value) &gt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:value) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:value appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[hl7:observation]/hl7:observation/hl7:code
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[hl7:observation]/hl7:observation/hl7:code"
         id="d44e58540-false-d4547104e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="@code">(Terapie Farmacologiche_SubstanceAdministration (RSA)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Terapie Farmacologiche_SubstanceAdministration (RSA)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="@codeSystem">(Terapie Farmacologiche_SubstanceAdministration (RSA)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Terapie Farmacologiche_SubstanceAdministration (RSA)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terapie Farmacologiche_SubstanceAdministration (RSA)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terapie Farmacologiche_SubstanceAdministration (RSA)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[hl7:observation]/hl7:observation/hl7:value
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[hl7:observation]/hl7:observation/hl7:value"
         id="d44e58559-false-d4547128e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="@nullFlavor or ($xsiLocalName='REAL' and $xsiLocalNS='urn:hl7-org:v3')">(Terapie Farmacologiche_SubstanceAdministration (RSA)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:REAL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]"
         id="d44e58574-false-d4547140e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="string(@typeCode) = ('COMP')">(Terapie Farmacologiche_SubstanceAdministration (RSA)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:observation) &gt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:observation is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:observation) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:observation appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation"
         id="d44e58586-false-d4547160e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Terapie Farmacologiche_SubstanceAdministration (RSA)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Terapie Farmacologiche_SubstanceAdministration (RSA)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:code) &gt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:code) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:value) &gt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:value) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:value appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:code
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:code"
         id="d44e58594-false-d4547192e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="@code">(Terapie Farmacologiche_SubstanceAdministration (RSA)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Terapie Farmacologiche_SubstanceAdministration (RSA)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="@codeSystem">(Terapie Farmacologiche_SubstanceAdministration (RSA)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Terapie Farmacologiche_SubstanceAdministration (RSA)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terapie Farmacologiche_SubstanceAdministration (RSA)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terapie Farmacologiche_SubstanceAdministration (RSA)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:value
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:value"
         id="d44e58613-false-d4547216e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="@nullFlavor or ($xsiLocalName='REAL' and $xsiLocalNS='urn:hl7-org:v3')">(Terapie Farmacologiche_SubstanceAdministration (RSA)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:REAL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]"
         id="d44e58629-false-d4547228e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="string(@typeCode) = ('COMP')">(Terapie Farmacologiche_SubstanceAdministration (RSA)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:supply) &gt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:supply is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:supply) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:supply appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]/hl7:supply
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]/hl7:supply"
         id="d44e58641-false-d4547248e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="string(@classCode) = ('SPLY') or not(@classCode)">(Terapie Farmacologiche_SubstanceAdministration (RSA)): The value for classCode SHALL be 'SPLY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="string(@moodCode) = ('RQO') or not(@moodCode)">(Terapie Farmacologiche_SubstanceAdministration (RSA)): The value for moodCode SHALL be 'RQO'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:quantity) &gt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:quantity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="count(hl7:quantity) &lt;= 1">(Terapie Farmacologiche_SubstanceAdministration (RSA)): element hl7:quantity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.388
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]/hl7:supply/hl7:quantity
Item: (Terapie Farmacologiche_SubstanceAdministration (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]/hl7:supply/hl7:quantity"
         id="d44e58649-false-d4547272e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.html"
              test="@value">(Terapie Farmacologiche_SubstanceAdministration (RSA)): attribute @value SHALL be present.</assert>
   </rule>
</pattern>
