<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.380
Name: Terapie Farmacologiche (RSA)
Description: Pharmacological Therapies
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.380-2023-12-18T163734">
   <title>Terapie Farmacologiche (RSA)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.380
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]
Item: (Terapie Farmacologiche (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]"
         id="d44e57752-false-d4545660e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.380-2023-12-18T163734.html"
              test="count(hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]) &gt;= 1">(Terapie Farmacologiche (RSA)): element hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.380-2023-12-18T163734.html"
              test="count(hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]) &lt;= 1">(Terapie Farmacologiche (RSA)): element hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.380
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]
Item: (Terapie Farmacologiche (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]"
         id="d44e57776-false-d4545681e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.380-2023-12-18T163734.html"
              test="string(@classCode) = ('SBADM')">(Terapie Farmacologiche (RSA)): The value for classCode SHALL be 'SBADM'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.380-2023-12-18T163734.html"
              test="string(@moodCode) = ('EVN')">(Terapie Farmacologiche (RSA)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.380-2023-12-18T163734.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(Terapie Farmacologiche (RSA)): Attribute @negationInd SHALL be of data type 'bl'  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.380-2023-12-18T163734.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.380']) &lt;= 1">(Terapie Farmacologiche (RSA)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.380'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.380-2023-12-18T163734.html"
              test="count(hl7:consumable[hl7:manufacturedProduct]) &gt;= 1">(Terapie Farmacologiche (RSA)): element hl7:consumable[hl7:manufacturedProduct] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.380-2023-12-18T163734.html"
              test="count(hl7:consumable[hl7:manufacturedProduct]) &lt;= 1">(Terapie Farmacologiche (RSA)): element hl7:consumable[hl7:manufacturedProduct] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.380
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.380']
Item: (Terapie Farmacologiche (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.380']"
         id="d44e57786-false-d4545719e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.380-2023-12-18T163734.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.380')">(Terapie Farmacologiche (RSA)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.380'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.380
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]
Item: (Terapie Farmacologiche (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct
Item: (Codice Farmaco )
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="string(@classCode) = ('MANU') or not(@classCode)">(Codice Farmaco ): The value for classCode SHALL be 'MANU'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']) &lt;= 1">(Codice Farmaco ): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']
Item: (Codice Farmaco )
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.53')">(Codice Farmaco ): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.53'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:id
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial
Item: (Codice Farmaco )
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="string(@classCode) = ('MMAT') or not(@classCode)">(Codice Farmaco ): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="string(@determinerCode) = ('KIND') or not(@determinerCode)">(Codice Farmaco ): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="count(hl7:code) &gt;= 1">(Codice Farmaco ): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="count(hl7:code) &lt;= 1">(Codice Farmaco ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="count(hl7:name) &lt;= 1">(Codice Farmaco ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial/hl7:code
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial/hl7:code/hl7:translation
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]]/hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'EVN'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial/hl7:name
Item: (Codice Farmaco )
--></pattern>
