<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.345
Name: Section CERT VACC
Description: Template CDA Section (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722">
   <title>Section CERT VACC</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.345
Context: *[hl7:section]
Item: (Section CERT VACC)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section]"
         id="d44e52792-false-d4538282e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="count(hl7:section) &gt;= 1">(Section CERT VACC): element hl7:section is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="count(hl7:section) &lt;= 1">(Section CERT VACC): element hl7:section appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.345
Context: *[hl7:section]/hl7:section
Item: (Section CERT VACC)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section]/hl7:section"
         id="d44e52810-false-d4538369e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Section CERT VACC): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Section CERT VACC): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="count(hl7:templateId) &lt;= 1">(Section CERT VACC): element hl7:templateId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="count(hl7:code[(@code = '11369-6' and @codeSystem = '2.16.840.1.113883.6.1') or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10871-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Section CERT VACC): element hl7:code[(@code = '11369-6' and @codeSystem = '2.16.840.1.113883.6.1') or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10871-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="count(hl7:title) &gt;= 1">(Section CERT VACC): element hl7:title is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="count(hl7:title) &lt;= 1">(Section CERT VACC): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="count(hl7:text) &gt;= 1">(Section CERT VACC): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="count(hl7:text) &lt;= 1">(Section CERT VACC): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="count(hl7:entry[[Dati Vaccinazione]] | hl7:entry[[Dati Esonero/omissione o differimento]]) &gt;= 1">(Section CERT VACC): choice (hl7:entry[[Dati Vaccinazione]]  or  hl7:entry[[Dati Esonero/omissione o differimento]]) does not contain enough elements [min 1x]</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.345
Context: *[hl7:section]/hl7:section/hl7:templateId
Item: (Section CERT VACC)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section]/hl7:section/hl7:templateId"
         id="d44e52822-false-d4538426e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.11.3.2') or not(@root)">(Section CERT VACC): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.11.3.2'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.345
Context: *[hl7:section]/hl7:section/hl7:code[(@code = '11369-6' and @codeSystem = '2.16.840.1.113883.6.1') or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10871-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Section CERT VACC)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section]/hl7:section/hl7:code[(@code = '11369-6' and @codeSystem = '2.16.840.1.113883.6.1') or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10871-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d44e52833-false-d4538440e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10871-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Section CERT VACC): The element value SHALL be one of '2.16.840.1.113883.1.11.10871 DocumentSectionType (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="string(@code) = ('11369-6')">(Section CERT VACC): The value for code SHALL be '11369-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Section CERT VACC): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Section CERT VACC): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.345-2023-07-26T165722.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Section CERT VACC): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.345
Context: *[hl7:section]/hl7:section/hl7:title
Item: (Section CERT VACC)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.345
Context: *[hl7:section]/hl7:section/hl7:text
Item: (Section CERT VACC)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.345
Context: *[hl7:section]/hl7:section/hl7:entry[[Dati Vaccinazione]]
Item: (Section CERT VACC)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.345
Context: *[hl7:section]/hl7:section/hl7:entry[[Dati Esonero/omissione o differimento]]
Item: (Section CERT VACC)
--></pattern>
