<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.331
Name: Terapie Farmacologiche PS (VPS)
Description: Pharmacological Therapies
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344">
   <title>Terapie Farmacologiche PS (VPS)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]
Item: (Terapie Farmacologiche PS (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]"
         id="d44e50535-false-d4537555e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="string(@classCode) = ('SBADM')">(Terapie Farmacologiche PS (VPS)): The value for classCode SHALL be 'SBADM'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="string(@moodCode) = ('INT')">(Terapie Farmacologiche PS (VPS)): The value for moodCode SHALL be 'INT'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']) &gt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:routeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:routeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:approachSiteCode) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:approachSiteCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:doseQuantity) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:doseQuantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:rateQuantity) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:rateQuantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:administrationUnitCode) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:administrationUnitCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:consumable[hl7:manufacturedProduct]) &gt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:consumable[hl7:manufacturedProduct] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:consumable[hl7:manufacturedProduct]) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:consumable[hl7:manufacturedProduct] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']"
         id="d44e50545-false-d4537676e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.52')">(Terapie Farmacologiche PS (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.52'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:statusCode[@code = 'completed' or @nullFlavor]"
         id="d44e50550-false-d4537688e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="@nullFlavor or (@code='completed')">(Terapie Farmacologiche PS (VPS)): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:effectiveTime
Item: (Terapie Farmacologiche PS (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:effectiveTime
Item: (Terapie Farmacologiche PS (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:effectiveTime
Item: (Terapie Farmacologiche PS (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:routeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:routeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e50580-false-d4537728e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Terapie Farmacologiche PS (VPS)): The element value SHALL be one of '2.16.840.1.113883.1.11.14581 RouteOfAdministration (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:approachSiteCode
Item: (Terapie Farmacologiche PS (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:doseQuantity
Item: (Terapie Farmacologiche PS (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:rateQuantity
Item: (Terapie Farmacologiche PS (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:administrationUnitCode
Item: (Terapie Farmacologiche PS (VPS))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct]
Item: (Terapie Farmacologiche PS (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct]
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct
Item: (Codice Farmaco )
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="string(@classCode) = ('MANU') or not(@classCode)">(Codice Farmaco ): The value for classCode SHALL be 'MANU'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']) &lt;= 1">(Codice Farmaco ): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']
Item: (Codice Farmaco )
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.53')">(Codice Farmaco ): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.53'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:id
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial
Item: (Codice Farmaco )
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="string(@classCode) = ('MMAT') or not(@classCode)">(Codice Farmaco ): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="string(@determinerCode) = ('KIND') or not(@determinerCode)">(Codice Farmaco ): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="count(hl7:code) &gt;= 1">(Codice Farmaco ): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="count(hl7:code) &lt;= 1">(Codice Farmaco ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.53-2018-03-19T000000.html"
              test="count(hl7:name) &lt;= 1">(Codice Farmaco ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial/hl7:code
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial/hl7:code/hl7:translation
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.53
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct]/hl7:manufacturedProduct/hl7:manufacturedMaterial/hl7:name
Item: (Codice Farmaco )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]
Item: (Terapie Farmacologiche PS (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.8
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]
Item: (Participant Richiedente (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="@typeCode">(Participant Richiedente (VPS)): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (('REF')))])">(Participant Richiedente (VPS)): The value for typeCode SHALL be 'code REF'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:time) &lt;= 1">(Participant Richiedente (VPS)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:participantRole) &gt;= 1">(Participant Richiedente (VPS)): element hl7:participantRole is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:participantRole) &lt;= 1">(Participant Richiedente (VPS)): element hl7:participantRole appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.8
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:time
Item: (Participant Richiedente (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.8
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:participantRole
Item: (Participant Richiedente (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:participantRole">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:id) &gt;= 1">(Participant Richiedente (VPS)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:playingEntity) &lt;= 1">(Participant Richiedente (VPS)): element hl7:playingEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.8
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:participantRole/hl7:id
Item: (Participant Richiedente (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.8
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:participantRole/hl7:playingEntity
Item: (Participant Richiedente (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:participantRole/hl7:playingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:name) &gt;= 1">(Participant Richiedente (VPS)): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:name) &lt;= 1">(Participant Richiedente (VPS)): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.8
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (Participant Richiedente (VPS))
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]"
         id="d44e50676-false-d4538013e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:observation) &gt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:observation is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:observation) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:observation appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]/hl7:observation
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]/hl7:observation"
         id="d44e50684-false-d4538029e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Terapie Farmacologiche PS (VPS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Terapie Farmacologiche PS (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:code) &gt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:code) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:value) &gt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:value) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:value appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]/hl7:observation/hl7:code
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]/hl7:observation/hl7:code"
         id="d44e50690-false-d4538061e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="@code">(Terapie Farmacologiche PS (VPS)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Terapie Farmacologiche PS (VPS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="@codeSystem">(Terapie Farmacologiche PS (VPS)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Terapie Farmacologiche PS (VPS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terapie Farmacologiche PS (VPS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terapie Farmacologiche PS (VPS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]/hl7:observation/hl7:value
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]/hl7:observation/hl7:value"
         id="d44e50706-false-d4538085e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="@nullFlavor or ($xsiLocalName='REAL' and $xsiLocalNS='urn:hl7-org:v3')">(Terapie Farmacologiche PS (VPS)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:REAL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]"
         id="d44e50719-false-d4538097e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="string(@typeCode) = ('COMP')">(Terapie Farmacologiche PS (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:observation) &gt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:observation is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:observation) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:observation appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation"
         id="d44e50729-false-d4538117e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Terapie Farmacologiche PS (VPS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Terapie Farmacologiche PS (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:code) &gt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:code) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:value) &gt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:value) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:value appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:code
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:code"
         id="d44e50735-false-d4538149e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="@code">(Terapie Farmacologiche PS (VPS)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Terapie Farmacologiche PS (VPS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="@codeSystem">(Terapie Farmacologiche PS (VPS)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Terapie Farmacologiche PS (VPS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terapie Farmacologiche PS (VPS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terapie Farmacologiche PS (VPS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:value
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:value"
         id="d44e50751-false-d4538173e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="@nullFlavor or ($xsiLocalName='REAL' and $xsiLocalNS='urn:hl7-org:v3')">(Terapie Farmacologiche PS (VPS)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:REAL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]"
         id="d44e50764-false-d4538185e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="string(@typeCode) = ('COMP')">(Terapie Farmacologiche PS (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:supply) &gt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:supply is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:supply) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:supply appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]/hl7:supply
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]/hl7:supply"
         id="d44e50774-false-d4538205e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="string(@classCode) = ('SPLY') or not(@classCode)">(Terapie Farmacologiche PS (VPS)): The value for classCode SHALL be 'SPLY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="string(@moodCode) = ('RQO') or not(@moodCode)">(Terapie Farmacologiche PS (VPS)): The value for moodCode SHALL be 'RQO'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:quantity) &gt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:quantity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="count(hl7:quantity) &lt;= 1">(Terapie Farmacologiche PS (VPS)): element hl7:quantity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.331
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]/hl7:supply/hl7:quantity
Item: (Terapie Farmacologiche PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]/hl7:supply/hl7:quantity"
         id="d44e50780-false-d4538229e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.html"
              test="@value">(Terapie Farmacologiche PS (VPS)): attribute @value SHALL be present.</assert>
   </rule>
</pattern>
