<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.330
Name: Terapia farmacologica PS (VPS)
Description: Discharge meds (LOINC: 75311-1)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944">
   <title>Terapia farmacologica PS (VPS)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.330
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]
Item: (Terapia farmacologica PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]"
         id="d44e50429-false-d4536481e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]) &gt;= 1">(Terapia farmacologica PS (VPS)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]) &lt;= 1">(Terapia farmacologica PS (VPS)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.330
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]
Item: (Terapia farmacologica PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]"
         id="d44e50450-false-d4536568e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Terapia farmacologica PS (VPS)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Terapia farmacologica PS (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']) &gt;= 1">(Terapia farmacologica PS (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']) &lt;= 1">(Terapia farmacologica PS (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="count(hl7:id) &lt;= 1">(Terapia farmacologica PS (VPS)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="count(hl7:code[(@code = '75311-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Terapia farmacologica PS (VPS)): element hl7:code[(@code = '75311-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="count(hl7:title) &lt;= 1">(Terapia farmacologica PS (VPS)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="count(hl7:text) &gt;= 1">(Terapia farmacologica PS (VPS)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="count(hl7:text) &lt;= 1">(Terapia farmacologica PS (VPS)): element hl7:text appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.330
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']
Item: (Terapia farmacologica PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']"
         id="d44e50456-false-d4536664e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.74')">(Terapia farmacologica PS (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.74'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.330
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:id
Item: (Terapia farmacologica PS (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.330
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:code[(@code = '75311-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Terapia farmacologica PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:code[(@code = '75311-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]"
         id="d44e50463-false-d4536684e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="@nullFlavor or (@code='75311-1' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Discharge medications Narrative' and @codeSystemName='LOINC')">(Terapia farmacologica PS (VPS)): The element value SHALL be one of 'code '75311-1' codeSystem '2.16.840.1.113883.6.1' displayName='Discharge medications Narrative' codeSystemName='LOINC''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.330
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:title
Item: (Terapia farmacologica PS (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:title"
         id="d44e50472-false-d4536697e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="text()='Terapia farmacologica alla dimissione'">(Terapia farmacologica PS (VPS)): the element content of hl7:title SHALL be ''Terapia farmacologica alla dimissione''. Found: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.330
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:text
Item: (Terapia farmacologica PS (VPS))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.330
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]
Item: (Terapia farmacologica PS (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]">
      <extends rule="d4536852e0-false-d4536873e0"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.330
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (Terapia farmacologica PS (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.330
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (Terapia farmacologica PS (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (assignedAuthor_BodyVps)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <extends rule="d4536852e17-false-d4536972e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(assignedAuthor_BodyVps): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:assignedPerson) &lt;= 1">(assignedAuthor_BodyVps): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id[not(@nullFlavor)]
Item: (assignedAuthor_BodyVps)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (assignedAuthor_BodyVps)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(assignedAuthor_BodyVps): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(assignedAuthor_BodyVps): element hl7:name[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name[not(@nullFlavor)]
Item: (assignedAuthor_BodyVps)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4536852e0-false-d4536873e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA Author (Body)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Author (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Author (Body)): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &gt;= 1">(CDA Author (Body)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Author (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA Author (Body)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA Author (Body)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Author (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4536852e17-false-d4536972e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA Author (Body)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA Author (Body)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Author (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedPerson | hl7:assignedAuthoringDevice) &lt;= 1">(CDA Author (Body)): choice (hl7:assignedPerson  or  hl7:assignedAuthoringDevice) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA Author (Body)): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.330
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]
Item: (Terapia farmacologica PS (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Terapia farmacologica PS (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.330-2023-05-17T113944.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Terapia farmacologica PS (VPS)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
