<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.319
Name: Allergie - act (VPS)
Description: Template CDA Act (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332">
   <title>Allergie - act (VPS)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.319
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]
Item: (Allergie - act (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]"
         id="d44e49007-false-d4535043e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]) &gt;= 1">(Allergie - act (VPS)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]) &lt;= 1">(Allergie - act (VPS)): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.319
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]
Item: (Allergie - act (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]"
         id="d44e49029-false-d4535104e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="string(@classCode) = ('ACT')">(Allergie - act (VPS)): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="string(@moodCode) = ('EVN')">(Allergie - act (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']) &gt;= 1">(Allergie - act (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']) &lt;= 1">(Allergie - act (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="count(hl7:code) &gt;= 1">(Allergie - act (VPS)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="count(hl7:code) &lt;= 1">(Allergie - act (VPS)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="count(hl7:text) &lt;= 1">(Allergie - act (VPS)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &gt;= 1">(Allergie - act (VPS)): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(Allergie - act (VPS)): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Allergie - act (VPS)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Allergie - act (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]) &gt;= 1">(Allergie - act (VPS)): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]) &lt;= 1">(Allergie - act (VPS)): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.319
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']
Item: (Allergie - act (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']"
         id="d44e49046-false-d4535194e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.319')">(Allergie - act (VPS)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.319'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.319
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:code
Item: (Allergie - act (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:code"
         id="d44e49051-false-d4535205e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="string(@nullFlavor) = ('NA') or not(@nullFlavor)">(Allergie - act (VPS)): The value for nullFlavor SHALL be 'NA'. Found: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.319
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:text
Item: (Allergie - act (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.319
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (Allergie - act (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]"
         id="d44e49059-false-d4535227e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Allergie - act (VPS)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.10 X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.319
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:effectiveTime
Item: (Allergie - act (VPS))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.319
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]
Item: (Allergie - act (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]">
      <extends rule="d4535287e0-false-d4535291e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="@typeCode">(Allergie - act (VPS)): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Allergie - act (VPS)): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]
Item: (Allergie - observation (VPS))
-->
   <rule fpi="RULC-1" id="d4535287e0-false-d4535291e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]) &gt;= 1">(Allergie - observation (VPS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]) &lt;= 1">(Allergie - observation (VPS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]
Item: (Allergie - observation (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Allergie - observation (VPS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="string(@moodCode) = ('EVN')">(Allergie - observation (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']) &gt;= 1">(Allergie - observation (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']) &lt;= 1">(Allergie - observation (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &gt;= 1">(Allergie - observation (VPS)): element hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Allergie - observation (VPS)): element hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:text) &gt;= 1">(Allergie - observation (VPS)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:text) &lt;= 1">(Allergie - observation (VPS)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(Allergie - observation (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(Allergie - observation (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Allergie - observation (VPS)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Allergie - observation (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:value) &gt;= 1">(Allergie - observation (VPS)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:value) &lt;= 1">(Allergie - observation (VPS)): element hl7:value appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:participant[@typeCode][@typeCode = 'CSM'][hl7:participantRole]) &gt;= 1">(Allergie - observation (VPS)): element hl7:participant[@typeCode][@typeCode = 'CSM'][hl7:participantRole] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]) &lt;= 1">(Allergie - observation (VPS)): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]) &lt;= 1">(Allergie - observation (VPS)): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Allergie - observation (VPS)): element hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']
Item: (Allergie - observation (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.320')">(Allergie - observation (VPS)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.320'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Allergie - observation (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:code[(@code = '52473-6' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="@nullFlavor or (@code='52473-6' and @codeSystem='2.16.840.1.113883.6.1')">(Allergie - observation (VPS)): The element value SHALL be one of 'code '52473-6' codeSystem '2.16.840.1.113883.6.1''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie - observation (VPS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie - observation (VPS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:text
Item: (Allergie - observation (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (Allergie - observation (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:statusCode[@code = 'completed' or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="@nullFlavor or (@code='completed')">(Allergie - observation (VPS)): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:effectiveTime
Item: (Allergie - observation (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:value
Item: (Allergie - observation (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:value">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="count(hl7:originalText) &lt;= 1">(Allergie - observation (VPS)): element hl7:originalText appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:value/hl7:originalText
Item: (Allergie - observation (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:value/hl7:originalText/hl7:text
Item: (Allergie - observation (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:participant[@typeCode][@typeCode = 'CSM'][hl7:participantRole]
Item: (Allergie - observation (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.161
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:participant[@typeCode][@typeCode = 'CSM'][hl7:participantRole]
Item: (Descrizione Agente)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:participant[@typeCode][@typeCode = 'CSM'][hl7:participantRole]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.161-2022-09-25T151100.html"
              test="@typeCode">(Descrizione Agente): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.161-2022-09-25T151100.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Descrizione Agente): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.161-2022-09-25T151100.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(Descrizione Agente): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.161-2022-09-25T151100.html"
              test="string(@typeCode) = ('CSM')">(Descrizione Agente): The value for typeCode SHALL be 'CSM'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.161-2022-09-25T151100.html"
              test="count(hl7:time) &lt;= 1">(Descrizione Agente): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.161-2022-09-25T151100.html"
              test="count(hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &gt;= 1">(Descrizione Agente): element hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.161-2022-09-25T151100.html"
              test="count(hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &lt;= 1">(Descrizione Agente): element hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.161
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:participant[@typeCode][@typeCode = 'CSM'][hl7:participantRole]/hl7:time
Item: (Descrizione Agente)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.161
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:participant[@typeCode][@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]
Item: (Descrizione Agente)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:participant[@typeCode][@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.161-2022-09-25T151100.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(Descrizione Agente): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.161-2022-09-25T151100.html"
              test="count(hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(Descrizione Agente): element hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.161-2022-09-25T151100.html"
              test="count(hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(Descrizione Agente): element hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.161
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:participant[@typeCode][@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (Descrizione Agente)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.162
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:participant[@typeCode][@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (playingEntity - Agente)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:participant[@typeCode][@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.162-2022-09-25T151441.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(playingEntity - Agente): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.162-2022-09-25T151441.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(playingEntity - Agente): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.162-2022-09-25T151441.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt; 1">(playingEntity - Agente): element hl7:code is coded with binding strength 'extensible' and contains a code other than the specified set.</report>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.162-2022-09-25T151441.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(playingEntity - Agente): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.162
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:participant[@typeCode][@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (playingEntity - Agente)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:participant[@typeCode][@typeCode = 'CSM'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.162-2022-09-25T151441.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.15-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(playingEntity - Agente): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.15 ObservationIntoleranceType (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]
Item: (Allergie - observation (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]">
      <extends rule="d4535745e0-false-d4535749e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="string(@typeCode) = ('MFST')">(Allergie - observation (VPS)): The value for typeCode SHALL be 'MFST'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.163
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]
Item: (Descrizione Reazione)
-->
   <rule fpi="RULC-1" id="d4535745e0-false-d4535749e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]) &gt;= 1">(Descrizione Reazione): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]) &lt;= 1">(Descrizione Reazione): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.163
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]
Item: (Descrizione Reazione)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Descrizione Reazione): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="string(@moodCode) = ('EVN')">(Descrizione Reazione): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']) &gt;= 1">(Descrizione Reazione): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']) &lt;= 1">(Descrizione Reazione): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="count(hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Descrizione Reazione): element hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="count(hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Descrizione Reazione): element hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="count(hl7:text) &lt;= 1">(Descrizione Reazione): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(Descrizione Reazione): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Descrizione Reazione): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Descrizione Reazione): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="count(hl7:value) &gt;= 1">(Descrizione Reazione): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="count(hl7:value) &lt;= 1">(Descrizione Reazione): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.163
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']
Item: (Descrizione Reazione)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.163')">(Descrizione Reazione): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.163'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.163
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]/hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Descrizione Reazione)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]/hl7:code[(@code = '75321-0' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="string(@code) = ('75321-0')">(Descrizione Reazione): The value for code SHALL be '75321-0'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Descrizione Reazione): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Descrizione Reazione): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Descrizione Reazione): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.163
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]/hl7:text
Item: (Descrizione Reazione)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.163
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (Descrizione Reazione)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.163-2022-09-25T153114.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Descrizione Reazione): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.10 X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.163
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]/hl7:effectiveTime
Item: (Descrizione Reazione)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.163
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.163']]/hl7:value
Item: (Descrizione Reazione)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]
Item: (Allergie - observation (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]">
      <extends rule="d4535925e0-false-d4535929e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="string(@typeCode) = ('SUBJ')">(Allergie - observation (VPS)): The value for typeCode SHALL be 'SUBJ'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.321
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]
Item: (Descrizione Criticità (VPS))
-->
   <rule fpi="RULC-1" id="d4535925e0-false-d4535929e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]) &gt;= 1">(Descrizione Criticità (VPS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]) &lt;= 1">(Descrizione Criticità (VPS)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.321
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]
Item: (Descrizione Criticità (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Descrizione Criticità (VPS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="string(@moodCode) = ('EVN')">(Descrizione Criticità (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']) &gt;= 1">(Descrizione Criticità (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']) &lt;= 1">(Descrizione Criticità (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="count(hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">(Descrizione Criticità (VPS)): element hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="count(hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">(Descrizione Criticità (VPS)): element hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="count(hl7:text) &lt;= 1">(Descrizione Criticità (VPS)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(Descrizione Criticità (VPS)): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Descrizione Criticità (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="count(hl7:value) &gt;= 1">(Descrizione Criticità (VPS)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="count(hl7:value) &lt;= 1">(Descrizione Criticità (VPS)): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.321
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']
Item: (Descrizione Criticità (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.321')">(Descrizione Criticità (VPS)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.321'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.321
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]/hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]
Item: (Descrizione Criticità (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]/hl7:code[(@code = 'SEV' and @codeSystem = '2.16.840.1.113883.5.4')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="string(@code) = ('SEV')">(Descrizione Criticità (VPS)): The value for code SHALL be 'SEV'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.4')">(Descrizione Criticità (VPS)): The value for codeSystem SHALL be '2.16.840.1.113883.5.4'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="string(@codeSystemName) = ('ActCode') or not(@codeSystemName)">(Descrizione Criticità (VPS)): The value for codeSystemName SHALL be 'ActCode'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Descrizione Criticità (VPS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Descrizione Criticità (VPS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.321
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]/hl7:text
Item: (Descrizione Criticità (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.321
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (Descrizione Criticità (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.321-2023-05-04T121805.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Descrizione Criticità (VPS)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.10 X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.321
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]/hl7:effectiveTime
Item: (Descrizione Criticità (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.321
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.321']]/hl7:value
Item: (Descrizione Criticità (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]
Item: (Allergie - observation (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]">
      <extends rule="d4536106e0-false-d4536110e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="string(@typeCode) = ('REFR')">(Allergie - observation (VPS)): The value for typeCode SHALL be 'REFR'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.165
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]
Item: (Stato dell'Allergia/Intolleranza )
-->
   <rule fpi="RULC-1" id="d4536106e0-false-d4536110e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]) &gt;= 1">(Stato dell'Allergia/Intolleranza ): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]) &lt;= 1">(Stato dell'Allergia/Intolleranza ): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.165
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]
Item: (Stato dell'Allergia/Intolleranza )
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Stato dell'Allergia/Intolleranza ): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="string(@moodCode) = ('EVN')">(Stato dell'Allergia/Intolleranza ): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']) &gt;= 1">(Stato dell'Allergia/Intolleranza ): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']) &lt;= 1">(Stato dell'Allergia/Intolleranza ): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="count(hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Stato dell'Allergia/Intolleranza ): element hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="count(hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Stato dell'Allergia/Intolleranza ): element hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="count(hl7:text) &lt;= 1">(Stato dell'Allergia/Intolleranza ): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="count(hl7:statusCode) &lt;= 1">(Stato dell'Allergia/Intolleranza ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Stato dell'Allergia/Intolleranza ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="count(hl7:value) &gt;= 1">(Stato dell'Allergia/Intolleranza ): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="count(hl7:value) &lt;= 1">(Stato dell'Allergia/Intolleranza ): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.165
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']
Item: (Stato dell'Allergia/Intolleranza )
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.165')">(Stato dell'Allergia/Intolleranza ): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.165'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.165
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]/hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Stato dell'Allergia/Intolleranza )
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]/hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="string(@code) = ('33999-4')">(Stato dell'Allergia/Intolleranza ): The value for code SHALL be '33999-4'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Stato dell'Allergia/Intolleranza ): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Stato dell'Allergia/Intolleranza ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Stato dell'Allergia/Intolleranza ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.165
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]/hl7:text
Item: (Stato dell'Allergia/Intolleranza )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.165
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]/hl7:statusCode
Item: (Stato dell'Allergia/Intolleranza )
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]/hl7:statusCode">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="@code">(Stato dell'Allergia/Intolleranza ): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.165-2022-09-25T155950.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Stato dell'Allergia/Intolleranza ): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.10' X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.165
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]/hl7:effectiveTime
Item: (Stato dell'Allergia/Intolleranza )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.165
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.165']]/hl7:value
Item: (Stato dell'Allergia/Intolleranza )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.320
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Allergie - observation (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <extends rule="d4536284e0-false-d4536288e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.320-2023-05-04T115941.html"
              test="string(@typeCode) = ('SUBJ')">(Allergie - observation (VPS)): The value for typeCode SHALL be 'SUBJ'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Commenti)
-->
   <rule fpi="RULC-1" id="d4536284e0-false-d4536288e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(Commenti): element hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Commenti): element hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Commenti)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="string(@classCode) = ('ACT')">(Commenti): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="string(@moodCode) = ('EVN')">(Commenti): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:templateId[not(@nullFlavor)]) &gt;= 1">(Commenti): element hl7:templateId[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:templateId[not(@nullFlavor)]) &lt;= 1">(Commenti): element hl7:templateId[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Commenti): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Commenti): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:text) &gt;= 1">(Commenti): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:text) &lt;= 1">(Commenti): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(Commenti): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Commenti): element hl7:effectiveTime appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId[not(@nullFlavor)]
Item: (Commenti)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId[not(@nullFlavor)]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.166') or not(@root)">(Commenti): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.166'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Commenti)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="string(@code) = ('48767-8')">(Commenti): The value for code SHALL be '48767-8'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Commenti): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Commenti): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Commenti): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Commenti)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:reference) &lt;= 1">(Commenti): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text/hl7:reference
Item: (Commenti)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (Commenti)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = 'completed' or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="@nullFlavor or (@code='completed')">(Commenti): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.320']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime
Item: (Commenti)
--></pattern>
