<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.261
Name: CDA Observation
Description: Template CDA Observation (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533">
   <title>CDA Observation</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.261
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]]
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]]"
         id="d44e43483-false-d4532842e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]) &gt;= 1">(CDA Observation): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]) &lt;= 1">(CDA Observation): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.261
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]"
         id="d44e43501-false-d4532859e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(CDA Observation): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="string(@moodCode) = ('EVN')">(CDA Observation): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']) &gt;= 1">(CDA Observation): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']) &lt;= 1">(CDA Observation): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="count(hl7:id) &lt;= 1">(CDA Observation): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="count(hl7:code) &gt;= 1">(CDA Observation): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="count(hl7:code) &lt;= 1">(CDA Observation): element hl7:code appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.261
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']"
         id="d44e43513-false-d4532902e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.261')">(CDA Observation): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.261'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.261
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]/hl7:id
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]/hl7:id"
         id="d44e43518-false-d4532913e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="@root">(CDA Observation): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Observation): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Observation): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Observation): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.261
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]/hl7:code
Item: (CDA Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.261']]/hl7:code"
         id="d44e43534-false-d4532935e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16226-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Observation): The element value SHALL be one of '2.16.840.1.113883.1.11.16226 ObservationType (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="@code">(CDA Observation): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA Observation): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.103')">(CDA Observation): The value for codeSystem SHALL be '2.16.840.1.113883.6.103'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="string(@codeSystemName) = ('ICD-9CM') or not(@codeSystemName)">(CDA Observation): The value for codeSystemName SHALL be 'ICD-9CM'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA Observation): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.261-2022-10-27T120533.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA Observation): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
</pattern>
