<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.246
Name: Scala Valutazione RAP
Description: Template CDA Observation (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359">
   <title>Scala Valutazione RAP</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.246
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]]
Item: (Scala Valutazione RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.246
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]
Item: (Scala Valutazione RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]"
         id="d44e42455-false-d4522233e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Scala Valutazione RAP): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="string(@moodCode) = ('EVN')">(Scala Valutazione RAP): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']) &gt;= 1">(Scala Valutazione RAP): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']) &lt;= 1">(Scala Valutazione RAP): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &gt;= 1">(Scala Valutazione RAP): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &lt;= 1">(Scala Valutazione RAP): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="count(hl7:value[xsi:type=&#34;ST&#34;]) &gt;= 1">(Scala Valutazione RAP): element hl7:value[xsi:type="ST"] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="count(hl7:value[xsi:type=&#34;ST&#34;]) &lt;= 1">(Scala Valutazione RAP): element hl7:value[xsi:type="ST"] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="count(hl7:value[xsi:type='CD']) &gt;= 1">(Scala Valutazione RAP): element hl7:value[xsi:type='CD'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="count(hl7:value[xsi:type='CD']) &lt;= 1">(Scala Valutazione RAP): element hl7:value[xsi:type='CD'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.246
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']
Item: (Scala Valutazione RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']"
         id="d44e42461-false-d4522279e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.246')">(Scala Valutazione RAP): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.246'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.246
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1']
Item: (Scala Valutazione RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1']"
         id="d44e42466-false-d4522291e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="@code">(Scala Valutazione RAP): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Scala Valutazione RAP): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Scala Valutazione RAP): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Scala Valutazione RAP): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Scala Valutazione RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Scala Valutazione RAP): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.246
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]/hl7:value[xsi:type="ST"]
Item: (Scala Valutazione RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]/hl7:value[xsi:type=&#34;ST&#34;]"
         id="d44e42486-false-d4522315e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="@nullFlavor or ($xsiLocalName='ST' and $xsiLocalNS='urn:hl7-org:v3')">(Scala Valutazione RAP): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.246
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]/hl7:value[xsi:type='CD']
Item: (Scala Valutazione RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.246']]/hl7:value[xsi:type='CD']"
         id="d44e42491-false-d4522325e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.246-2022-10-05T182359.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Scala Valutazione RAP): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
</pattern>
