<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.244
Name: Topografia RAP
Description: Template CDA Observation (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128">
   <title>Topografia RAP</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.244
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]]
Item: (Topografia RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]]"
         id="d44e42323-false-d4521974e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]) &gt;= 1">(Topografia RAP): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]) &lt;= 1">(Topografia RAP): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.244
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]
Item: (Topografia RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]"
         id="d44e42343-false-d4521991e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Topografia RAP): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="string(@moodCode) = ('EVN')">(Topografia RAP): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']) &gt;= 1">(Topografia RAP): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']) &lt;= 1">(Topografia RAP): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="count(hl7:code[(@code = '42129-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Topografia RAP): element hl7:code[(@code = '42129-7' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="count(hl7:code[(@code = '42129-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Topografia RAP): element hl7:code[(@code = '42129-7' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="count(hl7:value) &gt;= 1">(Topografia RAP): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="count(hl7:value) &lt;= 1">(Topografia RAP): element hl7:value appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.244
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']
Item: (Topografia RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']"
         id="d44e42349-false-d4522034e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.244')">(Topografia RAP): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.244'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.244
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]/hl7:code[(@code = '42129-7' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Topografia RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]/hl7:code[(@code = '42129-7' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d44e42354-false-d4522046e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="string(@code) = ('42129-7')">(Topografia RAP): The value for code SHALL be '42129-7'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Topografia RAP): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Topografia RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Topografia RAP): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.244
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]/hl7:value
Item: (Topografia RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.244']]/hl7:value"
         id="d44e42365-false-d4522068e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="@code">(Topografia RAP): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Topografia RAP): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="@codeSystem">(Topografia RAP): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Topografia RAP): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Topografia RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.244-2022-10-05T181128.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Topografia RAP): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
</pattern>
