<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.24
Name: Esenzioni Applicate (PrF)
Description: Template CDA Act (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634">
   <title>Esenzioni Applicate (PrF)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.24
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]
Item: (Esenzioni Applicate (PrF))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]"
         id="d44e42036-false-d4521870e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="count(hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']) &gt;= 1">(Esenzioni Applicate (PrF)): element hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="count(hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']) &lt;= 1">(Esenzioni Applicate (PrF)): element hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.24
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']
Item: (Esenzioni Applicate (PrF))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']"
         id="d44e42058-false-d4521885e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="string(@classCode) = ('ACT')">(Esenzioni Applicate (PrF)): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="string(@moodCode) = ('EVN')">(Esenzioni Applicate (PrF)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="count(hl7:code) &gt;= 1">(Esenzioni Applicate (PrF)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="count(hl7:code) &lt;= 1">(Esenzioni Applicate (PrF)): element hl7:code appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.24
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code
Item: (Esenzioni Applicate (PrF))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code"
         id="d44e42084-false-d4521909e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Esenzioni Applicate (PrF)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="@codeSystem">(Esenzioni Applicate (PrF)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(Esenzioni Applicate (PrF)): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Esenzioni Applicate (PrF)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Esenzioni Applicate (PrF)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="count(hl7:originalText) &lt;= 1">(Esenzioni Applicate (PrF)): element hl7:originalText appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.24
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code/hl7:originalText
Item: (Esenzioni Applicate (PrF))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code/hl7:originalText"
         id="d44e42127-false-d4521937e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="count(hl7:reference) &gt;= 1">(Esenzioni Applicate (PrF)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="count(hl7:reference) &lt;= 1">(Esenzioni Applicate (PrF)): element hl7:reference appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.24
Context: *[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code/hl7:originalText/hl7:reference
Item: (Esenzioni Applicate (PrF))
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code/hl7:originalText/hl7:reference"
         id="d44e42135-false-d4521953e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="@value">(Esenzioni Applicate (PrF)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.24-2022-06-23T142634.html"
              test="not(@value) or string-length(@value)&gt;0">(Esenzioni Applicate (PrF)): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>
</pattern>
