<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.207
Name: Stadiazione RAP
Description: Template CDA Observation (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541">
   <title>Stadiazione RAP</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.207
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]]
Item: (Stadiazione RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]]"
         id="d44e38993-false-d4475365e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]) &lt;= 1">(Stadiazione RAP): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.207
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]
Item: (Stadiazione RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]"
         id="d44e39015-false-d4475380e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Stadiazione RAP): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="string(@moodCode) = ('EVN')">(Stadiazione RAP): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']) &gt;= 1">(Stadiazione RAP): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']) &lt;= 1">(Stadiazione RAP): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="count(hl7:code) &gt;= 1">(Stadiazione RAP): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="count(hl7:code) &lt;= 1">(Stadiazione RAP): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.15.16']) &gt;= 1">(Stadiazione RAP): element hl7:value[@codeSystem = '2.16.840.1.113883.15.16'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.15.16']) &lt;= 1">(Stadiazione RAP): element hl7:value[@codeSystem = '2.16.840.1.113883.15.16'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.207
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']
Item: (Stadiazione RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']"
         id="d44e39027-false-d4475423e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.207')">(Stadiazione RAP): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.207'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.207
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]/hl7:code
Item: (Stadiazione RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]/hl7:code"
         id="d44e39032-false-d4475434e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="string(@code) = ('21902-2') or not(@code)">(Stadiazione RAP): The value for code SHALL be '21902-2'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1') or not(@codeSystem)">(Stadiazione RAP): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Stadiazione RAP): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Stadiazione RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Stadiazione RAP): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.207
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]/hl7:value[@codeSystem = '2.16.840.1.113883.15.16']
Item: (Stadiazione RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.207']]/hl7:value[@codeSystem = '2.16.840.1.113883.15.16']"
         id="d44e39051-false-d4475460e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="@code">(Stadiazione RAP): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Stadiazione RAP): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.15.16')">(Stadiazione RAP): The value for codeSystem SHALL be '2.16.840.1.113883.15.16'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Stadiazione RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.207-2022-09-27T122541.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Stadiazione RAP): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
</pattern>
