<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.199
Name: Analisi Supplementari dei campioni (RAP)
Description: Template CDA Observation (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135">
   <title>Analisi Supplementari dei campioni (RAP)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.199
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]
Item: (Analisi Supplementari dei campioni (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.199
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]
Item: (Analisi Supplementari dei campioni (RAP))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]"
         id="d44e38262-false-d4474063e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Analisi Supplementari dei campioni (RAP)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="string(@moodCode) = ('EVN')">(Analisi Supplementari dei campioni (RAP)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']) &gt;= 1">(Analisi Supplementari dei campioni (RAP)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']) &lt;= 1">(Analisi Supplementari dei campioni (RAP)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="count(hl7:code) &gt;= 1">(Analisi Supplementari dei campioni (RAP)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="count(hl7:code) &lt;= 1">(Analisi Supplementari dei campioni (RAP)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="count(hl7:text) &lt;= 1">(Analisi Supplementari dei campioni (RAP)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(Analisi Supplementari dei campioni (RAP)): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Analisi Supplementari dei campioni (RAP)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="count(hl7:value) &gt;= 1">(Analisi Supplementari dei campioni (RAP)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="count(hl7:value) &lt;= 1">(Analisi Supplementari dei campioni (RAP)): element hl7:value appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.199
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']
Item: (Analisi Supplementari dei campioni (RAP))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']"
         id="d44e38274-false-d4474133e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.199')">(Analisi Supplementari dei campioni (RAP)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.199'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.199
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:code
Item: (Analisi Supplementari dei campioni (RAP))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:code"
         id="d44e38279-false-d4474144e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Analisi Supplementari dei campioni (RAP)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Analisi Supplementari dei campioni (RAP)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Analisi Supplementari dei campioni (RAP)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Analisi Supplementari dei campioni (RAP)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.199
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:text
Item: (Analisi Supplementari dei campioni (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.199
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (Analisi Supplementari dei campioni (RAP))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]"
         id="d44e38305-false-d4474175e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Analisi Supplementari dei campioni (RAP)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.10 X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.199
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:effectiveTime
Item: (Analisi Supplementari dei campioni (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.199
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:value
Item: (Analisi Supplementari dei campioni (RAP))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.199
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Analisi Supplementari dei campioni (RAP))
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <extends rule="d4474234e0-false-d4474238e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="@typeCode">(Analisi Supplementari dei campioni (RAP)): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.199-2022-09-27T112135.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19447-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Analisi Supplementari dei campioni (RAP)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19447' x_ActRelationshipEntryRelationship (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Commenti)
-->
   <rule fpi="RULC-1" id="d4474234e0-false-d4474238e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(Commenti): element hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Commenti): element hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Commenti)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="string(@classCode) = ('ACT')">(Commenti): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="string(@moodCode) = ('EVN')">(Commenti): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:templateId[not(@nullFlavor)]) &gt;= 1">(Commenti): element hl7:templateId[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:templateId[not(@nullFlavor)]) &lt;= 1">(Commenti): element hl7:templateId[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Commenti): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Commenti): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:text) &gt;= 1">(Commenti): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:text) &lt;= 1">(Commenti): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(Commenti): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Commenti): element hl7:effectiveTime appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId[not(@nullFlavor)]
Item: (Commenti)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId[not(@nullFlavor)]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.166') or not(@root)">(Commenti): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.166'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Commenti)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="string(@code) = ('48767-8')">(Commenti): The value for code SHALL be '48767-8'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Commenti): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Commenti): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Commenti): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Commenti)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="count(hl7:reference) &lt;= 1">(Commenti): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text/hl7:reference
Item: (Commenti)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (Commenti)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = 'completed' or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.166-2022-09-25T200132.html"
              test="@nullFlavor or (@code='completed')">(Commenti): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.166
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.199']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:act[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime
Item: (Commenti)
--></pattern>
