<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.194
Name: Osservazione Microscopica RAP
Description: Template CDA Observation (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326">
   <title>Osservazione Microscopica RAP</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]
Item: (Osservazione Microscopica RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]"
         id="d44e37705-false-d4473412e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]) &gt;= 1">(Osservazione Microscopica RAP): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]) &lt;= 1">(Osservazione Microscopica RAP): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]
Item: (Osservazione Microscopica RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]"
         id="d44e37723-false-d4473439e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Osservazione Microscopica RAP): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="string(@moodCode) = ('EVN')">(Osservazione Microscopica RAP): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']) &gt;= 1">(Osservazione Microscopica RAP): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']) &lt;= 1">(Osservazione Microscopica RAP): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &gt;= 1">(Osservazione Microscopica RAP): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &lt;= 1">(Osservazione Microscopica RAP): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:text) &lt;= 1">(Osservazione Microscopica RAP): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(Osservazione Microscopica RAP): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Osservazione Microscopica RAP): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:value[xsi:type=&#34;ST&#34;]) &lt;= 1">(Osservazione Microscopica RAP): element hl7:value[xsi:type="ST"] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:value[xsi:type=&#34;IVL_PQ&#34;]) &lt;= 1">(Osservazione Microscopica RAP): element hl7:value[xsi:type="IVL_PQ"] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:value[xsi:type=&#34;IVL_TS&#34;]) &lt;= 1">(Osservazione Microscopica RAP): element hl7:value[xsi:type="IVL_TS"] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:value[xsi:type=&#34;INT&#34;]) &lt;= 1">(Osservazione Microscopica RAP): element hl7:value[xsi:type="INT"] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:value[xsi:type=&#34;CD&#34;]) &lt;= 1">(Osservazione Microscopica RAP): element hl7:value[xsi:type="CD"] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:value[xsi:type=&#34;RTO_QTY_QTY&#34;]) &lt;= 1">(Osservazione Microscopica RAP): element hl7:value[xsi:type="RTO_QTY_QTY"] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:specimen[hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]]) &lt;= 1">(Osservazione Microscopica RAP): element hl7:specimen[hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="count(hl7:entryRelationship[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]]) &lt;= 1">(Osservazione Microscopica RAP): element hl7:entryRelationship[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']
Item: (Osservazione Microscopica RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']"
         id="d44e37735-false-d4473532e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.194')">(Osservazione Microscopica RAP): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.194'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1']
Item: (Osservazione Microscopica RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1']"
         id="d44e37740-false-d4473544e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="@code">(Osservazione Microscopica RAP): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Osservazione Microscopica RAP): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Osservazione Microscopica RAP): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Osservazione Microscopica RAP): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Osservazione Microscopica RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Osservazione Microscopica RAP): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:text
Item: (Osservazione Microscopica RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (Osservazione Microscopica RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]"
         id="d44e37760-false-d4473581e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Osservazione Microscopica RAP): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.10 X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:effectiveTime
Item: (Osservazione Microscopica RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:value[xsi:type="ST"]
Item: (Osservazione Microscopica RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:value[xsi:type=&#34;ST&#34;]"
         id="d44e37769-false-d4473604e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="@nullFlavor or ($xsiLocalName='ST' and $xsiLocalNS='urn:hl7-org:v3')">(Osservazione Microscopica RAP): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:value[xsi:type="IVL_PQ"]
Item: (Osservazione Microscopica RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:value[xsi:type=&#34;IVL_PQ&#34;]"
         id="d44e37780-false-d4473614e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="@nullFlavor or ($xsiLocalName='IVL_PQ' and $xsiLocalNS='urn:hl7-org:v3')">(Osservazione Microscopica RAP): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:IVL_PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:value[xsi:type="IVL_TS"]
Item: (Osservazione Microscopica RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:value[xsi:type=&#34;IVL_TS&#34;]"
         id="d44e37785-false-d4473624e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="@nullFlavor or ($xsiLocalName='IVL_TS' and $xsiLocalNS='urn:hl7-org:v3')">(Osservazione Microscopica RAP): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:IVL_TS". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:value[xsi:type="INT"]
Item: (Osservazione Microscopica RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:value[xsi:type=&#34;INT&#34;]"
         id="d44e37790-false-d4473634e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="@nullFlavor or ($xsiLocalName='INT' and $xsiLocalNS='urn:hl7-org:v3')">(Osservazione Microscopica RAP): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:INT". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:value[xsi:type="CD"]
Item: (Osservazione Microscopica RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:value[xsi:type=&#34;CD&#34;]"
         id="d44e37795-false-d4473644e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Osservazione Microscopica RAP): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:value[xsi:type="RTO_QTY_QTY"]
Item: (Osservazione Microscopica RAP)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:value[xsi:type=&#34;RTO_QTY_QTY&#34;]"
         id="d44e37801-false-d4473654e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="@nullFlavor or ($xsiLocalName='RTO_QTY_QTY' and $xsiLocalNS='urn:hl7-org:v3')">(Osservazione Microscopica RAP): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:RTO_QTY_QTY". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="not(@xsi:type) or string-length(@xsi:type)&gt;0">(Osservazione Microscopica RAP): Attribute @xsi:type SHALL be of data type 'st'  - '<value-of select="@xsi:type"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:specimen[hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]]
Item: (Osservazione Microscopica RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.174
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:specimen[hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]]
Item: (Campione RAP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:specimen[hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.174-2022-09-26T144919.html"
              test="string(@typeCode) = ('SPC') or not(@typeCode)">(Campione RAP): The value for typeCode SHALL be 'SPC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.174-2022-09-26T144919.html"
              test="count(hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]) &gt;= 1">(Campione RAP): element hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.174-2022-09-26T144919.html"
              test="count(hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]) &lt;= 1">(Campione RAP): element hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.174
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:specimen[hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]]/hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]
Item: (Campione RAP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:specimen[hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]]/hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.174-2022-09-26T144919.html"
              test="string(@classCode) = ('SPEC') or not(@classCode)">(Campione RAP): The value for classCode SHALL be 'SPEC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.174-2022-09-26T144919.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']) &gt;= 1">(Campione RAP): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.174-2022-09-26T144919.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']) &lt;= 1">(Campione RAP): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.174-2022-09-26T144919.html"
              test="count(hl7:id) &gt;= 1">(Campione RAP): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.174-2022-09-26T144919.html"
              test="count(hl7:id) &lt;= 1">(Campione RAP): element hl7:id appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.174
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:specimen[hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]]/hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']
Item: (Campione RAP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:specimen[hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]]/hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.174-2022-09-26T144919.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.174')">(Campione RAP): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.174'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.174
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:specimen[hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]]/hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]/hl7:id
Item: (Campione RAP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:specimen[hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]]/hl7:specimenRole[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.174']]/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.174-2022-09-26T144919.html"
              test="@root">(Campione RAP): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.174-2022-09-26T144919.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Campione RAP): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.174-2022-09-26T144919.html"
              test="@extension">(Campione RAP): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.174-2022-09-26T144919.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Campione RAP): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.194
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:entryRelationship[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]]
Item: (Osservazione Microscopica RAP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:entryRelationship[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="@typeCode">(Osservazione Microscopica RAP): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.194-2022-09-26T182326.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Osservazione Microscopica RAP): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.209
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:entryRelationship[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]]
Item: (Oggetti correlati - RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.209
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:entryRelationship[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]
Item: (Oggetti correlati - RAP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:entryRelationship[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.209-2022-09-27T123040.html"
              test="string(@classCode) = ('OBS')">(Oggetti correlati - RAP): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.209-2022-09-27T123040.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Oggetti correlati - RAP): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.209-2022-09-27T123040.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']) &gt;= 1">(Oggetti correlati - RAP): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.209-2022-09-27T123040.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']) &lt;= 1">(Oggetti correlati - RAP): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.209-2022-09-27T123040.html"
              test="count(hl7:value) &gt;= 1">(Oggetti correlati - RAP): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.209-2022-09-27T123040.html"
              test="count(hl7:value) &lt;= 1">(Oggetti correlati - RAP): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.209
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:entryRelationship[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']
Item: (Oggetti correlati - RAP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:entryRelationship[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.209-2022-09-27T123040.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.209')">(Oggetti correlati - RAP): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.209'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.209
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:entryRelationship[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]/hl7:value
Item: (Oggetti correlati - RAP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.194']]/hl7:entryRelationship[hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]]/hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.209']]/hl7:value">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.209-2022-09-27T123040.html"
              test="string(@representation) = ('B64')">(Oggetti correlati - RAP): The value for representation SHALL be 'B64'. Found: "<value-of select="@representation"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.209-2022-09-27T123040.html"
              test="@mediaType">(Oggetti correlati - RAP): attribute @mediaType SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.209-2022-09-27T123040.html"
              test="not(@mediaType) or (string-length(@mediaType) &gt; 0 and not(matches(@mediaType,'\s')))">(Oggetti correlati - RAP): Attribute @mediaType SHALL be of data type 'cs'  - '<value-of select="@mediaType"/>'</assert>
   </rule>
</pattern>
